/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.controller;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import com.cyberway.mp.flow.api.model.FlowModelApi;
import com.cyberway.mp.flow.api.model.dto.FlowModelCreateDto;
import com.cyberway.mp.flow.api.model.dto.FlowModelDesignDto;
import com.cyberway.mp.flow.api.model.dto.FlowModelModifyDto;
import com.cyberway.mp.flow.api.model.dto.FlowModelPageDto;
import com.cyberway.mp.flow.api.model.vo.FlowModelInfoVo;
import com.cyberway.mp.flow.api.model.vo.FlowModelListVo;
import com.cyberway.mp.flow.api.model.vo.FlowModelNodesVo;
import com.cyberway.mp.flow.api.model.vo.FlowModelSimpleVo;
import com.cyberway.mp.flow.api.model.vo.FlowModelStatusInfoVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/flowModel"})
@Tag(name="flowModel")
public class FlowModelController {
    private final FlowModelApi flowModelApi;

    public FlowModelController(FlowModelApi flowModelApi) {
        this.flowModelApi = flowModelApi;
    }

    @Operation(summary="\u521b\u5efa\u6d41\u7a0b\u56fe")
    @PostMapping
    public ResponseResult<Long> createModel(@RequestBody FlowModelCreateDto dto) {
        return ResponseResult.successResult((Object)this.flowModelApi.createModel(dto));
    }

    @Operation(summary="\u4fee\u6539\u6d41\u7a0b\u56fe")
    @PutMapping(value={"{id}"})
    public ResponseResult<FlowModelStatusInfoVo> modifyModel(@Parameter(description="ID") @PathVariable(value="id") long id, @RequestBody FlowModelCreateDto dto) {
        return ResponseResult.successResult((Object)this.flowModelApi.modifyModel(FlowModelModifyDto.fromFlowModelCreateDto((long)id, (FlowModelCreateDto)dto)));
    }

    @Operation(summary="\u4fdd\u5b58\u6d41\u7a0b\u56fe\u8bbe\u8ba1")
    @PostMapping(value={"saveModelDesign"})
    public ResponseResult<FlowModelStatusInfoVo> saveModelDesign(@RequestBody FlowModelDesignDto dto) {
        return ResponseResult.successResult((Object)this.flowModelApi.saveModelDesign(dto));
    }

    @Operation(summary="\u83b7\u53d6\u6d41\u7a0b\u56fe\u8bbe\u8ba1\u5185\u5bb9")
    @GetMapping(value={"{id}/modelDesign"})
    public ResponseResult<String> getModelDesign(@Parameter(description="ID") @PathVariable(value="id") long id) {
        return ResponseResult.successResult((Object)this.flowModelApi.getModelDesign(id));
    }

    @Operation(summary="\u83b7\u53d6\u6d41\u7a0b\u56fe\u8bbe\u8ba1\u5185\u5bb9")
    @GetMapping(value={"{id}"})
    public ResponseResult<FlowModelInfoVo> getModel(@Parameter(description="ID") @PathVariable(value="id") long id) {
        return ResponseResult.successResult((Object)this.flowModelApi.getModel(id));
    }

    @Operation(summary="\u67e5\u8be2\u6d41\u7a0b\u56fe")
    @PostMapping(value={"query"})
    public ResponseResult<Page<FlowModelListVo>> queryModel(@RequestBody FlowModelPageDto dto) {
        return ResponseResult.successResult((Object)this.flowModelApi.queryModel(dto));
    }

    @Operation(summary="\u53d1\u5e03\u6d41\u7a0b\u56fe")
    @PostMapping(value={"{id}/releaseModel"})
    public ResponseResult<Void> releaseModel(@Parameter(description="ID") @PathVariable(value="id") long id) {
        this.flowModelApi.releaseModel(id);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u542f\u7528\u6d41\u7a0b\u56fe")
    @PostMapping(value={"{id}/enable"})
    public ResponseResult<Void> enableModel(@Parameter(description="ID") @PathVariable(value="id") long id) {
        this.flowModelApi.enableModel(id);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u7981\u7528\u6d41\u7a0b\u56fe")
    @PostMapping(value={"{id}/disable"})
    public ResponseResult<Void> disableModel(@Parameter(description="ID") @PathVariable(value="id") long id) {
        this.flowModelApi.disableModel(id);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u5220\u9664\u6d41\u7a0b\u56fe")
    @DeleteMapping(value={"{id}"})
    public ResponseResult<Void> deleteModel(@Parameter(description="ID") @PathVariable(value="id") long id) {
        this.flowModelApi.deleteModel(id);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u83b7\u53d6\u6307\u5b9a\u5206\u7c7b\u4e0b\u7684\u53ef\u7528\u6d41\u7a0b\u56fe\u5217\u8868")
    @GetMapping(value={"listEnabledModelInCategory/{categoryId}"})
    public ResponseResult<List<FlowModelSimpleVo>> listEnabledModelInCategory(@Parameter(description="\u6d41\u7a0b\u5206\u7c7bID") @PathVariable(value="categoryId") long categoryId) {
        return ResponseResult.successResult((Object)this.flowModelApi.listEnabledModelInCategory(categoryId));
    }

    @Operation(summary="\u83b7\u53d6\u6d41\u7a0b\u56fe\u8282\u70b9\u4fe1\u606f")
    @GetMapping(value={"{id}/loadModelNodes"})
    public ResponseResult<FlowModelNodesVo> loadModelNodes(@Parameter(description="ID") @PathVariable(value="id") long id) {
        return ResponseResult.successResult((Object)this.flowModelApi.loadModelNodes(id));
    }
}

