/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.controller;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import com.cyberway.mp.flow.api.common.vo.IdNameVo;
import com.cyberway.mp.flow.api.project.FlowProjectApi;
import com.cyberway.mp.flow.api.project.dto.FirstNodeFormFieldQueryDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectBundleCreateDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectBundleModifyDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectBundlePageDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectCreateDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectModifyDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectPageDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectTestDto;
import com.cyberway.mp.flow.api.project.dto.ModifyEntityProjectDto;
import com.cyberway.mp.flow.api.project.vo.FlowProjectBundleListVo;
import com.cyberway.mp.flow.api.project.vo.FlowProjectBundleVersionVo;
import com.cyberway.mp.flow.api.project.vo.FlowProjectFullInfoVo;
import com.cyberway.mp.flow.api.project.vo.FlowProjectListVo;
import com.cyberway.mp.flow.api.project.vo.FlowProjectSimpleInfoVo;
import com.cyberway.mp.flow.api.project.vo.FlowProjectStatusInfoVo;
import com.cyberway.mp.flow.api.task.vo.NodeFormFieldConfigVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Set;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/flowProject"})
@Tag(name="flowProject")
public class FlowProjectController {
    private final FlowProjectApi flowProjectApi;

    public FlowProjectController(FlowProjectApi flowProjectApi) {
        this.flowProjectApi = flowProjectApi;
    }

    @Operation(summary="\u521b\u5efa\u6d41\u7a0b\u65b9\u6848")
    @PostMapping
    public ResponseResult<Long> createFlowProject(@RequestBody FlowProjectCreateDto dto) {
        return ResponseResult.successResult((Object)this.flowProjectApi.createFlowProject(dto));
    }

    @Operation(summary="\u4fee\u6539\u6d41\u7a0b\u65b9\u6848")
    @PutMapping(value={"{id}"})
    public ResponseResult<FlowProjectStatusInfoVo> modifyFlowProject(@Parameter(description="ID") @PathVariable(value="id") long id, @RequestBody FlowProjectCreateDto dto) {
        return ResponseResult.successResult((Object)this.flowProjectApi.modifyFlowProject(FlowProjectModifyDto.fromFlowProjectCreateDto((long)id, (FlowProjectCreateDto)dto)));
    }

    @Operation(summary="\u83b7\u53d6\u6d41\u7a0b\u65b9\u6848")
    @GetMapping(value={"{id}"})
    public ResponseResult<FlowProjectFullInfoVo> getFlowProject(@Parameter(description="ID") @PathVariable(value="id") long id) {
        return ResponseResult.successResult((Object)this.flowProjectApi.getFlowProjectFullInfo(id));
    }

    @Operation(summary="\u67e5\u8be2\u6d41\u7a0b\u65b9\u6848")
    @PostMapping(value={"query"})
    public ResponseResult<Page<FlowProjectListVo>> queryFlowProject(@RequestBody FlowProjectPageDto dto) {
        return ResponseResult.successResult((Object)this.flowProjectApi.queryFlowProject(dto));
    }

    @Operation(summary="\u5bfc\u51fa\u6d41\u7a0b\u65b9\u6848")
    @PostMapping(value={"/export"})
    public void export(@RequestBody List<Long> ids, HttpServletResponse response) {
        this.flowProjectApi.export(ids, response);
    }

    @Operation(summary="\u5bfc\u5165\u6d41\u7a0b\u65b9\u6848")
    @PostMapping(value={"/importFlowProject"})
    public ResponseResult<Void> importFlowProject(@RequestParam(value="file") MultipartFile file) {
        this.flowProjectApi.importFlowProject(file);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u542f\u7528\u6d41\u7a0b\u65b9\u6848")
    @PostMapping(value={"{id}/enable"})
    public ResponseResult<Void> enableFlowProject(@Parameter(description="ID") @PathVariable(value="id") long id) {
        this.flowProjectApi.enableFlowProject(id);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u7981\u7528\u6d41\u7a0b\u65b9\u6848")
    @PostMapping(value={"{id}/disable"})
    public ResponseResult<Void> disableFlowProject(@Parameter(description="ID") @PathVariable(value="id") long id) {
        this.flowProjectApi.disableFlowProject(id);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u5220\u9664\u6d41\u7a0b\u65b9\u6848")
    @DeleteMapping(value={"{id}"})
    public ResponseResult<Void> deleteFlowProject(@Parameter(description="ID") @PathVariable(value="id") long id) {
        this.flowProjectApi.deleteFlowProject(id);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u53d1\u5e03\u6d41\u7a0b\u65b9\u6848")
    @PostMapping(value={"{id}/release"})
    public ResponseResult<Void> releaseFlowProject(@Parameter(description="ID") @PathVariable(value="id") long id) {
        this.flowProjectApi.releaseFlowProject(id);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u83b7\u53d6\u53ef\u7528\u6d41\u7a0b\u65b9\u6848\u7684\u521d\u59cb\u7248\u672c\u53f7\u548c\u540d\u79f0")
    @GetMapping(value={"listEnabledFirstVersion"})
    public ResponseResult<List<IdNameVo>> listEnabledFirstVersion() {
        return ResponseResult.successResult((Object)this.flowProjectApi.listEnabledFirstVersion());
    }

    @Operation(summary="\u4fee\u6539\u6d41\u51fa\u65b9\u6848\u589e\u52a0\u5143\u6570\u636e\u5bf9\u5e94\u8868\u5355\u5730\u5740\u548c\u56de\u8c03\u4e8b\u4ef6")
    @PostMapping(value={"/modifyProjectForMetadataEntity"})
    public ResponseResult<Void> modifyProjectForMetadataEntity(@RequestBody List<ModifyEntityProjectDto> dtoList) {
        this.flowProjectApi.modifyProjectForMetadataEntity(dtoList);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u6346\u7ed1\u521b\u5efa\u6d41\u7a0b\u65b9\u6848\u4e0e\u6d41\u7a0b\u56fe")
    @PostMapping(value={"bundleCreateFlowProject"})
    public ResponseResult<Long> bundleCreateFlowProject(@RequestBody FlowProjectBundleCreateDto dto) {
        return ResponseResult.successResult((Object)this.flowProjectApi.bundleCreateFlowProject(dto));
    }

    @Operation(summary="\u6346\u7ed1\u4fee\u6539\u6d41\u7a0b\u65b9\u6848\u4e0e\u6d41\u7a0b\u56fe")
    @PutMapping(value={"bundleModifyFlowProject"})
    public ResponseResult<FlowProjectStatusInfoVo> bundleModifyFlowProject(@RequestBody FlowProjectBundleModifyDto dto) {
        return ResponseResult.successResult((Object)this.flowProjectApi.bundleModifyFlowProject(dto));
    }

    @Operation(summary="\u5206\u9875\u67e5\u8be2\u9996\u7248\u672c\u6d41\u7a0b\u65b9\u6848")
    @PostMapping(value={"bundleQueryFlowProject"})
    public ResponseResult<Page<FlowProjectBundleListVo>> bundleQueryFlowProject(@RequestBody FlowProjectBundlePageDto dto) {
        return ResponseResult.successResult((Object)this.flowProjectApi.bundleQueryFlowProject(dto));
    }

    @Operation(summary="\u83b7\u53d6\u6307\u5b9a\u6d41\u7a0b\u65b9\u6848\u7684\u7248\u672c\u5217\u8868")
    @GetMapping(value={"bundleListFlowProjectVersions/{id}"})
    public ResponseResult<List<FlowProjectBundleVersionVo>> bundleListFlowProjectVersions(@PathVariable(value="id") long id) {
        return ResponseResult.successResult((Object)this.flowProjectApi.bundleListFlowProjectVersions(id));
    }

    @Operation(summary="\u83b7\u53d6\u6307\u5b9a\u7f16\u7801\u6d41\u7a0b\u65b9\u6848\u7684\u7248\u672c\u5217\u8868")
    @GetMapping(value={"bundleListFlowProjectVersionsByCode/{code}"})
    public ResponseResult<List<FlowProjectBundleVersionVo>> bundleListFlowProjectVersionsByCode(@PathVariable(value="code") String code) {
        return ResponseResult.successResult((Object)this.flowProjectApi.bundleListFlowProjectVersionsByCode(code));
    }

    @Operation(summary="\u83b7\u53d6\u9996\u8282\u70b9\u7684\u8868\u5355\u5b57\u6bb5\u6743\u9650(\u6574\u5408\u767b\u5f55\u7528\u6237\u5b57\u6bb5\u6743\u9650)")
    @PostMapping(value={"loadFirstNodeFormFieldConfig"})
    public ResponseResult<NodeFormFieldConfigVo> loadFirstNodeFormFieldConfig(@RequestBody FirstNodeFormFieldQueryDto dto) {
        return ResponseResult.successResult((Object)this.flowProjectApi.loadFirstNodeFormFieldConfig(dto));
    }

    @Operation(summary="\u83b7\u53d6\u6307\u5b9a\u7f16\u7801\u5f53\u524d\u542f\u7528\u6d41\u7a0b\u65b9\u6848\u7684\u4fe1\u606f")
    @GetMapping(value={"getFlowProjectInfoByCode/{code}"})
    public ResponseResult<FlowProjectSimpleInfoVo> getFlowProjectInfoByCode(@PathVariable(value="code") String code) {
        return ResponseResult.successResult((Object)this.flowProjectApi.getFlowProjectInfoByCode(code));
    }

    @Operation(summary="\u83b7\u53d6\u5bfc\u51fa\u6570\u636e")
    @PostMapping(value={"getExportData"})
    public ResponseResult<String> getExportData(@RequestBody List<Long> ids) {
        return ResponseResult.successResult((Object)this.flowProjectApi.getExportData(ids));
    }

    @Operation(summary="\u83b7\u53d6\u7528\u4e8e\u5bfc\u51fa\u7684\u6d41\u7a0b\u65b9\u6848\u4fe1\u606f", description="\u6709\u542f\u7528\u7248\u672c\u7684\u8fd4\u56de\u542f\u7528\u7248\u672c\u7684\u6570\u636e, \u6ca1\u6709\u7684\u8fd4\u56de\u6700\u65b0\u8349\u7a3f\u7248\u672c\u6570\u636e, \u4e5f\u6ca1\u6709\u7684\u8fd4\u56de\u6700\u65b0\u7981\u7528\u7248\u672c\u6570\u636e")
    @PostMapping(value={"/listForExportByCodes"})
    public ResponseResult<List<FlowProjectSimpleInfoVo>> listForExportByCodes(@RequestBody Set<String> codes) {
        return ResponseResult.successResult((Object)this.flowProjectApi.listForExportByCodes(codes));
    }

    @Operation(summary="\u6d4b\u8bd5\u6d41\u7a0b\u65b9\u6848")
    @PostMapping(value={"/testProject"})
    public ResponseResult<String> testProject(@RequestBody FlowProjectTestDto dto) {
        return ResponseResult.successResult((Object)this.flowProjectApi.testProject(dto));
    }
}

