/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.controller;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import com.cyberway.mp.flow.api.opinion.OpinionPoolApi;
import com.cyberway.mp.flow.api.opinion.dto.OpinionPoolCreateDto;
import com.cyberway.mp.flow.api.opinion.dto.OpinionPoolModifyDto;
import com.cyberway.mp.flow.api.opinion.dto.OpinionPoolPageDto;
import com.cyberway.mp.flow.api.opinion.dto.OpinionSelfCreateDto;
import com.cyberway.mp.flow.api.opinion.dto.OpinionSelfModifyDto;
import com.cyberway.mp.flow.api.opinion.vo.OpinionAssociationVo;
import com.cyberway.mp.flow.api.opinion.vo.OpinionPoolDetailsVo;
import com.cyberway.mp.flow.api.opinion.vo.OpinionPoolVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/opinionPool"})
@Tag(name="OpinionPool")
public class OpinionPoolController {
    private final OpinionPoolApi opinionPoolApi;

    public OpinionPoolController(OpinionPoolApi opinionPoolApi) {
        this.opinionPoolApi = opinionPoolApi;
    }

    @Operation(summary="\u65b0\u589e\u610f\u89c1\u5e93")
    @PostMapping
    public ResponseResult<Long> createOpinionPool(@RequestBody OpinionPoolCreateDto opinionPoolCreateDto) {
        return ResponseResult.successResult((Object)this.opinionPoolApi.createOpinionPool(opinionPoolCreateDto));
    }

    @Operation(summary="\u4fee\u6539\u610f\u89c1\u5e93")
    @PutMapping
    public ResponseResult<Void> modifyOpinionPool(@RequestBody OpinionPoolModifyDto opinionPoolModifyDto) {
        this.opinionPoolApi.modifyOpinionPool(opinionPoolModifyDto);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u83b7\u53d6\u610f\u89c1\u5e93\u8868\u57fa\u672c\u4fe1\u606f")
    @GetMapping(value={"{id}"})
    public ResponseResult<OpinionPoolDetailsVo> getOpinionPoolDetail(@Parameter(description="\u610f\u89c1\u5e93\u8868ID") @PathVariable(value="id") long id) {
        return ResponseResult.successResult((Object)this.opinionPoolApi.getOpinionPool(id));
    }

    @Operation(summary="\u5206\u9875\u67e5\u8be2\u610f\u89c1\u5e93\u8868")
    @PostMapping(value={"query"})
    public ResponseResult<Page<OpinionPoolVo>> queryOpinionPool(@RequestBody OpinionPoolPageDto opinionPoolPageDto) {
        return ResponseResult.successResult((Object)this.opinionPoolApi.queryOpinionPool(opinionPoolPageDto));
    }

    @Operation(summary="\u5220\u9664\u610f\u89c1\u5e93\u8868")
    @DeleteMapping(value={"{id}"})
    public ResponseResult<Void> deleteOpinionPool(@Parameter(description="\u610f\u89c1\u5e93\u8868ID") @PathVariable(value="id") long id) {
        this.opinionPoolApi.deleteOpinionPool(id);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u542f\u7528\u610f\u89c1\u5e93")
    @PutMapping(value={"/enable/{id}"})
    public ResponseResult<Void> enableOpinionPool(@PathVariable(value="id") long id) {
        this.opinionPoolApi.enableOpinionPool(id);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u7981\u7528\u610f\u89c1\u5e93")
    @PutMapping(value={"/disable/{id}"})
    public ResponseResult<Void> disableOpinionPool(@PathVariable(value="id") long id) {
        this.opinionPoolApi.disableOpinionPool(id);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u83b7\u53d6\u5e38\u7528\u610f\u89c1")
    @GetMapping(value={"/common/{flowCategory}"})
    public ResponseResult<List<OpinionPoolDetailsVo>> getCommonOpinion(@Parameter(description="\u6d41\u7a0b\u5206\u7c7bID") @PathVariable(value="flowCategory") long flowCategory) {
        return ResponseResult.successResult((Object)this.opinionPoolApi.getCommonOpinion(flowCategory));
    }

    @Operation(summary="\u5220\u9664\u4e2a\u4eba\u610f\u89c1")
    @DeleteMapping(value={"/self/{id}"})
    public ResponseResult<Void> deleteOpinionSelf(@Parameter(description="\u610f\u89c1ID") @PathVariable(value="id") long id) {
        this.opinionPoolApi.deleteOpinionSelf(id);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u65b0\u589e\u4e2a\u4eba\u610f\u89c1")
    @PostMapping(value={"/self/opinion"})
    public ResponseResult<Long> createOpinionSelf(@RequestBody OpinionSelfCreateDto opinionSelfCreateDto) {
        return ResponseResult.successResult((Object)this.opinionPoolApi.createOpinionSelf(opinionSelfCreateDto));
    }

    @Operation(summary="\u83b7\u53d6\u4e2a\u4eba\u610f\u89c1")
    @GetMapping(value={"/self"})
    public ResponseResult<List<OpinionAssociationVo>> getOpinionSelf() {
        return ResponseResult.successResult((Object)this.opinionPoolApi.getOpinionSelf());
    }

    @Operation(summary="\u4fee\u6539\u4e2a\u4eba\u610f\u89c1")
    @PutMapping(value={"/self"})
    public ResponseResult<Void> modifyOpinionSelf(@RequestBody OpinionSelfModifyDto opinionSelfModifyDto) {
        this.opinionPoolApi.modifyOpinionSelf(opinionSelfModifyDto);
        return ResponseResult.successResult();
    }
}

