/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.feign.client;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import com.cyberway.mp.flow.api.common.vo.IdNameVo;
import com.cyberway.mp.flow.api.project.dto.FirstNodeFormFieldQueryDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectBundleCreateDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectBundleModifyDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectBundlePageDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectCreateDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectPageDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectTestDto;
import com.cyberway.mp.flow.api.project.dto.ModifyEntityProjectDto;
import com.cyberway.mp.flow.api.project.vo.FlowProjectBundleListVo;
import com.cyberway.mp.flow.api.project.vo.FlowProjectBundleVersionVo;
import com.cyberway.mp.flow.api.project.vo.FlowProjectFullInfoVo;
import com.cyberway.mp.flow.api.project.vo.FlowProjectListVo;
import com.cyberway.mp.flow.api.project.vo.FlowProjectSimpleInfoVo;
import com.cyberway.mp.flow.api.project.vo.FlowProjectStatusInfoVo;
import com.cyberway.mp.flow.api.task.vo.NodeFormFieldConfigVo;
import java.util.List;
import java.util.Set;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@FeignClient(contextId="FlowProjectClient", value="${mp.flow-feign.server-name:fc-server}", path="/api/flowProject")
public interface FlowProjectClient {
    @PostMapping
    public ResponseResult<Long> createFlowProject(@RequestBody FlowProjectCreateDto var1);

    @PutMapping(value={"{id}"})
    public ResponseResult<FlowProjectStatusInfoVo> modifyFlowProject(@PathVariable(value="id") long var1, @RequestBody FlowProjectCreateDto var3);

    @GetMapping(value={"{id}"})
    public ResponseResult<FlowProjectFullInfoVo> getFlowProject(@PathVariable(value="id") long var1);

    @PostMapping(value={"query"})
    public ResponseResult<Page<FlowProjectListVo>> queryFlowProject(@RequestBody FlowProjectPageDto var1);

    @PostMapping(value={"{id}/enable"})
    public ResponseResult<Void> enableFlowProject(@PathVariable(value="id") long var1);

    @PostMapping(value={"{id}/disable"})
    public ResponseResult<Void> disableFlowProject(@PathVariable(value="id") long var1);

    @DeleteMapping(value={"{id}"})
    public ResponseResult<Void> deleteFlowProject(@PathVariable(value="id") long var1);

    @PostMapping(value={"{id}/release"})
    public ResponseResult<Void> releaseFlowProject(@PathVariable(value="id") long var1);

    @PostMapping(value={"getExportData"})
    public ResponseResult<String> getExportData(@RequestBody List<Long> var1);

    @GetMapping(value={"listEnabledFirstVersion"})
    public ResponseResult<List<IdNameVo>> listEnabledFirstVersion();

    @PostMapping(value={"/modifyProjectForMetadataEntity"})
    public ResponseResult<Void> modifyProjectForMetadataEntity(@RequestBody List<ModifyEntityProjectDto> var1);

    @PostMapping(value={"bundleCreateFlowProject"})
    public ResponseResult<Long> bundleCreateFlowProject(@RequestBody FlowProjectBundleCreateDto var1);

    @PutMapping(value={"bundleModifyFlowProject"})
    public ResponseResult<FlowProjectStatusInfoVo> bundleModifyFlowProject(@RequestBody FlowProjectBundleModifyDto var1);

    @PostMapping(value={"bundleQueryFlowProject"})
    public ResponseResult<Page<FlowProjectBundleListVo>> bundleQueryFlowProject(@RequestBody FlowProjectBundlePageDto var1);

    @GetMapping(value={"bundleListFlowProjectVersions/{id}"})
    public ResponseResult<List<FlowProjectBundleVersionVo>> bundleListFlowProjectVersions(@PathVariable(value="id") long var1);

    @GetMapping(value={"bundleListFlowProjectVersionsByCode/{code}"})
    public ResponseResult<List<FlowProjectBundleVersionVo>> bundleListFlowProjectVersionsByCode(@PathVariable(value="code") String var1);

    @PostMapping(value={"loadFirstNodeFormFieldConfig"})
    public ResponseResult<NodeFormFieldConfigVo> loadFirstNodeFormFieldConfig(@RequestBody FirstNodeFormFieldQueryDto var1);

    @GetMapping(value={"getFlowProjectInfoByCode/{code}"})
    public ResponseResult<FlowProjectSimpleInfoVo> getFlowProjectInfoByCode(@PathVariable(value="code") String var1);

    @PostMapping(value={"/importFlowProject"}, consumes={"multipart/form-data"})
    public ResponseResult<Void> importFlowProject(@RequestPart(value="file") MultipartFile var1);

    @PostMapping(value={"/listForExportByCodes"})
    public ResponseResult<List<FlowProjectSimpleInfoVo>> listForExportByCodes(@RequestBody Set<String> var1);

    @PostMapping(value={"/testProject"})
    public ResponseResult<String> testProject(@RequestBody FlowProjectTestDto var1);
}

