/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.beans;

import cn.hutool.core.bean.BeanPath;
import cn.hutool.core.map.MapUtil;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.function.annotation.Function;
import com.cyberway.mp.flow.api.function.annotation.FunctionBean;
import com.cyberway.mp.flow.api.function.annotation.FunctionParam;
import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.task.enums.FlowTaskStatus;
import com.cyberway.mp.flow.domain.condition.service.ConditionMatrixService;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.service.FlowTaskService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.variable.VariableContainer;

@FunctionBean(name="\u6d41\u7a0b\u51fd\u6570")
public class FlowHelperBean {
    private final FlowTaskService flowTaskService;
    private final ConditionMatrixService conditionMatrixService;
    private final FlowProjectConfigCacheRepository flowProjectConfigCacheRepository;

    public FlowHelperBean(FlowTaskService flowTaskService, ConditionMatrixService conditionMatrixService, FlowProjectConfigCacheRepository flowProjectConfigCacheRepository) {
        this.flowTaskService = flowTaskService;
        this.conditionMatrixService = conditionMatrixService;
        this.flowProjectConfigCacheRepository = flowProjectConfigCacheRepository;
    }

    @Function(description="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u6307\u5b9a\u8282\u70b9\u7684\u6700\u540e\u4e00\u6b21\u6301\u6709\u4ebaID", example="flowHelper.getNodeLastOwnerId(1,'xxxxx-xxxxx-xxxxx-xxxxx')")
    public Long getNodeLastOwnerId(@FunctionParam(description="\u6d41\u7a0b\u5b9e\u4f8bID") Long flowInstanceId, @FunctionParam(description="\u6d41\u7a0b\u8282\u70b9\u7684Key") String nodeKey) {
        return this.getNodeLastUserId(flowInstanceId, nodeKey, FlowTask::getOwnerUserId);
    }

    @Function(description="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u6307\u5b9a\u8282\u70b9\u7684\u6700\u540e\u4e00\u6b21\u529e\u7406\u4ebaID", example="flowHelper.getNodeLastOwnerId(1,'xxxxx-xxxxx-xxxxx-xxxxx')")
    public Long getNodeLastAssigneeId(@FunctionParam(description="\u6d41\u7a0b\u5b9e\u4f8bID") Long flowInstanceId, @FunctionParam(description="\u6d41\u7a0b\u8282\u70b9\u7684Key") String nodeKey) {
        return this.getNodeLastUserId(flowInstanceId, nodeKey, FlowTask::getAssigneeUserId);
    }

    private Long getNodeLastUserId(Long flowInstanceId, String nodeKey, java.util.function.Function<FlowTask, Long> userIdGetFunction) {
        List tasks = this.flowTaskService.listByFlowInstanceAndNodeKey(flowInstanceId.longValue(), nodeKey);
        if (tasks.isEmpty()) {
            return null;
        }
        return tasks.stream().filter(t -> !FlowTaskStatus.DELETED.equals((Object)t.getStatus())).findFirst().map(userIdGetFunction).orElse(null);
    }

    @Function(ignore=true)
    public List<String> conditionMatrixFilter(Long matrixId, VariableContainer variableContainer, String nodeKey, boolean assigneeRule) {
        Map<String, Object> ruleValueMap = this.buildRuleValueMap(variableContainer, nodeKey, assigneeRule);
        return this.conditionMatrixService.filterUser(matrixId, ruleValueMap).stream().map(Object::toString).collect(Collectors.toList());
    }

    @Function(ignore=true)
    public List<String> conditionMatrixFilter(Object sourceAssignee, Long matrixId, VariableContainer variableContainer, String nodeKey) {
        if (sourceAssignee == null) {
            return null;
        }
        if (sourceAssignee instanceof Collection) {
            Collection sourceAssigneeCollection = (Collection)sourceAssignee;
            if (sourceAssigneeCollection.isEmpty()) {
                return Collections.emptyList();
            }
            List<Long> longIdList = sourceAssigneeCollection.stream().filter(Objects::nonNull).map(Object::toString).filter(StringUtils::isNotBlank).map(Long::parseLong).collect(Collectors.toList());
            if (longIdList.size() != sourceAssigneeCollection.size()) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.ASSIGNEE_COLLECTION_HAS_NOT_LONG_VALUE);
            }
            return this.conditionMatrixFilter(longIdList, matrixId, variableContainer, nodeKey);
        }
        String stringAssignee = sourceAssignee.toString();
        if (StringUtils.isBlank((CharSequence)stringAssignee)) {
            return Collections.singletonList(stringAssignee);
        }
        return this.conditionMatrixFilter(Collections.singleton(Long.parseLong(stringAssignee)), matrixId, variableContainer, nodeKey);
    }

    private List<String> conditionMatrixFilter(Collection<Long> sourceAssignee, Long matrixId, VariableContainer variableContainer, String nodeKey) {
        if (sourceAssignee.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, Object> ruleValueMap = this.buildRuleValueMap(variableContainer, nodeKey, false);
        return this.conditionMatrixService.filterUser(sourceAssignee, matrixId, ruleValueMap).stream().map(Object::toString).collect(Collectors.toList());
    }

    private Map<String, Object> buildRuleValueMap(VariableContainer variableContainer, String nodeKey, boolean assigneeRule) {
        FlowInfoVariables flowInfoVariables = (FlowInfoVariables)variableContainer.getVariable("_FLOW_INFO_VARIABLES");
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowInfoVariables.getFlowProjectId().longValue(), flowInfoVariables.getFlowInstanceId().longValue(), nodeKey);
        Map ruleMap = assigneeRule ? approvalNodeConfig.getAssigneeConditionMatrixRuleMap() : approvalNodeConfig.getConditionMatrixRuleMap();
        HashMap ruleValueMap = MapUtil.newHashMap((int)ruleMap.size());
        ruleMap.forEach((k, v) -> ruleValueMap.put(k, this.getVariableValue(variableContainer, (String)v)));
        return ruleValueMap;
    }

    private Object getVariableValue(VariableContainer variableContainer, String variableKey) {
        if (!variableKey.contains(".")) {
            return variableContainer.getVariable(variableKey);
        }
        String[] splitKey = variableKey.split("\\.", 2);
        Object rootVariable = variableContainer.getVariable(splitKey[0]);
        if (rootVariable == null) {
            return null;
        }
        return new BeanPath(splitKey[1]).get(rootVariable);
    }
}

