/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.beans;

import com.cyberway.mp.bc.context.autoconfigure.ContextProperties;
import com.cyberway.mp.flow.api.function.annotation.FunctionBean;
import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.project.dto.ServiceNodeConfigDto;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.flowable.util.CustomApiUtils;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import feign.Client;
import feign.Request;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.flowable.variable.api.delegate.VariableScope;

@FunctionBean(ignore=true, name="")
public class ServiceTaskHelperBean
implements JavaDelegate {
    private static final long DEFAULT_CONNECT_TIMEOUT = 10000L;
    private static final long DEFAULT_READ_TIMEOUT = 120000L;
    private final FlowProjectConfigCacheRepository flowProjectConfigCacheRepository;
    private final Client feignClient;
    private final ContextProperties contextProperties;

    public ServiceTaskHelperBean(FlowProjectConfigCacheRepository flowProjectConfigCacheRepository, Client feignClient, ContextProperties contextProperties) {
        this.flowProjectConfigCacheRepository = flowProjectConfigCacheRepository;
        this.feignClient = feignClient;
        this.contextProperties = contextProperties;
    }

    public void execute(DelegateExecution execution) {
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)execution);
        String nodeKey = execution.getCurrentActivityId();
        ServiceNodeConfigDto serviceNodeConfig = this.flowProjectConfigCacheRepository.getServiceNodeConfig(flowInfoVariables.getFlowProjectId().longValue(), nodeKey);
        if (StringUtils.isNotBlank((CharSequence)serviceNodeConfig.getServiceId())) {
            this.callInternalApi(execution, serviceNodeConfig);
        } else {
            this.callExternalApi(execution, serviceNodeConfig);
        }
    }

    private void callInternalApi(DelegateExecution execution, ServiceNodeConfigDto serviceNodeConfig) {
        Map variables = execution.getVariables();
        Request request = CustomApiUtils.createInternalApiRequest(serviceNodeConfig, (Map<String, Object>)variables, this.contextProperties);
        Request.Options options = new Request.Options(10000L, TimeUnit.MILLISECONDS, 120000L, TimeUnit.MILLISECONDS, true);
        CustomApiUtils.callFeignApi(this.feignClient, request, options, true);
    }

    private void callExternalApi(DelegateExecution execution, ServiceNodeConfigDto serviceNodeConfig) {
        Map variables = execution.getVariables();
        okhttp3.Request request = CustomApiUtils.createExternalApiRequest(serviceNodeConfig, (Map<String, Object>)variables);
        OkHttpClient okHttpClient = CustomApiUtils.getOkHttpClient(10000L, 120000L);
        CustomApiUtils.callWebApi(okHttpClient, request, true);
    }
}

