/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.beans;

import com.cyberway.mp.flow.api.function.annotation.Function;
import com.cyberway.mp.flow.api.function.annotation.FunctionBean;
import com.cyberway.mp.flow.api.function.annotation.FunctionParam;
import com.cyberway.mp.flow.api.project.enums.AssigneeType;
import com.cyberway.mp.flow.infra.service.UserHelperService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@FunctionBean(name="\u7528\u6237\u51fd\u6570")
public class UserHelperBean {
    private final UserHelperService userHelperService;

    public UserHelperBean(UserHelperService userHelperService) {
        this.userHelperService = userHelperService;
    }

    @Function(description="\u6839\u636e\u7c7b\u578b\u548c\u5bf9\u5e94\u7c7b\u578bID\u5217\u8868\u67e5\u8be2\u7528\u6237ID\u5217\u8868", example="\u83b7\u53d6\u89d2\u8272ID\u4e3a1\u30012\u30013\u4e0b\u7684\u7528\u6237ID\u5217\u8868\uff1auserHelper.findByTypeAndIds('ROLE', '1,2,3')")
    public List<String> findByTypeAndIds(@FunctionParam(description="\u7c7b\u578b\uff0c\u53ef\u9009\u7c7b\u578b\u6709\uff1aUSER\uff08\u7528\u6237\uff09\u3001ROLE\uff08\u89d2\u8272\uff09\u3001DUTY\uff08\u5c97\u4f4d\uff09\u3001ORG_UNIT\uff08\u7ec4\u7ec7\u5355\u5143\uff09") String type, @FunctionParam(description="\u5bf9\u5e94\u7c7b\u578b\u7684ID\uff0c\u4f20\u5165\u591a\u4e2a\u65f6\u7528\u82f1\u6587\u9017\u53f7\u5206\u5f00") String ids) {
        return this.userHelperService.findByTypeAndIds(AssigneeType.valueOf((String)type), (Collection)Arrays.stream(ids.split(",")).filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList())).stream().map(Object::toString).collect(Collectors.toList());
    }

    @Function(description="\u68c0\u67e5\u7528\u6237\u662f\u5426\u62e5\u6709\u6307\u5b9a\u89d2\u8272", example="\u68c0\u67e5ID\u4e3a1\u7684\u7528\u6237\u662f\u5426\u62e5\u6709ROLE_ADMIN\u7684\u89d2\u8272\u6743\u9650\uff1auserHelper.checkUserHasRole(1, 'ROLE_ADMIN')")
    public boolean checkUserHasRole(@FunctionParam(description="\u7528\u6237ID") Long userId, @FunctionParam(description="\u89d2\u8272\u7f16\u7801") String roleCode) {
        return this.userHelperService.checkUserHasRole(userId, roleCode);
    }

    @Function(description="\u68c0\u67e5\u7528\u6237\u662f\u5426\u5728\u6307\u5b9a\u7ec4\u7ec7\u5355\u5143\u4e0b", example="\u68c0\u67e5ID\u4e3a1\u7684\u7528\u6237\u662f\u5426\u5728ORG_UNIT_1\u7ec4\u7ec7\u5355\u5143\u4e0b\uff1auserHelper.checkUserInOrgUnit(1, 'ORG_UNIT_1')")
    public boolean checkUserInOrgUnit(@FunctionParam(description="\u7528\u6237ID") Long userId, @FunctionParam(description="\u7ec4\u7ec7\u5355\u5143\u7f16\u7801") String orgUnitCode) {
        return this.userHelperService.checkUserInOrgUnit(userId, orgUnitCode);
    }

    @Function(description="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u7684\u4e0a\u7ea7\u9886\u5bfcID", example="\u83b7\u53d6ID\u4e3a1\u7684\u7528\u6237\u7684\u4e0a\u7ea7\u9886\u5bfcID\uff1auserHelper.getLeaderUserId(1)")
    public Long getLeaderUserId(@FunctionParam(description="\u7528\u6237ID") Long userId) {
        return this.userHelperService.getLeaderUserId(userId);
    }

    @Function(description="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u7684\u6240\u6709\u4e0a\u7ea7\u9886\u5bfcID", example="\u83b7\u53d6ID\u4e3a1\u7684\u7528\u6237\u7684\u6240\u6709\u4e0a\u7ea7\u9886\u5bfcID\uff1auserHelper.getAllLeaderUserId(1)")
    public List<Long> getAllLeaderUserId(@FunctionParam(description="\u7528\u6237ID") Long userId) {
        return this.userHelperService.getAllLeaderUserId(userId);
    }

    @Function(description="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u7684\u4e3b\u7ec4\u7ec7ID", example="\u83b7\u53d6ID\u4e3a1\u7684\u7528\u6237\u7684\u4e3b\u7ec4\u7ec7ID\uff1auserHelper.getUserMainOrgUnitId(1)")
    public Long getUserMainOrgUnitId(@FunctionParam(description="\u7528\u6237ID") Long userId) {
        return this.userHelperService.getUserMainOrgUnitId(userId);
    }

    @Function(description="\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7ID\u7684\u7236\u7ec4\u7ec7ID", example="\u83b7\u53d6ID\u4e3a1\u7684\u7ec4\u7ec7\u7684\u7236\u7ec4\u7ec7ID\uff1auserHelper.getParentOrgUnitId(1)")
    public Long getParentOrgUnitId(@FunctionParam(description="\u7ec4\u7ec7ID") Long orgUnitId) {
        return this.userHelperService.getParentOrgUnitId(orgUnitId);
    }

    @Function(description="\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7ID\u548c\u89d2\u8272\u7f16\u7801\u7684\u7528\u6237ID\u5217\u8868", example="\u83b7\u53d6ID\u4e3a1\u7684\u7ec4\u7ec7\u4e0b\u7684\u89d2\u8272\u7f16\u7801\u4e3aROLE_ADMIN\u7684\u7528\u6237ID\u5217\u8868\uff1auserHelper.findUserIdsByOrgUnitIdAndRoleCode(1, 'ROLE_ADMIN')")
    public List<Long> findUserIdsByOrgUnitIdAndRoleCode(@FunctionParam(description="\u7ec4\u7ec7ID") Long orgUnitId, @FunctionParam(description="\u89d2\u8272\u7f16\u7801") String roleCode) {
        return this.userHelperService.findUserIdsByOrgUnitIdAndRoleCode(orgUnitId, roleCode);
    }

    @Function(description="\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7\u7f16\u7801\u548c\u89d2\u8272\u7f16\u7801\u7684\u7528\u6237ID\u5217\u8868", example="\u83b7\u53d6\u7ec4\u7ec7\u7f16\u7801\u4e3aORG_UNIT_1\u7684\u89d2\u8272\u7f16\u7801\u4e3aROLE_ADMIN\u7684\u7528\u6237ID\u5217\u8868\uff1auserHelper.findUserIdsByOrgUnitCodeAndRoleCode('ORG_UNIT_1', 'ROLE_ADMIN')")
    public List<Long> findUserIdsByOrgUnitCodeAndRoleCode(@FunctionParam(description="\u7ec4\u7ec7\u7f16\u7801") String orgUnitCode, @FunctionParam(description="\u89d2\u8272\u7f16\u7801") String roleCode) {
        return this.userHelperService.findUserIdsByOrgUnitCodeAndRoleCode(orgUnitCode, roleCode);
    }

    @Function(description="\u5224\u65ad\u7ec4\u7ec7\u662f\u5426\u662f\u5b50\u7ec4\u7ec7", example="\u5224\u65ad\u7ec4\u7ec7ID\u4e3a1\u7684\u7ec4\u7ec7\u662f\u5426\u4e3a\u7ec4\u7ec7\u7f16\u7801\u4e3aORG_UNIT_2\u7684\u5b50\u7ec4\u7ec7\uff1auserHelper.checkOrgUnitIsSubUnit(1, 'ORG_UNIT_2')")
    public boolean checkOrgUnitIsSubUnit(@FunctionParam(description="\u7ec4\u7ec7ID") Long orgUnitId, @FunctionParam(description="\u7236\u7ec4\u7ec7\u7f16\u7801") String parentOrgUnitCode) {
        return this.userHelperService.checkOrgUnitIsSubUnit(orgUnitId, parentOrgUnitCode);
    }

    @Function(description="\u6839\u636e\u591a\u4e2a\u89d2\u8272\u7f16\u7801\u83b7\u53d6\u7528\u6237ID\u5217\u8868", example="\u83b7\u53d6\u89d2\u8272\u7f16\u7801\u4e3aROLE_ADMIN\u3001ROLE_USER\u7684\u7528\u6237ID\u5217\u8868\uff1auserHelper.findUserIdsByRoleCodes('ROLE_ADMIN', 'ROLE_USER')")
    public List<Long> findUserIdsByRoleCodes(String ... roleCodes) {
        if (roleCodes == null || roleCodes.length == 0) {
            return Collections.emptyList();
        }
        return this.userHelperService.findUserIdsByRoleCodes(Set.of(roleCodes));
    }

    @Function(description="\u67e5\u8be2\u4e1a\u52a1\u7ebf\u4e0b\u6c47\u62a5\u4eba\u5bf9\u5e94\u7684\u88ab\u6c47\u62a5\u4ebaID\u5217\u8868", example="userHelper.findUserIdsByBusinessLine('BUSINESS_CODE', 1, 1, 1)")
    public List<Long> findUserIdsByBusinessLine(@FunctionParam(description="\u4e1a\u52a1\u7ebf\u7f16\u7801") String businessCode, @FunctionParam(description="\u6c47\u62a5\u4ebaID") Long reporterId, @FunctionParam(description="\u6c47\u62a5\u4ebaID\u7c7b\u578b") Integer reporterIdType, @FunctionParam(description="\u6c47\u62a5\u4eba\u4e1a\u52a1\u5355\u5143ID") Long reporterOrgUnitId) {
        return this.userHelperService.findUserIdsByBusinessLine(businessCode, reporterId, reporterIdType, reporterOrgUnitId);
    }
}

