/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.config;

import cn.hutool.core.map.MapUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=99)
public class FlowableEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String LIQUIBASE_PROPERTY = "spring.liquibase.enabled";
    private static final String EVENT_REGISTER_PROPERTY = "flowable.eventregistry.enabled";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        HashMap source = MapUtil.newHashMap((int)2);
        if (!environment.containsProperty(LIQUIBASE_PROPERTY)) {
            source.put(LIQUIBASE_PROPERTY, true);
        }
        if (!environment.containsProperty(EVENT_REGISTER_PROPERTY)) {
            source.put(EVENT_REGISTER_PROPERTY, false);
        }
        if (!source.isEmpty()) {
            environment.getPropertySources().addLast((PropertySource)new MapPropertySource("mp-flowable-override", (Map)source));
        }
    }
}

