/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.behavior;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.enums.CountersignNumType;
import com.cyberway.mp.flow.api.project.enums.CountersignType;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.flowable.flow.behavior.RejectExecutor;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.flowable.util.CountersignUtils;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import com.cyberway.mp.flow.flowable.util.ProcessUtils;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.flowable.bpmn.model.Activity;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.JobUtil;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityManager;
import org.flowable.variable.api.delegate.VariableScope;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomParallelMultiInstanceBehavior
extends ParallelMultiInstanceBehavior {
    private final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final transient FlowProjectConfigCacheRepository flowProjectConfigCacheRepository;
    private final transient FlowDataHelperService flowDataHelperService;

    public CustomParallelMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior originalActivityBehavior, FlowProjectConfigCacheRepository flowProjectConfigCacheRepository, FlowDataHelperService flowDataHelperService) {
        super(activity, originalActivityBehavior);
        this.flowProjectConfigCacheRepository = flowProjectConfigCacheRepository;
        this.flowDataHelperService = flowDataHelperService;
    }

    protected int createInstances(DelegateExecution multiInstanceRootExecution) {
        this.setLoopVariable(multiInstanceRootExecution, "nrOfApproveInstances", 0);
        this.setLoopVariable(multiInstanceRootExecution, "nrOfRollbackInstances", 0);
        this.setLoopVariable(multiInstanceRootExecution, "nrOfWaiverInstances", 0);
        int instances = super.createInstances(multiInstanceRootExecution);
        if (instances == 0) {
            ProcessUtils.handleEmptyAssigneeNode(multiInstanceRootExecution);
        }
        return instances;
    }

    protected void internalLeave(DelegateExecution execution, boolean zeroNrOfInstances) {
        int loopCounter = this.getLoopVariable(execution, this.getCollectionElementIndexVariable());
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        VariableInstance nrOfCompletedInstancesVariable = this.getLoopVariableInstance(execution, "nrOfCompletedInstances");
        boolean usesParallelMultiInstanceLoopVariable = nrOfCompletedInstancesVariable != null && "bpmnParallelMultiInstanceCompleted".equals(nrOfCompletedInstancesVariable.getTypeName());
        int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances") - 1;
        int nrOfApproveInstances = this.getLoopVariable(execution, "nrOfApproveInstances");
        int nrOfRollbackInstances = this.getLoopVariable(execution, "nrOfRollbackInstances");
        int nrOfWaiverInstances = this.getLoopVariable(execution, "nrOfWaiverInstances");
        DelegateExecution multiInstanceRootExecution = this.getMultiInstanceRootExecution(execution);
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)execution);
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowInfoVariables.getFlowProjectId().longValue(), flowInfoVariables.getFlowInstanceId().longValue(), execution.getCurrentFlowElement().getId());
        if (approvalNodeConfig != null && approvalNodeConfig.getSignType() != null && !FlowConstant.SIGN_TYPE_NORMAL.equals(approvalNodeConfig.getSignType())) {
            this.setLoopVariable(multiInstanceRootExecution, "nrOfActiveInstances", nrOfActiveInstances);
            ExecutionEntity currentExecution = (ExecutionEntity)execution;
            String deleteReason = currentExecution.getDeleteReason();
            if (deleteReason == null || deleteReason.equals(FlowTaskDeleteReason.SIGN_APPROVE.name())) {
                this.setLoopVariable(multiInstanceRootExecution, "nrOfApproveInstances", ++nrOfApproveInstances);
            } else if (deleteReason.equals(FlowTaskDeleteReason.SIGN_REJECT.name())) {
                this.setLoopVariable(multiInstanceRootExecution, "nrOfRollbackInstances", ++nrOfRollbackInstances);
            } else if (deleteReason.equals(FlowTaskDeleteReason.SIGN_WAIVER.name())) {
                this.setLoopVariable(multiInstanceRootExecution, "nrOfWaiverInstances", ++nrOfWaiverInstances);
            }
            Integer signResult = FlowConstant.SIGN_TYPE_SINGER_SIGN.equals(approvalNodeConfig.getSignType()) ? (FlowTaskDeleteReason.SIGN_REJECT.name().equals(deleteReason) ? CountersignUtils.REJECT_TASK_CODE : CountersignUtils.APPROVE_TASK_CODE) : this.handleCountersignResult(approvalNodeConfig, currentExecution, nrOfActiveInstances, nrOfApproveInstances, nrOfRollbackInstances);
            this.logger.debug("handleSignResult: {}", (Object)signResult);
            if (CountersignUtils.CONTINUE_TASK_CODE.equals(signResult)) {
                this.continueLeave(loopCounter, nrOfInstances, usesParallelMultiInstanceLoopVariable, nrOfActiveInstances, nrOfApproveInstances, execution, zeroNrOfInstances);
            } else if (CountersignUtils.APPROVE_TASK_CODE.equals(signResult)) {
                this.approveLeave(execution);
            } else if (CountersignUtils.REJECT_TASK_CODE.equals(signResult)) {
                this.rejectLeave(approvalNodeConfig, execution);
            }
            return;
        }
        int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances") + 1;
        this.defaultLeave(loopCounter, nrOfInstances, usesParallelMultiInstanceLoopVariable, nrOfActiveInstances, nrOfCompletedInstances, execution, zeroNrOfInstances);
    }

    private void defaultLeave(int loopCounter, int nrOfInstances, boolean usesParallelMultiInstanceLoopVariable, int nrOfActiveInstances, int nrOfCompletedInstances, DelegateExecution execution, boolean zeroNrOfInstances) {
        DelegateExecution miRootExecution = this.getMultiInstanceRootExecution(execution);
        if (miRootExecution != null && !usesParallelMultiInstanceLoopVariable) {
            this.setLoopVariable(miRootExecution, "nrOfCompletedInstances", nrOfCompletedInstances);
            this.setLoopVariable(miRootExecution, "nrOfActiveInstances", nrOfActiveInstances);
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        this.inactivateExecution(execution, processEngineConfiguration);
        this.callActivityEndListeners(execution);
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        if (zeroNrOfInstances) {
            return;
        }
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        if (executionEntity.getParent() != null) {
            this.continueLeave(nrOfInstances, usesParallelMultiInstanceLoopVariable, nrOfCompletedInstances, execution, miRootExecution, processEngineConfiguration, executionEntity);
        } else {
            this.sendCompletedEvent(execution);
            this.cleanupMiRoot(execution);
        }
    }

    private void continueLeave(int loopCounter, int nrOfInstances, boolean usesParallelMultiInstanceLoopVariable, int nrOfActiveInstances, int nrOfCompletedInstances, DelegateExecution execution, boolean zeroNrOfInstances) {
        DelegateExecution miRootExecution = this.getMultiInstanceRootExecution(execution);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        this.inactivateExecution(execution, processEngineConfiguration);
        this.callActivityEndListeners(execution);
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        if (zeroNrOfInstances) {
            return;
        }
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        if (executionEntity.getParent() != null) {
            this.continueLeave(nrOfInstances, usesParallelMultiInstanceLoopVariable, nrOfCompletedInstances, execution, miRootExecution, processEngineConfiguration, executionEntity);
        }
    }

    private void continueLeave(int nrOfInstances, boolean usesParallelMultiInstanceLoopVariable, int nrOfCompletedInstances, DelegateExecution execution, DelegateExecution miRootExecution, ProcessEngineConfigurationImpl processEngineConfiguration, ExecutionEntity executionEntity) {
        boolean asyncLeave;
        boolean bl = asyncLeave = usesParallelMultiInstanceLoopVariable && processEngineConfiguration.isParallelMultiInstanceAsyncLeave() && !this.isAsyncWithoutWaitStates(processEngineConfiguration) && !Boolean.TRUE.equals(CommandContextUtil.getCommandContext().getAttribute("_NO_ASYNC_JOB"));
        if (!asyncLeave) {
            this.lockFirstParentScope((DelegateExecution)executionEntity);
        }
        this.aggregateVariablesForChildExecution(execution, miRootExecution);
        boolean isCompletionConditionSatisfied = this.completionConditionSatisfied(execution.getParent());
        if (nrOfCompletedInstances >= nrOfInstances || isCompletionConditionSatisfied) {
            this.leave(executionEntity, nrOfInstances, nrOfCompletedInstances, isCompletionConditionSatisfied);
        } else if (asyncLeave) {
            JobService jobService = processEngineConfiguration.getJobServiceConfiguration().getJobService();
            JobEntity job = JobUtil.createJob((ExecutionEntity)executionEntity, (String)"parallel-multi-instance-complete", (ProcessEngineConfigurationImpl)processEngineConfiguration);
            jobService.createAsyncJob(job, true);
            jobService.scheduleAsyncJob(job);
        }
    }

    private void approveLeave(DelegateExecution execution) {
        TaskEntityManager taskEntityManager = CommandContextUtil.getProcessEngineConfiguration().getTaskServiceConfiguration().getTaskEntityManager();
        FlowableEventDispatcher eventDispatcher = CommandContextUtil.getEventDispatcher();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
        List childExecutions = executionEntityManager.findChildExecutionsByParentExecutionId(execution.getParent().getId());
        childExecutions = childExecutions.stream().filter(item -> !item.getId().equals(execution.getId())).collect(Collectors.toList());
        for (ExecutionEntity childExecution : childExecutions) {
            List tasksByExecution = taskEntityManager.findTasksByExecutionId(childExecution.getId());
            for (TaskEntity taskEntity : tasksByExecution) {
                eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(taskEntity, CustomFlowableEngineEventType.NODE_SIGN_FIN), processEngineConfiguration.getEngineCfgKey());
            }
        }
        eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(execution, CustomFlowableEngineEventType.SIGN_FIN_APPROVE), processEngineConfiguration.getEngineCfgKey());
        this.sendCompletedEvent(execution);
        this.cleanupMiRoot(execution);
    }

    private void rejectLeave(ApprovalNodeConfigDto approvalNodeConfigDto, DelegateExecution execution) {
        new RejectExecutor(this.flowDataHelperService).reject(execution, approvalNodeConfigDto);
    }

    private Integer handleCountersignResult(ApprovalNodeConfigDto approvalNodeConfig, ExecutionEntity execution, Integer nrOfActiveInstances, Integer nrOfCompletedInstances, Integer nrOfRollbackInstances) {
        CountersignType countersignType = approvalNodeConfig.getCountersignType();
        CountersignNumType countersignNumType = approvalNodeConfig.getCountersignNumType();
        Integer countersignNum = approvalNodeConfig.getCountersignNum();
        Integer totalNum = this.getLoopVariable((DelegateExecution)execution, "nrOfInstances");
        if (CountersignType.APPROVE.equals((Object)countersignType) || CountersignType.REJECT.equals((Object)countersignType)) {
            return CountersignUtils.calCountersignResult(countersignNumType, countersignType, countersignNum, totalNum, nrOfActiveInstances, nrOfCompletedInstances, nrOfRollbackInstances);
        }
        throw new FlowableException("getCountersignType error");
    }

    protected Collection<?> resolveAndValidateCollection(DelegateExecution execution) {
        DelegateExecution multiInstanceRootExecution = this.getMultiInstanceRootExecution(execution);
        Object assigneeCollection = multiInstanceRootExecution.getVariableLocal("multiInstanceAssignees");
        if (assigneeCollection instanceof String) {
            return JSON.parseArray((String)assigneeCollection.toString(), String.class);
        }
        Collection collection = super.resolveAndValidateCollection(execution);
        this.setLoopVariable(multiInstanceRootExecution, "multiInstanceAssignees", JSON.toJSONString((Object)collection));
        return collection;
    }

    protected Object resolveCollection(DelegateExecution execution) {
        Object collection = super.resolveCollection(execution);
        if (collection == null) {
            return Collections.emptyList();
        }
        if (collection instanceof Long) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(collection);
            return list;
        }
        return collection;
    }
}

