/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.behavior;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.enums.CountersignNumType;
import com.cyberway.mp.flow.api.project.enums.CountersignType;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.flowable.flow.behavior.RejectExecutor;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.flowable.flow.model.AssigneeVar;
import com.cyberway.mp.flow.flowable.util.CountersignUtils;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import com.cyberway.mp.flow.flowable.util.ProcessUtils;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.variable.api.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSequentialMultiInstanceBehavior
extends SequentialMultiInstanceBehavior {
    private final transient FlowProjectConfigCacheRepository flowProjectConfigCacheRepository;
    private final transient FlowDataHelperService flowDataHelperService;
    private final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public CustomSequentialMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior originalActivityBehavior, FlowProjectConfigCacheRepository flowProjectConfigCacheRepository, FlowDataHelperService flowDataHelperService) {
        super(activity, originalActivityBehavior);
        this.flowProjectConfigCacheRepository = flowProjectConfigCacheRepository;
        this.flowDataHelperService = flowDataHelperService;
    }

    protected int createInstances(DelegateExecution multiInstanceRootExecution) {
        int nrOfInstances = this.resolveNrOfInstances(multiInstanceRootExecution);
        if (nrOfInstances > 0) {
            ExecutionEntity execution = CommandContextUtil.getExecutionEntityManager().createChildExecution((ExecutionEntity)multiInstanceRootExecution);
            execution.setCurrentFlowElement(multiInstanceRootExecution.getCurrentFlowElement());
            this.setLoopVariable(multiInstanceRootExecution, "nrOfInstances", nrOfInstances);
            this.setLoopVariable(multiInstanceRootExecution, "nrOfCompletedInstances", 0);
            this.setLoopVariable(multiInstanceRootExecution, "nrOfActiveInstances", 1);
            this.logLoopDetails(multiInstanceRootExecution, "initialized", 0, 0, 1, nrOfInstances);
            this.executeOriginalBehavior((DelegateExecution)execution, (ExecutionEntity)multiInstanceRootExecution, 0);
        } else {
            if (nrOfInstances < 0) {
                throw new FlowableIllegalArgumentException("Invalid number of instances: must be a non-negative integer value, but was " + nrOfInstances);
            }
            ProcessUtils.handleEmptyAssigneeNode(multiInstanceRootExecution);
        }
        return nrOfInstances;
    }

    public void leave(DelegateExecution execution) {
        DelegateExecution multiInstanceRootExecution = this.getMultiInstanceRootExecution(execution);
        int loopCounter = this.getLoopVariable(execution, this.getCollectionElementIndexVariable()) + 1;
        int nrOfInstances = this.getLoopVariable(multiInstanceRootExecution, "nrOfInstances");
        int nrOfApproveInstances = this.getLoopVariable(multiInstanceRootExecution, "nrOfApproveInstances");
        int nrOfRollbackInstances = this.getLoopVariable(multiInstanceRootExecution, "nrOfRollbackInstances");
        int nrOfWaiverInstances = this.getLoopVariable(multiInstanceRootExecution, "nrOfWaiverInstances");
        this.callActivityEndListeners(execution);
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)execution);
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowInfoVariables.getFlowProjectId().longValue(), flowInfoVariables.getFlowInstanceId().longValue(), execution.getCurrentFlowElement().getId());
        ExecutionEntity currentExecution = (ExecutionEntity)execution;
        if (approvalNodeConfig != null && approvalNodeConfig.getSignType() != null && !FlowConstant.SIGN_TYPE_NORMAL.equals(approvalNodeConfig.getSignType())) {
            Integer signResult;
            String deleteReason = currentExecution.getDeleteReason();
            if (deleteReason == null || deleteReason.equals(FlowTaskDeleteReason.SIGN_APPROVE.name())) {
                this.setLoopVariable(multiInstanceRootExecution, "nrOfApproveInstances", ++nrOfApproveInstances);
            } else if (deleteReason.equals(FlowTaskDeleteReason.SIGN_REJECT.name())) {
                this.setLoopVariable(multiInstanceRootExecution, "nrOfRollbackInstances", ++nrOfRollbackInstances);
            } else if (deleteReason.equals(FlowTaskDeleteReason.SIGN_WAIVER.name())) {
                this.setLoopVariable(multiInstanceRootExecution, "nrOfWaiverInstances", ++nrOfWaiverInstances);
            }
            if (FlowConstant.SIGN_TYPE_SINGER_SIGN.equals(approvalNodeConfig.getSignType())) {
                signResult = FlowTaskDeleteReason.SIGN_REJECT.name().equals(deleteReason) ? CountersignUtils.REJECT_TASK_CODE : CountersignUtils.APPROVE_TASK_CODE;
            } else {
                int nrOfActiveInstances = nrOfInstances - loopCounter;
                signResult = this.handleSignResult(approvalNodeConfig, currentExecution, nrOfActiveInstances, nrOfApproveInstances, nrOfRollbackInstances);
            }
            this.logger.info("handleSignResult: {}", (Object)signResult);
            if (CountersignUtils.CONTINUE_TASK_CODE.equals(signResult)) {
                this.continueLeave(execution, multiInstanceRootExecution, loopCounter);
            } else if (CountersignUtils.APPROVE_TASK_CODE.equals(signResult)) {
                this.approveLeave(execution);
            } else if (CountersignUtils.REJECT_TASK_CODE.equals(signResult)) {
                this.rejectLeave(approvalNodeConfig, execution);
            }
            return;
        }
        int nrOfActiveInstances = this.getLoopVariable(multiInstanceRootExecution, "nrOfActiveInstances");
        int nrOfCompletedInstances = this.getLoopVariable(multiInstanceRootExecution, "nrOfCompletedInstances") + 1;
        this.setLoopVariable(multiInstanceRootExecution, "nrOfCompletedInstances", nrOfCompletedInstances);
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        this.defaultLeave(execution, multiInstanceRootExecution, loopCounter, nrOfInstances);
    }

    protected void defaultLeave(DelegateExecution execution, DelegateExecution multiInstanceRootExecution, int loopCounter, int nrOfInstances) {
        this.aggregateVariablesForChildExecution(execution, multiInstanceRootExecution);
        boolean completeConditionSatisfied = this.completionConditionSatisfied(multiInstanceRootExecution);
        if (loopCounter >= nrOfInstances || completeConditionSatisfied) {
            if (completeConditionSatisfied) {
                this.sendCompletedWithConditionEvent(multiInstanceRootExecution);
            } else {
                this.sendCompletedEvent(multiInstanceRootExecution);
            }
            super.leave(execution);
        } else {
            this.continueSequentialMultiInstance(execution, loopCounter, (ExecutionEntity)multiInstanceRootExecution);
        }
    }

    protected void continueLeave(DelegateExecution execution, DelegateExecution multiInstanceRootExecution, int loopCounter) {
        this.aggregateVariablesForChildExecution(execution, multiInstanceRootExecution);
        this.continueSequentialMultiInstance(execution, loopCounter, (ExecutionEntity)multiInstanceRootExecution);
    }

    protected void approveLeave(DelegateExecution execution) {
        CommandContextUtil.getEventDispatcher().dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(execution, CustomFlowableEngineEventType.SIGN_FIN_APPROVE), CommandContextUtil.getProcessEngineConfiguration().getEngineCfgKey());
        this.sendCompletedEvent(execution);
        this.cleanupMiRoot(execution);
    }

    private void rejectLeave(ApprovalNodeConfigDto approvalNodeConfigDto, DelegateExecution execution) {
        new RejectExecutor(this.flowDataHelperService).reject(execution, approvalNodeConfigDto);
    }

    private Integer handleSignResult(ApprovalNodeConfigDto approvalNodeConfig, ExecutionEntity execution, Integer nrOfActiveInstances, Integer nrOfCompletedInstances, Integer nrOfRollbackInstances) {
        CountersignType countersignType = (CountersignType)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getCountersignType(), (Object)CountersignType.APPROVE);
        CountersignNumType countersignNumType = approvalNodeConfig.getCountersignNumType();
        Integer countersignNum = approvalNodeConfig.getCountersignNum();
        Integer totalNum = this.getLoopVariable((DelegateExecution)execution, "nrOfInstances");
        return CountersignUtils.calCountersignResult(countersignNumType, countersignType, countersignNum, totalNum, nrOfActiveInstances, nrOfCompletedInstances, nrOfRollbackInstances);
    }

    protected Collection<?> resolveAndValidateCollection(DelegateExecution execution) {
        Collection collection;
        DelegateExecution multiInstanceRootExecution = this.getMultiInstanceRootExecution(execution);
        Object assigneeCollection = multiInstanceRootExecution.getVariableLocal("multiInstanceAssignees");
        if (assigneeCollection instanceof String) {
            return JSON.parseArray((String)assigneeCollection.toString(), String.class);
        }
        assigneeCollection = multiInstanceRootExecution.getVariableLocal("sequentialAssignee");
        if (assigneeCollection instanceof String) {
            List assigneeVars = JSON.parseArray((String)assigneeCollection.toString(), AssigneeVar.class);
            collection = assigneeVars.stream().map(AssigneeVar::getUserId).collect(Collectors.toList());
        } else {
            collection = super.resolveAndValidateCollection(execution);
        }
        this.setLoopVariable(multiInstanceRootExecution, "multiInstanceAssignees", JSON.toJSONString((Object)collection));
        return collection;
    }

    protected Object resolveCollection(DelegateExecution execution) {
        Object collection = super.resolveCollection(execution);
        if (collection == null) {
            return Collections.emptyList();
        }
        if (collection instanceof Long) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(collection);
            return list;
        }
        return collection;
    }
}

