/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.behavior;

import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.GlobalConfigDto;
import com.cyberway.mp.flow.domain.delegation.entity.DelegationRule;
import com.cyberway.mp.flow.domain.delegation.service.DelegationRuleService;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.engine.interceptor.CreateUserTaskBeforeContext;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.api.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomUserTaskActivityBehavior
extends UserTaskActivityBehavior {
    private final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final transient FlowProjectConfigCacheRepository flowProjectConfigCacheRepository;
    private final transient DelegationRuleService delegationRuleService;
    private final transient FlowDataHelperService flowDataHelperService;

    public CustomUserTaskActivityBehavior(FlowProjectConfigCacheRepository flowProjectConfigCacheRepository, DelegationRuleService delegationRuleService, FlowDataHelperService flowDataHelperService, UserTask userTask) {
        super(userTask);
        this.flowProjectConfigCacheRepository = flowProjectConfigCacheRepository;
        this.delegationRuleService = delegationRuleService;
        this.flowDataHelperService = flowDataHelperService;
    }

    protected void handleName(CreateUserTaskBeforeContext beforeContext, ExpressionManager expressionManager, TaskEntity task, DelegateExecution execution) {
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)execution);
        GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowInfoVariables.getFlowProjectId().longValue());
        if (globalConfig != null && StringUtils.isNotBlank((CharSequence)globalConfig.getFlowNameFormula())) {
            try {
                Object nameValue = expressionManager.createExpression(globalConfig.getFlowNameFormula()).getValue((VariableContainer)execution);
                if (nameValue != null) {
                    task.setName(nameValue.toString());
                }
            }
            catch (FlowableException e) {
                this.logger.warn("property not found in task name expression {}", (Object)e.getMessage());
                super.handleName(beforeContext, expressionManager, task, execution);
            }
        } else {
            super.handleName(beforeContext, expressionManager, task, execution);
        }
    }

    protected void handleAssignments(TaskService taskService, String assignee, String owner, List<String> candidateUsers, List<String> candidateGroups, TaskEntity task, ExpressionManager expressionManager, DelegateExecution execution, ProcessEngineConfigurationImpl processEngineConfiguration) {
        ChangeAssigneeInfo info = new ChangeAssigneeInfo();
        info.owner = owner;
        if (StringUtils.isNotEmpty((CharSequence)assignee)) {
            Object assigneeExpressionValue = expressionManager.createExpression(assignee).getValue((VariableContainer)execution);
            if (assigneeExpressionValue != null) {
                info.assignee = assigneeExpressionValue.toString();
            }
            if (StringUtils.isNotEmpty((CharSequence)info.assignee)) {
                FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)execution);
                this.checkAutoReTransfer(info, task, flowInfoVariables);
                this.checkDelegation(info, task, flowInfoVariables);
            }
        }
        super.handleAssignments(taskService, info.assignee, info.owner, candidateUsers, candidateGroups, task, expressionManager, execution, processEngineConfiguration);
    }

    private void checkAutoReTransfer(ChangeAssigneeInfo info, TaskEntity task, FlowInfoVariables flowInfoVariables) {
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowInfoVariables.getFlowProjectId().longValue(), task.getTaskDefinitionKey());
        if (approvalNodeConfig == null || !Boolean.TRUE.equals(approvalNodeConfig.getAutoReTransfer())) {
            return;
        }
        String assigneeValue = info.assignee;
        long checkOwner = Long.parseLong(assigneeValue);
        Optional<FlowTask> lastSameTask = this.flowDataHelperService.listTaskByFlowInstanceAndNodeKey(flowInfoVariables.getFlowInstanceId().longValue(), task.getTaskDefinitionKey()).stream().filter(t -> t.alreadyFinish() && Objects.equals(t.getOwnerUserId(), checkOwner)).max(Comparator.comparing(FlowTask::getStartTime));
        if (lastSameTask.isEmpty()) {
            return;
        }
        FlowTask flowTask = lastSameTask.get();
        if (Objects.equals(flowTask.getOwnerUserId(), flowTask.getAssigneeUserId())) {
            return;
        }
        info.owner = info.assignee;
        info.assignee = flowTask.getAssigneeUserId().toString();
        info.changed = true;
        TaskHelper.changeTaskOwner((TaskEntity)task, (String)info.owner);
    }

    private void checkDelegation(ChangeAssigneeInfo info, TaskEntity task, FlowInfoVariables flowInfoVariables) {
        if (info.changed) {
            return;
        }
        GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowInfoVariables.getFlowProjectId().longValue());
        if (!Boolean.TRUE.equals(globalConfig.getEnableDelegation())) {
            return;
        }
        Long firstVersionId = flowInfoVariables.getFlowProjectFirstVersionId();
        long longAssignee = Long.parseLong(info.assignee);
        DelegationRule delegationRule = this.delegationRuleService.checkDelegation(longAssignee, firstVersionId.longValue());
        if (delegationRule == null) {
            return;
        }
        info.owner = info.assignee;
        info.assignee = delegationRule.getDelegationUserId().toString();
        info.changed = true;
        TaskHelper.changeTaskOwner((TaskEntity)task, (String)info.owner);
        task.setVariableLocal("_DELEGATION_RULE_ID", (Object)delegationRule.getId());
    }

    private static final class ChangeAssigneeInfo {
        String assignee;
        String owner;
        boolean changed = false;

        private ChangeAssigneeInfo() {
        }
    }
}

