/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.behavior;

import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.enums.RejectAction;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.flowable.flow.command.BaseJumpCmd;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import com.cyberway.mp.flow.flowable.util.ProcessUtils;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.engine.FlowableEngineAgenda;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class RejectExecutor {
    private final FlowDataHelperService flowDataHelperService;
    private ProcessEngineConfigurationImpl processEngineConfiguration;
    private FlowableEngineAgenda flowableEngineAgenda;
    private ExecutionEntityManager executionEntityManager;
    private TaskService taskService;
    private FlowableEventDispatcher eventDispatcher;

    public RejectExecutor(FlowDataHelperService flowDataHelperService) {
        this.flowDataHelperService = flowDataHelperService;
    }

    public void reject(DelegateExecution execution, ApprovalNodeConfigDto approvalNodeConfigDto) {
        BaseJumpCmd.JumpNodeInfo jumpNodeInfo;
        this.processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        this.flowableEngineAgenda = CommandContextUtil.getAgenda();
        this.executionEntityManager = this.processEngineConfiguration.getExecutionEntityManager();
        this.taskService = this.processEngineConfiguration.getTaskServiceConfiguration().getTaskService();
        this.eventDispatcher = this.processEngineConfiguration.getEventDispatcher();
        RejectAction rejectAction = (RejectAction)ObjectUtils.defaultIfNull((Object)approvalNodeConfigDto.getRejectAction(), (Object)RejectAction.ROLLBACK_START);
        String subDeleteReason = FlowTaskDeleteReason.NODE_SIGN_FIN.name();
        CustomFlowableEngineEventType subEventType = CustomFlowableEngineEventType.NODE_SIGN_FIN;
        CustomFlowableEntityEvent event = new CustomFlowableEntityEvent(execution, CustomFlowableEngineEventType.SIGN_FIN_REJECT);
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)execution);
        switch (rejectAction) {
            case CANCEL_FLOW: {
                this.cancelFlow(execution, event, subDeleteReason, subEventType, flowInfoVariables);
                return;
            }
            case ROLLBACK_PREV: {
                jumpNodeInfo = this.findPrevNode(execution);
                break;
            }
            case ROLLBACK_START: {
                if (ProcessUtils.skipFirstNode(flowInfoVariables.getFlowProjectId())) {
                    CommandContextUtil.getCommandContext().addAttribute("_RESUBMIT_CONTEXT", (Object)true);
                }
                jumpNodeInfo = this.findStartNode(execution);
                break;
            }
            default: {
                jumpNodeInfo = this.findSpecialNode(execution, approvalNodeConfigDto.getRejectToNodeKey());
            }
        }
        CommandContextUtil.getCommandContext().addAttribute("_REJECT_INFO", (Object)jumpNodeInfo);
        FlowElement targetNode = ProcessDefinitionUtil.getProcess((String)execution.getProcessDefinitionId()).getFlowElement(jumpNodeInfo.getTargetNodeKey());
        CommandContextUtil.getEventDispatcher().dispatchEvent((FlowableEvent)event, CommandContextUtil.getProcessEngineConfiguration().getEngineCfgKey());
        if (ProcessUtils.JUMP_MODE_SIMPLE.equals(jumpNodeInfo.getJumpMode())) {
            this.jumpSimple(execution, targetNode, subDeleteReason, subEventType, flowInfoVariables);
        } else {
            this.jumpParallel((ExecutionEntity)execution, targetNode, subDeleteReason, subEventType);
        }
    }

    private void cancelFlow(DelegateExecution currentExecution, CustomFlowableEntityEvent event, String subDeleteReason, CustomFlowableEngineEventType subEventType, FlowInfoVariables flowInfoVariables) {
        CommandContextUtil.getEventDispatcher().dispatchEvent((FlowableEvent)event, CommandContextUtil.getProcessEngineConfiguration().getEngineCfgKey());
        this.cleanRunningTasks(currentExecution, subDeleteReason, subEventType, flowInfoVariables);
        this.processEngineConfiguration.getRuntimeService().deleteProcessInstance(currentExecution.getProcessInstanceId(), FlowTaskDeleteReason.REJECT.name());
    }

    private void cleanRunningTasks(DelegateExecution currentExecution, String subDeleteReason, CustomFlowableEngineEventType subEventType, FlowInfoVariables flowInfoVariables) {
        String processInstanceId = currentExecution.getProcessInstanceId();
        List tasks = this.taskService.findTasksByProcessInstanceId(processInstanceId);
        for (TaskEntity t : tasks) {
            TaskHelper.deleteTask((TaskEntity)t, (String)subDeleteReason, (boolean)false, (boolean)true, (boolean)true);
            this.eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(t, subEventType), this.processEngineConfiguration.getEngineCfgKey());
        }
        List flowTasks = this.flowDataHelperService.listRunningStartFillTask(flowInfoVariables.getFlowInstanceId().longValue());
        for (FlowTask flowTask : flowTasks) {
            this.eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(flowTask, processInstanceId, subEventType), this.processEngineConfiguration.getEngineCfgKey());
        }
    }

    private void jumpSimple(DelegateExecution currentExecution, FlowElement targetNode, String subDeleteReason, CustomFlowableEngineEventType subEventType, FlowInfoVariables flowInfoVariables) {
        this.cleanRunningTasks(currentExecution, subDeleteReason, subEventType, flowInfoVariables);
        ExecutionEntity processExecution = (ExecutionEntity)this.executionEntityManager.findById(currentExecution.getProcessInstanceId());
        for (ExecutionEntity execution : processExecution.getExecutions()) {
            this.deleteExecutionAndChild(execution, subDeleteReason);
        }
        ExecutionEntity childExecution = this.executionEntityManager.createChildExecution(processExecution);
        childExecution.setCurrentFlowElement(targetNode);
        this.flowableEngineAgenda.planContinueProcessOperation(childExecution);
    }

    private void deleteExecutionAndChild(ExecutionEntity execution, String subDeleteReason) {
        for (ExecutionEntity child : execution.getExecutions()) {
            this.deleteExecutionAndChild(child, subDeleteReason);
        }
        execution.forceUpdate();
        this.executionEntityManager.deleteExecutionAndRelatedData(execution, subDeleteReason, false);
    }

    private void jumpParallel(ExecutionEntity currentExecution, FlowElement targetNode, String subDeleteReason, CustomFlowableEngineEventType subEventType) {
        ExecutionEntity parentExecution = currentExecution.getParent();
        List tasks = this.taskService.findTasksByExecutionId(currentExecution.getId());
        for (TaskEntity t : tasks) {
            this.eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(t, subEventType), this.processEngineConfiguration.getEngineCfgKey());
        }
        this.executionEntityManager.deleteExecutionAndRelatedData(currentExecution, subDeleteReason, false);
        if (parentExecution.isMultiInstanceRoot()) {
            ExecutionEntity miExecution = parentExecution;
            parentExecution = parentExecution.getParent();
            for (ExecutionEntity child : miExecution.getExecutions()) {
                if (child.getId().equals(currentExecution.getId())) continue;
                for (TaskEntity childTask : this.taskService.findTasksByExecutionId(child.getId())) {
                    this.eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(childTask, subEventType), this.processEngineConfiguration.getEngineCfgKey());
                }
                this.executionEntityManager.deleteExecutionAndRelatedData(child, subDeleteReason, false);
            }
            this.executionEntityManager.deleteExecutionAndRelatedData(miExecution, subDeleteReason, false);
        }
        ExecutionEntity childExecution = this.executionEntityManager.createChildExecution(parentExecution);
        childExecution.setCurrentFlowElement(targetNode);
        this.flowableEngineAgenda.planContinueProcessOperation(childExecution);
    }

    private BaseJumpCmd.JumpNodeInfo findSpecialNode(DelegateExecution execution, String targetNodeKey) {
        String sourceNodeKey = execution.getCurrentFlowElement().getId();
        Integer jumpMode = ProcessUtils.checkJumpMode(execution.getProcessDefinitionId(), sourceNodeKey, targetNodeKey);
        if (!ProcessUtils.JUMP_MODE_DIFFERENT_PARALLEL.equals(jumpMode)) {
            return new BaseJumpCmd.JumpNodeInfo(sourceNodeKey, targetNodeKey, jumpMode);
        }
        throw new BaseI18nException((ErrorCode)FlowErrorCode.CAN_NOT_ROLLBACK_INTO_PARALLEL);
    }

    private BaseJumpCmd.JumpNodeInfo findStartNode(DelegateExecution execution) {
        Process process = ProcessDefinitionUtil.getProcess((String)execution.getProcessDefinitionId());
        FlowNode initialFlowElement = (FlowNode)process.getInitialFlowElement();
        FlowElement targetFlowElement = ((SequenceFlow)initialFlowElement.getOutgoingFlows().get(0)).getTargetFlowElement();
        return new BaseJumpCmd.JumpNodeInfo(execution.getCurrentFlowElement().getId(), targetFlowElement.getId(), ProcessUtils.JUMP_MODE_SIMPLE);
    }

    private BaseJumpCmd.JumpNodeInfo findPrevNode(DelegateExecution execution) {
        String taskDefKey;
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)execution);
        List flowNodes = this.flowDataHelperService.listNodeForRollbackPrev(flowInfoVariables.getFlowInstanceId());
        boolean skipForRollback = false;
        String skipToNodeKey = taskDefKey = execution.getCurrentFlowElement().getId();
        for (com.cyberway.mp.flow.domain.node.entity.FlowNode flowNode : flowNodes) {
            if (skipForRollback && skipToNodeKey.equals(flowNode.getNodeKey())) {
                skipForRollback = false;
                continue;
            }
            if (skipForRollback || taskDefKey.equals(flowNode.getNodeKey())) continue;
            switch (flowNode.getStatus()) {
                case COMPLETED: 
                case JUMPED: {
                    Integer jumpMode = ProcessUtils.checkJumpMode(execution.getProcessDefinitionId(), taskDefKey, flowNode.getNodeKey());
                    if (!ProcessUtils.JUMP_MODE_DIFFERENT_PARALLEL.equals(jumpMode)) {
                        return new BaseJumpCmd.JumpNodeInfo(taskDefKey, flowNode.getNodeKey(), jumpMode);
                    }
                    skipToNodeKey = flowNode.getNodeKey();
                    break;
                }
                case REJECTED: 
                case ROLLBACK_PREV: 
                case ROLLBACK: 
                case ROLLBACK_START: {
                    skipForRollback = true;
                    break;
                }
            }
        }
        throw new BaseI18nException((ErrorCode)FlowErrorCode.NO_PREV_STEP_TO_ROLLBACK);
    }
}

