/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.common.dto.IdNameDto;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.enums.AssigneeType;
import com.cyberway.mp.flow.api.project.enums.TaskExecuteType;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstanceAddNode;
import com.cyberway.mp.flow.domain.instance.service.FlowInstanceService;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.impl.bpmn.parser.BpmnParser;
import org.flowable.engine.impl.bpmn.parser.handler.UserTaskParseHandler;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.AbstractDynamicInjectionCmd;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.api.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicNodeInjectionCmd
extends AbstractDynamicInjectionCmd
implements Command<Void> {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final FlowInstanceService flowInstanceService;
    protected final FlowProjectConfigCacheRepository flowProjectConfigCacheRepository;
    protected final String currentTaskId;
    protected final Collection<IdNameDto> assignees;
    protected final String nodeName;
    protected final CustomCmdParams customCmdParams;
    protected TaskEntity task;
    protected FlowInstanceAddNode flowInstanceAddNode;
    protected Map<String, AtomicInteger> counterMap = new HashMap<String, AtomicInteger>(16);

    protected AbstractDynamicNodeInjectionCmd(FlowInstanceService flowInstanceService, FlowProjectConfigCacheRepository flowProjectConfigCacheRepository, String currentTaskId, String nodeName, Collection<IdNameDto> assignees, CustomCmdParams customCmdParams) {
        this.flowInstanceService = flowInstanceService;
        this.flowProjectConfigCacheRepository = flowProjectConfigCacheRepository;
        this.currentTaskId = currentTaskId;
        this.nodeName = nodeName;
        this.assignees = assignees;
        this.customCmdParams = customCmdParams;
    }

    public Void execute(CommandContext commandContext) {
        TaskService taskService = CommandContextUtil.getTaskService((CommandContext)commandContext);
        this.task = taskService.getTask(this.currentTaskId);
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)this.task);
        this.flowInstanceAddNode = new FlowInstanceAddNode();
        this.flowInstanceAddNode.setFlowInstanceId(flowInfoVariables.getFlowInstanceId());
        this.flowInstanceAddNode.setActionTaskId((Long)this.task.getVariableLocal("_FLOW_TASK_ID", Long.class));
        this.flowInstanceAddNode.setActionNodeKey(this.task.getTaskDefinitionKey());
        this.flowInstanceAddNode.setAddType(Integer.valueOf(this.getAddType()));
        this.flowInstanceAddNode.setApproveNodeConfig(JSON.toJSONString((Object)this.buildApprovalNodeConfigDto(flowInfoVariables)));
        this.flowInstanceAddNode.setOpinion(StringUtils.defaultString((String)this.customCmdParams.getOpinion()));
        this.flowInstanceAddNode.setAssigneeUserIds(this.assignees.stream().map(a -> a.getId().toString()).collect(Collectors.joining(",")));
        this.flowInstanceAddNode.setAssignees(this.assignees);
        commandContext.addAttribute("_CUSTOM_CMD_PARAMS", (Object)this.customCmdParams);
        this.createDerivedProcessDefinitionForProcessInstance(commandContext, this.task.getProcessInstanceId());
        this.flowInstanceService.addNode(this.flowInstanceAddNode);
        return null;
    }

    protected void updateBpmnProcess(CommandContext commandContext, Process process, BpmnModel bpmnModel, ProcessDefinitionEntity originalProcessDefinitionEntity, DeploymentEntity newDeploymentEntity) {
        Optional<UserTask> taskDef = process.findFlowElementsOfType(UserTask.class).stream().filter(t -> this.task.getTaskDefinitionKey().equals(t.getId())).findFirst();
        if (taskDef.isEmpty()) {
            this.logger.error("Can't find task definition for key: {}", (Object)this.task.getTaskDefinitionKey());
            throw new BaseI18nException((ErrorCode)FlowErrorCode.UNKNOWN_ERROR);
        }
        UserTask userTask = taskDef.get();
        Map flowElementMap = process.getFlowElementMap();
        UserTask newUserTask = new UserTask();
        newUserTask.setId(this.nextTaskId(flowElementMap));
        newUserTask.setAssignee("${assignee}");
        newUserTask.setName(this.nodeName);
        MultiInstanceLoopCharacteristics loopCharacteristics = new MultiInstanceLoopCharacteristics();
        loopCharacteristics.setSequential(false);
        String collectionString = "${utilHelper.splitCommaString(\"" + this.assignees.stream().map(a -> a.getId().toString()).collect(Collectors.joining(",")) + "\")}";
        loopCharacteristics.setInputDataItem(collectionString);
        loopCharacteristics.setElementVariable("assignee");
        newUserTask.setLoopCharacteristics(loopCharacteristics);
        process.addFlowElement((FlowElement)newUserTask);
        SequenceFlow sequenceFlow = new SequenceFlow();
        sequenceFlow.setId(this.nextFlowId(flowElementMap));
        process.addFlowElement((FlowElement)sequenceFlow);
        this.initNewTaskAndSequenceFlow(newUserTask, sequenceFlow, userTask);
        this.buildBehavior(commandContext, newUserTask);
        this.handleBpmnGraphicInfo(bpmnModel, userTask, newUserTask, sequenceFlow);
        this.flowInstanceAddNode.setNodeKey(newUserTask.getId());
        this.flowInstanceAddNode.setNodeName(newUserTask.getName());
    }

    protected void buildBehavior(CommandContext commandContext, UserTask newUserTask) {
        ProcessEngineConfigurationImpl engineConfiguration = CommandContextUtil.getProcessEngineConfiguration((CommandContext)commandContext);
        BpmnParser bpmnParser = engineConfiguration.getBpmnParser();
        BpmnParse bpmnParse = engineConfiguration.getBpmnParseFactory().createBpmnParse(bpmnParser);
        UserTaskParseHandler userTaskParseHandler = new UserTaskParseHandler();
        userTaskParseHandler.parse(bpmnParse, (BaseElement)newUserTask);
    }

    protected void handleBpmnGraphicInfo(BpmnModel bpmnModel, UserTask currentUserTask, UserTask newUserTask, SequenceFlow sequenceFlow) {
        GraphicInfo currentTaskGraphicInfo = bpmnModel.getGraphicInfo(currentUserTask.getId());
        if (currentTaskGraphicInfo == null) {
            return;
        }
        GraphicInfo newTaskGraphicInfo = new GraphicInfo();
        double nodeWidth = currentTaskGraphicInfo.getWidth();
        double lineLength = 50.0;
        double xDiff = nodeWidth + lineLength;
        newTaskGraphicInfo.setWidth(nodeWidth);
        newTaskGraphicInfo.setHeight(currentTaskGraphicInfo.getHeight());
        newTaskGraphicInfo.setY(currentTaskGraphicInfo.getY());
        boolean moveSelf = sequenceFlow.getTargetRef().equals(newUserTask.getId());
        if (moveSelf) {
            newTaskGraphicInfo.setX(currentTaskGraphicInfo.getX());
        } else {
            newTaskGraphicInfo.setX(currentTaskGraphicInfo.getX() + xDiff);
        }
        for (GraphicInfo graphicInfo2 : bpmnModel.getLocationMap().values()) {
            boolean needMove = graphicInfo2.getX() > currentTaskGraphicInfo.getX() || moveSelf && graphicInfo2.equals(currentTaskGraphicInfo);
            if (!needMove) continue;
            graphicInfo2.setX(graphicInfo2.getX() + xDiff);
        }
        bpmnModel.getFlowLocationMap().values().stream().flatMap(Collection::stream).forEach(graphicInfo -> {
            if (graphicInfo.getX() > currentTaskGraphicInfo.getX()) {
                graphicInfo.setX(graphicInfo.getX() + xDiff);
            }
        });
        bpmnModel.addGraphicInfo(newUserTask.getId(), newTaskGraphicInfo);
        if (moveSelf) {
            bpmnModel.addFlowGraphicInfoList(sequenceFlow.getId(), this.createWayPoints(newTaskGraphicInfo.getX() + newTaskGraphicInfo.getWidth(), newTaskGraphicInfo.getY() + 15.0, newTaskGraphicInfo.getX() + newTaskGraphicInfo.getWidth() + lineLength, newTaskGraphicInfo.getY() + 15.0));
        } else {
            bpmnModel.addFlowGraphicInfoList(sequenceFlow.getId(), this.createWayPoints(newTaskGraphicInfo.getX() - lineLength, newTaskGraphicInfo.getY() + 15.0, newTaskGraphicInfo.getX(), newTaskGraphicInfo.getY() + 15.0));
        }
    }

    protected abstract int getAddType();

    protected ApprovalNodeConfigDto buildApprovalNodeConfigDto(FlowInfoVariables flowInfoVariables) {
        ApprovalNodeConfigDto currentNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowInfoVariables.getFlowProjectId().longValue(), this.flowInstanceAddNode.getFlowInstanceId().longValue(), this.flowInstanceAddNode.getActionNodeKey());
        ApprovalNodeConfigDto nodeConfigDto = new ApprovalNodeConfigDto();
        nodeConfigDto.setSignType(FlowConstant.SIGN_TYPE_NORMAL);
        nodeConfigDto.setTaskExecuteType(TaskExecuteType.PARALLEL);
        nodeConfigDto.setUseGlobalStarterConfig(currentNodeConfig.getUseGlobalStarterConfig());
        nodeConfigDto.setStarterCancel(currentNodeConfig.getStarterCancel());
        nodeConfigDto.setStarterRollback(currentNodeConfig.getStarterRollback());
        nodeConfigDto.setStarterUrge(currentNodeConfig.getStarterUrge());
        nodeConfigDto.setStarterUrgeTemplate(currentNodeConfig.getStarterUrgeTemplate());
        nodeConfigDto.setAssigneeApprove(Boolean.valueOf(true));
        nodeConfigDto.setAssigneeReject(Boolean.valueOf(true));
        nodeConfigDto.setAssigneeCancel(Boolean.valueOf(true));
        nodeConfigDto.setRejectAction(currentNodeConfig.getRejectAction());
        nodeConfigDto.setRejectToNodeKey(currentNodeConfig.getRejectToNodeKey());
        nodeConfigDto.setAssigneeType(AssigneeType.USER);
        nodeConfigDto.setAssignees(new ArrayList<IdNameDto>(this.assignees));
        nodeConfigDto.setFormFieldConfigs(currentNodeConfig.getFormFieldConfigs());
        nodeConfigDto.setSubFormFieldConfigs(currentNodeConfig.getSubFormFieldConfigs());
        return nodeConfigDto;
    }

    protected abstract void initNewTaskAndSequenceFlow(UserTask var1, SequenceFlow var2, UserTask var3);

    protected String nextId(String prefix, Map<String, FlowElement> flowElementMap) {
        String nextId = null;
        boolean nextIdNotFound = true;
        AtomicInteger counter = this.counterMap.computeIfAbsent(prefix, k -> new AtomicInteger());
        while (nextIdNotFound) {
            nextId = prefix + counter.incrementAndGet();
            if (flowElementMap.containsKey(nextId)) continue;
            nextIdNotFound = false;
        }
        return nextId;
    }

    public String nextTaskId(Map<String, FlowElement> flowElementMap) {
        return this.nextId("dynamicTask", flowElementMap);
    }

    public String nextFlowId(Map<String, FlowElement> flowElementMap) {
        return this.nextId("dynamicFlow", flowElementMap);
    }
}

