/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.task.dto.FlowTaskAddSignDto;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.flowable.flow.event.FlowableAddSignEvent;
import com.cyberway.mp.flow.flowable.flow.model.AssigneeVar;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.FlowableEngineAgenda;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.ExecutionQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityManager;

public class AddSignCmd
implements Command<Void> {
    private final String processInstanceId;
    private final String taskDefinitionId;
    private final List<String> assigneeIds;
    private final Boolean isSequentialMultiInstance;
    private final FlowTaskAddSignDto dto;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected ExecutionEntityManager executionEntityManager;
    protected TaskEntityManager taskEntityManager;
    protected FlowableEventDispatcher eventDispatcher;
    protected FlowableEngineAgenda agenda;

    public AddSignCmd(String processInstanceId, String taskDefinitionId, Boolean isSequentialMultiInstance, FlowTaskAddSignDto dto) {
        this.processInstanceId = processInstanceId;
        this.taskDefinitionId = taskDefinitionId;
        this.assigneeIds = dto.getAssigneeUserIds().stream().map(Object::toString).collect(Collectors.toList());
        this.isSequentialMultiInstance = isSequentialMultiInstance;
        this.dto = dto;
    }

    public Void execute(CommandContext commandContext) {
        this.processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration((CommandContext)commandContext);
        this.agenda = CommandContextUtil.getAgenda((CommandContext)commandContext);
        this.executionEntityManager = this.processEngineConfiguration.getExecutionEntityManager();
        this.taskEntityManager = this.processEngineConfiguration.getTaskServiceConfiguration().getTaskEntityManager();
        this.eventDispatcher = this.processEngineConfiguration.getEventDispatcher();
        commandContext.addAttribute("_CUSTOM_CMD_PARAMS", (Object)CustomCmdParams.fromFlowTaskAddSignDto(this.dto));
        ExecutionQueryImpl executionQuery = new ExecutionQueryImpl().processInstanceId(this.processInstanceId);
        List executionList = this.executionEntityManager.findExecutionsByQueryCriteria(executionQuery);
        ExecutionEntity rootExecution = null;
        Optional<ExecutionEntity> first = executionList.stream().filter(DelegateExecution::isMultiInstanceRoot).filter(item -> this.taskDefinitionId.equals(item.getActivityId())).findFirst();
        if (first.isPresent()) {
            rootExecution = first.get();
        }
        if (rootExecution == null) {
            throw new FlowableException("\u8282\u70b9\u672a\u6267\u884c\u6216\u8282\u70b9\u4e0d\u662f\u4e0d\u662f\u591a\u5b9e\u4f8b\u8282\u70b9");
        }
        if (Boolean.TRUE.equals(this.isSequentialMultiInstance)) {
            this.addTaskSequential(rootExecution, this.assigneeIds);
        } else {
            this.addTaskParallel(rootExecution, this.assigneeIds);
        }
        FlowableAddSignEvent addSignEvent = new FlowableAddSignEvent(CustomFlowableEngineEventType.ADD_SIGN, this.processInstanceId, this.dto.getFlowTaskId());
        addSignEvent.setAssigneeIds(this.assigneeIds);
        addSignEvent.setTaskDefinitionId(this.taskDefinitionId);
        this.eventDispatcher.dispatchEvent((FlowableEvent)addSignEvent, this.processEngineConfiguration.getEngineCfgKey());
        return null;
    }

    public void addTaskParallel(ExecutionEntity rootExecution, List<String> assigneeIds) {
        List<String> assigneeList;
        int nrOfInstances = this.getLoopVariable(rootExecution, "nrOfInstances");
        int nrOfActiveInstances = this.getLoopVariable(rootExecution, "nrOfActiveInstances") + assigneeIds.size();
        this.setLoopVariable(rootExecution, "nrOfInstances", nrOfInstances + assigneeIds.size());
        this.setLoopVariable(rootExecution, "nrOfActiveInstances", nrOfActiveInstances);
        Object assigneeCollection = rootExecution.getVariableLocal("multiInstanceAssignees");
        if (assigneeCollection instanceof String) {
            assigneeList = JSON.parseArray((String)assigneeCollection.toString(), String.class);
        } else {
            assigneeList = new ArrayList();
            for (int i = 0; i < nrOfInstances; ++i) {
                assigneeList.add("");
            }
        }
        UserTask userTask = (UserTask)rootExecution.getCurrentFlowElement();
        for (int i = 0; i < assigneeIds.size(); ++i) {
            ExecutionEntity concurrentExecution = CommandContextUtil.getExecutionEntityManager().createChildExecution(rootExecution);
            concurrentExecution.setCurrentFlowElement(rootExecution.getCurrentFlowElement());
            concurrentExecution.setActive(true);
            concurrentExecution.setScope(false);
            assigneeList.add(assigneeIds.get(i));
            String elementVariable = userTask.getLoopCharacteristics().getElementVariable();
            this.setLoopVariable(concurrentExecution, elementVariable, assigneeIds.get(i));
            this.agenda.planContinueMultiInstanceOperation(concurrentExecution, rootExecution, nrOfInstances + i - 1);
        }
        this.setLoopVariable(rootExecution, "multiInstanceAssignees", JSON.toJSONString(assigneeList));
    }

    public void addTaskSequential(ExecutionEntity rootExecution, List<String> assigneeIds) {
        ArrayList<String> assigneeList;
        Integer loopCounter = this.getLoopVariable(rootExecution, "loopCounter");
        Object assigneeCollection = rootExecution.getVariableLocal("multiInstanceAssignees");
        if (assigneeCollection instanceof String) {
            assigneeList = JSON.parseArray((String)assigneeCollection.toString(), String.class);
        } else {
            Object loopVariableObj = this.getSequentialAssigneeVar(rootExecution);
            List assigneeVars = JSON.parseArray((String)loopVariableObj.toString(), AssigneeVar.class);
            assigneeList = new ArrayList<String>();
            assigneeVars.forEach(a -> assigneeList.add(a.getUserId()));
        }
        String newAssigneeId = null;
        for (int i = assigneeIds.size() - 1; i >= 0; --i) {
            String userId = assigneeIds.get(i);
            assigneeList.add(loopCounter, userId);
            if (i != 0) continue;
            newAssigneeId = userId;
        }
        if (newAssigneeId == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.UNKNOWN_ERROR);
        }
        this.setLoopVariable(rootExecution, "nrOfInstances", assigneeList.size());
        this.setLoopVariable(rootExecution, "multiInstanceAssignees", JSON.toJSONString(assigneeList));
        List childExecutions = this.executionEntityManager.findChildExecutionsByParentExecutionId(rootExecution.getId());
        for (ExecutionEntity childExecution2 : childExecutions) {
            List tasksByExecution = this.taskEntityManager.findTasksByExecutionId(childExecution2.getId());
            for (TaskEntity taskEntity : tasksByExecution) {
                this.eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(taskEntity, CustomFlowableEngineEventType.DELETE_ADD_SIGN), this.processEngineConfiguration.getEngineCfgKey());
            }
        }
        childExecutions.forEach(childExecution -> this.executionEntityManager.deleteExecutionAndRelatedData(childExecution, FlowTaskDeleteReason.DELETE_BY_ADD_SIGN.name(), false));
        ExecutionEntity childExecution3 = this.executionEntityManager.createChildExecution(rootExecution);
        UserTask userTask = (UserTask)rootExecution.getCurrentFlowElement();
        childExecution3.setCurrentFlowElement((FlowElement)userTask);
        this.setLoopVariable(childExecution3, userTask.getLoopCharacteristics().getElementVariable(), newAssigneeId);
        this.agenda.planContinueMultiInstanceOperation(childExecution3, rootExecution, loopCounter.intValue());
    }

    protected void setLoopVariable(ExecutionEntity rootExecution, String variableName, Object value) {
        rootExecution.setVariableLocal(variableName, value);
    }

    protected Integer getLoopVariable(ExecutionEntity rootExecution, String variableName) {
        Object value = rootExecution.getVariableLocal(variableName);
        return (Integer)(value != null ? value : Integer.valueOf(0));
    }

    protected Object getSequentialAssigneeVar(ExecutionEntity rootExecution) {
        return rootExecution.getVariableLocal("sequentialAssignee");
    }
}

