/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import com.cyberway.mp.flow.flowable.util.ProcessUtils;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.FlowableEngineAgenda;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.api.delegate.VariableScope;

public abstract class BaseJumpCmd
implements Command<Void> {
    private final String taskId;
    private final Map<String, Object> variables;
    private final CustomCmdParams customCmdParams;
    private final boolean noAsyncJob;
    private final FlowDataHelperService flowDataHelperService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected ExecutionEntityManager executionEntityManager;
    protected FlowableEngineAgenda flowableEngineAgenda;
    protected FlowableEventDispatcher eventDispatcher;
    protected TaskService taskService;
    protected CommandContext commandContext;

    protected BaseJumpCmd(String taskId, CustomCmdParams customCmdParams, Map<String, Object> variables, boolean noAsyncJob, FlowDataHelperService flowDataHelperService) {
        this.taskId = taskId;
        this.variables = variables;
        this.customCmdParams = customCmdParams;
        this.noAsyncJob = noAsyncJob;
        this.flowDataHelperService = flowDataHelperService;
    }

    public Void execute(CommandContext commandContext) {
        this.commandContext = commandContext;
        this.processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration((CommandContext)commandContext);
        this.flowableEngineAgenda = CommandContextUtil.getAgenda((CommandContext)commandContext);
        this.executionEntityManager = this.processEngineConfiguration.getExecutionEntityManager();
        this.taskService = this.processEngineConfiguration.getTaskServiceConfiguration().getTaskService();
        this.eventDispatcher = this.processEngineConfiguration.getEventDispatcher();
        if (this.noAsyncJob) {
            commandContext.addAttribute("_NO_ASYNC_JOB", (Object)true);
        }
        commandContext.addAttribute("_CUSTOM_CMD_PARAMS", (Object)this.customCmdParams);
        TaskEntity task = this.taskService.getTask(this.taskId);
        task.setVariableLocal("_TASK_OPINION", (Object)this.customCmdParams.getOpinion());
        if (this.variables != null && !this.variables.isEmpty()) {
            task.setVariables(this.variables);
        }
        JumpNodeInfo jumpNodeInfo = this.findJumpNode(task);
        FlowElement targetNode = ProcessDefinitionUtil.getProcess((String)task.getProcessDefinitionId()).getFlowElement(jumpNodeInfo.targetNodeKey);
        commandContext.addAttribute("_REJECT_INFO", (Object)jumpNodeInfo);
        String mainDeleteReason = this.getMainDeleteReason();
        String subDeleteReason = this.getSubDeleteReason();
        CustomFlowableEngineEventType mainEventType = this.getMainEventType();
        CustomFlowableEngineEventType subEventType = this.getSubEventType();
        FlowVariableUtils.markAutoComplete(commandContext, task, this.customCmdParams.getAutoCompleteFlag());
        if (ProcessUtils.JUMP_MODE_SIMPLE.equals(jumpNodeInfo.jumpMode)) {
            this.jumpSimple(task, targetNode, mainDeleteReason, subDeleteReason, mainEventType, subEventType);
        } else {
            this.jumpParallel(task, targetNode, mainDeleteReason, subDeleteReason, mainEventType, subEventType);
        }
        return null;
    }

    protected abstract String getMainDeleteReason();

    protected abstract String getSubDeleteReason();

    protected abstract CustomFlowableEngineEventType getMainEventType();

    protected abstract CustomFlowableEngineEventType getSubEventType();

    private void jumpSimple(TaskEntity task, FlowElement targetNode, String mainDeleteReason, String subDeleteReason, CustomFlowableEngineEventType mainEventType, CustomFlowableEngineEventType subEventType) {
        String processInstanceId = task.getProcessInstanceId();
        List tasks = this.taskService.findTasksByProcessInstanceId(processInstanceId);
        for (TaskEntity t : tasks) {
            if (t.getId().equals(task.getId())) {
                TaskHelper.deleteTask((TaskEntity)t, (String)mainDeleteReason, (boolean)false, (boolean)true, (boolean)true);
                this.eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(t, mainEventType), this.processEngineConfiguration.getEngineCfgKey());
                continue;
            }
            TaskHelper.deleteTask((TaskEntity)t, (String)subDeleteReason, (boolean)false, (boolean)true, (boolean)true);
            this.eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(t, subEventType), this.processEngineConfiguration.getEngineCfgKey());
        }
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)task);
        List flowTasks = this.flowDataHelperService.listRunningStartFillTask(flowInfoVariables.getFlowInstanceId().longValue());
        for (Object flowTask : flowTasks) {
            this.eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(flowTask, processInstanceId, subEventType), this.processEngineConfiguration.getEngineCfgKey());
        }
        ExecutionEntity processExecution = (ExecutionEntity)this.executionEntityManager.findById(processInstanceId);
        for (ExecutionEntity execution : processExecution.getExecutions()) {
            ProcessUtils.deleteExecutionAndChild(this.executionEntityManager, execution, subDeleteReason);
        }
        ExecutionEntity childExecution = this.executionEntityManager.createChildExecution(processExecution);
        childExecution.setCurrentFlowElement(targetNode);
        this.flowableEngineAgenda.planContinueProcessOperation(childExecution);
    }

    private void jumpParallel(TaskEntity task, FlowElement targetNode, String mainDeleteReason, String subDeleteReason, CustomFlowableEngineEventType mainEventType, CustomFlowableEngineEventType subEventType) {
        ExecutionEntity taskExecution = (ExecutionEntity)this.executionEntityManager.findById(task.getExecutionId());
        ExecutionEntity parentExecution = taskExecution.getParent();
        List tasks = this.taskService.findTasksByExecutionId(taskExecution.getId());
        for (TaskEntity t : tasks) {
            if (t.getId().equals(task.getId())) {
                TaskHelper.deleteTask((TaskEntity)t, (String)mainDeleteReason, (boolean)false, (boolean)true, (boolean)true);
                this.eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(t, mainEventType), this.processEngineConfiguration.getEngineCfgKey());
                continue;
            }
            this.eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(t, subEventType), this.processEngineConfiguration.getEngineCfgKey());
        }
        this.executionEntityManager.deleteExecutionAndRelatedData(taskExecution, subDeleteReason, false);
        if (parentExecution.isMultiInstanceRoot()) {
            ExecutionEntity miExecution = parentExecution;
            parentExecution = parentExecution.getParent();
            for (ExecutionEntity child : miExecution.getExecutions()) {
                if (child.getId().equals(taskExecution.getId())) continue;
                for (TaskEntity childTask : this.taskService.findTasksByExecutionId(child.getId())) {
                    this.eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(childTask, subEventType), this.processEngineConfiguration.getEngineCfgKey());
                }
                this.executionEntityManager.deleteExecutionAndRelatedData(child, subDeleteReason, false);
            }
            this.executionEntityManager.deleteExecutionAndRelatedData(miExecution, subDeleteReason, false);
        }
        ExecutionEntity childExecution = this.executionEntityManager.createChildExecution(parentExecution);
        childExecution.setCurrentFlowElement(targetNode);
        this.flowableEngineAgenda.planContinueProcessOperation(childExecution);
    }

    protected abstract JumpNodeInfo findJumpNode(TaskEntity var1);

    public static class JumpNodeInfo {
        private final String sourceNodeKey;
        private final String targetNodeKey;
        private final Integer jumpMode;

        public JumpNodeInfo(String sourceNodeKey, String targetNodeKey, Integer jumpMode) {
            this.sourceNodeKey = sourceNodeKey;
            this.targetNodeKey = targetNodeKey;
            this.jumpMode = jumpMode;
        }

        public String getSourceNodeKey() {
            return this.sourceNodeKey;
        }

        public String getTargetNodeKey() {
            return this.targetNodeKey;
        }

        public Integer getJumpMode() {
            return this.jumpMode;
        }
    }
}

