/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import java.util.Map;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSignCmd
implements Command<Void> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String taskId;
    private final CustomCmdParams customCmdParams;
    private final Map<String, Object> variables;
    private final boolean noAsyncJob;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected TaskService taskService;
    protected TaskEntity task;

    protected BaseSignCmd(String taskId, CustomCmdParams customCmdParams, Map<String, Object> variables) {
        this(taskId, customCmdParams, variables, false);
    }

    protected BaseSignCmd(String taskId, CustomCmdParams customCmdParams, Map<String, Object> variables, boolean noAsyncJob) {
        this.taskId = taskId;
        this.customCmdParams = customCmdParams;
        this.variables = variables;
        this.noAsyncJob = noAsyncJob;
    }

    public Void execute(CommandContext commandContext) {
        this.processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration((CommandContext)commandContext);
        this.taskService = this.processEngineConfiguration.getTaskServiceConfiguration().getTaskService();
        if (this.noAsyncJob) {
            commandContext.addAttribute("_NO_ASYNC_JOB", (Object)true);
        }
        commandContext.addAttribute("_CUSTOM_CMD_PARAMS", (Object)this.customCmdParams);
        this.task = this.taskService.getTask(this.taskId);
        if (this.task == null) {
            if (this.noAsyncJob) {
                return null;
            }
            this.logger.error("Task id [{}] not exist", (Object)this.taskId);
            throw new BaseI18nException((ErrorCode)FlowErrorCode.UNKNOWN_ERROR);
        }
        this.task.setVariableLocal("_TASK_OPINION", (Object)this.customCmdParams.getOpinion());
        FlowVariableUtils.markAutoComplete(commandContext, this.task, this.customCmdParams.getAutoCompleteFlag());
        if (this.variables != null && !this.variables.isEmpty()) {
            this.task.setVariables(this.variables);
        }
        this.doAction(commandContext);
        return null;
    }

    protected abstract void doAction(CommandContext var1);
}

