/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelProcessCmd
implements Command<Void> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String processInstanceId;
    private final Long flowTaskId;
    private final String taskId;
    private final CustomCmdParams customCmdParams;
    private final Map<String, Object> variables;

    public CancelProcessCmd(String processInstanceId, CustomCmdParams customCmdParams, Map<String, Object> variables) {
        this.processInstanceId = processInstanceId;
        this.flowTaskId = null;
        this.taskId = null;
        this.customCmdParams = customCmdParams;
        this.variables = variables;
    }

    public CancelProcessCmd(String processInstanceId, Long flowTaskId, CustomCmdParams customCmdParams, Map<String, Object> variables) {
        this.processInstanceId = processInstanceId;
        this.flowTaskId = flowTaskId;
        this.taskId = null;
        this.customCmdParams = customCmdParams;
        this.variables = variables;
    }

    public CancelProcessCmd(Long flowTaskId, String taskId, CustomCmdParams customCmdParams, Map<String, Object> variables) {
        this.flowTaskId = flowTaskId;
        this.taskId = taskId;
        this.customCmdParams = customCmdParams;
        this.variables = variables;
    }

    public Void execute(CommandContext commandContext) {
        commandContext.addAttribute("_CUSTOM_CMD_PARAMS", (Object)this.customCmdParams);
        RuntimeService runtimeService = CommandContextUtil.getProcessEngineConfiguration().getRuntimeService();
        if (StringUtils.isNotBlank((CharSequence)this.taskId)) {
            TaskEntity task = CommandContextUtil.getTaskService().getTask(this.taskId);
            if (task == null) {
                this.logger.error("\u65e0\u6cd5\u83b7\u53d6\u5230\u4efb\u52a1\u5b9e\u4f8b[{}]", (Object)this.taskId);
                throw new BaseI18nException((ErrorCode)FlowErrorCode.UNKNOWN_ERROR);
            }
            if (StringUtils.isNotBlank((CharSequence)this.customCmdParams.getOpinion())) {
                task.setVariableLocal("_TASK_OPINION", (Object)this.customCmdParams.getOpinion());
            }
            this.processInstanceId = task.getProcessInstanceId();
        }
        if (this.flowTaskId != null) {
            commandContext.addAttribute("_MAIN_FLOW_TASK_ID", (Object)this.flowTaskId);
        }
        if (this.variables != null && !this.variables.isEmpty()) {
            runtimeService.setVariables(this.processInstanceId, this.variables);
        }
        runtimeService.deleteProcessInstance(this.processInstanceId, "CANCEL");
        return null;
    }
}

