/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.flow.api.common.dto.IdNameDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceCcDto;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import java.util.List;
import java.util.stream.Collectors;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;

public class CcInstanceCmd
implements Command<Void> {
    private final FlowDataHelperService flowDataHelperService;
    private final FlowInstance flowInstance;
    private final FlowInstanceCcDto dto;

    public CcInstanceCmd(FlowDataHelperService flowDataHelperService, FlowInstance flowInstance, FlowInstanceCcDto dto) {
        this.flowDataHelperService = flowDataHelperService;
        this.flowInstance = flowInstance;
        this.dto = dto;
    }

    public Void execute(CommandContext commandContext) {
        commandContext.addAttribute("_CUSTOM_CMD_PARAMS", (Object)CustomCmdParams.fromFlowInstanceCcDto(this.dto));
        commandContext.addAttribute("_EXTRA_INFO", (Object)JSON.toJSONString((Object)this.dto.getUsers()));
        List ccUserIdList = this.dto.getUsers().stream().map(IdNameDto::getId).collect(Collectors.toList());
        commandContext.addAttribute("_CC_USER_ID_LIST", (Object)JSON.toJSONString(ccUserIdList));
        this.flowDataHelperService.ccInstance(this.flowInstance, this.dto);
        ProcessEngineConfigurationImpl engineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        FlowableEventDispatcher eventDispatcher = engineConfiguration.getEventDispatcher();
        eventDispatcher.dispatchEvent((FlowableEvent)this.buildEvent(this.flowInstance), engineConfiguration.getEngineCfgKey());
        return null;
    }

    private CustomFlowableEntityEvent buildEvent(FlowInstance flowInstance) {
        String processInstanceId = flowInstance.getProcessInstanceId();
        CustomFlowableEntityEvent event = new CustomFlowableEntityEvent(flowInstance, processInstanceId, CustomFlowableEngineEventType.CC_INSTANCE);
        event.setExecutionId(processInstanceId);
        event.setScopeType("bpmn");
        return event;
    }
}

