/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.flow.api.common.dto.IdNameDto;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.task.dto.FlowTaskCcDto;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;

public class CcTaskCmd
implements Command<Void> {
    private final FlowDataHelperService flowDataHelperService;
    private final FlowTask flowTask;
    private final FlowTaskCcDto dto;

    public CcTaskCmd(FlowDataHelperService flowDataHelperService, FlowTask flowTask, FlowTaskCcDto dto) {
        this.flowDataHelperService = flowDataHelperService;
        this.flowTask = flowTask;
        this.dto = dto;
    }

    public Void execute(CommandContext commandContext) {
        commandContext.addAttribute("_CUSTOM_CMD_PARAMS", (Object)CustomCmdParams.fromFlowTaskCcDto(this.dto));
        commandContext.addAttribute("_EXTRA_INFO", (Object)JSON.toJSONString((Object)this.dto.getUsers()));
        List ccUserIdList = this.dto.getUsers().stream().map(IdNameDto::getId).collect(Collectors.toList());
        commandContext.addAttribute("_CC_USER_ID_LIST", (Object)JSON.toJSONString(ccUserIdList));
        if (this.flowTask.getAutoCompleteFlag() != null && !FlowConstant.AUTO_COMPLETE_FLAG_NO.equals(this.flowTask.getAutoCompleteFlag())) {
            HashSet<String> autoCompleteTaskIds = (HashSet<String>)commandContext.getAttribute("autoCompleteTaskIds");
            if (autoCompleteTaskIds == null) {
                autoCompleteTaskIds = new HashSet<String>();
                commandContext.addAttribute("autoCompleteTaskIds", autoCompleteTaskIds);
            }
            autoCompleteTaskIds.add(this.flowTask.getTaskId());
        }
        String processInstanceId = this.flowDataHelperService.ccTask(this.flowTask, this.dto);
        ProcessEngineConfigurationImpl engineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        FlowableEventDispatcher eventDispatcher = engineConfiguration.getEventDispatcher();
        eventDispatcher.dispatchEvent((FlowableEvent)this.buildEvent(this.flowTask, processInstanceId), engineConfiguration.getEngineCfgKey());
        return null;
    }

    private CustomFlowableEntityEvent buildEvent(FlowTask flowTask, String processInstanceId) {
        CustomFlowableEntityEvent event = new CustomFlowableEntityEvent(flowTask, processInstanceId, CustomFlowableEngineEventType.CC_TASK);
        event.setExecutionId(processInstanceId);
        event.setScopeType("bpmn");
        return event;
    }
}

