/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.cyberway.mp.flow.api.common.dto.FlowAdminActionDto;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.instance.dto.AttachmentInfo;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceActionDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceCcDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskActionDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskAddNodeDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskAddSignDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskAutoActionDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskCcDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskTargetNodeDto;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CustomCmdParams {
    private String opinion = "";
    private List<AttachmentInfo> attachmentInfo;
    private boolean adminAction = false;
    private int autoCompleteFlag = FlowConstant.AUTO_COMPLETE_FLAG_NO;

    public CustomCmdParams() {
    }

    public CustomCmdParams(String opinion, List<AttachmentInfo> attachmentInfo) {
        this.opinion = StringUtils.defaultString((String)opinion);
        this.attachmentInfo = attachmentInfo;
    }

    public CustomCmdParams(String opinion, List<AttachmentInfo> attachmentInfo, boolean adminAction) {
        this.opinion = StringUtils.defaultString((String)opinion);
        this.attachmentInfo = attachmentInfo;
        this.adminAction = adminAction;
    }

    public CustomCmdParams(String opinion, List<AttachmentInfo> attachmentInfo, int autoCompleteFlag) {
        this.opinion = StringUtils.defaultString((String)opinion);
        this.attachmentInfo = attachmentInfo;
        this.autoCompleteFlag = autoCompleteFlag;
    }

    public String getOpinion() {
        return this.opinion;
    }

    public void setOpinion(String opinion) {
        this.opinion = opinion;
    }

    public List<AttachmentInfo> getAttachmentInfo() {
        return this.attachmentInfo;
    }

    public void setAttachmentInfo(List<AttachmentInfo> attachmentInfo) {
        this.attachmentInfo = attachmentInfo;
    }

    public boolean isAdminAction() {
        return this.adminAction;
    }

    public void setAdminAction(boolean adminAction) {
        this.adminAction = adminAction;
    }

    public int getAutoCompleteFlag() {
        return this.autoCompleteFlag;
    }

    public void setAutoCompleteFlag(int autoCompleteFlag) {
        this.autoCompleteFlag = autoCompleteFlag;
    }

    public static CustomCmdParams fromFlowTaskActionDto(FlowTaskActionDto dto) {
        if (dto instanceof FlowTaskAutoActionDto) {
            return CustomCmdParams.fromFlowTaskAutoActionDto((FlowTaskAutoActionDto)dto);
        }
        return new CustomCmdParams(dto.getOpinion(), (List<AttachmentInfo>)dto.getAttachmentInfo(), dto instanceof FlowAdminActionDto);
    }

    public static CustomCmdParams fromFlowTaskAddNodeDto(FlowTaskAddNodeDto dto) {
        return new CustomCmdParams(dto.getOpinion(), (List<AttachmentInfo>)dto.getAttachmentInfo(), dto instanceof FlowAdminActionDto);
    }

    public static CustomCmdParams fromFlowTaskAddSignDto(FlowTaskAddSignDto dto) {
        return new CustomCmdParams(dto.getOpinion(), (List<AttachmentInfo>)dto.getAttachmentInfo(), dto instanceof FlowAdminActionDto);
    }

    public static CustomCmdParams fromFlowTaskTargetNodeDto(FlowTaskTargetNodeDto dto) {
        return new CustomCmdParams(dto.getOpinion(), (List<AttachmentInfo>)dto.getAttachmentInfo(), dto instanceof FlowAdminActionDto);
    }

    public static CustomCmdParams fromFlowInstanceActionDto(FlowInstanceActionDto dto) {
        return new CustomCmdParams(dto.getOpinion(), (List<AttachmentInfo>)dto.getAttachmentInfo(), dto instanceof FlowAdminActionDto);
    }

    public static CustomCmdParams fromFlowTaskAutoActionDto(FlowTaskAutoActionDto dto) {
        return new CustomCmdParams(dto.getOpinion(), (List<AttachmentInfo>)dto.getAttachmentInfo(), dto.getAutoCompleteFlag());
    }

    public static CustomCmdParams fromFlowTaskCcDto(FlowTaskCcDto dto) {
        return new CustomCmdParams(dto.getNote(), dto.getAttachmentInfo());
    }

    public static CustomCmdParams fromFlowInstanceCcDto(FlowInstanceCcDto dto) {
        return new CustomCmdParams(dto.getNote(), dto.getAttachmentInfo());
    }
}

