/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.cyberway.mp.flow.api.common.dto.IdNameDto;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.domain.instance.service.FlowInstanceService;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.flowable.flow.command.AbstractDynamicNodeInjectionCmd;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.flowable.util.ProcessUtils;
import java.util.Collection;
import java.util.List;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class DynamicPrevNodeInjectionCmd
extends AbstractDynamicNodeInjectionCmd {
    private UserTask newUserTask;

    public DynamicPrevNodeInjectionCmd(FlowInstanceService flowInstanceService, FlowProjectConfigCacheRepository flowProjectConfigCacheRepository, String currentTaskId, String nodeName, Collection<IdNameDto> assignees, CustomCmdParams customCmdParams) {
        super(flowInstanceService, flowProjectConfigCacheRepository, currentTaskId, nodeName, assignees, customCmdParams);
    }

    @Override
    protected int getAddType() {
        return 0;
    }

    @Override
    protected void initNewTaskAndSequenceFlow(UserTask newUserTask, SequenceFlow sequenceFlow, UserTask currentUserTask) {
        for (SequenceFlow incomingFlow : currentUserTask.getIncomingFlows()) {
            incomingFlow.setTargetFlowElement((FlowElement)newUserTask);
            incomingFlow.setTargetRef(newUserTask.getId());
            newUserTask.getIncomingFlows().add(incomingFlow);
        }
        sequenceFlow.setSourceRef(newUserTask.getId());
        sequenceFlow.setSourceFlowElement((FlowElement)newUserTask);
        sequenceFlow.setTargetRef(currentUserTask.getId());
        sequenceFlow.setTargetFlowElement((FlowElement)currentUserTask);
        currentUserTask.getIncomingFlows().add(sequenceFlow);
        newUserTask.getOutgoingFlows().add(sequenceFlow);
        this.newUserTask = newUserTask;
    }

    protected void updateExecutions(CommandContext commandContext, ProcessDefinitionEntity processDefinitionEntity, ExecutionEntity processInstance, List<ExecutionEntity> childExecutions) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration((CommandContext)commandContext);
        ExecutionEntityManager executionEntityManager = processEngineConfiguration.getExecutionEntityManager();
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        TaskService taskService = processEngineConfiguration.getTaskServiceConfiguration().getTaskService();
        boolean inParallel = ProcessUtils.checkInParallel(this.task.getProcessDefinitionId(), this.task.getTaskDefinitionKey());
        if (inParallel) {
            this.jumpPrevParallel(commandContext, executionEntityManager, eventDispatcher, taskService, processEngineConfiguration.getEngineCfgKey());
        } else {
            this.jumpPrevSimple(commandContext, executionEntityManager, eventDispatcher, taskService, processEngineConfiguration.getEngineCfgKey());
        }
    }

    private void jumpPrevSimple(CommandContext commandContext, ExecutionEntityManager executionEntityManager, FlowableEventDispatcher eventDispatcher, TaskService taskService, String engineCfgKey) {
        String processInstanceId = this.task.getProcessInstanceId();
        List tasks = taskService.findTasksByProcessInstanceId(processInstanceId);
        for (Object t : tasks) {
            if (t.getId().equals(this.task.getId())) {
                TaskHelper.deleteTask((TaskEntity)t, (String)FlowTaskDeleteReason.ADD_PREV_NODE.name(), (boolean)false, (boolean)true, (boolean)true);
                eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(this.flowInstanceAddNode, processInstanceId, CustomFlowableEngineEventType.ADD_PREV_NODE), engineCfgKey);
                continue;
            }
            TaskHelper.deleteTask((TaskEntity)t, (String)FlowTaskDeleteReason.NODE_ADD_PREV_NODE.name(), (boolean)false, (boolean)true, (boolean)true);
            eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent((TaskEntity)t, CustomFlowableEngineEventType.NODE_ADD_PREV_NODE), engineCfgKey);
        }
        ExecutionEntity processExecution = (ExecutionEntity)executionEntityManager.findById(processInstanceId);
        for (ExecutionEntity execution : processExecution.getExecutions()) {
            ProcessUtils.deleteExecutionAndChild(executionEntityManager, execution, FlowTaskDeleteReason.NODE_ADD_PREV_NODE.name());
        }
        ExecutionEntity childExecution = executionEntityManager.createChildExecution(processExecution);
        childExecution.setCurrentFlowElement((FlowElement)this.newUserTask);
        CommandContextUtil.getAgenda((CommandContext)commandContext).planContinueProcessOperation(childExecution);
    }

    private void jumpPrevParallel(CommandContext commandContext, ExecutionEntityManager executionEntityManager, FlowableEventDispatcher eventDispatcher, TaskService taskService, String engineCfgKey) {
        ExecutionEntity taskExecution = (ExecutionEntity)executionEntityManager.findById(this.task.getExecutionId());
        ExecutionEntity parentExecution = taskExecution.getParent();
        List tasks = taskService.findTasksByExecutionId(taskExecution.getId());
        for (TaskEntity t : tasks) {
            if (t.getId().equals(this.task.getId())) {
                TaskHelper.deleteTask((TaskEntity)t, (String)FlowTaskDeleteReason.ADD_PREV_NODE.name(), (boolean)false, (boolean)true, (boolean)true);
                eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(this.flowInstanceAddNode, this.task.getProcessInstanceId(), CustomFlowableEngineEventType.ADD_PREV_NODE), engineCfgKey);
                continue;
            }
            eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(t, CustomFlowableEngineEventType.NODE_ADD_PREV_NODE), engineCfgKey);
        }
        executionEntityManager.deleteExecutionAndRelatedData(taskExecution, FlowTaskDeleteReason.NODE_ADD_PREV_NODE.name(), false);
        if (parentExecution.isMultiInstanceRoot()) {
            ExecutionEntity miExecution = parentExecution;
            parentExecution = parentExecution.getParent();
            for (ExecutionEntity child : miExecution.getExecutions()) {
                if (child.getId().equals(taskExecution.getId())) continue;
                for (TaskEntity childTask : taskService.findTasksByExecutionId(child.getId())) {
                    eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(childTask, CustomFlowableEngineEventType.NODE_ADD_PREV_NODE), engineCfgKey);
                }
                executionEntityManager.deleteExecutionAndRelatedData(child, FlowTaskDeleteReason.NODE_ADD_PREV_NODE.name(), false);
            }
            executionEntityManager.deleteExecutionAndRelatedData(miExecution, FlowTaskDeleteReason.NODE_ADD_PREV_NODE.name(), false);
        }
        ExecutionEntity childExecution = executionEntityManager.createChildExecution(parentExecution);
        childExecution.setCurrentFlowElement((FlowElement)this.newUserTask);
        CommandContextUtil.getAgenda((CommandContext)commandContext).planContinueProcessOperation(childExecution);
    }
}

