/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.flowable.util.ProcessUtils;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class JumpFlowCmd
implements Command<Void> {
    private final String processInstanceId;
    private final String targetNodeKey;
    private final CustomCmdParams customCmdParams;
    private final Map<String, Object> variables;

    public JumpFlowCmd(String processInstanceId, String targetNodeKey, CustomCmdParams customCmdParams, Map<String, Object> variables) {
        this.processInstanceId = processInstanceId;
        this.targetNodeKey = targetNodeKey;
        this.customCmdParams = customCmdParams;
        this.variables = variables;
    }

    public Void execute(CommandContext commandContext) {
        commandContext.addAttribute("_CUSTOM_CMD_PARAMS", (Object)this.customCmdParams);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration((CommandContext)commandContext);
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        ExecutionEntityManager executionEntityManager = processEngineConfiguration.getExecutionEntityManager();
        ExecutionEntity processInstance = (ExecutionEntity)executionEntityManager.findById(this.processInstanceId);
        if (ProcessUtils.checkInParallel(processInstance.getProcessDefinitionId(), this.targetNodeKey)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.CAN_NOT_JUMP_INTO_PARALLEL);
        }
        if (this.variables != null && !this.variables.isEmpty()) {
            processInstance.setVariables(this.variables);
        }
        FlowElement targetElement = ProcessDefinitionUtil.getProcess((String)processInstance.getProcessDefinitionId()).getFlowElement(this.targetNodeKey);
        List tasks = processEngineConfiguration.getTaskServiceConfiguration().getTaskService().findTasksByProcessInstanceId(this.processInstanceId);
        String deleteReason = FlowTaskDeleteReason.FLOW_JUMP.name();
        for (Object task : tasks) {
            TaskHelper.deleteTask((TaskEntity)task, (String)deleteReason, (boolean)false, (boolean)true, (boolean)true);
            eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent((TaskEntity)task, CustomFlowableEngineEventType.FLOW_JUMP), processEngineConfiguration.getEngineCfgKey());
        }
        ExecutionEntity processExecution = (ExecutionEntity)executionEntityManager.findById(this.processInstanceId);
        for (ExecutionEntity execution : processExecution.getExecutions()) {
            this.deleteExecutionAndChild(executionEntityManager, execution, deleteReason);
        }
        ExecutionEntity childExecution = executionEntityManager.createChildExecution(processExecution);
        childExecution.setCurrentFlowElement(targetElement);
        CommandContextUtil.getAgenda((CommandContext)commandContext).planContinueProcessOperation(childExecution);
        eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent((DelegateExecution)processInstance, CustomFlowableEngineEventType.FLOW_JUMP), processEngineConfiguration.getEngineCfgKey());
        return null;
    }

    private void deleteExecutionAndChild(ExecutionEntityManager executionEntityManager, ExecutionEntity execution, String deleteReason) {
        for (ExecutionEntity child : execution.getExecutions()) {
            this.deleteExecutionAndChild(executionEntityManager, child, deleteReason);
        }
        execution.forceUpdate();
        executionEntityManager.deleteExecutionAndRelatedData(execution, deleteReason, false);
    }
}

