/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.flowable.flow.command.BaseJumpCmd;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.util.ProcessUtils;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import java.util.Map;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class JumpTaskCmd
extends BaseJumpCmd {
    private final String targetNodeKey;

    public JumpTaskCmd(String taskId, String targetNodeKey, CustomCmdParams customCmdParams, Map<String, Object> variables, FlowDataHelperService flowDataHelperService) {
        super(taskId, customCmdParams, variables, false, flowDataHelperService);
        this.targetNodeKey = targetNodeKey;
    }

    @Override
    protected String getMainDeleteReason() {
        return FlowTaskDeleteReason.JUMP.name();
    }

    @Override
    protected String getSubDeleteReason() {
        return FlowTaskDeleteReason.NODE_JUMP.name();
    }

    @Override
    protected CustomFlowableEngineEventType getMainEventType() {
        return CustomFlowableEngineEventType.JUMP;
    }

    @Override
    protected CustomFlowableEngineEventType getSubEventType() {
        return CustomFlowableEngineEventType.NODE_JUMP;
    }

    @Override
    protected BaseJumpCmd.JumpNodeInfo findJumpNode(TaskEntity task) {
        Integer jumpMode = ProcessUtils.checkJumpMode(task.getProcessDefinitionId(), task.getTaskDefinitionKey(), this.targetNodeKey);
        if (!ProcessUtils.JUMP_MODE_DIFFERENT_PARALLEL.equals(jumpMode)) {
            return new BaseJumpCmd.JumpNodeInfo(task.getTaskDefinitionKey(), this.targetNodeKey, jumpMode);
        }
        throw new BaseI18nException((ErrorCode)FlowErrorCode.CAN_NOT_ROLLBACK_INTO_PARALLEL);
    }
}

