/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class RejectProcessCmd
implements Command<Void> {
    private final String taskId;
    private final CustomCmdParams customCmdParams;
    private final Map<String, Object> variables;
    private final boolean noAsyncJob;

    public RejectProcessCmd(String taskId, CustomCmdParams customCmdParams, Map<String, Object> variables, boolean noAsyncJob) {
        this.taskId = taskId;
        this.customCmdParams = customCmdParams;
        this.variables = variables;
        this.noAsyncJob = noAsyncJob;
    }

    public Void execute(CommandContext commandContext) {
        if (this.noAsyncJob) {
            commandContext.addAttribute("_NO_ASYNC_JOB", (Object)true);
        }
        commandContext.addAttribute("_CUSTOM_CMD_PARAMS", (Object)this.customCmdParams);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration((CommandContext)commandContext);
        TaskService taskService = processEngineConfiguration.getTaskServiceConfiguration().getTaskService();
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        TaskEntity task = taskService.getTask(this.taskId);
        List tasks = taskService.findTasksByProcessInstanceId(task.getProcessInstanceId());
        String mainDeleteReason = FlowTaskDeleteReason.REJECT.name();
        task.setVariableLocal("_TASK_OPINION", (Object)this.customCmdParams.getOpinion());
        if (this.variables != null && !this.variables.isEmpty()) {
            task.setVariables(this.variables);
        }
        FlowVariableUtils.markAutoComplete(commandContext, task, this.customCmdParams.getAutoCompleteFlag());
        for (TaskEntity t : tasks) {
            if (t.getId().equals(task.getId())) {
                TaskHelper.deleteTask((TaskEntity)t, (String)mainDeleteReason, (boolean)false, (boolean)true, (boolean)true);
                eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(t, CustomFlowableEngineEventType.REJECT), processEngineConfiguration.getEngineCfgKey());
                continue;
            }
            TaskHelper.deleteTask((TaskEntity)t, (String)FlowTaskDeleteReason.NODE_REJECT.name(), (boolean)false, (boolean)true, (boolean)true);
            eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(t, CustomFlowableEngineEventType.NODE_REJECT), processEngineConfiguration.getEngineCfgKey());
        }
        CommandContextUtil.getProcessEngineConfiguration().getRuntimeService().deleteProcessInstance(task.getProcessInstanceId(), mainDeleteReason);
        return null;
    }
}

