/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import cn.hutool.extra.spring.SpringUtil;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.domain.node.entity.FlowNode;
import com.cyberway.mp.flow.domain.node.service.FlowNodeService;
import com.cyberway.mp.flow.flowable.flow.command.BaseJumpCmd;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import com.cyberway.mp.flow.flowable.util.ProcessUtils;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import java.util.List;
import java.util.Map;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class RollbackTaskCmd
extends BaseJumpCmd {
    private final boolean reject;
    private final String targetNodeKey;

    public RollbackTaskCmd(String taskId, CustomCmdParams customCmdParams, Map<String, Object> variables, String targetNodeKey, boolean reject, boolean noAsyncJob, FlowDataHelperService flowDataHelperService) {
        super(taskId, customCmdParams, variables, noAsyncJob, flowDataHelperService);
        this.targetNodeKey = targetNodeKey;
        this.reject = reject;
    }

    @Override
    protected String getMainDeleteReason() {
        return this.reject ? FlowTaskDeleteReason.REJECT.name() : FlowTaskDeleteReason.ROLLBACK_TO_SPECIAL.name();
    }

    @Override
    protected String getSubDeleteReason() {
        return this.reject ? FlowTaskDeleteReason.NODE_REJECT.name() : FlowTaskDeleteReason.NODE_ROLLBACK_SPECIAL.name();
    }

    @Override
    protected CustomFlowableEngineEventType getMainEventType() {
        return this.reject ? CustomFlowableEngineEventType.REJECT : CustomFlowableEngineEventType.ROLLBACK_TO_SPECIAL;
    }

    @Override
    protected CustomFlowableEngineEventType getSubEventType() {
        return this.reject ? CustomFlowableEngineEventType.NODE_REJECT : CustomFlowableEngineEventType.NODE_ROLLBACK_SPECIAL;
    }

    @Override
    protected BaseJumpCmd.JumpNodeInfo findJumpNode(TaskEntity task) {
        String sourceNodeKey = task.getTaskDefinitionKey();
        Integer jumpMode = ProcessUtils.checkJumpMode(task.getProcessDefinitionId(), sourceNodeKey, this.targetNodeKey);
        if (ProcessUtils.JUMP_MODE_DIFFERENT_PARALLEL.equals(jumpMode)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.CAN_NOT_ROLLBACK_INTO_PARALLEL);
        }
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)task);
        List finNodes = ((FlowNodeService)SpringUtil.getBean(FlowNodeService.class)).listForRollbackPrev(flowInfoVariables.getFlowInstanceId().longValue());
        for (FlowNode finNode : finNodes) {
            switch (finNode.getStatus()) {
                case COMPLETED: 
                case JUMPED: {
                    if (!finNode.getNodeKey().equals(this.targetNodeKey)) break;
                    return new BaseJumpCmd.JumpNodeInfo(sourceNodeKey, finNode.getNodeKey(), jumpMode);
                }
            }
        }
        throw new BaseI18nException((ErrorCode)FlowErrorCode.ROLLBACK_NODE_NOT_EXECUTED);
    }
}

