/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import cn.hutool.extra.spring.SpringUtil;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.domain.node.entity.FlowNode;
import com.cyberway.mp.flow.domain.node.service.FlowNodeService;
import com.cyberway.mp.flow.flowable.flow.command.BaseJumpCmd;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import com.cyberway.mp.flow.flowable.util.ProcessUtils;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import java.util.List;
import java.util.Map;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class RollbackTaskPrevCmd
extends BaseJumpCmd {
    private final boolean reject;

    public RollbackTaskPrevCmd(String taskId, CustomCmdParams customCmdParams, Map<String, Object> variables, boolean reject, boolean noAsyncJob, FlowDataHelperService flowDataHelperService) {
        super(taskId, customCmdParams, variables, noAsyncJob, flowDataHelperService);
        this.reject = reject;
    }

    @Override
    protected String getMainDeleteReason() {
        return this.reject ? FlowTaskDeleteReason.REJECT.name() : FlowTaskDeleteReason.ROLLBACK_TO_PREV.name();
    }

    @Override
    protected String getSubDeleteReason() {
        return this.reject ? FlowTaskDeleteReason.NODE_REJECT.name() : FlowTaskDeleteReason.NODE_ROLLBACK_PERV.name();
    }

    @Override
    protected CustomFlowableEngineEventType getMainEventType() {
        return this.reject ? CustomFlowableEngineEventType.REJECT : CustomFlowableEngineEventType.ROLLBACK_TO_PREV;
    }

    @Override
    protected CustomFlowableEngineEventType getSubEventType() {
        return this.reject ? CustomFlowableEngineEventType.NODE_REJECT : CustomFlowableEngineEventType.NODE_ROLLBACK_PERV;
    }

    @Override
    protected BaseJumpCmd.JumpNodeInfo findJumpNode(TaskEntity task) {
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)task);
        List flowNodes = ((FlowNodeService)SpringUtil.getBean(FlowNodeService.class)).listForRollbackPrev(flowInfoVariables.getFlowInstanceId().longValue());
        boolean skipForRollback = false;
        String skipToNodeKey = task.getTaskDefinitionKey();
        for (FlowNode flowNode : flowNodes) {
            if (skipForRollback && skipToNodeKey.equals(flowNode.getNodeKey())) {
                skipForRollback = false;
            } else if (!skipForRollback && !task.getTaskDefinitionKey().equals(flowNode.getNodeKey())) {
                switch (flowNode.getStatus()) {
                    case COMPLETED: 
                    case JUMPED: {
                        Integer jumpMode = ProcessUtils.checkJumpMode(task.getProcessDefinitionId(), task.getTaskDefinitionKey(), flowNode.getNodeKey());
                        if (ProcessUtils.JUMP_MODE_DIFFERENT_PARALLEL.equals(jumpMode)) break;
                        return new BaseJumpCmd.JumpNodeInfo(skipToNodeKey, flowNode.getNodeKey(), jumpMode);
                    }
                    case REJECTED: 
                    case ROLLBACK_PREV: 
                    case ROLLBACK: 
                    case ROLLBACK_START: {
                        skipForRollback = true;
                        break;
                    }
                }
            }
        }
        throw new BaseI18nException((ErrorCode)FlowErrorCode.NO_PREV_STEP_TO_ROLLBACK);
    }
}

