/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.flowable.flow.command.BaseJumpCmd;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import com.cyberway.mp.flow.flowable.util.ProcessUtils;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import java.util.Map;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class RollbackTaskStartCmd
extends BaseJumpCmd {
    private final boolean reject;

    public RollbackTaskStartCmd(String taskId, CustomCmdParams customCmdParams, Map<String, Object> variables, boolean reject, boolean noAsyncJob, FlowDataHelperService flowDataHelperService) {
        super(taskId, customCmdParams, variables, noAsyncJob, flowDataHelperService);
        this.reject = reject;
    }

    @Override
    protected String getMainDeleteReason() {
        return this.reject ? FlowTaskDeleteReason.REJECT.name() : FlowTaskDeleteReason.ROLLBACK_TO_START.name();
    }

    @Override
    protected String getSubDeleteReason() {
        return this.reject ? FlowTaskDeleteReason.NODE_REJECT.name() : FlowTaskDeleteReason.NODE_ROLLBACK_START.name();
    }

    @Override
    protected CustomFlowableEngineEventType getMainEventType() {
        return this.reject ? CustomFlowableEngineEventType.REJECT : CustomFlowableEngineEventType.ROLLBACK_TO_START;
    }

    @Override
    protected CustomFlowableEngineEventType getSubEventType() {
        return this.reject ? CustomFlowableEngineEventType.NODE_REJECT : CustomFlowableEngineEventType.NODE_ROLLBACK_START;
    }

    @Override
    protected BaseJumpCmd.JumpNodeInfo findJumpNode(TaskEntity task) {
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)task);
        if (ProcessUtils.skipFirstNode(flowInfoVariables.getFlowProjectId())) {
            this.commandContext.addAttribute("_RESUBMIT_CONTEXT", (Object)true);
        }
        Process process = ProcessDefinitionUtil.getProcess((String)task.getProcessDefinitionId());
        FlowNode initialFlowElement = (FlowNode)process.getInitialFlowElement();
        FlowElement targetFlowElement = ((SequenceFlow)initialFlowElement.getOutgoingFlows().get(0)).getTargetFlowElement();
        return new BaseJumpCmd.JumpNodeInfo(task.getTaskDefinitionKey(), targetFlowElement.getId(), ProcessUtils.JUMP_MODE_SIMPLE);
    }
}

