/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.flowable.flow.command.BaseSignCmd;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.BpmnLoggingSessionUtil;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.task.api.DelegationState;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class SignWaiverCmd
extends BaseSignCmd {
    public SignWaiverCmd(String taskId, CustomCmdParams customCmdParams, Map<String, Object> variables) {
        super(taskId, customCmdParams, variables);
    }

    @Override
    protected void doAction(CommandContext commandContext) {
        this.handleCurrentTask(this.task);
        ExecutionEntity currentExecution = (ExecutionEntity)this.processEngineConfiguration.getExecutionEntityManager().findById(this.task.getExecutionId());
        currentExecution.setDeleteReason(FlowTaskDeleteReason.SIGN_WAIVER.name());
        CommandContextUtil.getAgenda((CommandContext)commandContext).planTriggerExecutionOperation(currentExecution);
    }

    private void handleCurrentTask(TaskEntity task) {
        if (task.getDelegationState() != null && task.getDelegationState() == DelegationState.PENDING) {
            throw new FlowableException("A delegated task cannot be completed, but should be resolved instead.");
        }
        FlowableEventDispatcher eventDispatcher = this.processEngineConfiguration.getEventDispatcher();
        eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(task, CustomFlowableEngineEventType.SIGN_WAIVER), this.processEngineConfiguration.getEngineCfgKey());
        if (this.processEngineConfiguration.isLoggingSessionEnabled() && task.getExecutionId() != null) {
            String taskLabel = StringUtils.isNotEmpty((CharSequence)task.getName()) ? task.getName() : task.getId();
            ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(task.getExecutionId());
            if (execution != null) {
                BpmnLoggingSessionUtil.addLoggingData((String)CustomFlowableEngineEventType.SIGN_WAIVER.name(), (String)("User task '" + taskLabel + "' rollBack to pervious"), (TaskEntity)task, (DelegateExecution)execution);
            }
        }
        TaskHelper.deleteTask((TaskEntity)task, (String)FlowTaskDeleteReason.SIGN_WAIVER.name(), (boolean)false, (boolean)true, (boolean)true);
    }
}

