/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.cyberway.mp.flow.api.task.dto.FlowTaskActionDto;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithProject;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import java.util.List;
import org.apache.commons.lang3.tuple.Triple;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;

public class StarterFillCmd
implements Command<Void> {
    private final FlowDataHelperService flowDataHelperService;
    private final FlowTaskWithProject task;
    private final FlowTaskActionDto dto;

    public StarterFillCmd(FlowDataHelperService flowDataHelperService, FlowTaskWithProject task, FlowTaskActionDto dto) {
        this.flowDataHelperService = flowDataHelperService;
        this.task = task;
        this.dto = dto;
    }

    public Void execute(CommandContext commandContext) {
        commandContext.addAttribute("_CUSTOM_CMD_PARAMS", (Object)CustomCmdParams.fromFlowTaskActionDto(this.dto));
        Triple triple = this.flowDataHelperService.starterFill(this.task, this.dto);
        ProcessEngineConfigurationImpl engineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        String processInstanceId = ((FlowInstance)triple.getRight()).getProcessInstanceId();
        if (this.dto.getVariables() != null && !this.dto.getVariables().isEmpty()) {
            RuntimeService runtimeService = engineConfiguration.getRuntimeService();
            runtimeService.setVariables(processInstanceId, this.dto.getVariables());
        }
        FlowableEventDispatcher eventDispatcher = engineConfiguration.getEventDispatcher();
        eventDispatcher.dispatchEvent((FlowableEvent)this.buildEvent((FlowTask)this.task, CustomFlowableEngineEventType.STARTER_FILL, processInstanceId), engineConfiguration.getEngineCfgKey());
        ((List)triple.getLeft()).forEach(t -> eventDispatcher.dispatchEvent((FlowableEvent)this.buildEvent((FlowTask)t, CustomFlowableEngineEventType.NODE_STARTER_FILL, processInstanceId), engineConfiguration.getEngineCfgKey()));
        eventDispatcher.dispatchEvent((FlowableEvent)this.buildEvent((FlowTask)triple.getMiddle(), CustomFlowableEngineEventType.STARTER_FILL_START, processInstanceId), engineConfiguration.getEngineCfgKey());
        return null;
    }

    private CustomFlowableEntityEvent buildEvent(FlowTask flowTask, CustomFlowableEngineEventType eventType, String processInstanceId) {
        CustomFlowableEntityEvent event = new CustomFlowableEntityEvent(flowTask, processInstanceId, eventType);
        event.setExecutionId(processInstanceId);
        event.setScopeType("bpmn");
        return event;
    }
}

