/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.cyberway.mp.flow.api.task.dto.FlowTaskActionDto;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithProject;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import java.util.List;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;

public class StarterFillCompleteCmd
implements Command<Void> {
    private final FlowDataHelperService flowDataHelperService;
    private final FlowTaskWithProject task;
    private final FlowTaskActionDto dto;

    public StarterFillCompleteCmd(FlowDataHelperService flowDataHelperService, FlowTaskWithProject task, FlowTaskActionDto dto) {
        this.flowDataHelperService = flowDataHelperService;
        this.task = task;
        this.dto = dto;
    }

    public Void execute(CommandContext commandContext) {
        commandContext.addAttribute("_CUSTOM_CMD_PARAMS", (Object)CustomCmdParams.fromFlowTaskActionDto(this.dto));
        List restartTasks = this.flowDataHelperService.completeStarterFillTask(this.task, this.dto);
        ProcessEngineConfigurationImpl engineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        FlowInstance flowInstance = this.flowDataHelperService.getFlowInstance(this.task.getFlowInstanceId());
        String processInstanceId = flowInstance.getProcessInstanceId();
        if (this.dto.getVariables() != null && !this.dto.getVariables().isEmpty()) {
            RuntimeService runtimeService = engineConfiguration.getRuntimeService();
            runtimeService.setVariables(processInstanceId, this.dto.getVariables());
        }
        FlowableEventDispatcher eventDispatcher = engineConfiguration.getEventDispatcher();
        eventDispatcher.dispatchEvent((FlowableEvent)this.buildEvent((FlowTask)this.task, CustomFlowableEngineEventType.STARTER_FILL_COMPLETE, processInstanceId), engineConfiguration.getEngineCfgKey());
        restartTasks.forEach(t -> eventDispatcher.dispatchEvent((FlowableEvent)this.buildEvent((FlowTask)t, CustomFlowableEngineEventType.WAIT_STARTER_FILL_FIN, processInstanceId), engineConfiguration.getEngineCfgKey()));
        return null;
    }

    private CustomFlowableEntityEvent buildEvent(FlowTask flowTask, CustomFlowableEngineEventType eventType, String processInstanceId) {
        CustomFlowableEntityEvent event = new CustomFlowableEntityEvent(flowTask, processInstanceId, eventType);
        event.setExecutionId(processInstanceId);
        event.setScopeType("bpmn");
        return event;
    }
}

