/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.cyberway.mp.flow.api.task.enums.FlowTaskType;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import java.util.Map;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.NeedsActiveTaskCmd;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class TransferTaskCmd
extends NeedsActiveTaskCmd<Void> {
    public static final String PARAM_NEW_ASSIGNEE_ID = "newAssigneeId";
    public static final String PARAM_PROCESS_INSTANCE_ID = "processInstanceId";
    private final FlowTask flowTask;
    private final FlowInstance flowInstance;
    private final Long newAssigneeId;
    private final transient Map<String, Object> variables;
    private final CustomCmdParams customCmdParams;

    public TransferTaskCmd(FlowTask flowTask, FlowInstance flowInstance, Long newAssigneeId, Map<String, Object> variables, CustomCmdParams customCmdParams) {
        super(flowTask.getTaskId());
        this.flowTask = flowTask;
        this.flowInstance = flowInstance;
        this.newAssigneeId = newAssigneeId;
        this.variables = variables;
        this.customCmdParams = customCmdParams;
    }

    public Void execute(CommandContext commandContext) {
        if (FlowTaskType.STARTER_FILL.equals((Object)this.flowTask.getTaskType()) || FlowTaskType.DRAFT.equals((Object)this.flowTask.getTaskType())) {
            return this.executeDirect(commandContext);
        }
        return (Void)super.execute(commandContext);
    }

    private Void executeDirect(CommandContext commandContext) {
        commandContext.addAttribute("_CUSTOM_CMD_PARAMS", (Object)this.customCmdParams);
        ProcessEngineConfigurationImpl engineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        String processInstanceId = this.flowInstance.getProcessInstanceId();
        if (this.variables != null && !this.variables.isEmpty()) {
            RuntimeService runtimeService = engineConfiguration.getRuntimeService();
            runtimeService.setVariables(processInstanceId, this.variables);
        }
        FlowableEventDispatcher eventDispatcher = engineConfiguration.getEventDispatcher();
        CustomFlowableEntityEvent event = new CustomFlowableEntityEvent(this.flowTask, processInstanceId, CustomFlowableEngineEventType.TRANSFER_TASK);
        event.setExecutionId(processInstanceId);
        event.setProcessInstanceId(processInstanceId);
        event.setScopeType("bpmn");
        event.addAppendParam(PARAM_NEW_ASSIGNEE_ID, this.newAssigneeId);
        event.addAppendParam(PARAM_PROCESS_INSTANCE_ID, processInstanceId);
        eventDispatcher.dispatchEvent((FlowableEvent)event, engineConfiguration.getEngineCfgKey());
        return null;
    }

    protected Void execute(CommandContext commandContext, TaskEntity task) {
        String owner = task.getOwner();
        if (owner == null) {
            task.setOwner(task.getAssignee());
        }
        commandContext.addAttribute("_CUSTOM_CMD_PARAMS", (Object)this.customCmdParams);
        task.setVariableLocal("_TASK_OPINION", (Object)this.customCmdParams.getOpinion());
        if (this.variables != null && !this.variables.isEmpty()) {
            task.setVariables(this.variables);
        }
        TaskHelper.changeTaskAssignee((TaskEntity)task, (String)this.newAssigneeId.toString());
        return null;
    }
}

