/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.flowable.flow.event.FlowableWithdrawApprovalEvent;
import com.cyberway.mp.flow.flowable.flow.model.AssigneeVar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.FlowableEngineAgenda;
import org.flowable.engine.HistoryService;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.ExecutionQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ActivityInstanceEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class WithdrawApproveCmd
implements Command<Void> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String historicTaskId;
    private final CustomCmdParams customCmdParams;
    private final Boolean isSequentialMultiInstance;
    protected ExecutionEntityManager executionEntityManager;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected FlowableEngineAgenda flowableEngineAgenda;
    protected ActivityInstanceEntityManager activityInstanceEntityManager;
    protected HistoricActivityInstanceEntityManager historicActivityInstanceEntityManager;
    protected FlowableEngineAgenda agenda;
    protected TaskEntityManager taskEntityManager;
    protected FlowableEventDispatcher eventDispatcher;
    protected IdGenerator idGenerator;
    protected HistoryService historyService;
    protected HistoricTaskInstance historicTaskInstance;

    public WithdrawApproveCmd(String historicTaskId, CustomCmdParams customCmdParams, Boolean isSequentialMultiInstance) {
        this.historicTaskId = historicTaskId;
        this.customCmdParams = customCmdParams;
        this.isSequentialMultiInstance = isSequentialMultiInstance;
    }

    public Void execute(CommandContext commandContext) {
        this.logger.info("\u64a4\u56de\u5ba1\u6279\u5f00\u59cb historicTaskId\uff1a{}", (Object)this.historicTaskId);
        this.processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration((CommandContext)commandContext);
        this.flowableEngineAgenda = CommandContextUtil.getAgenda((CommandContext)commandContext);
        this.executionEntityManager = this.processEngineConfiguration.getExecutionEntityManager();
        this.idGenerator = this.processEngineConfiguration.getIdGenerator();
        this.activityInstanceEntityManager = this.processEngineConfiguration.getActivityInstanceEntityManager();
        this.historicActivityInstanceEntityManager = this.processEngineConfiguration.getHistoricActivityInstanceEntityManager();
        this.historyService = this.processEngineConfiguration.getHistoryService();
        this.agenda = CommandContextUtil.getAgenda((CommandContext)commandContext);
        this.historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(this.historicTaskId)).singleResult();
        this.taskEntityManager = this.processEngineConfiguration.getTaskServiceConfiguration().getTaskEntityManager();
        this.eventDispatcher = this.processEngineConfiguration.getEventDispatcher();
        if (this.historicTaskInstance == null) {
            throw new FlowableException("\u5386\u53f2\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u64a4\u56de\u5ba1\u6279");
        }
        ExecutionQueryImpl executionQuery = new ExecutionQueryImpl().processInstanceId(this.historicTaskInstance.getProcessInstanceId());
        List executions = this.executionEntityManager.findExecutionsByQueryCriteria(executionQuery);
        if (CollectionUtils.isEmpty((Collection)executions)) {
            throw new FlowableException("\u4efb\u52a1\u5ba1\u6279\u7ed3\u675f\uff0c\u4e0d\u80fd\u64a4\u56de");
        }
        ExecutionEntity rootExecution = null;
        Optional<ExecutionEntity> first = executions.stream().filter(item -> this.historicTaskInstance.getTaskDefinitionKey().equals(item.getActivityId())).filter(DelegateExecution::isMultiInstanceRoot).findFirst();
        if (first.isPresent()) {
            rootExecution = first.get();
        }
        if (rootExecution == null) {
            throw new FlowableException("\u8282\u70b9\u672a\u6267\u884c\u6216\u8282\u70b9\u4e0d\u662f\u4e0d\u662f\u591a\u5b9e\u4f8b\u8282\u70b9");
        }
        commandContext.addAttribute("_CUSTOM_CMD_PARAMS", (Object)this.customCmdParams);
        if (Boolean.TRUE.equals(this.isSequentialMultiInstance)) {
            this.withdrawTaskSequential(rootExecution);
        } else {
            this.withdrawTaskParallel(rootExecution);
        }
        FlowableWithdrawApprovalEvent withdrawApprovalEvent = new FlowableWithdrawApprovalEvent(this.historicTaskInstance.getProcessInstanceId(), this.historicTaskInstance.getId());
        this.eventDispatcher.dispatchEvent((FlowableEvent)withdrawApprovalEvent, this.processEngineConfiguration.getEngineCfgKey());
        this.logger.info("\u64a4\u56de\u4efb\u52a1\u5ba1\u6279 historicTaskId:{}", (Object)this.historicTaskId);
        return null;
    }

    private void withdrawTaskSequential(ExecutionEntity rootExecution) {
        ArrayList<String> assigneeList;
        Object assigneeCollection = rootExecution.getVariableLocal("multiInstanceAssignees");
        if (assigneeCollection instanceof String) {
            assigneeList = JSON.parseArray((String)assigneeCollection.toString(), String.class);
        } else {
            Object loopVariableObj = this.getLoopVariableObj(rootExecution, "sequentialAssignee");
            List assigneeVars = JSON.parseArray((String)loopVariableObj.toString(), AssigneeVar.class);
            assigneeList = new ArrayList<String>();
            assigneeVars.forEach(a -> assigneeList.add(a.getUserId()));
        }
        Integer loopCounter = this.getLoopVariable(rootExecution, "loopCounter");
        boolean removeOld = false;
        for (int i = 0; i < loopCounter; ++i) {
            String assigneeId = (String)assigneeList.get(i);
            if (!assigneeId.equals(this.historicTaskInstance.getOwner())) continue;
            assigneeList.remove(i);
            assigneeList.add(loopCounter - 1, assigneeId);
            removeOld = true;
            break;
        }
        if (!removeOld) {
            throw new FlowableException("\u56de\u9000\u4efb\u52a1\u7684\u5ba1\u6279\u4eba\u4e0d\u5b58\u5728\u5386\u53f2\u5ba1\u6279\u4eba\u5217\u8868\u4e2d");
        }
        int nrOfActiveInstances = this.getLoopVariable(rootExecution, "nrOfActiveInstances") + 1;
        this.setLoopVariable(rootExecution, "nrOfActiveInstances", nrOfActiveInstances);
        this.setLoopVariable(rootExecution, "multiInstanceAssignees", JSON.toJSONString(assigneeList));
        List childExecutions = this.executionEntityManager.findChildExecutionsByParentExecutionId(rootExecution.getId());
        for (ExecutionEntity childExecution2 : childExecutions) {
            List tasksByExecution = this.taskEntityManager.findTasksByExecutionId(childExecution2.getId());
            for (TaskEntity taskEntity : tasksByExecution) {
                this.eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(taskEntity, CustomFlowableEngineEventType.TASK_APPROVAL_WITHDRAW), this.processEngineConfiguration.getEngineCfgKey());
            }
        }
        childExecutions.forEach(childExecution -> this.executionEntityManager.deleteExecutionAndRelatedData(childExecution, FlowTaskDeleteReason.TASK_APPROVAL_WITHDRAW.name(), false));
        ExecutionEntity concurrentExecution = CommandContextUtil.getExecutionEntityManager().createChildExecution(rootExecution);
        concurrentExecution.setCurrentFlowElement(rootExecution.getCurrentFlowElement());
        concurrentExecution.setActive(true);
        concurrentExecution.setScope(false);
        this.fixSignNum(rootExecution);
        UserTask userTask = (UserTask)rootExecution.getCurrentFlowElement();
        String elementVariable = userTask.getLoopCharacteristics().getElementVariable();
        this.setLoopVariable(concurrentExecution, elementVariable, this.historicTaskInstance.getOwner());
        this.agenda.planContinueMultiInstanceOperation(concurrentExecution, rootExecution, loopCounter - 1);
    }

    private void fixSignNum(ExecutionEntity rootExecution) {
        if (FlowTaskDeleteReason.APPROVE.name().equals(this.historicTaskInstance.getDeleteReason()) || null == this.historicTaskInstance.getDeleteReason()) {
            int nrOfCompletedInstances = this.getLoopVariable(rootExecution, "nrOfCompletedInstances");
            this.setLoopVariable(rootExecution, "nrOfCompletedInstances", nrOfCompletedInstances - 1);
        } else {
            int nrOfRejectInstances = this.getLoopVariable(rootExecution, "nrOfRollbackInstances");
            this.setLoopVariable(rootExecution, "nrOfRollbackInstances", nrOfRejectInstances - 1);
        }
    }

    public void withdrawTaskParallel(ExecutionEntity rootExecution) {
        int nrOfActiveInstances = this.getLoopVariable(rootExecution, "nrOfActiveInstances") + 1;
        this.setLoopVariable(rootExecution, "nrOfActiveInstances", nrOfActiveInstances);
        this.fixSignNum(rootExecution);
        UserTask userTask = (UserTask)rootExecution.getCurrentFlowElement();
        ExecutionEntity concurrentExecution = CommandContextUtil.getExecutionEntityManager().createChildExecution(rootExecution);
        concurrentExecution.setCurrentFlowElement((FlowElement)userTask);
        concurrentExecution.setActive(true);
        concurrentExecution.setScope(false);
        String elementVariable = userTask.getLoopCharacteristics().getElementVariable();
        this.setLoopVariable(concurrentExecution, elementVariable, this.historicTaskInstance.getAssignee());
        int nrOfInstances = this.getLoopVariable(rootExecution, "nrOfInstances");
        this.agenda.planContinueMultiInstanceOperation(concurrentExecution, rootExecution, nrOfInstances);
    }

    protected void setLoopVariable(ExecutionEntity rootExecution, String variableName, Object value) {
        rootExecution.setVariableLocal(variableName, value);
    }

    protected Integer getLoopVariable(ExecutionEntity rootExecution, String variableName) {
        Object value = rootExecution.getVariableLocal(variableName);
        return (Integer)(value != null ? value : Integer.valueOf(0));
    }

    protected Object getLoopVariableObj(ExecutionEntity rootExecution, String variableName) {
        return rootExecution.getVariableLocal(variableName);
    }
}

