/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.flow.command;

import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.flowable.flow.event.FlowableWithdrawProcessEvent;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import com.cyberway.mp.flow.flowable.util.ProcessUtils;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.FlowableEngineAgenda;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WithdrawProcessCmd
implements Command<Void> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String processInstanceId;
    private final Map<String, Object> variables;
    private final CustomCmdParams customCmdParams;
    private ExecutionEntityManager executionEntityManager;
    private final FlowDataHelperService flowDataHelperService;

    public WithdrawProcessCmd(String processInstanceId, CustomCmdParams customCmdParams, Map<String, Object> variables, FlowDataHelperService flowDataHelperService) {
        this.processInstanceId = processInstanceId;
        this.customCmdParams = customCmdParams;
        this.variables = variables;
        this.flowDataHelperService = flowDataHelperService;
    }

    public Void execute(CommandContext commandContext) {
        this.logger.info("\u64a4\u56de\u6d41\u7a0b\u5b9e\u4f8b\u5f00\u59cb processInstanceId:{}", (Object)this.processInstanceId);
        commandContext.addAttribute("_CUSTOM_CMD_PARAMS", (Object)this.customCmdParams);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration((CommandContext)commandContext);
        FlowableEngineAgenda flowableEngineAgenda = CommandContextUtil.getAgenda((CommandContext)commandContext);
        this.executionEntityManager = processEngineConfiguration.getExecutionEntityManager();
        TaskService taskService = processEngineConfiguration.getTaskServiceConfiguration().getTaskService();
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        RuntimeService runtimeService = processEngineConfiguration.getRuntimeService();
        if (this.variables != null && !this.variables.isEmpty()) {
            runtimeService.setVariables(this.processInstanceId, this.variables);
        }
        ProcessInstance processInstance = (ProcessInstance)runtimeService.createProcessInstanceQuery().processInstanceId(this.processInstanceId).singleResult();
        Process process = ProcessDefinitionUtil.getProcess((String)processInstance.getProcessDefinitionId());
        FlowNode initialFlowElement = (FlowNode)process.getInitialFlowElement();
        FlowElement targetFlowElement = ((SequenceFlow)initialFlowElement.getOutgoingFlows().get(0)).getTargetFlowElement();
        String deleteReason = FlowTaskDeleteReason.PROCESS_WITHDRAW.name();
        CustomFlowableEngineEventType eventType = CustomFlowableEngineEventType.PROCESS_WITHDRAW;
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables(runtimeService, this.processInstanceId);
        if (ProcessUtils.skipFirstNode(flowInfoVariables.getFlowProjectId())) {
            commandContext.addAttribute("_RESUBMIT_CONTEXT", (Object)true);
        }
        List tasks = taskService.findTasksByProcessInstanceId(this.processInstanceId);
        for (Object t : tasks) {
            TaskHelper.deleteTask((TaskEntity)t, (String)deleteReason, (boolean)false, (boolean)true, (boolean)true);
            eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent((TaskEntity)t, eventType), processEngineConfiguration.getEngineCfgKey());
        }
        List flowTasks = this.flowDataHelperService.listRunningStartFillTask(flowInfoVariables.getFlowInstanceId().longValue());
        for (Object flowTask : flowTasks) {
            eventDispatcher.dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(flowTask, this.processInstanceId, eventType), processEngineConfiguration.getEngineCfgKey());
        }
        ExecutionEntity processExecution = (ExecutionEntity)this.executionEntityManager.findById(this.processInstanceId);
        for (ExecutionEntity execution : processExecution.getExecutions()) {
            this.deleteExecutionAndChild(execution, deleteReason);
        }
        ExecutionEntity childExecution = this.executionEntityManager.createChildExecution(processExecution);
        childExecution.setCurrentFlowElement(targetFlowElement);
        flowableEngineAgenda.planContinueProcessOperation(childExecution);
        FlowableWithdrawProcessEvent withdrawProcessEvent = new FlowableWithdrawProcessEvent(this.processInstanceId);
        eventDispatcher.dispatchEvent((FlowableEvent)withdrawProcessEvent, processEngineConfiguration.getEngineCfgKey());
        return null;
    }

    private void deleteExecutionAndChild(ExecutionEntity execution, String subDeleteReason) {
        for (ExecutionEntity child : execution.getExecutions()) {
            this.deleteExecutionAndChild(child, subDeleteReason);
        }
        execution.forceUpdate();
        this.executionEntityManager.deleteExecutionAndRelatedData(execution, subDeleteReason, false);
    }
}

