/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.listener;

import com.cyberway.mp.flow.flowable.service.AsyncEventActionService;
import com.cyberway.mp.flow.flowable.service.AsyncEventActionTask;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandContextCloseListener;

public class AsyncActionListener
implements CommandContextCloseListener {
    public static final String ATTR_NAME = "asyncActionTasks";
    public static final String ATTR_ANY_CHANGE = "asyncAnyChange";
    private final AsyncEventActionService asyncEventActionService;

    public AsyncActionListener(AsyncEventActionService asyncEventActionService) {
        this.asyncEventActionService = asyncEventActionService;
    }

    public void closing(CommandContext commandContext) {
    }

    public void afterSessionsFlush(CommandContext commandContext) {
    }

    public void closed(CommandContext commandContext) {
        List<AsyncEventActionTask> tasks;
        Map anyChangeTaskMap = (Map)commandContext.getAttribute(ATTR_ANY_CHANGE);
        Set autoCompleteTaskIds = (Set)commandContext.getAttribute("autoCompleteTaskIds");
        if (anyChangeTaskMap != null) {
            tasks = anyChangeTaskMap.values().stream().flatMap(Collection::stream).filter(task -> this.filterAutoCompleteTask((AsyncEventActionTask)task, autoCompleteTaskIds)).collect(Collectors.toList());
            this.asyncEventActionService.addTasks(tasks);
        }
        if ((tasks = (List<AsyncEventActionTask>)commandContext.getAttribute(ATTR_NAME)) == null) {
            return;
        }
        this.asyncEventActionService.addTasks(tasks.stream().filter(task -> this.filterAutoCompleteTask((AsyncEventActionTask)task, autoCompleteTaskIds)).collect(Collectors.toList()));
    }

    private boolean filterAutoCompleteTask(AsyncEventActionTask task, Set<String> autoCompleteTaskIds) {
        if (autoCompleteTaskIds == null || autoCompleteTaskIds.isEmpty() || !task.isSkipAutoCompleteTask() || task.getTaskId() == null) {
            return true;
        }
        return !autoCompleteTaskIds.contains(task.getTaskId());
    }

    public void closeFailure(CommandContext commandContext) {
    }

    public Integer order() {
        return 0x7FFFFFFE;
    }

    public boolean multipleAllowed() {
        return false;
    }
}

