/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.listener;

import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.GlobalConfigDto;
import com.cyberway.mp.flow.api.project.enums.AssigneeType;
import com.cyberway.mp.flow.api.task.enums.FlowTaskStatus;
import com.cyberway.mp.flow.domain.node.service.FlowNodeService;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.domain.task.service.FlowTaskService;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.command.CustomCompleteTaskCmd;
import com.cyberway.mp.flow.flowable.flow.command.SignApproveCmd;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.ManualTask;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.ReceiveTask;
import org.flowable.bpmn.model.ScriptTask;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEntityEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventListener;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cmd.StartProcessInstanceCmd;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.api.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCompleteListener
implements FlowableEventListener {
    public static final String ATTR_AUTO_COMPLETE_TASK_IDS = "autoCompleteTaskIds";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FlowProjectConfigCacheRepository flowProjectConfigCacheRepository;
    private final FlowTaskService flowTaskService;
    private final FlowNodeService flowNodeService;

    public AutoCompleteListener(FlowProjectConfigCacheRepository flowProjectConfigCacheRepository, FlowTaskService flowTaskService, FlowNodeService flowNodeService) {
        this.flowProjectConfigCacheRepository = flowProjectConfigCacheRepository;
        this.flowTaskService = flowTaskService;
        this.flowNodeService = flowNodeService;
    }

    public void onEvent(FlowableEvent event) {
        if (FlowableEngineEventType.TASK_ASSIGNED.equals((Object)event.getType())) {
            FlowableEntityEvent entityEvent = (FlowableEntityEvent)event;
            TaskEntity task = (TaskEntity)entityEvent.getEntity();
            CommandContext commandContext = CommandContextUtil.getCommandContext();
            if (commandContext == null || !Boolean.TRUE.equals(commandContext.getAttribute("_NEW_TASK_" + task.getId())) || task.isDeleted()) {
                return;
            }
            FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)task);
            Long flowProjectId = flowInfoVariables.getFlowProjectId();
            Long flowInstanceId = flowInfoVariables.getFlowInstanceId();
            GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowProjectId.longValue());
            ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowProjectId.longValue(), flowInstanceId.longValue(), task.getTaskDefinitionKey());
            if (globalConfig != null && Boolean.TRUE.equals(globalConfig.getSkipFirstTask()) && commandContext.getCommand() instanceof StartProcessInstanceCmd && this.checkIsFirstNode(flowInstanceId)) {
                this.doAutoComplete(task, (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getSignType(), (Object)FlowConstant.SIGN_TYPE_NORMAL), FlowConstant.AUTO_COMPLETE_FLAG_FIRST_NODE);
            } else if (approvalNodeConfig != null) {
                this.checkAutoCompleteByNodeConfig(task, approvalNodeConfig, flowInstanceId, flowProjectId);
            }
        }
    }

    private void checkAutoCompleteByNodeConfig(TaskEntity task, ApprovalNodeConfigDto approvalNodeConfig, Long flowInstanceId, Long flowProjectId) {
        long assigneeUserId = Long.parseLong(task.getAssignee());
        if (Boolean.TRUE.equals(approvalNodeConfig.getSkipIfSameAssigneeBefore()) && this.flowTaskService.hasSameAssigneeCompleted(flowInstanceId.longValue(), assigneeUserId)) {
            this.logger.debug("Auto complete task [{}] has same assignee before", (Object)task.getId());
            this.doAutoComplete(task, (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getSignType(), (Object)FlowConstant.SIGN_TYPE_NORMAL), FlowConstant.AUTO_COMPLETE_FLAG_SAME_ASSIGNEE_BEFORE);
        } else if (Boolean.TRUE.equals(approvalNodeConfig.getSkipIfSamePrevAssignee()) && this.checkSamePrevAssignee(task, flowInstanceId, assigneeUserId)) {
            this.logger.debug("Auto complete task [{}] has same assignee prev", (Object)task.getId());
            this.doAutoComplete(task, (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getSignType(), (Object)FlowConstant.SIGN_TYPE_NORMAL), FlowConstant.AUTO_COMPLETE_FLAG_SAME_PREV_ASSIGNEE);
        } else if (Boolean.TRUE.equals(approvalNodeConfig.getSkipIfSameAssigneeAfter()) && this.checkSameAfterAssignee(task, (long)flowProjectId, (long)flowInstanceId, assigneeUserId)) {
            this.doAutoComplete(task, (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getSignType(), (Object)FlowConstant.SIGN_TYPE_NORMAL), FlowConstant.AUTO_COMPLETE_FLAG_SAME_ASSIGNEE_AFTER);
        }
    }

    private boolean checkIsFirstNode(Long flowInstanceId) {
        return this.flowNodeService.listByFlowInstanceId(flowInstanceId.longValue()).stream().allMatch(n -> FlowTaskStatus.RUNNING.equals((Object)n.getStatus()));
    }

    private void doAutoComplete(TaskEntity task, int signType, int autoCompleteFlag) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        FlowVariableUtils.markAutoComplete(commandContext, task, autoCompleteFlag);
        if (!FlowConstant.SIGN_TYPE_NORMAL.equals(signType)) {
            commandContext.getCommandExecutor().execute((Command)new SignApproveCmd(task.getId(), new CustomCmdParams(), null, true));
        } else {
            commandContext.getCommandExecutor().execute((Command)new CustomCompleteTaskCmd(task.getId(), new HashMap<String, Object>(16), new CustomCmdParams(), true));
        }
    }

    private boolean checkSamePrevAssignee(TaskEntity task, Long flowInstanceId, long assigneeUserId) {
        Process process = ProcessDefinitionUtil.getProcess((String)task.getProcessDefinitionId());
        FlowNode flowNode = (FlowNode)process.getFlowElement(task.getTaskDefinitionKey());
        HashSet<String> prevKeys = new HashSet<String>();
        this.findPrevNodeKeys(flowNode, prevKeys);
        if (!prevKeys.isEmpty()) {
            return this.flowTaskService.hasSameAssigneeCompletedInNodes(flowInstanceId.longValue(), assigneeUserId, prevKeys);
        }
        return false;
    }

    private boolean checkSameAfterAssignee(TaskEntity task, long flowProjectId, long flowInstanceId, long assigneeUserId) {
        Process process = ProcessDefinitionUtil.getProcess((String)task.getProcessDefinitionId());
        FlowNode flowNode = (FlowNode)process.getFlowElement(task.getTaskDefinitionKey());
        List outgoingFlows = flowNode.getOutgoingFlows();
        return this.checkSameAfterAssignee(outgoingFlows, flowProjectId, flowInstanceId, assigneeUserId);
    }

    private boolean checkSameAfterAssignee(List<SequenceFlow> outgoingFlows, long flowProjectId, long flowInstanceId, long assigneeUserId) {
        for (SequenceFlow outgoingFlow : outgoingFlows) {
            FlowElement targetFlowElement = outgoingFlow.getTargetFlowElement();
            if (targetFlowElement instanceof UserTask) {
                ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowProjectId, flowInstanceId, targetFlowElement.getId());
                if (approvalNodeConfig != null && AssigneeType.USER.equals((Object)approvalNodeConfig.getAssigneeType()) && approvalNodeConfig.getAssignees() != null && approvalNodeConfig.getAssignees().stream().anyMatch(dto -> dto.getId().equals(assigneeUserId))) {
                    return true;
                }
                return this.checkSameAfterAssignee(((UserTask)targetFlowElement).getOutgoingFlows(), flowProjectId, flowInstanceId, assigneeUserId);
            }
            if (!(targetFlowElement instanceof ParallelGateway) && !(targetFlowElement instanceof ScriptTask) && !(targetFlowElement instanceof ReceiveTask) && !(targetFlowElement instanceof ServiceTask) && !(targetFlowElement instanceof ManualTask)) continue;
            return this.checkSameAfterAssignee(((FlowNode)targetFlowElement).getOutgoingFlows(), flowProjectId, flowInstanceId, assigneeUserId);
        }
        return false;
    }

    private void findPrevNodeKeys(FlowNode flowNode, Set<String> keys) {
        List incomingFlows = flowNode.getIncomingFlows();
        if (incomingFlows != null) {
            for (SequenceFlow incomingFlow : incomingFlows) {
                if (incomingFlow.getSourceFlowElement() instanceof Activity) {
                    keys.add(incomingFlow.getSourceFlowElement().getId());
                    continue;
                }
                if (!(incomingFlow.getSourceFlowElement() instanceof FlowNode)) continue;
                this.findPrevNodeKeys((FlowNode)incomingFlow.getSourceFlowElement(), keys);
            }
        }
    }

    public boolean isFailOnException() {
        return true;
    }

    public boolean isFireOnTransactionLifecycleEvent() {
        return false;
    }

    public String getOnTransaction() {
        return null;
    }
}

