/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.listener;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.context.autoconfigure.ContextProperties;
import com.cyberway.mp.bc.event.BeanEvent;
import com.cyberway.mp.bc.event.FrameworkEvent;
import com.cyberway.mp.bc.event.FrameworkEventService;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.common.dto.IdNameDto;
import com.cyberway.mp.flow.api.common.event.FlowInstanceEvent;
import com.cyberway.mp.flow.api.common.event.FlowInstanceEventType;
import com.cyberway.mp.flow.api.common.event.FlowInstanceFrameworkEvent;
import com.cyberway.mp.flow.api.common.event.FlowNodeEvent;
import com.cyberway.mp.flow.api.common.event.FlowNodeEventType;
import com.cyberway.mp.flow.api.common.event.FlowNodeFrameworkEvent;
import com.cyberway.mp.flow.api.common.event.FlowTaskEvent;
import com.cyberway.mp.flow.api.common.event.FlowTaskEventType;
import com.cyberway.mp.flow.api.common.event.FlowTaskFrameworkEvent;
import com.cyberway.mp.flow.api.common.vo.IdNameVo;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceCcDto;
import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.AutoCcActionConfig;
import com.cyberway.mp.flow.api.project.dto.CustomApiParamValueDto;
import com.cyberway.mp.flow.api.project.dto.CustomHttpActionConfigDto;
import com.cyberway.mp.flow.api.project.dto.EventConfigDto;
import com.cyberway.mp.flow.api.project.dto.EventTemplateDto;
import com.cyberway.mp.flow.api.project.dto.ExternalHttpActionConfigDto;
import com.cyberway.mp.flow.api.project.dto.FrameworkEventActionConfigDto;
import com.cyberway.mp.flow.api.project.dto.GlobalConfigDto;
import com.cyberway.mp.flow.api.project.dto.InternalHttpActionConfigDto;
import com.cyberway.mp.flow.api.project.dto.LocalMethodActionConfigDto;
import com.cyberway.mp.flow.api.project.dto.NoticeConfigDto;
import com.cyberway.mp.flow.api.project.dto.NoticeTargetDto;
import com.cyberway.mp.flow.api.project.dto.NoticeUserDto;
import com.cyberway.mp.flow.api.project.enums.ActionCallType;
import com.cyberway.mp.flow.api.project.enums.AssigneeType;
import com.cyberway.mp.flow.api.project.enums.EventType;
import com.cyberway.mp.flow.api.project.enums.NoticeTargetType;
import com.cyberway.mp.flow.api.task.dto.FlowTaskCcDto;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.instance.service.FlowInstanceService;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithBusinessKey;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithProject;
import com.cyberway.mp.flow.domain.task.service.FlowTaskService;
import com.cyberway.mp.flow.flowable.constants.FlowableConstant;
import com.cyberway.mp.flow.flowable.flow.command.CancelDelegateTaskCmd;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.command.CustomDelegateTaskCmd;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.flowable.flow.event.FlowableWithdrawProcessEvent;
import com.cyberway.mp.flow.flowable.listener.AsyncActionListener;
import com.cyberway.mp.flow.flowable.service.AsyncApprovalMailNoticeTask;
import com.cyberway.mp.flow.flowable.service.AsyncEventActionService;
import com.cyberway.mp.flow.flowable.service.AsyncEventActionTask;
import com.cyberway.mp.flow.flowable.service.AsyncEventAutoCcTask;
import com.cyberway.mp.flow.flowable.service.AsyncEventExternalApiTask;
import com.cyberway.mp.flow.flowable.service.AsyncEventFrameworkEventTask;
import com.cyberway.mp.flow.flowable.service.AsyncEventInternalApiTask;
import com.cyberway.mp.flow.flowable.service.AsyncEventLocalMethodTask;
import com.cyberway.mp.flow.flowable.util.CustomApiUtils;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import com.cyberway.mp.flow.flowable.util.MethodInvokerUtils;
import com.cyberway.mp.flow.infra.service.FlowEngineService;
import com.cyberway.mp.flow.infra.service.FlowExpressionExecutor;
import com.cyberway.mp.flow.infra.service.MailHelperService;
import com.cyberway.mp.flow.infra.service.UserHelperService;
import com.cyberway.mp.mc.api.push.dto.EventPushDto;
import feign.Client;
import feign.Request;
import feign.RequestTemplate;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEntityEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventListener;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandContextCloseListener;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.FlowableCancelledEvent;
import org.flowable.engine.delegate.event.FlowableMultiInstanceActivityEvent;
import org.flowable.engine.delegate.event.FlowableProcessStartedEvent;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntityImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.api.delegate.VariableScope;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

public class EventActionListener
implements FlowableEventListener {
    private static final long DEFAULT_CONNECT_TIMEOUT = 3000L;
    private static final long DEFAULT_READ_TIMEOUT = 30000L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FlowInstanceService flowInstanceService;
    private final FlowTaskService flowTaskService;
    private final FlowProjectConfigCacheRepository flowProjectConfigCacheRepository;
    private final FrameworkEventService frameworkEventService;
    private final Client feignClient;
    private final AsyncEventActionService asyncEventActionService;
    private final UserHelperService userHelperService;
    private final MailHelperService mailHelperService;
    private final ContextProperties contextProperties;
    private final ApplicationContext applicationContext;
    private final FlowEngineService flowEngineService;

    public EventActionListener(FlowInstanceService flowInstanceService, FlowTaskService flowTaskService, FlowProjectConfigCacheRepository flowProjectConfigCacheRepository, FrameworkEventService frameworkEventService, Client feignClient, AsyncEventActionService asyncEventActionService, UserHelperService userHelperService, MailHelperService mailHelperService, ContextProperties contextProperties, ApplicationContext applicationContext, FlowEngineService flowEngineService) {
        this.flowInstanceService = flowInstanceService;
        this.flowTaskService = flowTaskService;
        this.flowProjectConfigCacheRepository = flowProjectConfigCacheRepository;
        this.frameworkEventService = frameworkEventService;
        this.feignClient = feignClient;
        this.asyncEventActionService = asyncEventActionService;
        this.userHelperService = userHelperService;
        this.mailHelperService = mailHelperService;
        this.contextProperties = contextProperties;
        this.applicationContext = applicationContext;
        this.flowEngineService = flowEngineService;
    }

    public void onEvent(FlowableEvent event) {
        if (event.getType() instanceof FlowableEngineEventType) {
            switch ((FlowableEngineEventType)event.getType()) {
                case PROCESS_STARTED: {
                    this.handleProcessStarted((FlowableProcessStartedEvent)event);
                    break;
                }
                case PROCESS_COMPLETED: {
                    this.handleProcessComplete((FlowableEntityEvent)event);
                    break;
                }
                case PROCESS_CANCELLED: {
                    this.handleProcessCancelled((FlowableCancelledEvent)event);
                    break;
                }
                case TASK_ASSIGNED: {
                    this.handleTaskAssigned((FlowableEntityEvent)event);
                    break;
                }
                case TASK_COMPLETED: {
                    this.handleTaskComplete((FlowableEntityEvent)event);
                    break;
                }
                case MULTI_INSTANCE_ACTIVITY_STARTED: {
                    this.handleMiActivityStarted((FlowableMultiInstanceActivityEvent)event);
                    break;
                }
                case MULTI_INSTANCE_ACTIVITY_COMPLETED: {
                    this.handleMiActivityCompleted((FlowableMultiInstanceActivityEvent)event);
                    break;
                }
                case CUSTOM: {
                    this.handleCustomEvent(event);
                    break;
                }
                case ENTITY_SUSPENDED: {
                    this.handleProcessSuspended((FlowableEntityEvent)event);
                    break;
                }
                case ENTITY_ACTIVATED: {
                    this.handleProcessActivated((FlowableEntityEvent)event);
                    break;
                }
            }
        }
    }

    private void handleCustomEvent(FlowableEvent event) {
        if (event instanceof CustomFlowableEntityEvent) {
            this.handleCustomFlowableEntityEvent((CustomFlowableEntityEvent)event);
        } else if (event instanceof FlowableWithdrawProcessEvent) {
            this.handleProcessWithdraw((FlowableWithdrawProcessEvent)event);
        }
    }

    private void handleCustomFlowableEntityEvent(CustomFlowableEntityEvent event) {
        switch (event.getCustomEventType()) {
            case REJECT: {
                this.handleReject(event);
                break;
            }
            case SIGN_APPROVE: {
                this.handleSignApprove(event);
                break;
            }
            case SIGN_REJECT: {
                this.handleSignReject(event);
                break;
            }
            case SIGN_FIN_REJECT: {
                this.handleSignFinReject(event);
                break;
            }
            case ROLLBACK_TO_PREV: {
                this.handleRollbackToPrev(event);
                break;
            }
            case ROLLBACK_TO_SPECIAL: {
                this.handleRollbackToSpecial(event);
                break;
            }
            case ROLLBACK_TO_START: {
                this.handleRollbackToStart(event);
                break;
            }
            case EMPTY_MI_NODE_FIN: {
                this.handleEmptyMiNodeFin(event);
                break;
            }
            case PROCESS_WITHDRAW: 
            case NODE_REJECT: 
            case NODE_SIGN_FIN: 
            case NODE_ROLLBACK_PERV: 
            case NODE_ROLLBACK_SPECIAL: 
            case NODE_ROLLBACK_START: 
            case NODE_JUMP: {
                this.handleTaskDeleted(event);
                break;
            }
            case FLOW_JUMP: {
                this.handleFlowJump(event);
                break;
            }
            case STARTER_FILL: 
            case NODE_STARTER_FILL: 
            case WAIT_STARTER_FILL_FIN: 
            case STARTER_FILL_START: 
            case STARTER_FILL_COMPLETE: {
                this.handleStarterFillEvent(event);
                break;
            }
            case CC_TASK: {
                this.handleCcTask(event);
                break;
            }
            case CC_INSTANCE: {
                this.handleCcInstance(event);
                break;
            }
            case TRANSFER_TASK: {
                this.handleTransferTask(event);
                break;
            }
        }
    }

    private List<EventConfigDto> filterGlobalAndAppendEventConfigs(FlowInfoVariables flowInfoVariables, EventType eventType) {
        GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowInfoVariables.getFlowProjectId().longValue());
        ArrayList<EventConfigDto> eventConfigs = new ArrayList<EventConfigDto>();
        this.filterEventConfig(globalConfig.getEvents(), eventConfigs, flowInfoVariables, eventType);
        this.filterEventConfig(flowInfoVariables.getAppendEventConfigs(), eventConfigs, flowInfoVariables, eventType);
        return eventConfigs;
    }

    private Stream<EventConfigDto> streamEventConfig(FlowInfoVariables flowInfoVariables, String nodeKey, EventType eventType) {
        ApprovalNodeConfigDto approvalNodeConfig;
        List<EventConfigDto> eventConfigs = this.filterGlobalAndAppendEventConfigs(flowInfoVariables, eventType);
        if (StringUtils.isNotBlank((CharSequence)nodeKey) && (approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowInfoVariables.getFlowProjectId().longValue(), flowInfoVariables.getFlowInstanceId().longValue(), nodeKey)).getEvents() != null) {
            approvalNodeConfig.getEvents().stream().filter(config -> eventType.equals((Object)config.getType())).forEach(eventConfigs::add);
        }
        return eventConfigs.stream();
    }

    private Stream<EventConfigDto> streamEventConfig(FlowInfoVariables flowInfoVariables, FlowTask flowTask, EventType eventType) {
        ApprovalNodeConfigDto approvalNodeConfig;
        List<EventConfigDto> eventConfigs = this.filterGlobalAndAppendEventConfigs(flowInfoVariables, eventType);
        if (flowTask != null && (approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowTask, flowInfoVariables.getFlowProjectId())).getEvents() != null) {
            approvalNodeConfig.getEvents().stream().filter(config -> eventType.equals((Object)config.getType())).forEach(eventConfigs::add);
        }
        return eventConfigs.stream();
    }

    private void filterEventConfig(List<EventConfigDto> eventConfigs, List<EventConfigDto> result, FlowInfoVariables flowInfoVariables, EventType eventType) {
        if (eventConfigs == null || eventConfigs.isEmpty()) {
            return;
        }
        ArrayList<EventConfigDto> anyChangeConfigs = new ArrayList<EventConfigDto>();
        for (EventConfigDto config : eventConfigs) {
            if (eventType.equals((Object)config.getType())) {
                result.add(config);
                continue;
            }
            if (!EventType.ANY_CHANGE_FIN.equals((Object)config.getType())) continue;
            anyChangeConfigs.add(config);
        }
        if (anyChangeConfigs.isEmpty()) {
            return;
        }
        this.addAnyChangeTask(anyChangeConfigs, flowInfoVariables);
    }

    private void addAnyChangeTask(List<EventConfigDto> anyChangeConfigs, FlowInfoVariables flowInfoVariables) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        HashMap anyChangeTaskMap = (HashMap)commandContext.getAttribute("asyncAnyChange");
        if (anyChangeTaskMap == null) {
            anyChangeTaskMap = new HashMap(16);
            commandContext.addAttribute("asyncAnyChange", anyChangeTaskMap);
            commandContext.addCloseListener((CommandContextCloseListener)new AsyncActionListener(this.asyncEventActionService));
        }
        if (anyChangeTaskMap.containsKey(flowInfoVariables.getFlowInstanceId())) {
            return;
        }
        ArrayList<AsyncEventActionTask> anyChangeTasks = new ArrayList<AsyncEventActionTask>();
        anyChangeTaskMap.put(flowInfoVariables.getFlowInstanceId(), anyChangeTasks);
        FlowInstanceEvent event = new FlowInstanceEvent();
        event.setEventType(FlowInstanceEventType.ANY_CHANGE_FIN);
        event.setEventTime(new Date());
        event.setFlowInstanceId(flowInfoVariables.getFlowInstanceId());
        event.setBusinessKey(flowInfoVariables.getBusinessKey());
        String bodyJson = JSON.toJSONString((Object)event);
        HashMap requestVariables = MapUtil.newHashMap((int)1);
        requestVariables.put("_FLOW_INFO_VARIABLES", flowInfoVariables);
        for (EventConfigDto config : anyChangeConfigs) {
            AsyncEventActionTask task = this.buildAnyChangeTask(config, event, bodyJson, requestVariables);
            if (task == null) continue;
            task.setExecuteSync(true);
            anyChangeTasks.add(task);
        }
    }

    private AsyncEventActionTask buildAnyChangeTask(EventConfigDto config, FlowInstanceEvent event, String bodyJson, Map<String, Object> requestVariables) {
        AsyncEventActionTask task;
        switch (config.getActionType()) {
            case FRAMEWORK_EVENT: {
                task = new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)new FlowInstanceFrameworkEvent(event), config.getFrameworkEventActionConfig() == null ? null : config.getFrameworkEventActionConfig().getRoute());
                break;
            }
            case INTERNAL_HTTP: {
                Pair<feign.Request, Request.Options> internalRequest = this.buildInternalApiRequest(config.getInternalHttpActionConfig(), bodyJson);
                task = new AsyncEventInternalApiTask(this.feignClient, (feign.Request)internalRequest.getLeft(), (Request.Options)internalRequest.getRight());
                break;
            }
            case EXTERNAL_HTTP: {
                Pair<OkHttpClient, Request> externalRequest = this.buildExternalApiRequest(config.getExternalHttpActionConfig(), bodyJson, requestVariables);
                task = new AsyncEventExternalApiTask((OkHttpClient)externalRequest.getLeft(), (Request)externalRequest.getRight());
                break;
            }
            case CUSTOM_HTTP: {
                CustomHttpActionConfigDto actionConfig = config.getCustomHttpActionConfig();
                if (actionConfig == null) {
                    return null;
                }
                if (StringUtils.isNotBlank((CharSequence)actionConfig.getServiceId())) {
                    Pair<feign.Request, Request.Options> customRequest = this.buildCustomInternalApiRequest(actionConfig, requestVariables);
                    task = new AsyncEventInternalApiTask(this.feignClient, (feign.Request)customRequest.getLeft(), (Request.Options)customRequest.getRight());
                    break;
                }
                Pair<OkHttpClient, Request> request = this.buildCustomExternalApiRequest(actionConfig, requestVariables);
                task = new AsyncEventExternalApiTask((OkHttpClient)request.getLeft(), (Request)request.getRight());
                break;
            }
            case LOCAL_METHOD: {
                Object bean = this.applicationContext.getBean(config.getLocalMethodActionConfig().getBeanName());
                Method method = ReflectionUtils.findMethod(bean.getClass(), (String)config.getLocalMethodActionConfig().getMethodName());
                task = new AsyncEventLocalMethodTask(bean, method, MethodInvokerUtils.toParams(event));
                break;
            }
            default: {
                task = null;
            }
        }
        return task;
    }

    private Stream<NoticeConfigDto> streamNoticeConfig(FlowInfoVariables flowInfoVariables, ApprovalNodeConfigDto approvalNodeConfig, EventType eventType) {
        ArrayList noticeConfigs = new ArrayList();
        GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowInfoVariables.getFlowProjectId().longValue());
        if (globalConfig.getNotices() != null) {
            globalConfig.getNotices().stream().filter(config -> eventType.equals((Object)config.getEventType())).forEach(noticeConfigs::add);
        }
        if (approvalNodeConfig.getNotices() != null) {
            approvalNodeConfig.getNotices().stream().filter(config -> eventType.equals((Object)config.getEventType())).forEach(noticeConfigs::add);
        }
        return noticeConfigs.stream();
    }

    private Stream<NoticeConfigDto> streamNoticeConfig(FlowInfoVariables flowInfoVariables, String nodeKey, EventType eventType) {
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowInfoVariables.getFlowProjectId().longValue(), flowInfoVariables.getFlowInstanceId().longValue(), nodeKey);
        return this.streamNoticeConfig(flowInfoVariables, approvalNodeConfig, eventType);
    }

    private Stream<NoticeConfigDto> streamNoticeConfig(FlowInfoVariables flowInfoVariables, FlowTask task, EventType eventType) {
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(task, flowInfoVariables.getFlowProjectId());
        return this.streamNoticeConfig(flowInfoVariables, approvalNodeConfig, eventType);
    }

    private void handleProcessStarted(FlowableProcessStartedEvent event) {
        ExecutionEntity entity = (ExecutionEntity)event.getEntity();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)entity);
        this.streamEventConfig(flowInfoVariables, "", EventType.FLOW_START).forEach(config -> this.handleProcessStarted(entity, (EventConfigDto)config));
        this.streamFlowInstanceNoticeConfig(flowInfoVariables, EventType.FLOW_START).forEach(config -> {
            FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowInfoVariables.getFlowInstanceId().longValue());
            Map variables = entity.getProcessInstance().getVariables();
            this.noticeFLowInstanceEvent(flowInstance, EventType.FLOW_START, (NoticeConfigDto)config, new Date(), variables);
        });
    }

    private void handleProcessStarted(ExecutionEntity entity, EventConfigDto config) {
        ExecutionEntity processInstance = entity.getProcessInstance();
        switch (config.getActionType()) {
            case FRAMEWORK_EVENT: {
                this.sendFlowInstanceFrameworkEvent(processInstance, FlowInstanceEventType.FLOW_START, processInstance.getStartTime(), config.getFrameworkEventActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case INTERNAL_HTTP: {
                this.callInternalFlowApi(processInstance, FlowInstanceEventType.FLOW_START, processInstance.getStartTime(), config.getInternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case EXTERNAL_HTTP: {
                this.callExternalFlowApi(processInstance, FlowInstanceEventType.FLOW_START, processInstance.getStartTime(), config.getExternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case CUSTOM_HTTP: {
                this.callCustomFlowApi(processInstance, config.getCustomHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case LOCAL_METHOD: {
                this.invokeFlowInstanceLocalMethod(processInstance, FlowInstanceEventType.FLOW_START, processInstance.getStartTime(), config.getLocalMethodActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case AUTO_CC: {
                this.invokeAutoCcInstanceMethod((ProcessInstance)processInstance, config.getAutoCcActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
        }
    }

    private void handleCcInstance(CustomFlowableEntityEvent event) {
        FlowInstance flowInstance = (FlowInstance)event.getEntity();
        HistoricProcessInstanceEntity copyProcessInstance = this.getHistoricProcessInstanceEntity(event.getProcessInstanceId());
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((HistoricProcessInstance)copyProcessInstance);
        this.streamEventConfig(flowInfoVariables, "", EventType.FLOW_CC).forEach(config -> this.handleCcInstance((HistoricProcessInstance)copyProcessInstance, (EventConfigDto)config));
        this.streamFlowInstanceNoticeConfig(flowInfoVariables, EventType.FLOW_CC).forEach(config -> this.noticeFLowInstanceEvent(flowInstance, EventType.FLOW_CC, (NoticeConfigDto)config, new Date(), (HistoricProcessInstance)copyProcessInstance));
    }

    private Stream<NoticeConfigDto> streamFlowInstanceNoticeConfig(FlowInfoVariables flowInfoVariables, EventType eventType) {
        ArrayList globalNoticeConfigs = new ArrayList();
        GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowInfoVariables.getFlowProjectId().longValue());
        if (globalConfig.getNotices() != null) {
            globalConfig.getNotices().stream().filter(config -> eventType.equals((Object)config.getEventType())).forEach(globalNoticeConfigs::add);
        }
        return globalNoticeConfigs.stream();
    }

    private void handleCcInstance(HistoricProcessInstance processInstance, EventConfigDto config) {
        Date eventTime = new Date();
        switch (config.getActionType()) {
            case FRAMEWORK_EVENT: {
                this.sendFlowInstanceFrameworkEvent(processInstance, FlowInstanceEventType.FLOW_CC, eventTime, config.getFrameworkEventActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case INTERNAL_HTTP: {
                this.callInternalFlowApi(processInstance, FlowInstanceEventType.FLOW_CC, eventTime, config.getInternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case EXTERNAL_HTTP: {
                this.callExternalFlowApi(processInstance, FlowInstanceEventType.FLOW_CC, eventTime, config.getExternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case CUSTOM_HTTP: {
                this.callCustomFlowApi(processInstance, config.getCustomHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case LOCAL_METHOD: {
                this.invokeFlowInstanceLocalMethod(processInstance, FlowInstanceEventType.FLOW_CC, eventTime, config.getLocalMethodActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case AUTO_CC: {
                this.invokeAutoCcInstanceMethod(processInstance, FlowInstanceEventType.FLOW_CC, config.getAutoCcActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
        }
    }

    private void invokeAutoCcInstanceMethod(ProcessInstance processInstance, AutoCcActionConfig autoCcActionConfig, boolean sync) {
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables(processInstance);
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowInfoVariables.getFlowInstanceId().longValue());
        FlowInstanceCcDto dto = new FlowInstanceCcDto();
        dto.setUsers(this.getUserIdNameList(autoCcActionConfig, flowInstance));
        dto.setNote(autoCcActionConfig.getNote());
        if (!sync) {
            this.addAsyncTask(new AsyncEventAutoCcTask(this.flowEngineService, flowInstance, dto));
        } else {
            this.flowEngineService.ccInstance(flowInstance, dto);
        }
    }

    private void invokeAutoCcInstanceMethod(HistoricProcessInstance processInstance, FlowInstanceEventType eventType, AutoCcActionConfig autoCcActionConfig, boolean sync) {
        if (FlowInstanceEventType.FLOW_CC.equals((Object)eventType)) {
            return;
        }
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables(processInstance);
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowInfoVariables.getFlowInstanceId().longValue());
        FlowInstanceCcDto dto = new FlowInstanceCcDto();
        dto.setUsers(this.getUserIdNameList(autoCcActionConfig, flowInstance));
        dto.setNote(autoCcActionConfig.getNote());
        if (!sync) {
            this.addAsyncTask(new AsyncEventAutoCcTask(this.flowEngineService, flowInstance, dto));
        } else {
            this.flowEngineService.ccInstance(flowInstance, dto);
        }
    }

    private void handleProcessComplete(FlowableEntityEvent event) {
        ExecutionEntity entity = (ExecutionEntity)event.getEntity();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)entity);
        GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowInfoVariables.getFlowProjectId().longValue());
        this.streamEventConfig(flowInfoVariables, "", EventType.FLOW_COMPLETE).forEach(config -> this.handleProcessComplete(entity, (EventConfigDto)config));
        this.streamFlowInstanceNoticeConfig(flowInfoVariables, EventType.FLOW_COMPLETE).forEach(config -> {
            FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowInfoVariables.getFlowInstanceId().longValue());
            Map variables = entity.getProcessInstance().getVariables();
            this.noticeFLowInstanceEvent(flowInstance, EventType.FLOW_COMPLETE, (NoticeConfigDto)config, new Date(), variables);
        });
        this.noticeFinish(globalConfig, entity);
    }

    private void handleProcessSuspended(FlowableEntityEvent event) {
        ExecutionEntity entity;
        if (event.getEntity() instanceof ProcessInstance && (entity = (ExecutionEntity)event.getEntity()).isProcessInstanceType()) {
            FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)entity);
            this.streamEventConfig(flowInfoVariables, "", EventType.FLOW_SUSPENDED).forEach(config -> this.handleProcessSuspended(entity, (EventConfigDto)config));
            this.streamFlowInstanceNoticeConfig(flowInfoVariables, EventType.FLOW_SUSPENDED).forEach(config -> {
                FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowInfoVariables.getFlowInstanceId().longValue());
                Map variables = entity.getProcessInstance().getProcessVariables();
                this.noticeFLowInstanceEvent(flowInstance, EventType.FLOW_SUSPENDED, (NoticeConfigDto)config, new Date(), variables);
            });
        }
    }

    private void handleProcessActivated(FlowableEntityEvent event) {
        ExecutionEntity entity;
        if (event.getEntity() instanceof ProcessInstance && (entity = (ExecutionEntity)event.getEntity()).isProcessInstanceType()) {
            FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)entity);
            this.streamEventConfig(flowInfoVariables, "", EventType.FLOW_ACTIVATED).forEach(config -> this.handleProcessActivated(entity, (EventConfigDto)config));
            this.streamFlowInstanceNoticeConfig(flowInfoVariables, EventType.FLOW_ACTIVATED).forEach(config -> {
                FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowInfoVariables.getFlowInstanceId().longValue());
                Map variables = entity.getProcessInstance().getProcessVariables();
                this.noticeFLowInstanceEvent(flowInstance, EventType.FLOW_ACTIVATED, (NoticeConfigDto)config, new Date(), variables);
            });
        }
    }

    private void handleProcessActivated(ExecutionEntity entity, EventConfigDto config) {
        ExecutionEntity processInstance = entity.getProcessInstance();
        switch (config.getActionType()) {
            case FRAMEWORK_EVENT: {
                this.sendFlowInstanceFrameworkEvent(processInstance, FlowInstanceEventType.FLOW_ACTIVATED, processInstance.getStartTime(), config.getFrameworkEventActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case INTERNAL_HTTP: {
                this.callInternalFlowApi(processInstance, FlowInstanceEventType.FLOW_ACTIVATED, processInstance.getStartTime(), config.getInternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case EXTERNAL_HTTP: {
                this.callExternalFlowApi(processInstance, FlowInstanceEventType.FLOW_ACTIVATED, processInstance.getStartTime(), config.getExternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case CUSTOM_HTTP: {
                this.callCustomFlowApi(processInstance, config.getCustomHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case LOCAL_METHOD: {
                this.invokeFlowInstanceLocalMethod(processInstance, FlowInstanceEventType.FLOW_ACTIVATED, processInstance.getStartTime(), config.getLocalMethodActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case AUTO_CC: {
                this.invokeAutoCcInstanceMethod((ProcessInstance)processInstance, config.getAutoCcActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
        }
    }

    private void handleProcessSuspended(ExecutionEntity entity, EventConfigDto config) {
        ExecutionEntity processInstance = entity.getProcessInstance();
        switch (config.getActionType()) {
            case FRAMEWORK_EVENT: {
                this.sendFlowInstanceFrameworkEvent(processInstance, FlowInstanceEventType.FLOW_SUSPENDED, processInstance.getStartTime(), config.getFrameworkEventActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case INTERNAL_HTTP: {
                this.callInternalFlowApi(processInstance, FlowInstanceEventType.FLOW_SUSPENDED, processInstance.getStartTime(), config.getInternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case EXTERNAL_HTTP: {
                this.callExternalFlowApi(processInstance, FlowInstanceEventType.FLOW_SUSPENDED, processInstance.getStartTime(), config.getExternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case CUSTOM_HTTP: {
                this.callCustomFlowApi(processInstance, config.getCustomHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case LOCAL_METHOD: {
                this.invokeFlowInstanceLocalMethod(processInstance, FlowInstanceEventType.FLOW_SUSPENDED, processInstance.getStartTime(), config.getLocalMethodActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case AUTO_CC: {
                this.invokeAutoCcInstanceMethod((ProcessInstance)processInstance, config.getAutoCcActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
        }
    }

    private void handleProcessComplete(ExecutionEntity entity, EventConfigDto config) {
        Date eventTime = new Date();
        switch (config.getActionType()) {
            case FRAMEWORK_EVENT: {
                this.sendFlowInstanceFrameworkEvent(entity.getProcessInstance(), FlowInstanceEventType.FLOW_COMPLETE, eventTime, config.getFrameworkEventActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case INTERNAL_HTTP: {
                this.callInternalFlowApi(entity.getProcessInstance(), FlowInstanceEventType.FLOW_COMPLETE, eventTime, config.getInternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case EXTERNAL_HTTP: {
                this.callExternalFlowApi(entity.getProcessInstance(), FlowInstanceEventType.FLOW_COMPLETE, eventTime, config.getExternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case CUSTOM_HTTP: {
                this.callCustomFlowApi(entity.getProcessInstance(), config.getCustomHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case LOCAL_METHOD: {
                this.invokeFlowInstanceLocalMethod(entity.getProcessInstance(), FlowInstanceEventType.FLOW_COMPLETE, eventTime, config.getLocalMethodActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case AUTO_CC: {
                this.invokeAutoCcInstanceMethod((ProcessInstance)entity.getProcessInstance(), config.getAutoCcActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
        }
    }

    private void handleProcessCancel(HistoricProcessInstance processInstance, EventConfigDto config) {
        Date eventTime = new Date();
        switch (config.getActionType()) {
            case FRAMEWORK_EVENT: {
                this.sendFlowInstanceFrameworkEvent(processInstance, FlowInstanceEventType.FLOW_CANCEL, eventTime, config.getFrameworkEventActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case INTERNAL_HTTP: {
                this.callInternalFlowApi(processInstance, FlowInstanceEventType.FLOW_CANCEL, eventTime, config.getInternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case EXTERNAL_HTTP: {
                this.callExternalFlowApi(processInstance, FlowInstanceEventType.FLOW_CANCEL, eventTime, config.getExternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case CUSTOM_HTTP: {
                this.callCustomFlowApi(processInstance, config.getCustomHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case LOCAL_METHOD: {
                this.invokeFlowInstanceLocalMethod(processInstance, FlowInstanceEventType.FLOW_CANCEL, eventTime, config.getLocalMethodActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case AUTO_CC: {
                this.invokeAutoCcInstanceMethod(processInstance, FlowInstanceEventType.FLOW_CANCEL, config.getAutoCcActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
        }
    }

    private void handleProcessWithdraw(HistoricProcessInstance processInstance, EventConfigDto config) {
        Date eventTime = new Date();
        switch (config.getActionType()) {
            case FRAMEWORK_EVENT: {
                this.sendFlowInstanceFrameworkEvent(processInstance, FlowInstanceEventType.FLOW_WITHDRAW, eventTime, config.getFrameworkEventActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case INTERNAL_HTTP: {
                this.callInternalFlowApi(processInstance, FlowInstanceEventType.FLOW_WITHDRAW, eventTime, config.getInternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case EXTERNAL_HTTP: {
                this.callExternalFlowApi(processInstance, FlowInstanceEventType.FLOW_WITHDRAW, eventTime, config.getExternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case CUSTOM_HTTP: {
                this.callCustomFlowApi(processInstance, config.getCustomHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case LOCAL_METHOD: {
                this.invokeFlowInstanceLocalMethod(processInstance, FlowInstanceEventType.FLOW_WITHDRAW, eventTime, config.getLocalMethodActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case AUTO_CC: {
                this.invokeAutoCcInstanceMethod(processInstance, FlowInstanceEventType.FLOW_WITHDRAW, config.getAutoCcActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
        }
    }

    private void noticeFinish(GlobalConfigDto globalConfig, ExecutionEntity entity) {
        boolean needNoticeStarter;
        boolean needNoticeAssignee = Boolean.TRUE.equals(globalConfig.getNoticeAssigneeAtFinish()) && globalConfig.getNoticeAssigneeAtFinishTemplate() != null && !globalConfig.getNoticeAssigneeAtFinishTemplate().isEmpty();
        boolean bl = needNoticeStarter = Boolean.TRUE.equals(globalConfig.getNoticeStarterAtFinish()) && globalConfig.getNoticeStarterAtFinishTemplate() != null && !globalConfig.getNoticeStarterAtFinishTemplate().isEmpty();
        if (!needNoticeAssignee && !needNoticeStarter) {
            return;
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)entity);
        Long flowInstanceId = flowInfoVariables.getFlowInstanceId();
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowInstanceId.longValue());
        Map variables = entity.getVariables();
        if (variables != null) {
            paramsMap.putAll(variables);
        }
        paramsMap.put("flowInstance", flowInstance.toFlowInstanceInfoVo());
        paramsMap.put("fc_instance_code", flowInstance.getInstanceCode());
        if (needNoticeAssignee) {
            for (IdNameVo vo : this.flowTaskService.listAllAssigneeInFlow(flowInstanceId.longValue())) {
                this.addAsyncTask(new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)this.buildEventPushDto(flowInstance, "FLOW_NOTICE", globalConfig.getNoticeAssigneeAtFinishTemplate(), vo.getId(), vo.getName(), paramsMap), null));
            }
        }
        if (needNoticeStarter) {
            this.addAsyncTask(new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)this.buildEventPushDto(flowInstance, "FLOW_NOTICE", globalConfig.getNoticeStarterAtFinishTemplate(), flowInstance.getStartUserId(), flowInstance.getStartUserName(), paramsMap), null));
        }
    }

    private void handleProcessCancelled(FlowableCancelledEvent event) {
        HistoricProcessInstanceEntity copyProcessInstance = this.getHistoricProcessInstanceEntity(event.getProcessInstanceId());
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((HistoricProcessInstance)copyProcessInstance);
        GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowInfoVariables.getFlowProjectId().longValue());
        this.streamEventConfig(flowInfoVariables, "", EventType.FLOW_CANCEL).forEach(config -> this.handleProcessCancel((HistoricProcessInstance)copyProcessInstance, (EventConfigDto)config));
        this.streamFlowInstanceNoticeConfig(flowInfoVariables, EventType.FLOW_CANCEL).forEach(config -> {
            FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowInfoVariables.getFlowInstanceId().longValue());
            Map variables = copyProcessInstance.getProcessVariables();
            this.noticeFLowInstanceEvent(flowInstance, EventType.FLOW_CANCEL, (NoticeConfigDto)config, new Date(), variables);
        });
        this.noticeCancel(globalConfig, (HistoricProcessInstance)copyProcessInstance, flowInfoVariables);
    }

    private HistoricProcessInstanceEntity getHistoricProcessInstanceEntity(String processInstanceId) {
        HistoryService historyService = Context.getProcessEngineConfiguration().getHistoryService();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HistoricProcessInstanceEntityImpl copyProcessInstance = new HistoricProcessInstanceEntityImpl();
        BeanUtils.copyProperties((Object)processInstance, (Object)copyProcessInstance);
        List variableInstances = historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).excludeTaskVariables().excludeVariableInitialization().list().stream().filter(v -> !"bpmnParallelMultiInstanceCompleted".equals(v.getVariableTypeName())).map(v -> (HistoricVariableInstanceEntity)v).collect(Collectors.toList());
        copyProcessInstance.setQueryVariables(variableInstances);
        return copyProcessInstance;
    }

    private void handleProcessWithdraw(FlowableWithdrawProcessEvent event) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)Context.getProcessEngineConfiguration().getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(event.getProcessInstanceId()).includeProcessVariables().singleResult();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables(processInstance);
        this.streamEventConfig(flowInfoVariables, "", EventType.FLOW_WITHDRAW).forEach(config -> this.handleProcessWithdraw(processInstance, (EventConfigDto)config));
        this.streamFlowInstanceNoticeConfig(flowInfoVariables, EventType.FLOW_WITHDRAW).forEach(config -> {
            FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowInfoVariables.getFlowInstanceId().longValue());
            Map variables = processInstance.getProcessVariables();
            this.noticeFLowInstanceEvent(flowInstance, EventType.FLOW_WITHDRAW, (NoticeConfigDto)config, new Date(), variables);
        });
    }

    private void noticeCancel(GlobalConfigDto globalConfig, HistoricProcessInstance processInstance, FlowInfoVariables flowInfoVariables) {
        boolean needNoticeStarter;
        boolean needNoticeAssignee = Boolean.TRUE.equals(globalConfig.getNoticeAssigneeAtFinish()) && globalConfig.getNoticeAssigneeAtFinishTemplate() != null && !globalConfig.getNoticeAssigneeAtFinishTemplate().isEmpty();
        boolean bl = needNoticeStarter = Boolean.TRUE.equals(globalConfig.getNoticeStarterAtFinish()) && globalConfig.getNoticeStarterAtFinishTemplate() != null && !globalConfig.getNoticeStarterAtFinishTemplate().isEmpty();
        if (!needNoticeAssignee && !needNoticeStarter) {
            return;
        }
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowInfoVariables.getFlowInstanceId().longValue());
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        Map variables = processInstance.getProcessVariables();
        if (variables != null) {
            paramsMap.putAll(variables);
        }
        paramsMap.put("flowInstance", flowInstance.toFlowInstanceInfoVo());
        paramsMap.put("fc_instance_code", flowInstance.getInstanceCode());
        if (needNoticeAssignee) {
            for (IdNameVo vo : this.flowTaskService.listAllAssigneeInFlow(((Long)flowInstance.getId()).longValue())) {
                this.addAsyncTask(new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)this.buildEventPushDto(flowInstance, "FLOW_NOTICE", globalConfig.getNoticeAssigneeAtFinishTemplate(), vo.getId(), vo.getName(), paramsMap), null));
            }
        }
        if (needNoticeStarter) {
            this.addAsyncTask(new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)this.buildEventPushDto(flowInstance, "FLOW_NOTICE", globalConfig.getNoticeStarterAtFinishTemplate(), flowInstance.getStartUserId(), flowInstance.getStartUserName(), paramsMap), null));
        }
    }

    private EventPushDto buildEventPushDto(FlowInstance flowInstance, String eventCode, List<EventTemplateDto> templateDtoList, Long userId, String userName, Map<String, Object> paramsMap) {
        EventPushDto eventPushDto = new EventPushDto();
        eventPushDto.setTenantId(flowInstance.getTenantId());
        eventPushDto.setInstanceId(flowInstance.getAppInstanceId());
        eventPushDto.setEventCode(eventCode);
        eventPushDto.setMessageTemplateCodes(templateDtoList.stream().map(EventTemplateDto::getCode).collect(Collectors.toList()));
        eventPushDto.setUserId(userId);
        eventPushDto.setUserName(userName);
        eventPushDto.setParamsMap(paramsMap);
        return eventPushDto;
    }

    private void handleTaskAssigned(FlowableEntityEvent event) {
        TaskEntity task = (TaskEntity)event.getEntity();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)task);
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        if (commandContext != null && Boolean.TRUE.equals(commandContext.getAttribute("_NEW_TASK_" + task.getId()))) {
            this.streamEventConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_START).forEach(config -> this.handleTaskEvent(task, (EventConfigDto)config, FlowTaskEventType.TASK_START, task.getCreateTime()));
            this.streamNoticeConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_START).forEach(config -> this.noticeTaskEvent(task, EventType.TASK_START, (NoticeConfigDto)config, task.getCreateTime()));
        } else if (commandContext != null) {
            Command command = commandContext.getCommand();
            if (command instanceof CustomDelegateTaskCmd) {
                this.streamEventConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_DELEGATE).forEach(config -> this.handleTaskEvent(task, (EventConfigDto)config, FlowTaskEventType.TASK_DELEGATE, task.getCreateTime()));
                this.streamNoticeConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_DELEGATE).forEach(config -> this.noticeTaskEvent(task, EventType.TASK_DELEGATE, (NoticeConfigDto)config, task.getCreateTime()));
            } else if (command instanceof CancelDelegateTaskCmd) {
                this.streamEventConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_CANCEL_DELEGATE).forEach(config -> this.handleTaskEvent(task, (EventConfigDto)config, FlowTaskEventType.TASK_CANCEL_DELEGATE, task.getCreateTime()));
                this.streamNoticeConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_CANCEL_DELEGATE).forEach(config -> this.noticeTaskEvent(task, EventType.TASK_CANCEL_DELEGATE, (NoticeConfigDto)config, task.getCreateTime()));
            } else {
                this.streamEventConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_CHANGE_ASSIGNEE).forEach(config -> this.handleTaskEvent(task, (EventConfigDto)config, FlowTaskEventType.TASK_CHANGE_ASSIGNEE, task.getCreateTime()));
                this.streamNoticeConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_CHANGE_ASSIGNEE).forEach(config -> this.noticeTaskEvent(task, EventType.TASK_CHANGE_ASSIGNEE, (NoticeConfigDto)config, task.getCreateTime()));
            }
        }
        Long flowTaskId = (Long)task.getVariableLocal("_FLOW_TASK_ID", Long.class);
        this.addAsyncTask(new AsyncApprovalMailNoticeTask(this.mailHelperService, flowInfoVariables.getFlowProjectId(), flowInfoVariables.getFlowProjectCode(), flowTaskId));
    }

    private void handleTransferTask(CustomFlowableEntityEvent event) {
        FlowTask flowTask = (FlowTask)event.getEntity();
        String processInstanceId = event.getAppendParam("processInstanceId").toString();
        RuntimeService runtimeService = CommandContextUtil.getProcessEngineConfiguration().getRuntimeService();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables(runtimeService, processInstanceId);
        this.streamEventConfig(flowInfoVariables, flowTask, EventType.TASK_CHANGE_ASSIGNEE).forEach(config -> this.handleFlowTaskEvent(flowTask, flowInfoVariables, processInstanceId, (EventConfigDto)config, FlowTaskEventType.TASK_CHANGE_ASSIGNEE));
        this.streamNoticeConfig(flowInfoVariables, flowTask, EventType.TASK_CHANGE_ASSIGNEE).forEach(config -> this.noticeTaskEvent(flowTask, flowInfoVariables, EventType.TASK_CHANGE_ASSIGNEE, (NoticeConfigDto)config, new Date(), () -> runtimeService.getVariables(event.getProcessInstanceId())));
    }

    private void handleTaskComplete(FlowableEntityEvent event) {
        TaskEntity entity = (TaskEntity)event.getEntity();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)entity);
        this.streamEventConfig(flowInfoVariables, entity.getTaskDefinitionKey(), EventType.TASK_COMPLETE).forEach(config -> this.handleTaskEvent(entity, (EventConfigDto)config, FlowTaskEventType.TASK_COMPLETE));
        this.streamNoticeConfig(flowInfoVariables, entity.getTaskDefinitionKey(), EventType.TASK_COMPLETE).forEach(config -> this.noticeTaskEvent(entity, EventType.TASK_COMPLETE, (NoticeConfigDto)config));
    }

    private void handleMiActivityStarted(FlowableMultiInstanceActivityEvent event) {
        RuntimeService runtimeService = CommandContextUtil.getProcessEngineConfiguration().getRuntimeService();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables(runtimeService, event.getProcessInstanceId());
        String nodeName = this.flowProjectConfigCacheRepository.getNodeName(flowInfoVariables.getFlowProjectId().longValue(), event.getActivityId());
        this.streamEventConfig(flowInfoVariables, event.getActivityId(), EventType.NODE_START).forEach(config -> this.handleNodeStart(event.getProcessInstanceId(), event.getActivityId(), nodeName, (EventConfigDto)config));
    }

    private void handleMiActivityCompleted(FlowableMultiInstanceActivityEvent event) {
        RuntimeService runtimeService = CommandContextUtil.getProcessEngineConfiguration().getRuntimeService();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables(runtimeService, event.getProcessInstanceId());
        String nodeName = this.flowProjectConfigCacheRepository.getNodeName(flowInfoVariables.getFlowProjectId().longValue(), event.getActivityId());
        this.streamEventConfig(flowInfoVariables, event.getActivityId(), EventType.NODE_COMPLETE).forEach(config -> this.handleNodeCompleted(event.getProcessInstanceId(), event.getActivityId(), nodeName, (EventConfigDto)config));
    }

    private void handleEmptyMiNodeFin(CustomFlowableEntityEvent event) {
        DelegateExecution miRoot = (DelegateExecution)event.getEntity();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)miRoot);
        String nodeName = this.flowProjectConfigCacheRepository.getNodeName(flowInfoVariables.getFlowProjectId().longValue(), miRoot.getCurrentActivityId());
        this.streamEventConfig(flowInfoVariables, miRoot.getCurrentActivityId(), EventType.NODE_COMPLETE).forEach(config -> this.handleNodeCompleted(miRoot.getProcessInstanceId(), miRoot.getCurrentActivityId(), nodeName, (EventConfigDto)config));
    }

    private void handleTaskDeleted(CustomFlowableEntityEvent event) {
        Object entity = event.getEntity();
        if (entity instanceof TaskEntity) {
            TaskEntity task = (TaskEntity)event.getEntity();
            FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)task);
            this.streamEventConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_DELETE).forEach(config -> this.handleTaskEvent(task, (EventConfigDto)config, FlowTaskEventType.TASK_DELETE));
            this.streamNoticeConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_DELETE).forEach(config -> this.noticeTaskEvent(task, EventType.TASK_DELETE, (NoticeConfigDto)config));
        } else if (entity instanceof FlowTask) {
            RuntimeService runtimeService = CommandContextUtil.getProcessEngineConfiguration().getRuntimeService();
            String processInstanceId = event.getProcessInstanceId();
            FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables(runtimeService, processInstanceId);
            FlowTask task = (FlowTask)entity;
            this.streamEventConfig(flowInfoVariables, task, EventType.TASK_DELETE).forEach(config -> this.handleFlowTaskEvent(task, flowInfoVariables, processInstanceId, (EventConfigDto)config, FlowTaskEventType.TASK_DELETE));
            this.streamNoticeConfig(flowInfoVariables, task, EventType.TASK_DELETE).forEach(config -> this.noticeTaskEvent(task, flowInfoVariables, EventType.TASK_DELETE, (NoticeConfigDto)config, () -> runtimeService.getVariables(event.getProcessInstanceId())));
        }
    }

    private void handleFlowJump(CustomFlowableEntityEvent event) {
        if (event.getEntity() instanceof TaskEntity || event.getEntity() instanceof FlowTask) {
            this.handleTaskDeleted(event);
        }
    }

    private void handleNodeStart(String processInstanceId, String nodeKey, String nodeName, EventConfigDto config) {
        ProcessInstance processInstance = (ProcessInstance)CommandContextUtil.getProcessEngineConfiguration().getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).includeProcessVariables().singleResult();
        switch (config.getActionType()) {
            case FRAMEWORK_EVENT: {
                this.sendFlowNodeFrameworkEvent(processInstance, nodeKey, nodeName, FlowNodeEventType.NODE_START, new Date(), config.getFrameworkEventActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case INTERNAL_HTTP: {
                this.callInternalNodeApi(processInstance, nodeKey, nodeName, FlowNodeEventType.NODE_START, new Date(), config.getInternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case EXTERNAL_HTTP: {
                this.callExternalNodeApi(processInstance, nodeKey, nodeName, FlowNodeEventType.NODE_START, new Date(), config.getExternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case CUSTOM_HTTP: {
                this.callCustomNodeApi(processInstance, config.getCustomHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case LOCAL_METHOD: {
                this.invokeFlowNodeLocalMethod(processInstance, nodeKey, nodeName, FlowNodeEventType.NODE_START, new Date(), config.getLocalMethodActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case AUTO_CC: {
                this.invokeAutoCcInstanceMethod(processInstance, config.getAutoCcActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
        }
    }

    private void handleNodeCompleted(String processInstanceId, String nodeKey, String nodeName, EventConfigDto config) {
        ProcessInstance processInstance = (ProcessInstance)CommandContextUtil.getProcessEngineConfiguration().getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).includeProcessVariables().singleResult();
        switch (config.getActionType()) {
            case FRAMEWORK_EVENT: {
                this.sendFlowNodeFrameworkEvent(processInstance, nodeKey, nodeName, FlowNodeEventType.NODE_COMPLETE, new Date(), config.getFrameworkEventActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case INTERNAL_HTTP: {
                this.callInternalNodeApi(processInstance, nodeKey, nodeName, FlowNodeEventType.NODE_COMPLETE, new Date(), config.getInternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case EXTERNAL_HTTP: {
                this.callExternalNodeApi(processInstance, nodeKey, nodeName, FlowNodeEventType.NODE_COMPLETE, new Date(), config.getExternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case CUSTOM_HTTP: {
                this.callCustomNodeApi(processInstance, config.getCustomHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case LOCAL_METHOD: {
                this.invokeFlowNodeLocalMethod(processInstance, nodeKey, nodeName, FlowNodeEventType.NODE_COMPLETE, new Date(), config.getLocalMethodActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case AUTO_CC: {
                this.invokeAutoCcInstanceMethod(processInstance, config.getAutoCcActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
        }
    }

    private void handleReject(CustomFlowableEntityEvent event) {
        TaskEntity task = (TaskEntity)event.getEntity();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)task);
        String nodeName = this.flowProjectConfigCacheRepository.getNodeName(flowInfoVariables.getFlowProjectId().longValue(), task.getTaskDefinitionKey());
        this.streamEventConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_REJECT).forEach(config -> this.handleTaskEvent(task, (EventConfigDto)config, FlowTaskEventType.TASK_REJECT));
        this.streamEventConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.NODE_REJECT).forEach(config -> this.handleNodeReject(task.getProcessInstanceId(), task.getTaskDefinitionKey(), nodeName, (EventConfigDto)config));
        this.streamNoticeConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_REJECT).forEach(config -> this.noticeTaskEvent(task, EventType.TASK_REJECT, (NoticeConfigDto)config));
    }

    private void handleSignApprove(CustomFlowableEntityEvent event) {
        TaskEntity task = (TaskEntity)event.getEntity();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)task);
        this.streamEventConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_COMPLETE).forEach(config -> this.handleTaskEvent(task, (EventConfigDto)config, FlowTaskEventType.TASK_COMPLETE));
        this.streamNoticeConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_COMPLETE).forEach(config -> this.noticeTaskEvent(task, EventType.TASK_COMPLETE, (NoticeConfigDto)config));
    }

    private void handleSignReject(CustomFlowableEntityEvent event) {
        TaskEntity task = (TaskEntity)event.getEntity();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)task);
        this.streamEventConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_REJECT).forEach(config -> this.handleTaskEvent(task, (EventConfigDto)config, FlowTaskEventType.TASK_REJECT));
        this.streamNoticeConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_REJECT).forEach(config -> this.noticeTaskEvent(task, EventType.TASK_REJECT, (NoticeConfigDto)config));
    }

    private void handleSignFinReject(CustomFlowableEntityEvent event) {
        DelegateExecution execution = (DelegateExecution)event.getEntity();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)execution);
        String nodeName = this.flowProjectConfigCacheRepository.getNodeName(flowInfoVariables.getFlowProjectId().longValue(), execution.getCurrentActivityId());
        this.streamEventConfig(flowInfoVariables, execution.getCurrentActivityId(), EventType.NODE_REJECT).forEach(config -> this.handleNodeReject(execution.getProcessInstanceId(), execution.getCurrentActivityId(), nodeName, (EventConfigDto)config));
    }

    private void handleNodeReject(String processInstanceId, String nodeKey, String nodeName, EventConfigDto config) {
        ProcessInstance processInstance = (ProcessInstance)CommandContextUtil.getProcessEngineConfiguration().getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).includeProcessVariables().singleResult();
        switch (config.getActionType()) {
            case FRAMEWORK_EVENT: {
                this.sendFlowNodeFrameworkEvent(processInstance, nodeKey, nodeName, FlowNodeEventType.NODE_REJECT, new Date(), config.getFrameworkEventActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case INTERNAL_HTTP: {
                this.callInternalNodeApi(processInstance, nodeKey, nodeName, FlowNodeEventType.NODE_REJECT, new Date(), config.getInternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case EXTERNAL_HTTP: {
                this.callExternalNodeApi(processInstance, nodeKey, nodeName, FlowNodeEventType.NODE_REJECT, new Date(), config.getExternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case CUSTOM_HTTP: {
                this.callCustomNodeApi(processInstance, config.getCustomHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case LOCAL_METHOD: {
                this.invokeFlowNodeLocalMethod(processInstance, nodeKey, nodeName, FlowNodeEventType.NODE_REJECT, new Date(), config.getLocalMethodActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case AUTO_CC: {
                this.invokeAutoCcInstanceMethod(processInstance, config.getAutoCcActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
        }
    }

    private void handleRollbackToPrev(CustomFlowableEntityEvent event) {
        TaskEntity task = (TaskEntity)event.getEntity();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)task);
        this.streamEventConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_ROLLBACK_PREV).forEach(config -> this.handleTaskEvent(task, (EventConfigDto)config, FlowTaskEventType.TASK_ROLLBACK_PREV));
        this.streamNoticeConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_ROLLBACK_PREV).forEach(config -> this.noticeTaskEvent(task, EventType.TASK_ROLLBACK_PREV, (NoticeConfigDto)config));
    }

    private void handleRollbackToSpecial(CustomFlowableEntityEvent event) {
        TaskEntity task = (TaskEntity)event.getEntity();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)task);
        this.streamEventConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_ROLLBACK_TO).forEach(config -> this.handleTaskEvent(task, (EventConfigDto)config, FlowTaskEventType.TASK_ROLLBACK_TO));
        this.streamNoticeConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_ROLLBACK_TO).forEach(config -> this.noticeTaskEvent(task, EventType.TASK_ROLLBACK_TO, (NoticeConfigDto)config));
    }

    private void handleRollbackToStart(CustomFlowableEntityEvent event) {
        TaskEntity task = (TaskEntity)event.getEntity();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)task);
        this.streamEventConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_ROLLBACK_START).forEach(config -> this.handleTaskEvent(task, (EventConfigDto)config, FlowTaskEventType.TASK_ROLLBACK_START));
        this.streamNoticeConfig(flowInfoVariables, task.getTaskDefinitionKey(), EventType.TASK_ROLLBACK_START).forEach(config -> this.noticeTaskEvent(task, EventType.TASK_ROLLBACK_START, (NoticeConfigDto)config));
    }

    private void handleCcTask(CustomFlowableEntityEvent event) {
        RuntimeService runtimeService = CommandContextUtil.getProcessEngineConfiguration().getRuntimeService();
        FlowTask task = (FlowTask)event.getEntity();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables(runtimeService, event.getProcessInstanceId());
        this.streamEventConfig(flowInfoVariables, task, EventType.TASK_CC).forEach(config -> this.handleFlowTaskEvent(task, flowInfoVariables, event.getProcessInstanceId(), (EventConfigDto)config, FlowTaskEventType.TASK_CC));
        this.streamNoticeConfig(flowInfoVariables, task, EventType.TASK_CC).forEach(config -> this.noticeTaskEvent(task, flowInfoVariables, EventType.TASK_CC, (NoticeConfigDto)config, new Date(), () -> runtimeService.getVariables(event.getProcessInstanceId())));
    }

    private void handleStarterFillEvent(CustomFlowableEntityEvent event) {
        FlowTaskEventType flowTaskEventType;
        EventType eventType;
        switch (event.getCustomEventType()) {
            case STARTER_FILL: {
                eventType = EventType.TASK_STARTER_FILL;
                flowTaskEventType = FlowTaskEventType.TASK_STARTER_FILL;
                break;
            }
            case STARTER_FILL_START: {
                eventType = EventType.TASK_STARTER_FILL_START;
                flowTaskEventType = FlowTaskEventType.TASK_STARTER_FILL_START;
                break;
            }
            case STARTER_FILL_COMPLETE: {
                eventType = EventType.TASK_STARTER_FILL_COMPLETE;
                flowTaskEventType = FlowTaskEventType.TASK_STARTER_FILL_COMPLETE;
                break;
            }
            case NODE_STARTER_FILL: {
                eventType = EventType.TASK_WAIT_STARTER_FILL;
                flowTaskEventType = FlowTaskEventType.TASK_WAIT_STARTER_FILL;
                break;
            }
            case WAIT_STARTER_FILL_FIN: {
                eventType = EventType.TASK_WAIT_STARTER_FILL_FIN;
                flowTaskEventType = FlowTaskEventType.TASK_WAIT_STARTER_FILL_FIN;
                break;
            }
            default: {
                return;
            }
        }
        RuntimeService runtimeService = CommandContextUtil.getProcessEngineConfiguration().getRuntimeService();
        FlowTask task = (FlowTask)event.getEntity();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables(runtimeService, event.getProcessInstanceId());
        this.streamEventConfig(flowInfoVariables, task, eventType).forEach(config -> this.handleFlowTaskEvent(task, flowInfoVariables, event.getProcessInstanceId(), (EventConfigDto)config, flowTaskEventType));
        this.streamNoticeConfig(flowInfoVariables, task, eventType).forEach(config -> this.noticeTaskEvent(task, flowInfoVariables, eventType, (NoticeConfigDto)config, new Date(), () -> runtimeService.getVariables(event.getProcessInstanceId())));
    }

    private void handleFlowTaskEvent(FlowTask task, FlowInfoVariables flowInfoVariables, String processInstanceId, EventConfigDto config, FlowTaskEventType eventType) {
        this.handleFlowTaskEvent(task, flowInfoVariables, processInstanceId, config, eventType, new Date());
    }

    private void handleFlowTaskEvent(FlowTask task, FlowInfoVariables flowInfoVariables, String processInstanceId, EventConfigDto config, FlowTaskEventType eventType, Date eventTime) {
        switch (config.getActionType()) {
            case FRAMEWORK_EVENT: {
                this.sendFlowTaskFrameworkEvent(task, flowInfoVariables, processInstanceId, eventType, eventTime, config.getFrameworkEventActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case INTERNAL_HTTP: {
                this.callInternalTaskApi(task, flowInfoVariables, processInstanceId, eventType, eventTime, config.getInternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case EXTERNAL_HTTP: {
                this.callExternalTaskApi(task, flowInfoVariables, processInstanceId, eventType, eventTime, config.getExternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case CUSTOM_HTTP: {
                this.callCustomTaskApi(processInstanceId, config.getCustomHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case LOCAL_METHOD: {
                this.invokeFlowTaskLocalMethod(task, flowInfoVariables, processInstanceId, eventType, eventTime, config.getLocalMethodActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case AUTO_CC: {
                this.invokeAutoCcTaskMethod(task, flowInfoVariables, eventType, config.getAutoCcActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
        }
    }

    private void invokeAutoCcTaskMethod(FlowTask task, FlowInfoVariables flowInfoVariables, FlowTaskEventType eventType, AutoCcActionConfig autoCcActionConfig, boolean sync) {
        if (FlowTaskEventType.TASK_CC.equals((Object)eventType)) {
            return;
        }
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowInfoVariables.getFlowInstanceId().longValue());
        FlowTaskCcDto dto = new FlowTaskCcDto();
        dto.setUsers(this.getUserIdNameList(autoCcActionConfig, flowInstance));
        dto.setNote(autoCcActionConfig.getNote());
        if (!sync) {
            this.addAsyncTask(new AsyncEventAutoCcTask(this.flowEngineService, task, dto));
        } else {
            this.flowEngineService.ccTask(task, dto);
        }
    }

    private void handleTaskEvent(TaskEntity entity, EventConfigDto config, FlowTaskEventType eventType) {
        this.handleTaskEvent(entity, config, eventType, new Date());
    }

    private void handleTaskEvent(TaskEntity entity, EventConfigDto config, FlowTaskEventType eventType, Date eventTime) {
        switch (config.getActionType()) {
            case FRAMEWORK_EVENT: {
                this.sendFlowTaskFrameworkEvent(entity, eventType, eventTime, config.getFrameworkEventActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case INTERNAL_HTTP: {
                this.callInternalTaskApi(entity, eventType, eventTime, config.getInternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case EXTERNAL_HTTP: {
                this.callExternalTaskApi(entity, eventType, eventTime, config.getExternalHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case CUSTOM_HTTP: {
                this.callCustomTaskApi(entity, config.getCustomHttpActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case LOCAL_METHOD: {
                this.invokeFlowTaskLocalMethod(entity, eventType, eventTime, config.getLocalMethodActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
            case AUTO_CC: {
                this.invokeAutoCcTaskMethod(entity, eventType, config.getAutoCcActionConfig(), ActionCallType.SYNC.equals((Object)config.getCallType()));
                break;
            }
        }
    }

    private void invokeAutoCcTaskMethod(TaskEntity entity, FlowTaskEventType eventType, AutoCcActionConfig autoCcActionConfig, boolean sync) {
        if (FlowTaskEventType.TASK_CC.equals((Object)eventType)) {
            return;
        }
        Long flowTaskId = (Long)entity.getVariableLocal("_FLOW_TASK_ID", Long.class);
        FlowTaskWithProject flowTaskWithProject = this.flowTaskService.getFlowTaskWithProject(flowTaskId.longValue());
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowTaskWithProject.getFlowInstanceId().longValue());
        FlowTaskCcDto dto = new FlowTaskCcDto();
        dto.setUsers(this.getUserIdNameList(autoCcActionConfig, flowInstance));
        dto.setNote(autoCcActionConfig.getNote());
        if (!sync) {
            this.addAsyncTask(new AsyncEventAutoCcTask(this.flowEngineService, (FlowTask)flowTaskWithProject, dto));
        } else {
            this.flowEngineService.ccTask((FlowTask)flowTaskWithProject, dto);
        }
    }

    private List<IdNameDto> getUserIdNameList(AutoCcActionConfig config, FlowInstance flowInstance) {
        HashSet<Long> userIds = new HashSet<Long>();
        if (Boolean.TRUE.equals(config.getNoticeStarter())) {
            userIds.add(flowInstance.getStartUserId());
        }
        if (Boolean.TRUE.equals(config.getNoticeSpecialTarget())) {
            AssigneeType assigneeType = config.getAssigneeType();
            if (AssigneeType.USER.equals((Object)assigneeType)) {
                for (NoticeUserDto noticeTarget : config.getNoticeTargets()) {
                    userIds.add(noticeTarget.getId());
                }
            } else if (AssigneeType.ROLE.equals((Object)assigneeType)) {
                Set roleCodes = config.getNoticeTargets().stream().map(NoticeUserDto::getCode).collect(Collectors.toSet());
                userIds.addAll(this.userHelperService.findUserIdsByRoleCodes(roleCodes));
            } else if (AssigneeType.FORMULA.equals((Object)assigneeType)) {
                userIds.addAll(this.getUserIdsFromFormula(config.getAssigneeFormula(), flowInstance));
            }
        }
        Map userNameMap = this.userHelperService.getUserNameMap(new HashSet(userIds));
        return userNameMap.entrySet().stream().map(entry -> {
            IdNameDto idNameDto = new IdNameDto();
            idNameDto.setId((Long)entry.getKey());
            idNameDto.setName((String)entry.getValue());
            return idNameDto;
        }).collect(Collectors.toList());
    }

    private Collection<Long> getUserIdsFromFormula(String ccUserFormula, FlowInstance flowInstance) {
        FlowExpressionExecutor expressionExecutor = this.flowEngineService.getFlowExpressionExecutor(flowInstance.getProcessInstanceId());
        try {
            Object expressionResult = expressionExecutor.execute(ccUserFormula);
            if (expressionResult instanceof Long) {
                return Collections.singleton((Long)expressionResult);
            }
            if (expressionResult instanceof Collection) {
                return ((Collection)expressionResult).stream().filter(this::canHandleCollectionResult).map(this::convertCollectionResult).collect(Collectors.toList());
            }
            if (expressionResult != null && StringUtils.isNumeric((CharSequence)expressionResult.toString())) {
                return Collections.singleton(Long.parseLong(expressionResult.toString()));
            }
        }
        catch (Exception e) {
            this.logger.error("Execute expression [{}] failed", (Object)ccUserFormula, (Object)e);
        }
        return Collections.emptyList();
    }

    private boolean canHandleCollectionResult(Object result) {
        if (result == null) {
            this.logger.warn("Result collection contains null value");
            return false;
        }
        if (result instanceof Long) {
            return true;
        }
        String resultString = result.toString();
        if (StringUtils.isNumeric((CharSequence)resultString)) {
            return true;
        }
        this.logger.warn("Result collection contains error value: [{}]", (Object)resultString);
        return false;
    }

    private Long convertCollectionResult(Object result) {
        if (result instanceof Long) {
            return (Long)result;
        }
        return Long.parseLong(result.toString());
    }

    private void noticeTaskEvent(TaskEntity entity, EventType eventType, NoticeConfigDto config) {
        this.noticeTaskEvent(entity, eventType, config, new Date());
    }

    private void noticeTaskEvent(TaskEntity entity, EventType eventType, NoticeConfigDto config, Date eventTime) {
        if (config.getNoticeTemplates() == null || config.getNoticeTemplates().isEmpty()) {
            return;
        }
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)entity);
        FlowTaskWithBusinessKey flowTask = this.flowTaskService.getFlowTaskWithBusinessKeyByTaskId(entity.getId());
        this.noticeTaskEvent(flowTask, flowInfoVariables, eventType, config, eventTime, () -> ((TaskEntity)entity).getVariables());
    }

    private void noticeTaskEvent(FlowTask flowTask, FlowInfoVariables flowInfoVariables, EventType eventType, NoticeConfigDto config, Supplier<Map<String, Object>> variablesSupplier) {
        this.noticeTaskEvent(flowTask, flowInfoVariables, eventType, config, new Date(), variablesSupplier);
    }

    private void noticeTaskEvent(FlowTask flowTask, FlowInfoVariables flowInfoVariables, EventType eventType, NoticeConfigDto config, Date eventTime, Supplier<Map<String, Object>> variablesSupplier) {
        if (flowTask instanceof FlowTaskWithBusinessKey) {
            this.noticeTaskEvent((FlowTaskWithBusinessKey)flowTask, flowInfoVariables, eventType, config, eventTime, variablesSupplier);
            return;
        }
        this.noticeTaskEvent(this.flowTaskService.getFlowTaskWithBusinessKey(((Long)flowTask.getId()).longValue()), flowInfoVariables, eventType, config, eventTime, variablesSupplier);
    }

    private void noticeTaskEvent(FlowTaskWithBusinessKey flowTask, FlowInfoVariables flowInfoVariables, EventType eventType, NoticeConfigDto config, Date eventTime, Supplier<Map<String, Object>> variablesSupplier) {
        if (config.getNoticeTemplates() == null || config.getNoticeTemplates().isEmpty()) {
            return;
        }
        Long flowInstanceId = flowInfoVariables.getFlowInstanceId();
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowInstanceId.longValue());
        HashSet<Long> noticeUserIds = new HashSet<Long>();
        if (Boolean.TRUE.equals(config.getNoticeAssignee())) {
            noticeUserIds.add(flowTask.getAssigneeUserId());
        }
        if (Boolean.TRUE.equals(config.getNoticeStarter())) {
            noticeUserIds.add(flowInstance.getStartUserId());
        }
        if (Boolean.TRUE.equals(config.getNoticeSpecialTarget())) {
            this.addSpecialNoticeTargetUserIds(noticeUserIds, config.getNoticeTargets());
        }
        if (Boolean.TRUE.equals(config.getNoticeCcUser())) {
            this.addCcUserIds(noticeUserIds);
        }
        if (noticeUserIds.isEmpty()) {
            return;
        }
        Map userNameMap = this.userHelperService.getUserNameMap(noticeUserIds);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        Map<String, Object> variables = variablesSupplier.get();
        if (variables != null) {
            paramsMap.putAll(variables);
        }
        paramsMap.put("flowInstance", flowInstance.toFlowInstanceInfoVo());
        paramsMap.put("flowTask", flowTask.toFlowTaskAllowActionVo());
        paramsMap.put("fc_instance_code", flowInstance.getInstanceCode());
        if (null != eventTime) {
            paramsMap.put("eventTime", eventTime.getTime());
        }
        paramsMap.put("actionUserId", ServiceContext.getContext().getRequestUserId());
        paramsMap.put("actionUserName", ServiceContext.getContext().getRequestUserName());
        for (Map.Entry user : userNameMap.entrySet()) {
            AsyncEventFrameworkEventTask task = new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)this.buildEventPushDto(flowInstance, eventType.name(), config.getNoticeTemplates(), (Long)user.getKey(), (String)user.getValue(), paramsMap), null);
            task.setSkipAutoCompleteTask(Boolean.TRUE.equals(config.getSkipAutoCompleteTask()));
            task.setTaskId(flowTask.getTaskId());
            this.addAsyncTask(task);
        }
    }

    private void addCcUserIds(Set<Long> noticeUserIds) {
        String userIdListJson = ObjectUtils.defaultIfNull((Object)CommandContextUtil.getCommandContext().getAttribute("_CC_USER_ID_LIST"), (Object)"").toString();
        if (StringUtils.isNotBlank((CharSequence)userIdListJson)) {
            List ccUserIds = (List)JSON.parseObject((String)userIdListJson, (TypeReference)new TypeReference<List<Long>>(){}, (Feature[])new Feature[0]);
            noticeUserIds.addAll(ccUserIds);
        }
    }

    private void noticeFLowInstanceEvent(FlowInstance flowInstance, EventType eventType, NoticeConfigDto config, Date eventTime, HistoricProcessInstance processInstance) {
        this.noticeFLowInstanceEvent(flowInstance, eventType, config, eventTime, processInstance.getProcessVariables());
    }

    private void noticeFLowInstanceEvent(FlowInstance flowInstance, EventType eventType, NoticeConfigDto config, Date eventTime, Map<String, Object> variables) {
        if (config.getNoticeTemplates() == null || config.getNoticeTemplates().isEmpty()) {
            return;
        }
        HashSet<Long> noticeUserIds = new HashSet<Long>();
        if (Boolean.TRUE.equals(config.getNoticeStarter())) {
            noticeUserIds.add(flowInstance.getStartUserId());
        }
        if (Boolean.TRUE.equals(config.getNoticeSpecialTarget())) {
            this.addSpecialNoticeTargetUserIds(noticeUserIds, config.getNoticeTargets());
        }
        if (Boolean.TRUE.equals(config.getNoticeCcUser())) {
            this.addCcUserIds(noticeUserIds);
        }
        if (noticeUserIds.isEmpty()) {
            return;
        }
        Map userNameMap = this.userHelperService.getUserNameMap(noticeUserIds);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        if (variables != null) {
            paramsMap.putAll(variables);
        }
        paramsMap.put("flowInstance", flowInstance.toFlowInstanceInfoVo());
        paramsMap.put("fc_instance_code", flowInstance.getInstanceCode());
        if (null != eventTime) {
            paramsMap.put("eventTime", eventTime.getTime());
        }
        paramsMap.put("actionUserId", ServiceContext.getContext().getRequestUserId());
        paramsMap.put("actionUserName", ServiceContext.getContext().getRequestUserName());
        for (Map.Entry user : userNameMap.entrySet()) {
            AsyncEventFrameworkEventTask task = new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)this.buildEventPushDto(flowInstance, eventType.name(), config.getNoticeTemplates(), (Long)user.getKey(), (String)user.getValue(), paramsMap), null);
            task.setSkipAutoCompleteTask(Boolean.TRUE.equals(config.getSkipAutoCompleteTask()));
            this.addAsyncTask(task);
        }
    }

    private void addSpecialNoticeTargetUserIds(Set<Long> noticeUserIds, List<NoticeTargetDto> noticeTargets) {
        if (noticeTargets == null || noticeTargets.isEmpty()) {
            return;
        }
        HashSet roleCodes = new HashSet();
        noticeTargets.forEach(target -> {
            if (NoticeTargetType.USER.equals((Object)target.getType()) && target.getId() != null) {
                noticeUserIds.add(target.getId());
            } else if (NoticeTargetType.ROLE.equals((Object)target.getType()) && StringUtils.isNotBlank((CharSequence)target.getCode())) {
                roleCodes.add(target.getCode());
            }
        });
        if (!roleCodes.isEmpty()) {
            noticeUserIds.addAll(this.userHelperService.findUserIdsByRoleCodes(roleCodes));
        }
    }

    private void addAsyncTask(AsyncEventActionTask task) {
        CommandContext commandContext = Context.getCommandContext();
        ArrayList<AsyncEventActionTask> tasks = (ArrayList<AsyncEventActionTask>)commandContext.getAttribute("asyncActionTasks");
        if (tasks == null) {
            tasks = new ArrayList<AsyncEventActionTask>();
            commandContext.addAttribute("asyncActionTasks", tasks);
        }
        tasks.add(task);
        commandContext.addCloseListener((CommandContextCloseListener)new AsyncActionListener(this.asyncEventActionService));
    }

    private FlowInstanceEvent buildFlowInstanceEvent(ExecutionEntity processInstance, FlowInstanceEventType eventType, Date eventTime, boolean sendVariablesJson) {
        Object customCmdParams;
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)processInstance);
        FlowInstanceEvent event = new FlowInstanceEvent();
        event.setEventType(eventType);
        event.setEventTime(eventTime);
        event.setFlowInstanceId(flowInfoVariables.getFlowInstanceId());
        event.setBusinessKey(flowInfoVariables.getBusinessKey());
        if (sendVariablesJson) {
            event.setVariablesJson(this.buildVariableJson(processInstance.getVariables()));
        }
        if ((customCmdParams = CommandContextUtil.getCommandContext().getAttribute("_CUSTOM_CMD_PARAMS")) instanceof CustomCmdParams) {
            event.setOpinion(((CustomCmdParams)customCmdParams).getOpinion());
        }
        return event;
    }

    private FlowInstanceEvent buildFlowInstanceEvent(HistoricProcessInstance processInstance, FlowInstanceEventType eventType, Date eventTime, boolean sendVariablesJson) {
        Object customCmdParams;
        FlowInstanceEvent event = new FlowInstanceEvent();
        event.setEventType(eventType);
        event.setEventTime(eventTime);
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables(processInstance);
        event.setFlowInstanceId(flowInfoVariables.getFlowInstanceId());
        event.setBusinessKey(flowInfoVariables.getBusinessKey());
        if (sendVariablesJson) {
            event.setVariablesJson(this.buildVariableJson(processInstance.getProcessVariables()));
        }
        if ((customCmdParams = CommandContextUtil.getCommandContext().getAttribute("_CUSTOM_CMD_PARAMS")) instanceof CustomCmdParams) {
            event.setOpinion(((CustomCmdParams)customCmdParams).getOpinion());
        }
        return event;
    }

    private FlowNodeEvent buildFlowNodeEvent(ProcessInstance processInstance, String nodeKey, String nodeName, FlowNodeEventType eventType, Date eventTime, boolean sendVariablesJson) {
        Object customCmdParams;
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables(processInstance);
        FlowNodeEvent event = new FlowNodeEvent();
        event.setEventType(eventType);
        event.setEventTime(eventTime);
        event.setFlowInstanceId(flowInfoVariables.getFlowInstanceId());
        event.setNodeKey(nodeKey);
        event.setNodeName(nodeName);
        event.setBusinessKey(flowInfoVariables.getBusinessKey());
        if (sendVariablesJson) {
            event.setVariablesJson(this.buildVariableJson(processInstance.getProcessVariables()));
        }
        if ((customCmdParams = CommandContextUtil.getCommandContext().getAttribute("_CUSTOM_CMD_PARAMS")) instanceof CustomCmdParams) {
            event.setOpinion(((CustomCmdParams)customCmdParams).getOpinion());
        }
        return event;
    }

    private FlowTaskEvent buildFlowTaskEvent(TaskEntity entity, FlowTaskEventType eventType, Date eventTime, boolean sendVariablesJson) {
        Object customCmdParams;
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)entity);
        FlowTaskEvent event = new FlowTaskEvent();
        event.setEventType(eventType);
        event.setEventTime(eventTime);
        event.setFlowTaskId((Long)entity.getVariableLocal("_FLOW_TASK_ID", Long.class));
        event.setFlowInstanceId(flowInfoVariables.getFlowInstanceId());
        event.setAssigneeUserId(StringUtils.isBlank((CharSequence)entity.getAssignee()) ? null : Long.valueOf(entity.getAssignee()));
        event.setOwnerUserId(StringUtils.isBlank((CharSequence)entity.getOwner()) ? null : Long.valueOf(entity.getOwner()));
        event.setNodeKey(entity.getTaskDefinitionKey());
        event.setBusinessKey(flowInfoVariables.getBusinessKey());
        if (sendVariablesJson) {
            event.setVariablesJson(this.buildVariableJson(entity.getVariables()));
        }
        if ((customCmdParams = CommandContextUtil.getCommandContext().getAttribute("_CUSTOM_CMD_PARAMS")) instanceof CustomCmdParams) {
            event.setOpinion(((CustomCmdParams)customCmdParams).getOpinion());
        }
        return event;
    }

    private FlowTaskEvent buildFlowTaskEvent(FlowTask flowTask, FlowInfoVariables flowInfoVariables, String processInstanceId, FlowTaskEventType eventType, Date eventTime, boolean sendVariablesJson) {
        Map variables;
        if (sendVariablesJson) {
            RuntimeService runtimeService = CommandContextUtil.getProcessEngineConfiguration().getRuntimeService();
            variables = runtimeService.getVariables(processInstanceId);
        } else {
            variables = null;
        }
        return this.buildFlowTaskEvent(flowTask, flowInfoVariables, eventType, eventTime, variables);
    }

    private FlowTaskEvent buildFlowTaskEvent(FlowTask flowTask, FlowInfoVariables flowInfoVariables, FlowTaskEventType eventType, Date eventTime, Map<String, Object> variables) {
        Object customCmdParams;
        FlowTaskEvent event = new FlowTaskEvent();
        event.setEventType(eventType);
        event.setEventTime(eventTime);
        event.setFlowTaskId((Long)flowTask.getId());
        event.setFlowInstanceId(flowInfoVariables.getFlowInstanceId());
        event.setAssigneeUserId(flowTask.getAssigneeUserId());
        event.setOwnerUserId(flowTask.getOwnerUserId());
        event.setNodeKey(flowTask.getNodeKey());
        event.setBusinessKey(flowInfoVariables.getBusinessKey());
        if (variables != null) {
            event.setVariablesJson(this.buildVariableJson(variables));
        }
        if ((customCmdParams = CommandContextUtil.getCommandContext().getAttribute("_CUSTOM_CMD_PARAMS")) instanceof CustomCmdParams) {
            event.setOpinion(((CustomCmdParams)customCmdParams).getOpinion());
        }
        return event;
    }

    private void invokeFlowInstanceLocalMethod(ExecutionEntity processInstance, FlowInstanceEventType eventType, Date eventTime, LocalMethodActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        boolean sendVariablesJson = Boolean.TRUE.equals(actionConfig.getSendVariablesJson());
        FlowInstanceEvent event = this.buildFlowInstanceEvent(processInstance, eventType, eventTime, sendVariablesJson);
        this.callLocalMethod(actionConfig, MethodInvokerUtils.toParams(event), sync, FlowInstanceEvent.class);
    }

    private void callLocalMethod(LocalMethodActionConfigDto actionConfig, Object[] event, boolean sync, Class<?> parameterType) {
        try {
            Object bean = this.applicationContext.getBean(actionConfig.getBeanName());
            Method method = ReflectionUtils.findMethod(bean.getClass(), (String)actionConfig.getMethodName(), (Class[])new Class[]{parameterType});
            if (method == null) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.METHOD_NOT_FOUND, new Object[]{actionConfig.getMethodName()});
            }
            if (!sync) {
                this.addAsyncTask(new AsyncEventLocalMethodTask(bean, method, event));
            } else {
                MethodInvokerUtils.invokeMethod(bean, method, event);
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.BEAN_NOT_FOUND, new Object[]{actionConfig.getBeanName()});
        }
    }

    private void invokeFlowInstanceLocalMethod(HistoricProcessInstance processInstance, FlowInstanceEventType eventType, Date eventTime, LocalMethodActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        boolean sendVariablesJson = Boolean.TRUE.equals(actionConfig.getSendVariablesJson());
        FlowInstanceEvent event = this.buildFlowInstanceEvent(processInstance, eventType, eventTime, sendVariablesJson);
        this.callLocalMethod(actionConfig, MethodInvokerUtils.toParams(event), sync, FlowInstanceEvent.class);
    }

    private void sendFlowInstanceFrameworkEvent(ExecutionEntity processInstance, FlowInstanceEventType eventType, Date eventTime, FrameworkEventActionConfigDto actionConfig, boolean sync) {
        boolean sendVariablesJson = actionConfig != null && Boolean.TRUE.equals(actionConfig.getSendVariablesJson());
        FlowInstanceEvent event = this.buildFlowInstanceEvent(processInstance, eventType, eventTime, sendVariablesJson);
        if (!sync) {
            this.addAsyncTask(new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)new FlowInstanceFrameworkEvent(event), actionConfig == null ? null : actionConfig.getRoute()));
        } else {
            this.pushFrameworkEvent((BeanEvent<?>)new FlowInstanceFrameworkEvent(event), actionConfig);
        }
    }

    private void sendFlowInstanceFrameworkEvent(HistoricProcessInstance processInstance, FlowInstanceEventType eventType, Date eventTime, FrameworkEventActionConfigDto actionConfig, boolean sync) {
        boolean sendVariablesJson = actionConfig != null && Boolean.TRUE.equals(actionConfig.getSendVariablesJson());
        FlowInstanceEvent event = this.buildFlowInstanceEvent(processInstance, eventType, eventTime, sendVariablesJson);
        if (!sync) {
            this.addAsyncTask(new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)new FlowInstanceFrameworkEvent(event), actionConfig == null ? null : actionConfig.getRoute()));
        } else {
            this.pushFrameworkEvent((BeanEvent<?>)new FlowInstanceFrameworkEvent(event), actionConfig);
        }
    }

    private void sendFlowNodeFrameworkEvent(ProcessInstance processInstance, String nodeKey, String nodeName, FlowNodeEventType eventType, Date eventTime, FrameworkEventActionConfigDto actionConfig, boolean sync) {
        boolean sendVariablesJson = actionConfig != null && Boolean.TRUE.equals(actionConfig.getSendVariablesJson());
        FlowNodeEvent event = this.buildFlowNodeEvent(processInstance, nodeKey, nodeName, eventType, eventTime, sendVariablesJson);
        if (!sync) {
            this.addAsyncTask(new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)new FlowNodeFrameworkEvent(event), actionConfig == null ? null : actionConfig.getRoute()));
        } else {
            this.pushFrameworkEvent((BeanEvent<?>)new FlowNodeFrameworkEvent(event), actionConfig);
        }
    }

    private void invokeFlowNodeLocalMethod(ProcessInstance processInstance, String nodeKey, String nodeName, FlowNodeEventType eventType, Date eventTime, LocalMethodActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        boolean sendVariablesJson = Boolean.TRUE.equals(actionConfig.getSendVariablesJson());
        FlowNodeEvent event = this.buildFlowNodeEvent(processInstance, nodeKey, nodeName, eventType, eventTime, sendVariablesJson);
        this.callLocalMethod(actionConfig, MethodInvokerUtils.toParams(event), sync, FlowNodeEvent.class);
    }

    private void invokeFlowTaskLocalMethod(TaskEntity entity, FlowTaskEventType eventType, Date eventTime, LocalMethodActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        boolean sendVariablesJson = Boolean.TRUE.equals(actionConfig.getSendVariablesJson());
        FlowTaskEvent event = this.buildFlowTaskEvent(entity, eventType, eventTime, sendVariablesJson);
        this.callLocalMethod(actionConfig, MethodInvokerUtils.toParams(event), sync, FlowTaskEvent.class);
    }

    private void invokeFlowTaskLocalMethod(FlowTask flowTask, FlowInfoVariables flowInfoVariables, String processInstanceId, FlowTaskEventType eventType, Date eventTime, LocalMethodActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        boolean sendVariablesJson = Boolean.TRUE.equals(actionConfig.getSendVariablesJson());
        FlowTaskEvent event = this.buildFlowTaskEvent(flowTask, flowInfoVariables, processInstanceId, eventType, eventTime, sendVariablesJson);
        this.callLocalMethod(actionConfig, MethodInvokerUtils.toParams(event), sync, FlowTaskEvent.class);
    }

    private void sendFlowTaskFrameworkEvent(TaskEntity entity, FlowTaskEventType eventType, Date eventTime, FrameworkEventActionConfigDto actionConfig, boolean sync) {
        boolean sendVariablesJson = actionConfig != null && Boolean.TRUE.equals(actionConfig.getSendVariablesJson());
        FlowTaskEvent event = this.buildFlowTaskEvent(entity, eventType, eventTime, sendVariablesJson);
        this.sendFlowTaskFrameworkEvent(event, actionConfig, sync);
    }

    private void sendFlowTaskFrameworkEvent(FlowTask flowTask, FlowInfoVariables flowInfoVariables, String processInstanceId, FlowTaskEventType eventType, Date eventTime, FrameworkEventActionConfigDto actionConfig, boolean sync) {
        boolean sendVariablesJson = actionConfig != null && Boolean.TRUE.equals(actionConfig.getSendVariablesJson());
        FlowTaskEvent event = this.buildFlowTaskEvent(flowTask, flowInfoVariables, processInstanceId, eventType, eventTime, sendVariablesJson);
        this.sendFlowTaskFrameworkEvent(event, actionConfig, sync);
    }

    private void sendFlowTaskFrameworkEvent(FlowTaskEvent event, FrameworkEventActionConfigDto actionConfig, boolean sync) {
        if (!sync) {
            this.addAsyncTask(new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)new FlowTaskFrameworkEvent(event), actionConfig == null ? null : actionConfig.getRoute()));
        } else {
            this.pushFrameworkEvent((BeanEvent<?>)new FlowTaskFrameworkEvent(event), actionConfig);
        }
    }

    private void pushFrameworkEvent(BeanEvent<?> event, FrameworkEventActionConfigDto actionConfig) {
        if (actionConfig != null && StringUtils.isNotBlank((CharSequence)actionConfig.getRoute())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u53d1\u9001\u6846\u67b6\u4e8b\u4ef6\u6d88\u606f, route: [{}], event: [{}]", (Object)actionConfig.getRoute(), (Object)JSON.toJSONString(event));
            }
            this.frameworkEventService.pushEvent(event, actionConfig.getRoute());
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u53d1\u9001\u6846\u67b6\u4e8b\u4ef6\u6d88\u606f, event: [{}]", (Object)JSON.toJSONString(event));
            }
            this.frameworkEventService.pushEvent(event);
        }
    }

    private void callInternalFlowApi(ExecutionEntity processInstance, FlowInstanceEventType eventType, Date eventTime, InternalHttpActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        FlowInstanceEvent event = this.buildFlowInstanceEvent(processInstance, eventType, eventTime, Boolean.TRUE.equals(actionConfig.getSendVariablesJson()));
        this.callInternalApi(actionConfig, JSON.toJSONString((Object)event), sync);
    }

    private void callInternalFlowApi(HistoricProcessInstance processInstance, FlowInstanceEventType eventType, Date eventTime, InternalHttpActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        FlowInstanceEvent event = this.buildFlowInstanceEvent(processInstance, eventType, eventTime, Boolean.TRUE.equals(actionConfig.getSendVariablesJson()));
        this.callInternalApi(actionConfig, JSON.toJSONString((Object)event), sync);
    }

    private void callInternalNodeApi(ProcessInstance processInstance, String nodeKey, String nodeName, FlowNodeEventType eventType, Date eventTime, InternalHttpActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        FlowNodeEvent event = this.buildFlowNodeEvent(processInstance, nodeKey, nodeName, eventType, eventTime, Boolean.TRUE.equals(actionConfig.getSendVariablesJson()));
        this.callInternalApi(actionConfig, JSON.toJSONString((Object)event), sync);
    }

    private void callInternalTaskApi(TaskEntity entity, FlowTaskEventType eventType, Date eventTime, InternalHttpActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        FlowTaskEvent event = this.buildFlowTaskEvent(entity, eventType, eventTime, Boolean.TRUE.equals(actionConfig.getSendVariablesJson()));
        this.callInternalApi(actionConfig, JSON.toJSONString((Object)event), sync);
    }

    private void callInternalTaskApi(FlowTask flowTask, FlowInfoVariables flowInfoVariables, String processInstanceId, FlowTaskEventType eventType, Date eventTime, InternalHttpActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        FlowTaskEvent event = this.buildFlowTaskEvent(flowTask, flowInfoVariables, processInstanceId, eventType, eventTime, Boolean.TRUE.equals(actionConfig.getSendVariablesJson()));
        this.callInternalApi(actionConfig, JSON.toJSONString((Object)event), sync);
    }

    private Map<String, Collection<String>> buildInternalApiHeaders(Request.Body body) {
        return CustomApiUtils.buildInternalApiHeaders(body, CustomApiUtils.JSON_MEDIA_TYPE.toString(), this.contextProperties);
    }

    private void callInternalApi(InternalHttpActionConfigDto actionConfig, String bodyJson, boolean sync) {
        Pair<feign.Request, Request.Options> request = this.buildInternalApiRequest(actionConfig, bodyJson);
        this.callFeignApi(sync, request, actionConfig.errorMsgPathIfEnabled());
    }

    private Pair<feign.Request, Request.Options> buildInternalApiRequest(InternalHttpActionConfigDto actionConfig, String bodyJson) {
        String url = CustomApiUtils.formatInternalApiPath(actionConfig);
        Request.Body body = Request.Body.create((String)bodyJson, (Charset)StandardCharsets.UTF_8);
        Map<String, Collection<String>> headers = this.buildInternalApiHeaders(body);
        feign.Request request = feign.Request.create((Request.HttpMethod)CustomApiUtils.toMethod(actionConfig.getHttpMethod()), (String)url, headers, (Request.Body)body, (RequestTemplate)new RequestTemplate());
        Request.Options options = new Request.Options(((Long)ObjectUtils.defaultIfNull((Object)actionConfig.getConnectionTimeoutMs(), (Object)3000L)).longValue(), TimeUnit.MILLISECONDS, ((Long)ObjectUtils.defaultIfNull((Object)actionConfig.getReadTimeoutMs(), (Object)30000L)).longValue(), TimeUnit.MILLISECONDS, true);
        return Pair.of((Object)request, (Object)options);
    }

    private void callExternalFlowApi(ExecutionEntity processInstance, FlowInstanceEventType eventType, Date eventTime, ExternalHttpActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        FlowInstanceEvent event = this.buildFlowInstanceEvent(processInstance, eventType, eventTime, Boolean.TRUE.equals(actionConfig.getSendVariablesJson()));
        Map variables = processInstance.getVariables();
        this.callExternalApi(actionConfig, JSON.toJSONString((Object)event), variables, sync);
    }

    private void callExternalFlowApi(HistoricProcessInstance processInstance, FlowInstanceEventType eventType, Date eventTime, ExternalHttpActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        FlowInstanceEvent event = this.buildFlowInstanceEvent(processInstance, eventType, eventTime, Boolean.TRUE.equals(actionConfig.getSendVariablesJson()));
        Map variables = processInstance.getProcessVariables();
        this.callExternalApi(actionConfig, JSON.toJSONString((Object)event), variables, sync);
    }

    private void callExternalNodeApi(ProcessInstance processInstance, String nodeKey, String nodeName, FlowNodeEventType eventType, Date eventTime, ExternalHttpActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        FlowNodeEvent event = this.buildFlowNodeEvent(processInstance, nodeKey, nodeName, eventType, eventTime, Boolean.TRUE.equals(actionConfig.getSendVariablesJson()));
        Map variables = processInstance.getProcessVariables();
        this.callExternalApi(actionConfig, JSON.toJSONString((Object)event), variables, sync);
    }

    private void callExternalTaskApi(TaskEntity entity, FlowTaskEventType eventType, Date eventTime, ExternalHttpActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        FlowTaskEvent event = this.buildFlowTaskEvent(entity, eventType, eventTime, Boolean.TRUE.equals(actionConfig.getSendVariablesJson()));
        Map variables = entity.getVariables();
        this.callExternalApi(actionConfig, JSON.toJSONString((Object)event), variables, sync);
    }

    private void callExternalTaskApi(FlowTask flowTask, FlowInfoVariables flowInfoVariables, String processInstanceId, FlowTaskEventType eventType, Date eventTime, ExternalHttpActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        RuntimeService runtimeService = CommandContextUtil.getProcessEngineConfiguration().getRuntimeService();
        Map variables = runtimeService.getVariables(processInstanceId);
        FlowTaskEvent event = this.buildFlowTaskEvent(flowTask, flowInfoVariables, eventType, eventTime, variables);
        this.callExternalApi(actionConfig, JSON.toJSONString((Object)event), variables, sync);
    }

    private Map<String, String> calCustomParams(List<CustomApiParamValueDto> valueDtoList, Map<String, Object> variables) {
        HashMap<String, String> customParams = new HashMap<String, String>(16);
        if (valueDtoList != null) {
            for (CustomApiParamValueDto valueDto : valueDtoList) {
                String value;
                String valueSource = valueDto.getValueSource();
                if (StringUtils.isNotBlank((CharSequence)valueSource) && variables.containsKey(valueSource) && StringUtils.isNotBlank((CharSequence)(value = variables.get(valueSource).toString()))) {
                    customParams.put(valueDto.getName(), value);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)valueDto.getDefaultValue())) continue;
                customParams.put(valueDto.getName(), valueDto.getDefaultValue());
            }
        }
        return customParams;
    }

    private void callExternalApi(ExternalHttpActionConfigDto actionConfig, String bodyJson, Map<String, Object> variables, boolean sync) {
        Pair<OkHttpClient, Request> request = this.buildExternalApiRequest(actionConfig, bodyJson, variables);
        this.callWebApi(request, sync, actionConfig.errorMsgPathIfEnabled());
    }

    private Pair<OkHttpClient, Request> buildExternalApiRequest(ExternalHttpActionConfigDto actionConfig, String bodyJson, Map<String, Object> variables) {
        Map<String, String> customHeaders = this.calCustomParams(actionConfig.getCustomHeader(), variables);
        Map<String, String> customParams = this.calCustomParams(actionConfig.getCustomUrlParam(), variables);
        HttpUrl url = HttpUrl.parse((String)actionConfig.getApiPath());
        if (url == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.API_PATH_FORMAT_ERROR, new Object[]{actionConfig.getApiPath()});
        }
        Request.Builder builder = new Request.Builder().method(actionConfig.getHttpMethod().name(), RequestBody.create((String)bodyJson, (MediaType)CustomApiUtils.JSON_MEDIA_TYPE));
        for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        if (!customParams.isEmpty()) {
            HttpUrl.Builder urlBuilder = url.newBuilder();
            for (Map.Entry<String, String> entry : customParams.entrySet()) {
                urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
            }
            url = urlBuilder.build();
        }
        Request request = builder.url(url).build();
        OkHttpClient okHttpClient = CustomApiUtils.getOkHttpClient((Long)ObjectUtils.defaultIfNull((Object)actionConfig.getConnectionTimeoutMs(), (Object)3000L), (Long)ObjectUtils.defaultIfNull((Object)actionConfig.getReadTimeoutMs(), (Object)30000L));
        return Pair.of((Object)okHttpClient, (Object)request);
    }

    private void callCustomFlowApi(ExecutionEntity processInstance, CustomHttpActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        if (StringUtils.isNotBlank((CharSequence)actionConfig.getServiceId())) {
            this.callCustomInternalApi(processInstance.getVariables(), actionConfig, sync);
        } else {
            this.callCustomExternalApi(processInstance.getVariables(), actionConfig, sync);
        }
    }

    private void callCustomFlowApi(HistoricProcessInstance processInstance, CustomHttpActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        if (StringUtils.isNotBlank((CharSequence)actionConfig.getServiceId())) {
            this.callCustomInternalApi(processInstance.getProcessVariables(), actionConfig, sync);
        } else {
            this.callCustomExternalApi(processInstance.getProcessVariables(), actionConfig, sync);
        }
    }

    private void callCustomNodeApi(ProcessInstance processInstance, CustomHttpActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        if (StringUtils.isNotBlank((CharSequence)actionConfig.getServiceId())) {
            this.callCustomInternalApi(processInstance.getProcessVariables(), actionConfig, sync);
        } else {
            this.callCustomExternalApi(processInstance.getProcessVariables(), actionConfig, sync);
        }
    }

    private void callCustomTaskApi(TaskEntity task, CustomHttpActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        if (StringUtils.isNotBlank((CharSequence)actionConfig.getServiceId())) {
            this.callCustomInternalApi(task.getProcessVariables(), actionConfig, sync);
        } else {
            this.callCustomExternalApi(task.getProcessVariables(), actionConfig, sync);
        }
    }

    private void callCustomTaskApi(String processInstanceId, CustomHttpActionConfigDto actionConfig, boolean sync) {
        if (actionConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ACTION_CONFIG_NULL);
        }
        RuntimeService runtimeService = CommandContextUtil.getProcessEngineConfiguration().getRuntimeService();
        Map variables = runtimeService.getVariables(processInstanceId);
        if (StringUtils.isNotBlank((CharSequence)actionConfig.getServiceId())) {
            this.callCustomInternalApi(variables, actionConfig, sync);
        } else {
            this.callCustomExternalApi(variables, actionConfig, sync);
        }
    }

    private void callCustomInternalApi(Map<String, Object> variables, CustomHttpActionConfigDto actionConfig, boolean sync) {
        Pair<feign.Request, Request.Options> request = this.buildCustomInternalApiRequest(actionConfig, variables);
        this.callFeignApi(sync, request, actionConfig.errorMsgPathIfEnabled());
    }

    private Pair<feign.Request, Request.Options> buildCustomInternalApiRequest(CustomHttpActionConfigDto actionConfig, Map<String, Object> variables) {
        feign.Request request = CustomApiUtils.createInternalApiRequest(actionConfig, variables, this.contextProperties);
        Request.Options options = new Request.Options(3000L, TimeUnit.MILLISECONDS, 30000L, TimeUnit.MILLISECONDS, true);
        return Pair.of((Object)request, (Object)options);
    }

    private void callFeignApi(boolean sync, Pair<feign.Request, Request.Options> request, String errorMsgPath) {
        if (!sync) {
            this.addAsyncTask(new AsyncEventInternalApiTask(this.feignClient, (feign.Request)request.getLeft(), (Request.Options)request.getRight()));
        } else {
            CustomApiUtils.callFeignApi(this.feignClient, (feign.Request)request.getLeft(), (Request.Options)request.getRight(), true, errorMsgPath);
        }
    }

    private void callCustomExternalApi(Map<String, Object> variables, CustomHttpActionConfigDto actionConfig, boolean sync) {
        Pair<OkHttpClient, Request> request = this.buildCustomExternalApiRequest(actionConfig, variables);
        this.callWebApi(request, sync, actionConfig.errorMsgPathIfEnabled());
    }

    private Pair<OkHttpClient, Request> buildCustomExternalApiRequest(CustomHttpActionConfigDto actionConfig, Map<String, Object> variables) {
        Request request = CustomApiUtils.createExternalApiRequest(actionConfig, variables);
        OkHttpClient okHttpClient = CustomApiUtils.getOkHttpClient(3000L, 30000L);
        return Pair.of((Object)okHttpClient, (Object)request);
    }

    private void callWebApi(Pair<OkHttpClient, Request> request, boolean sync, String errorMsgPath) {
        if (!sync) {
            this.addAsyncTask(new AsyncEventExternalApiTask((OkHttpClient)request.getLeft(), (Request)request.getRight()));
        } else {
            CustomApiUtils.callWebApi((OkHttpClient)request.getLeft(), (Request)request.getRight(), true, errorMsgPath);
        }
    }

    public boolean isFailOnException() {
        return true;
    }

    public boolean isFireOnTransactionLifecycleEvent() {
        return false;
    }

    public String getOnTransaction() {
        return null;
    }

    private String buildVariableJson(Map<String, Object> variables) {
        Map filterMap = variables.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("_") || FlowableConstant.ALLOW_SEND_INNER_VARIABLES.contains(entry.getKey())).collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), v.getValue()), HashMap::putAll);
        return JSON.toJSONString((Object)filterMap);
    }
}

