/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.listener;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.dal.model.Entity;
import com.cyberway.mp.bc.dal.util.IdWorker;
import com.cyberway.mp.flow.api.constants.BizFlowConstant;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.instance.enums.FlowInstanceStatus;
import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.log.enums.FlowActionType;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.CalendarDto;
import com.cyberway.mp.flow.api.project.dto.EventTemplateDto;
import com.cyberway.mp.flow.api.project.dto.GlobalConfigDto;
import com.cyberway.mp.flow.api.project.enums.DueAction;
import com.cyberway.mp.flow.api.project.enums.DueTimeStartType;
import com.cyberway.mp.flow.api.project.enums.DueTimeType;
import com.cyberway.mp.flow.api.task.enums.CountersignResult;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.api.task.enums.FlowTaskStatus;
import com.cyberway.mp.flow.api.task.enums.FlowTaskType;
import com.cyberway.mp.flow.domain.his.entity.FlowHisActivity;
import com.cyberway.mp.flow.domain.his.entity.FlowHisVariable;
import com.cyberway.mp.flow.domain.his.service.FlowHisService;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstanceAddNode;
import com.cyberway.mp.flow.domain.instance.service.FlowInstanceService;
import com.cyberway.mp.flow.domain.log.entity.FlowLog;
import com.cyberway.mp.flow.domain.log.service.FlowLogService;
import com.cyberway.mp.flow.domain.node.entity.FlowNode;
import com.cyberway.mp.flow.domain.node.service.FlowNodeService;
import com.cyberway.mp.flow.domain.project.entity.FlowProjectConfig;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.service.FlowTaskService;
import com.cyberway.mp.flow.flowable.flow.command.BaseJumpCmd;
import com.cyberway.mp.flow.flowable.flow.command.CancelDelegateTaskCmd;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.command.CustomDelegateTaskCmd;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.flowable.flow.event.FlowableAddSignEvent;
import com.cyberway.mp.flow.flowable.flow.event.FlowableWithdrawApprovalEvent;
import com.cyberway.mp.flow.flowable.flow.event.FlowableWithdrawProcessEvent;
import com.cyberway.mp.flow.flowable.util.FlowLogUtils;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import com.cyberway.mp.flow.flowable.util.ProcessUtils;
import com.cyberway.mp.flow.infra.service.TimeHelperService;
import com.cyberway.mp.flow.infra.service.UserHelperService;
import com.cyberway.mp.flow.infra.util.CodeUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEntityEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventListener;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.FlowableActivityEvent;
import org.flowable.engine.delegate.event.FlowableEntityWithVariablesEvent;
import org.flowable.engine.delegate.event.FlowableMultiInstanceActivityEvent;
import org.flowable.engine.delegate.event.FlowableProcessStartedEvent;
import org.flowable.engine.delegate.event.impl.FlowableProcessCancelledEventImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.CommentEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.ActivityInstance;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.api.delegate.VariableScope;
import org.jetbrains.annotations.NotNull;

public class FlowDataListener
implements FlowableEventListener {
    private static final Set<String> NEED_HANDLE_NODE_TYPES = new HashSet<String>(Arrays.asList("serviceTask", "scriptTask", "receiveTask"));
    private final FlowInstanceService flowInstanceService;
    private final FlowNodeService flowNodeService;
    private final FlowTaskService flowTaskService;
    private final FlowLogService flowLogService;
    private final FlowHisService flowHisService;
    private final UserHelperService userHelperService;
    private final TimeHelperService timeHelperService;
    private final FlowProjectConfigCacheRepository flowProjectConfigCacheRepository;
    private final IdWorker idWorker;

    public FlowDataListener(FlowInstanceService flowInstanceService, FlowNodeService flowNodeService, FlowTaskService flowTaskService, FlowLogService flowLogService, FlowHisService flowHisService, UserHelperService userHelperService, TimeHelperService timeHelperService, FlowProjectConfigCacheRepository flowProjectConfigCacheRepository, IdWorker idWorker) {
        this.flowInstanceService = flowInstanceService;
        this.flowNodeService = flowNodeService;
        this.flowTaskService = flowTaskService;
        this.flowLogService = flowLogService;
        this.flowHisService = flowHisService;
        this.userHelperService = userHelperService;
        this.timeHelperService = timeHelperService;
        this.flowProjectConfigCacheRepository = flowProjectConfigCacheRepository;
        this.idWorker = idWorker;
    }

    public void onEvent(FlowableEvent event) {
        if (event.getType() instanceof FlowableEngineEventType) {
            switch ((FlowableEngineEventType)event.getType()) {
                case PROCESS_STARTED: {
                    this.handleProcessStarted((FlowableProcessStartedEvent)event);
                    break;
                }
                case PROCESS_CANCELLED: {
                    this.handleProcessCancelled((FlowableProcessCancelledEventImpl)event);
                    break;
                }
                case PROCESS_COMPLETED: {
                    this.handleProcessComplete((FlowableEntityEvent)event);
                    break;
                }
                case TASK_ASSIGNED: {
                    this.handleTaskAssigned((FlowableEntityEvent)event);
                    break;
                }
                case TASK_COMPLETED: {
                    this.handleTaskComplete((FlowableEntityEvent)event);
                    break;
                }
                case ACTIVITY_STARTED: {
                    this.handleActivityStarted((FlowableActivityEvent)event);
                    break;
                }
                case MULTI_INSTANCE_ACTIVITY_STARTED: {
                    this.handleMiActivityStarted((FlowableMultiInstanceActivityEvent)event);
                    break;
                }
                case ACTIVITY_COMPLETED: {
                    this.handleActivityCompleted((FlowableActivityEvent)event);
                    break;
                }
                case MULTI_INSTANCE_ACTIVITY_COMPLETED: 
                case MULTI_INSTANCE_ACTIVITY_COMPLETED_WITH_CONDITION: {
                    this.handleMiActivityCompleted((FlowableMultiInstanceActivityEvent)event);
                    break;
                }
                case ENTITY_SUSPENDED: 
                case ENTITY_ACTIVATED: {
                    this.handleEntityUpdateStates((FlowableEntityEvent)event);
                    break;
                }
                case ENTITY_CREATED: {
                    FlowableEntityEvent flowableEntityEvent = (FlowableEntityEvent)event;
                    if (!(flowableEntityEvent.getEntity() instanceof CommentEntity)) break;
                    this.handleAddComment(flowableEntityEvent);
                    break;
                }
                case CUSTOM: {
                    this.handleCustomEvent(event);
                    break;
                }
            }
        }
    }

    private void handleCustomEvent(FlowableEvent event) {
        if (event instanceof CustomFlowableEntityEvent) {
            this.customFlowableEntityEvent((CustomFlowableEntityEvent)event);
        } else if (event instanceof FlowableAddSignEvent) {
            this.handleAddSign((FlowableAddSignEvent)event);
        } else if (event instanceof FlowableWithdrawProcessEvent) {
            this.handleWithdrawProcess((FlowableWithdrawProcessEvent)event);
        } else if (event instanceof FlowableWithdrawApprovalEvent) {
            this.handleFlowableWithdrawApproval((FlowableWithdrawApprovalEvent)event);
        }
    }

    private void handleFlowableWithdrawApproval(FlowableWithdrawApprovalEvent event) {
        String taskId = event.getTaskId();
        FlowTask flowTask = this.flowTaskService.getFlowTaskByTaskId(taskId);
        flowTask.setDeleteReason(FlowTaskDeleteReason.TASK_APPROVAL_WITHDRAW);
        flowTask.setStatus(FlowTaskStatus.DELETED);
        this.flowTaskService.modifyFlowTask(flowTask);
        FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask);
        flowLog.setActionTime(new Date());
        flowLog.setActionType(FlowActionType.APPROVAL_WITHDRAW);
        this.flowLogService.createFlowLog(flowLog);
    }

    public void customFlowableEntityEvent(CustomFlowableEntityEvent event) {
        switch (event.getCustomEventType()) {
            case ROLLBACK_TO_SPECIAL: {
                this.handleRollback(event);
                break;
            }
            case ROLLBACK_TO_PREV: {
                this.handleRollbackPerv(event);
                break;
            }
            case ROLLBACK_TO_START: {
                this.handleRollbackStart(event);
                break;
            }
            case NODE_ROLLBACK_SPECIAL: {
                this.handleTaskRollback(event);
                break;
            }
            case NODE_ROLLBACK_PERV: {
                this.handleTaskRollbackPerv((FlowableEntityEvent)event);
                break;
            }
            case NODE_ROLLBACK_START: {
                this.handleTaskRollbackStart(event);
                break;
            }
            case DELETE_ADD_SIGN: {
                this.handleDeleteByAddTaskSequential(event);
                break;
            }
            case PROCESS_WITHDRAW: {
                this.handleWithdrawProcessDelete(event);
                break;
            }
            case TASK_APPROVAL_WITHDRAW: {
                this.handleFlowableWithdrawApprovalDelete(event);
                break;
            }
            case SIGN_APPROVE: {
                this.handleFlowableSignApprove(event);
                break;
            }
            case SIGN_REJECT: {
                this.handleFlowableSignReject(event);
                break;
            }
            case SIGN_WAIVER: {
                this.handleFlowableSignWaiver(event);
                break;
            }
            case REJECT: {
                this.handleReject(event);
                break;
            }
            case NODE_REJECT: {
                this.handleNodeReject(event);
                break;
            }
            case NODE_SIGN_FIN: {
                this.handleNodeSignFin(event);
                break;
            }
            case SIGN_FIN_APPROVE: {
                this.handleSignFinApproval(event);
                break;
            }
            case SIGN_FIN_REJECT: {
                this.handleSignFinReject(event);
                break;
            }
            case FLOW_JUMP: {
                this.handleFlowJump(event);
                break;
            }
            case JUMP: {
                this.handleTaskJump(event);
                break;
            }
            case NODE_JUMP: {
                this.handleTaskNodeJump(event);
                break;
            }
            case EMPTY_MI_NODE_FIN: {
                this.handleEmptyMiNodeFin(event);
                break;
            }
            case ADD_PREV_NODE: {
                this.handleAddPrevNode(event);
                break;
            }
            case NODE_ADD_PREV_NODE: {
                this.handleNodeAddPrevNode(event);
                break;
            }
            case ADD_NEXT_NODE: {
                this.handleAddNextNode(event);
                break;
            }
            case STARTER_FILL: {
                this.handleStarterFill(event);
                break;
            }
            case STARTER_FILL_START: {
                this.handleStarterFillStart(event);
                break;
            }
            case STARTER_FILL_COMPLETE: {
                this.handleStarterFillComplete(event);
                break;
            }
            case CC_TASK: {
                this.handleCcTask(event);
                break;
            }
            case CC_INSTANCE: {
                this.handleCcInstance(event);
                break;
            }
            case TRANSFER_TASK: {
                this.handleTransferTask(event);
                break;
            }
        }
    }

    private void updateFlowTaskFin(TaskEntity task, FlowTaskStatus status, FlowTaskDeleteReason deleteReason, Date now) {
        Long flowTaskId = (Long)task.getVariable("_FLOW_TASK_ID", Long.class);
        String opinion = (String)task.getVariableLocal("_TASK_OPINION", String.class);
        this.flowTaskService.updateFinStatus(flowTaskId.longValue(), status, deleteReason, opinion, now);
    }

    private void markFlowTaskDelete(FlowTask flowTask, FlowTaskDeleteReason deleteReason, Date now) {
        this.flowTaskService.updateFinStatus(((Long)flowTask.getId()).longValue(), FlowTaskStatus.DELETED, deleteReason, "", now);
    }

    private FlowTask updateFlowTaskFinAndGetTask(TaskEntity task, FlowTaskStatus status, FlowTaskDeleteReason deleteReason, Date now) {
        Long flowTaskId = (Long)task.getVariable("_FLOW_TASK_ID", Long.class);
        String opinion = (String)task.getVariableLocal("_TASK_OPINION", String.class);
        Integer autoCompleteFlag = (Integer)task.getVariableLocal("_TASK_AUTO_COMPLETE_FLAG", Integer.class);
        return this.updateFlowTaskFinAndGetTask(flowTaskId, opinion, status, deleteReason, now, (Integer)ObjectUtils.defaultIfNull((Object)autoCompleteFlag, (Object)FlowConstant.AUTO_COMPLETE_FLAG_NO));
    }

    private FlowTask updateFlowTaskFinAndGetTask(Long flowTaskId, String opinion, FlowTaskStatus status, FlowTaskDeleteReason deleteReason, Date now, int autoCompleteFlag) {
        FlowTask flowTask = this.flowTaskService.getFlowTask(flowTaskId.longValue());
        flowTask.setStatus(status);
        flowTask.setDeleteReason(deleteReason);
        flowTask.setEndTime(now);
        flowTask.setAutoCompleteFlag(Integer.valueOf(autoCompleteFlag));
        flowTask.setOpinion(opinion);
        flowTask.setActionUserId(ServiceContext.getContext().getRequestUserId());
        flowTask.setActionUserName(ServiceContext.getContext().getRequestUserName());
        this.flowTaskService.modifyFlowTask(flowTask);
        return flowTask;
    }

    private void handleReject(CustomFlowableEntityEvent event) {
        Date now = new Date();
        TaskEntity entity = (TaskEntity)event.getEntity();
        FlowTask flowTask = this.updateFlowTaskFinAndGetTask(entity, FlowTaskStatus.REJECTED, FlowTaskDeleteReason.REJECT, now);
        this.updateNodeFin(entity, FlowTaskStatus.REJECTED, now);
        this.updateJumpOtherNodeDeleted(entity, now);
        this.updateNodeRejected(entity);
        boolean resubmitContext = Boolean.TRUE.equals(CommandContextUtil.getCommandContext().getAttribute("_RESUBMIT_CONTEXT"));
        if (resubmitContext) {
            FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)entity);
            this.flowInstanceService.changeFlowInstanceBizDataFlowStatus(flowInfoVariables.getFlowProjectId().longValue(), BizFlowConstant.FLOW_STATUS_REJECTED);
        }
        this.logTaskReject(flowTask);
    }

    private void logTaskReject(FlowTask flowTask) {
        FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask);
        flowLog.setActionTime(new Date());
        flowLog.setActionType(FlowActionType.REJECT_TASK);
        this.flowLogService.createFlowLog(flowLog);
    }

    private void handleNodeReject(CustomFlowableEntityEvent event) {
        Object entity = event.getEntity();
        if (entity instanceof TaskEntity) {
            this.updateFlowTaskFin((TaskEntity)entity, FlowTaskStatus.DELETED, FlowTaskDeleteReason.NODE_REJECT, new Date());
        } else if (entity instanceof FlowTask) {
            this.markFlowTaskDelete((FlowTask)entity, FlowTaskDeleteReason.NODE_REJECT, new Date());
        }
    }

    private void handleNodeSignFin(CustomFlowableEntityEvent event) {
        Object entity = event.getEntity();
        if (entity instanceof TaskEntity) {
            this.updateFlowTaskFin((TaskEntity)entity, FlowTaskStatus.DELETED, FlowTaskDeleteReason.NODE_SIGN_FIN, new Date());
        } else if (entity instanceof FlowTask) {
            this.markFlowTaskDelete((FlowTask)entity, FlowTaskDeleteReason.NODE_SIGN_FIN, new Date());
        }
    }

    private void handleSignFinApproval(CustomFlowableEntityEvent event) {
        DelegateExecution entity = (DelegateExecution)event.getEntity();
        List tasks = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)CommandContextUtil.getProcessEngineConfiguration().getHistoryService().createHistoricTaskInstanceQuery().executionId(entity.getId())).includeTaskLocalVariables()).list();
        for (HistoricTaskInstance task : tasks) {
            long id = Long.parseLong(task.getTaskLocalVariables().get("_FLOW_TASK_ID").toString());
            this.flowTaskService.updateCountersignResult(id, CountersignResult.APPROVE);
            this.updateNodeFin(task, FlowTaskStatus.COMPLETED, new Date());
        }
    }

    private void handleSignFinReject(CustomFlowableEntityEvent event) {
        DelegateExecution entity = (DelegateExecution)event.getEntity();
        List tasks = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)CommandContextUtil.getProcessEngineConfiguration().getHistoryService().createHistoricTaskInstanceQuery().executionId(entity.getId())).includeTaskLocalVariables()).list();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)entity);
        long flowInstanceId = flowInfoVariables.getFlowInstanceId();
        boolean resubmitContext = Boolean.TRUE.equals(CommandContextUtil.getCommandContext().getAttribute("_RESUBMIT_CONTEXT"));
        if (resubmitContext) {
            this.flowInstanceService.changeFlowInstanceBizDataFlowStatus(flowInstanceId, BizFlowConstant.FLOW_STATUS_REJECTED);
        }
        Date now = new Date();
        for (HistoricTaskInstance task : tasks) {
            long id = Long.parseLong(task.getTaskLocalVariables().get("_FLOW_TASK_ID").toString());
            this.flowTaskService.updateCountersignResult(id, CountersignResult.REJECT);
            this.updateNodeFin(task, FlowTaskStatus.REJECTED, now);
            this.updateNodeRejected(flowInstanceId, task.getProcessDefinitionId());
        }
        this.updateJumpOtherNodeDeleted(flowInfoVariables, now);
    }

    private void handleFlowableSignApprove(CustomFlowableEntityEvent event) {
        Date now = new Date();
        TaskEntity entity = (TaskEntity)event.getEntity();
        FlowTask flowTask = this.updateFlowTaskFinAndGetTask(entity, FlowTaskStatus.COMPLETED, FlowTaskDeleteReason.SIGN_APPROVE, now);
        this.logTaskComplete(flowTask, now);
    }

    private void handleFlowableSignReject(CustomFlowableEntityEvent event) {
        Date now = new Date();
        TaskEntity entity = (TaskEntity)event.getEntity();
        FlowTask flowTask = this.updateFlowTaskFinAndGetTask(entity, FlowTaskStatus.REJECTED, FlowTaskDeleteReason.SIGN_REJECT, now);
        this.logTaskReject(flowTask);
    }

    private void handleFlowableSignWaiver(CustomFlowableEntityEvent event) {
        Date now = new Date();
        TaskEntity entity = (TaskEntity)event.getEntity();
        this.updateFlowTaskFin(entity, FlowTaskStatus.WAIVER, FlowTaskDeleteReason.SIGN_WAIVER, now);
    }

    private void handleWithdrawProcess(FlowableWithdrawProcessEvent event) {
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstanceByProcessInstanceId(event.getProcessInstanceId());
        boolean resubmitContext = Boolean.TRUE.equals(CommandContextUtil.getCommandContext().getAttribute("_RESUBMIT_CONTEXT"));
        if (resubmitContext) {
            this.flowInstanceService.changeFlowInstanceBizDataFlowStatus(((Long)flowInstance.getId()).longValue(), BizFlowConstant.FLOW_STATUS_WITHDRAW);
        }
        FlowLog flowLog = FlowLogUtils.initFlowLog(null);
        flowLog.setFlowInstanceId((Long)flowInstance.getId());
        flowLog.setActionTime(new Date());
        flowLog.setActionType(FlowActionType.PROCESS_WITHDRAW);
        this.flowLogService.createFlowLog(flowLog);
    }

    private void handleWithdrawProcessDelete(CustomFlowableEntityEvent event) {
        Date now = new Date();
        Object entity = event.getEntity();
        if (entity instanceof TaskEntity) {
            TaskEntity taskEntity = (TaskEntity)entity;
            this.updateFlowTaskFin(taskEntity, FlowTaskStatus.DELETED, FlowTaskDeleteReason.PROCESS_WITHDRAW, now);
            this.updateNodeFin(taskEntity, FlowTaskStatus.DELETED, now);
        } else if (entity instanceof FlowTask) {
            this.markFlowTaskDelete((FlowTask)entity, FlowTaskDeleteReason.PROCESS_WITHDRAW, now);
        }
    }

    private void handleFlowableWithdrawApprovalDelete(CustomFlowableEntityEvent event) {
        Date now = new Date();
        TaskEntity entity = (TaskEntity)event.getEntity();
        this.updateFlowTaskFin(entity, FlowTaskStatus.DELETED, FlowTaskDeleteReason.TASK_APPROVAL_WITHDRAW, now);
    }

    private void handleDeleteByAddTaskSequential(CustomFlowableEntityEvent event) {
        Date now = new Date();
        TaskEntity entity = (TaskEntity)event.getEntity();
        FlowTask flowTask = this.updateFlowTaskFinAndGetTask(entity, FlowTaskStatus.DELETED, FlowTaskDeleteReason.DELETE_BY_ADD_SIGN, now);
        FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask, false);
        flowLog.setActionTime(now);
        flowLog.setActionType(FlowActionType.DELETE_BY_ADD_SIGN);
        this.flowLogService.createFlowLog(flowLog);
    }

    private void updateNodeFin(TaskEntity task, FlowTaskStatus status, Date endTime) {
        Long nodeId = (Long)task.getVariable("_FLOW_NODE_ID_" + task.getTaskDefinitionKey(), Long.class);
        if (nodeId != null) {
            this.flowNodeService.updateNodeFin(nodeId.longValue(), status, endTime);
        }
    }

    private void updateNodeFin(HistoricTaskInstance task, FlowTaskStatus status, Date endTime) {
        Long nodeId = (Long)CommandContextUtil.getProcessEngineConfiguration().getRuntimeService().getVariable(task.getProcessInstanceId(), "_FLOW_NODE_ID_" + task.getTaskDefinitionKey(), Long.class);
        if (nodeId != null) {
            this.flowNodeService.updateNodeFin(nodeId.longValue(), status, endTime);
        }
    }

    private void updateNodeRejected(TaskEntity task) {
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)task);
        this.updateNodeRejected(flowInfoVariables.getFlowInstanceId(), task.getProcessDefinitionId());
    }

    private void updateNodeRejected(Long flowInstanceId, String processDefinitionId) {
        BaseJumpCmd.JumpNodeInfo rejectInfo = (BaseJumpCmd.JumpNodeInfo)CommandContextUtil.getCommandContext().getAttribute("_REJECT_INFO");
        if (rejectInfo != null) {
            HashSet<String> nodes = new HashSet<String>();
            nodes.add(rejectInfo.getSourceNodeKey());
            nodes.add(rejectInfo.getTargetNodeKey());
            if (ProcessUtils.JUMP_MODE_SAME_PARALLEL.equals(rejectInfo.getJumpMode())) {
                for (Set<String> line : ProcessUtils.getParallelLine(processDefinitionId)) {
                    if (!line.containsAll(nodes)) continue;
                    this.flowNodeService.markNodeRejected(flowInstanceId.longValue(), rejectInfo.getTargetNodeKey(), line);
                    break;
                }
            } else {
                this.flowNodeService.markNodeRejected(flowInstanceId.longValue(), rejectInfo.getTargetNodeKey(), null);
            }
        } else {
            this.flowNodeService.markNodeRejected(flowInstanceId.longValue(), null, null);
        }
    }

    private void handleRollback(CustomFlowableEntityEvent event) {
        Date now = new Date();
        TaskEntity entity = (TaskEntity)event.getEntity();
        FlowTask flowTask = this.updateFlowTaskFinAndGetTask(entity, FlowTaskStatus.ROLLBACK, FlowTaskDeleteReason.ROLLBACK_TO_SPECIAL, now);
        FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask);
        flowLog.setActionTime(now);
        flowLog.setActionType(FlowActionType.ROLLBACK);
        this.flowLogService.createFlowLog(flowLog);
        this.updateNodeFin(entity, flowTask.getStatus(), flowTask.getEndTime());
        this.updateJumpOtherNodeDeleted(entity, now);
        this.updateNodeRejected(entity);
    }

    private void handleRollbackPerv(CustomFlowableEntityEvent event) {
        Date now = new Date();
        TaskEntity entity = (TaskEntity)event.getEntity();
        FlowTask flowTask = this.updateFlowTaskFinAndGetTask(entity, FlowTaskStatus.ROLLBACK_PREV, FlowTaskDeleteReason.ROLLBACK_TO_PREV, now);
        FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask);
        flowLog.setActionTime(new Date());
        flowLog.setActionType(FlowActionType.ROLLBACK_PREV);
        this.flowLogService.createFlowLog(flowLog);
        this.updateNodeFin(entity, flowTask.getStatus(), flowTask.getEndTime());
        this.updateJumpOtherNodeDeleted(entity, now);
        this.updateNodeRejected(entity);
    }

    private void handleRollbackStart(CustomFlowableEntityEvent event) {
        Date now = new Date();
        TaskEntity entity = (TaskEntity)event.getEntity();
        FlowTask flowTask = this.updateFlowTaskFinAndGetTask(entity, FlowTaskStatus.ROLLBACK_START, FlowTaskDeleteReason.ROLLBACK_TO_START, now);
        FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask);
        flowLog.setActionTime(new Date());
        flowLog.setActionType(FlowActionType.ROLLBACK_START);
        this.flowLogService.createFlowLog(flowLog);
        this.updateNodeFin(entity, flowTask.getStatus(), flowTask.getEndTime());
        this.updateJumpOtherNodeDeleted(entity, now);
        this.updateNodeRejected(entity);
        boolean resubmitContext = Boolean.TRUE.equals(CommandContextUtil.getCommandContext().getAttribute("_RESUBMIT_CONTEXT"));
        if (resubmitContext) {
            this.flowInstanceService.changeFlowInstanceBizDataFlowStatus(flowTask.getFlowInstanceId().longValue(), BizFlowConstant.FLOW_STATUS_REJECTED);
        }
    }

    private void updateJumpOtherNodeDeleted(TaskEntity entity, Date endTime) {
        BaseJumpCmd.JumpNodeInfo rejectInfo = (BaseJumpCmd.JumpNodeInfo)CommandContextUtil.getCommandContext().getAttribute("_REJECT_INFO");
        if (rejectInfo != null && ProcessUtils.JUMP_MODE_SAME_PARALLEL.equals(rejectInfo.getJumpMode())) {
            return;
        }
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)entity);
        this.flowNodeService.updateNodeFinAllRunning(flowInfoVariables.getFlowInstanceId().longValue(), FlowTaskStatus.DELETED, endTime);
    }

    private void updateJumpOtherNodeDeleted(FlowInfoVariables flowInfoVariables, Date endTime) {
        BaseJumpCmd.JumpNodeInfo rejectInfo = (BaseJumpCmd.JumpNodeInfo)CommandContextUtil.getCommandContext().getAttribute("_REJECT_INFO");
        if (rejectInfo != null && ProcessUtils.JUMP_MODE_SAME_PARALLEL.equals(rejectInfo.getJumpMode())) {
            return;
        }
        this.flowNodeService.updateNodeFinAllRunning(flowInfoVariables.getFlowInstanceId().longValue(), FlowTaskStatus.DELETED, endTime);
    }

    private void handleTaskRollback(CustomFlowableEntityEvent event) {
        Date now = new Date();
        Object entity = event.getEntity();
        if (entity instanceof TaskEntity) {
            this.updateFlowTaskFin((TaskEntity)entity, FlowTaskStatus.DELETED, FlowTaskDeleteReason.NODE_ROLLBACK_SPECIAL, now);
        } else if (entity instanceof FlowTask) {
            this.markFlowTaskDelete((FlowTask)entity, FlowTaskDeleteReason.NODE_ROLLBACK_SPECIAL, now);
        }
    }

    private void handleTaskRollbackPerv(FlowableEntityEvent event) {
        Date now = new Date();
        Object entity = event.getEntity();
        if (entity instanceof TaskEntity) {
            this.updateFlowTaskFin((TaskEntity)entity, FlowTaskStatus.DELETED, FlowTaskDeleteReason.NODE_ROLLBACK_PERV, now);
        } else if (entity instanceof FlowTask) {
            this.markFlowTaskDelete((FlowTask)entity, FlowTaskDeleteReason.NODE_ROLLBACK_PERV, now);
        }
    }

    private void handleTaskRollbackStart(CustomFlowableEntityEvent event) {
        Date now = new Date();
        Object entity = event.getEntity();
        if (entity instanceof TaskEntity) {
            this.updateFlowTaskFin((TaskEntity)entity, FlowTaskStatus.DELETED, FlowTaskDeleteReason.NODE_ROLLBACK_START, now);
        } else if (entity instanceof FlowTask) {
            this.markFlowTaskDelete((FlowTask)entity, FlowTaskDeleteReason.NODE_ROLLBACK_START, now);
        }
    }

    private void handleFlowJump(CustomFlowableEntityEvent event) {
        Object entity = event.getEntity();
        Date now = new Date();
        if (entity instanceof TaskEntity) {
            TaskEntity task = (TaskEntity)event.getEntity();
            this.updateFlowTaskFin(task, FlowTaskStatus.DELETED, FlowTaskDeleteReason.FLOW_JUMP, now);
            this.updateNodeFin(task, FlowTaskStatus.JUMPED, now);
            this.updateJumpOtherNodeDeleted(task, now);
        } else if (entity instanceof ExecutionEntity) {
            FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((ProcessInstance)entity);
            this.updateJumpOtherNodeDeleted(flowInfoVariables, now);
        }
    }

    private void handleTaskJump(CustomFlowableEntityEvent event) {
        Date now = new Date();
        TaskEntity entity = (TaskEntity)event.getEntity();
        FlowTask flowTask = this.updateFlowTaskFinAndGetTask(entity, FlowTaskStatus.JUMPED, FlowTaskDeleteReason.JUMP, now);
        FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask);
        flowLog.setActionTime(now);
        flowLog.setActionType(FlowActionType.JUMP);
        this.flowLogService.createFlowLog(flowLog);
        this.updateNodeFin(entity, flowTask.getStatus(), flowTask.getEndTime());
        this.updateJumpOtherNodeDeleted(entity, now);
    }

    private void handleTaskNodeJump(CustomFlowableEntityEvent event) {
        Date now = new Date();
        Object entity = event.getEntity();
        if (entity instanceof TaskEntity) {
            this.updateFlowTaskFin((TaskEntity)entity, FlowTaskStatus.DELETED, FlowTaskDeleteReason.JUMP, now);
        } else if (entity instanceof FlowTask) {
            this.markFlowTaskDelete((FlowTask)entity, FlowTaskDeleteReason.JUMP, now);
        }
    }

    private void handleEntityUpdateStates(FlowableEntityEvent event) {
        if (event.getEntity() instanceof ExecutionEntity) {
            this.handleExecutionEntityUpdate(event);
        }
        if (event.getEntity() instanceof TaskEntity) {
            this.handleTaskEntityUpdate(event);
        }
    }

    private void handleTaskEntityUpdate(FlowableEntityEvent event) {
        TaskEntity entity = (TaskEntity)event.getEntity();
        FlowTaskStatus status = null;
        if (FlowableEngineEventType.ENTITY_SUSPENDED.equals((Object)event.getType())) {
            status = FlowTaskStatus.SUSPENDED;
        } else if (FlowableEngineEventType.ENTITY_ACTIVATED.equals((Object)event.getType())) {
            status = FlowTaskStatus.RUNNING;
        }
        if (status != null) {
            Long flowTaskId = (Long)entity.getVariableLocal("_FLOW_TASK_ID", Long.class);
            FlowTask flowTask = this.flowTaskService.getFlowTask(flowTaskId.longValue());
            flowTask.setStatus(status);
            this.flowTaskService.modifyFlowTask(flowTask);
            Object mainTaskId = CommandContextUtil.getCommandContext().getAttribute("_MAIN_FLOW_TASK_ID");
            FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask);
            flowLog.setActionTime(new Date());
            if (flowTaskId.equals(mainTaskId)) {
                flowLog.setActionType(FlowTaskStatus.SUSPENDED.equals((Object)status) ? FlowActionType.SUSPEND_PROCESS : FlowActionType.ACTIVATE_PROCESS);
            } else {
                flowLog.setActionType(FlowTaskStatus.SUSPENDED.equals((Object)status) ? FlowActionType.SUSPEND_TASK : FlowActionType.ACTIVATE_TASK);
            }
            flowLog.setFlowInstanceId(flowTask.getFlowInstanceId());
            this.flowLogService.createFlowLog(flowLog);
        }
    }

    private void handleExecutionEntityUpdate(FlowableEntityEvent event) {
        ExecutionEntity executionEntity = (ExecutionEntity)event.getEntity();
        FlowInstanceStatus status = null;
        if (FlowableEngineEventType.ENTITY_SUSPENDED.equals((Object)event.getType())) {
            status = FlowInstanceStatus.SUSPENDED;
        } else if (FlowableEngineEventType.ENTITY_ACTIVATED.equals((Object)event.getType())) {
            status = FlowInstanceStatus.RUNNING;
        }
        if (executionEntity.isProcessInstanceType() && status != null) {
            FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)executionEntity);
            Long flowInstanceId = flowInfoVariables.getFlowInstanceId();
            this.flowInstanceService.changeFlowInstanceStatus(flowInstanceId.longValue(), status);
            Object mainTaskId = CommandContextUtil.getCommandContext().getAttribute("_MAIN_FLOW_TASK_ID");
            if (mainTaskId instanceof Long) {
                return;
            }
            FlowLog flowLog = FlowLogUtils.initFlowLog(null);
            flowLog.setActionTime(new Date());
            flowLog.setActionType(FlowInstanceStatus.SUSPENDED.equals((Object)status) ? FlowActionType.SUSPEND_PROCESS : FlowActionType.ACTIVATE_PROCESS);
            flowLog.setFlowInstanceId(flowInstanceId);
            this.flowLogService.createFlowLog(flowLog);
        }
    }

    private void handleProcessStarted(FlowableProcessStartedEvent event) {
        FlowInstance flowInstance = new FlowInstance();
        ExecutionEntity entity = (ExecutionEntity)event.getEntity();
        ExecutionEntity processInstance = entity.getProcessInstance();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((FlowableEntityWithVariablesEvent)event);
        Long flowProjectId = flowInfoVariables.getFlowProjectId();
        GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowProjectId.longValue());
        flowInstance.setId((Serializable)flowInfoVariables.getFlowInstanceId());
        flowInstance.setProcessInstanceId(entity.getProcessInstanceId());
        flowInstance.setInstanceName(processInstance.getName());
        flowInstance.setFlowProjectId(flowProjectId);
        flowInstance.setFlowProjectCode(flowInfoVariables.getFlowProjectCode());
        flowInstance.setBusinessKey(Long.valueOf(processInstance.getBusinessKey()));
        flowInstance.setStatus(FlowInstanceStatus.RUNNING);
        flowInstance.setBizDataFlowStatus(BizFlowConstant.FLOW_STATUS_RUNNING);
        flowInstance.setStartTime(flowInfoVariables.getFlowInstanceStartTime());
        flowInstance.setEndTime(FlowConstant.EMPTY_MIN_TIME);
        flowInstance.setStartUserId(ServiceContext.getContext().getRequestUserId());
        flowInstance.setStartUserName(ServiceContext.getContext().getRequestUserName());
        flowInstance.setInstanceCode(flowInfoVariables.getInstanceCode());
        flowInstance.setDueTime(this.calDueTime(globalConfig.getDueCalendar() == null ? null : globalConfig.getDueCalendar().getCode(), flowInstance.getStartTime(), (DueTimeType)ObjectUtils.defaultIfNull((Object)globalConfig.getDueTimeType(), (Object)DueTimeType.CALENDAR_DAY), (Integer)ObjectUtils.defaultIfNull((Object)globalConfig.getDueDay(), (Object)0), (Integer)ObjectUtils.defaultIfNull((Object)globalConfig.getDueHour(), (Object)0), (Integer)ObjectUtils.defaultIfNull((Object)globalConfig.getDueMinute(), (Object)0)));
        flowInstance.setDueNoticed(Boolean.valueOf(false));
        if (globalConfig.getNoticeSpecialUsers() == null || globalConfig.getNoticeSpecialUsers().isEmpty()) {
            flowInstance.setUrgeSpecialTime(FlowConstant.EMPTY_MAX_TIME);
        } else {
            flowInstance.setUrgeSpecialTime(this.calUrgeTime(globalConfig.getNoticeSpecialUserDueCalendar(), flowInstance.getStartTime(), (Integer)ObjectUtils.defaultIfNull((Object)globalConfig.getNoticeSpecialUserDueDay(), (Object)0), (Integer)ObjectUtils.defaultIfNull((Object)globalConfig.getNoticeSpecialUserDueHour(), (Object)0), (Integer)ObjectUtils.defaultIfNull((Object)globalConfig.getNoticeSpecialUserDueMinute(), (Object)0), globalConfig.getNoticeSpecialUserDueTemplate(), (DueTimeType)ObjectUtils.defaultIfNull((Object)globalConfig.getNoticeStarterDueTimeType(), (Object)DueTimeType.CALENDAR_DAY)));
        }
        flowInstance.setUrgeStarterTime(this.calUrgeTime(globalConfig.getNoticeStarterDueCalendar(), flowInstance.getStartTime(), (Integer)ObjectUtils.defaultIfNull((Object)globalConfig.getNoticeStarterDueDay(), (Object)0), (Integer)ObjectUtils.defaultIfNull((Object)globalConfig.getNoticeStarterDueHour(), (Object)0), (Integer)ObjectUtils.defaultIfNull((Object)globalConfig.getNoticeStarterDueMinute(), (Object)0), globalConfig.getNoticeStarterDueTemplate(), (DueTimeType)ObjectUtils.defaultIfNull((Object)globalConfig.getNoticeStarterDueTimeType(), (Object)DueTimeType.CALENDAR_DAY)));
        this.flowInstanceService.createFlowInstance(flowInstance);
        FlowLog flowLog = FlowLogUtils.initFlowLog(null);
        flowLog.setActionTime(flowInstance.getStartTime());
        flowLog.setActionType(FlowActionType.START_PROCESS);
        flowLog.setFlowInstanceId((Long)flowInstance.getId());
        this.flowLogService.createFlowLog(flowLog);
    }

    private void handleProcessCancelled(FlowableProcessCancelledEventImpl event) {
        RuntimeService runtimeService = CommandContextUtil.getProcessEngineConfiguration().getRuntimeService();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables(runtimeService, event.getExecutionId());
        Long flowInstanceId = flowInfoVariables.getFlowInstanceId();
        Date endTime = new Date();
        this.flowInstanceService.markFlowInstanceCancelled(flowInstanceId.longValue(), endTime);
        Object mainFlowTaskId = CommandContextUtil.getCommandContext().getAttribute("_MAIN_FLOW_TASK_ID");
        Object customCmdParams = CommandContextUtil.getCommandContext().getAttribute("_CUSTOM_CMD_PARAMS");
        String opinion = customCmdParams instanceof CustomCmdParams ? ((CustomCmdParams)customCmdParams).getOpinion() : "";
        if (mainFlowTaskId != null) {
            this.flowTaskService.updateFinStatus(((Long)mainFlowTaskId).longValue(), FlowTaskStatus.CANCEL_FLOW, FlowTaskDeleteReason.PROCESS_CANCEL, opinion, endTime);
            FlowTask flowTask = this.flowTaskService.getFlowTask(((Long)mainFlowTaskId).longValue());
            FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask);
            flowLog.setActionTime(endTime);
            flowLog.setActionType(FlowActionType.CANCEL_PROCESS);
            this.flowLogService.createFlowLog(flowLog);
        } else {
            FlowLog flowLog = FlowLogUtils.initFlowLog(null);
            flowLog.setActionTime(endTime);
            flowLog.setActionType(FlowActionType.CANCEL_PROCESS);
            flowLog.setFlowInstanceId(flowInstanceId);
            this.flowLogService.createFlowLog(flowLog);
        }
        this.flowTaskService.updateFinStatusAllRunning(flowInstanceId.longValue(), FlowTaskStatus.DELETED, FlowTaskDeleteReason.PROCESS_CANCEL, opinion, endTime);
        this.flowNodeService.updateNodeFinAllRunning(flowInstanceId.longValue(), FlowTaskStatus.CANCEL_FLOW, endTime);
        this.saveHisData(flowInfoVariables, event.getExecutionId());
    }

    private void handleProcessComplete(FlowableEntityEvent event) {
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)event.getEntity());
        Long flowInstanceId = flowInfoVariables.getFlowInstanceId();
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowInstanceId.longValue());
        flowInstance.setEndTime(new Date());
        flowInstance.setStatus(FlowInstanceStatus.COMPLETED);
        flowInstance.setBizDataFlowStatus(BizFlowConstant.FLOW_STATUS_PASS);
        this.flowInstanceService.modifyFlowInstance(flowInstance);
        this.saveHisData(flowInfoVariables, flowInstance.getProcessInstanceId());
    }

    private void handleNodeStarted(FlowableActivityEvent event) {
        Date now = new Date();
        RuntimeService runtimeService = CommandContextUtil.getProcessEngineConfiguration().getRuntimeService();
        ProcessInstance processInstance = (ProcessInstance)runtimeService.createProcessInstanceQuery().processInstanceId(event.getProcessInstanceId()).includeProcessVariables().singleResult();
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables(processInstance);
        long flowProjectId = flowInfoVariables.getFlowProjectId();
        long flowInstanceId = flowInfoVariables.getFlowInstanceId();
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowProjectId, flowInstanceId, event.getActivityId());
        boolean resubmitContext = Boolean.TRUE.equals(CommandContextUtil.getCommandContext().getAttribute("_RESUBMIT_CONTEXT"));
        FlowNode flowNode = new FlowNode();
        flowNode.setNodeKey(event.getActivityId());
        flowNode.setNodeName(event.getActivityName());
        flowNode.setFlowInstanceId(Long.valueOf(flowInstanceId));
        flowNode.setStartTime(now);
        flowNode.setCountersign(approvalNodeConfig == null ? FlowConstant.SIGN_TYPE_NORMAL : (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getSignType(), (Object)FlowConstant.SIGN_TYPE_NORMAL));
        flowNode.setStatus(FlowTaskStatus.RUNNING);
        flowNode.setEndTime(FlowConstant.EMPTY_MIN_TIME);
        flowNode.setReSubmit(Boolean.valueOf(resubmitContext));
        this.flowNodeService.createFlowNode(flowNode);
        runtimeService.setVariable(processInstance.getId(), "_FLOW_NODE_ID_" + flowNode.getNodeKey(), (Object)flowNode.getId());
    }

    private void handleActivityStarted(FlowableActivityEvent event) {
        if (NEED_HANDLE_NODE_TYPES.contains(event.getActivityType())) {
            this.handleNodeStarted(event);
        }
    }

    private void handleMiActivityStarted(FlowableMultiInstanceActivityEvent event) {
        this.handleNodeStarted((FlowableActivityEvent)event);
    }

    private void handleNodeCompleted(FlowableActivityEvent event) {
        Date now = new Date();
        ProcessInstance processInstance = (ProcessInstance)CommandContextUtil.getProcessEngineConfiguration().getRuntimeService().createProcessInstanceQuery().processInstanceId(event.getProcessInstanceId()).includeProcessVariables().singleResult();
        Map processVariables = processInstance.getProcessVariables();
        Object flowNodeIdVar = processVariables.get("_FLOW_NODE_ID_" + event.getActivityId());
        if (flowNodeIdVar != null) {
            this.flowNodeService.updateNodeFin(Long.parseLong(flowNodeIdVar.toString()), FlowTaskStatus.COMPLETED, now);
        }
    }

    private void handleActivityCompleted(FlowableActivityEvent event) {
        if (NEED_HANDLE_NODE_TYPES.contains(event.getActivityType())) {
            this.handleNodeCompleted(event);
        }
    }

    private void handleMiActivityCompleted(FlowableMultiInstanceActivityEvent event) {
        this.handleNodeCompleted((FlowableActivityEvent)event);
    }

    private void handleEmptyMiNodeFin(CustomFlowableEntityEvent event) {
        Date now = new Date();
        DelegateExecution miRoot = (DelegateExecution)event.getEntity();
        Long nodeId = (Long)miRoot.getVariable("_FLOW_NODE_ID_" + miRoot.getCurrentActivityId(), Long.class);
        if (nodeId != null) {
            this.flowNodeService.updateNodeFin(nodeId.longValue(), FlowTaskStatus.COMPLETED, now);
        }
    }

    private void handleTaskAssigned(FlowableEntityEvent event) {
        TaskEntity entity = (TaskEntity)event.getEntity();
        if (entity.hasVariableLocal("_FLOW_TASK_ID")) {
            this.handleChangeTaskAssignee(entity);
        } else {
            this.handleNewTaskAssigned(entity);
        }
    }

    private void handleChangeTaskAssignee(TaskEntity entity) {
        Date now = new Date();
        Long flowTaskId = (Long)entity.getVariableLocal("_FLOW_TASK_ID", Long.class);
        FlowTask flowTask = this.flowTaskService.getFlowTask(flowTaskId.longValue());
        Long oldAssigneeId = flowTask.getAssigneeUserId();
        String oldAssigneeName = flowTask.getAssigneeUserName();
        this.updateFlowTaskUserValue(flowTask, entity);
        this.flowTaskService.modifyFlowTask(flowTask);
        FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask);
        flowLog.setActionTime(now);
        JSONObject extraInfo = new JSONObject();
        extraInfo.put("oldAssigneeId", (Object)oldAssigneeId);
        extraInfo.put("oldAssigneeName", (Object)oldAssigneeName);
        extraInfo.put("newAssigneeId", (Object)flowTask.getAssigneeUserId());
        extraInfo.put("newAssigneeName", (Object)flowTask.getAssigneeUserName());
        flowLog.setExtraInfo(extraInfo.toJSONString());
        Command command = CommandContextUtil.getCommandContext().getCommand();
        if (command instanceof CancelDelegateTaskCmd) {
            flowLog.setActionType(FlowActionType.CANCEL_DELEGATE);
        } else if (command instanceof CustomDelegateTaskCmd) {
            flowLog.setActionType(FlowActionType.DELEGATE);
        } else {
            flowLog.setActionType(FlowActionType.CHANGE_ASSIGNEE);
        }
        this.flowLogService.createFlowLog(flowLog);
    }

    private void updateFlowTaskUserValue(FlowTask flowTask, TaskEntity task) {
        flowTask.setAssigneeUserId(Long.valueOf(task.getAssignee()));
        flowTask.setOwnerUserId(StringUtils.isBlank((CharSequence)task.getOwner()) ? flowTask.getAssigneeUserId() : Long.valueOf(task.getOwner()));
        HashSet<Long> userIds = new HashSet<Long>();
        userIds.add(flowTask.getAssigneeUserId());
        if (flowTask.getOwnerUserId() != null) {
            userIds.add(flowTask.getOwnerUserId());
        }
        Map userNameMap = this.userHelperService.getUserNameMap(userIds);
        flowTask.setAssigneeUserName((String)userNameMap.get(flowTask.getAssigneeUserId()));
        if (flowTask.getOwnerUserId() != null) {
            flowTask.setOwnerUserName((String)userNameMap.get(flowTask.getOwnerUserId()));
        }
        if (task.hasVariableLocal("_DELEGATION_RULE_ID")) {
            flowTask.setDelegationRuleId((Long)task.getVariableLocal("_DELEGATION_RULE_ID", Long.class));
        } else if (!CodeUtils.isEmptyId((Long)flowTask.getDelegationRuleId())) {
            flowTask.setDelegationRuleId(FlowConstant.EMPTY_ID_VALUE);
        }
    }

    private void handleNewTaskAssigned(TaskEntity entity) {
        CommandContextUtil.getCommandContext().addAttribute("_NEW_TASK_" + entity.getId(), (Object)true);
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)entity);
        FlowTask flowTask = this.createFlowTask(entity, flowInfoVariables);
        entity.setVariableLocal("_FLOW_TASK_ID", (Object)flowTask.getId());
        FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask, false);
        flowLog.setActionTime(entity.getCreateTime());
        flowLog.setActionType(FlowActionType.START_TASK);
        this.flowLogService.createFlowLog(flowLog);
    }

    private void handleTransferTask(CustomFlowableEntityEvent event) {
        Date now = new Date();
        FlowTask flowTask = (FlowTask)event.getEntity();
        Long oldAssigneeId = flowTask.getAssigneeUserId();
        String oldAssigneeName = flowTask.getAssigneeUserName();
        flowTask.setAssigneeUserId((Long)event.getAppendParam("newAssigneeId"));
        HashSet<Long> userIds = new HashSet<Long>();
        userIds.add(flowTask.getAssigneeUserId());
        Map userNameMap = this.userHelperService.getUserNameMap(userIds);
        flowTask.setAssigneeUserName(userNameMap.getOrDefault(flowTask.getAssigneeUserId(), ""));
        if (!CodeUtils.isEmptyId((Long)flowTask.getDelegationRuleId())) {
            flowTask.setDelegationRuleId(FlowConstant.EMPTY_ID_VALUE);
        }
        FlowTask updateTask = new FlowTask();
        updateTask.setId((Serializable)((Long)flowTask.getId()));
        updateTask.setAssigneeUserId(flowTask.getAssigneeUserId());
        updateTask.setAssigneeUserName(flowTask.getAssigneeUserName());
        updateTask.setDelegationRuleId(flowTask.getDelegationRuleId());
        this.flowTaskService.modifyFlowTask(updateTask);
        FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask);
        flowLog.setActionTime(now);
        JSONObject extraInfo = new JSONObject();
        extraInfo.put("oldAssigneeId", (Object)oldAssigneeId);
        extraInfo.put("oldAssigneeName", (Object)oldAssigneeName);
        extraInfo.put("newAssigneeId", (Object)flowTask.getAssigneeUserId());
        extraInfo.put("newAssigneeName", (Object)flowTask.getAssigneeUserName());
        flowLog.setExtraInfo(extraInfo.toJSONString());
        flowLog.setActionType(FlowActionType.CHANGE_ASSIGNEE);
        this.flowLogService.createFlowLog(flowLog);
    }

    @NotNull
    private FlowTask createFlowTask(TaskEntity entity, FlowInfoVariables flowInfoVariables) {
        Long flowProjectId = flowInfoVariables.getFlowProjectId();
        Long flowInstanceId = flowInfoVariables.getFlowInstanceId();
        Long flowNodeId = (Long)entity.getVariable("_FLOW_NODE_ID_" + entity.getTaskDefinitionKey(), Long.class);
        FlowProjectConfig projectConfig = this.flowProjectConfigCacheRepository.getProjectConfig(flowProjectId.longValue());
        ApprovalNodeConfigDto approvalNodeConfig = (ApprovalNodeConfigDto)projectConfig.getApprovalNodeConfigMap().get(entity.getTaskDefinitionKey());
        if (approvalNodeConfig == null) {
            approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(flowProjectId.longValue(), flowInstanceId.longValue(), entity.getTaskDefinitionKey());
        }
        GlobalConfigDto globalConfig = projectConfig.getGlobalConfig();
        boolean resubmitContext = Boolean.TRUE.equals(CommandContextUtil.getCommandContext().getAttribute("_RESUBMIT_CONTEXT"));
        FlowTask flowTask = new FlowTask();
        flowTask.setId((Serializable)Long.valueOf(this.idWorker.nextId()));
        flowTask.setFlowInstanceId(flowInstanceId);
        flowTask.setFlowNodeId(flowNodeId);
        flowTask.setTaskId(entity.getId());
        flowTask.setTaskName(entity.getName());
        flowTask.setNodeKey(entity.getTaskDefinitionKey());
        flowTask.setStatus(FlowTaskStatus.RUNNING);
        flowTask.setStartTime(entity.getCreateTime());
        flowTask.setLastStartTime(entity.getCreateTime());
        flowTask.setEndTime(FlowConstant.EMPTY_MIN_TIME);
        flowTask.setDeleteReason(FlowTaskDeleteReason.NOT_DELETED);
        flowTask.setTaskType(FlowTaskType.ENGINE);
        flowTask.setReSubmit(Boolean.valueOf(resubmitContext));
        if (Boolean.TRUE.equals(globalConfig.getEnableDelegation())) {
            flowTask.setEnableRunningDelegation(Boolean.valueOf(Boolean.TRUE.equals(globalConfig.getEnableRunningDelegation())));
            flowTask.setAutoBackToOwner(Boolean.valueOf(Boolean.TRUE.equals(globalConfig.getAutoBackToOwner())));
            flowTask.setAllowOwnerApprove(Boolean.valueOf(Boolean.TRUE.equals(globalConfig.getAllowOwnerApprove())));
        } else {
            flowTask.setEnableRunningDelegation(Boolean.valueOf(false));
            flowTask.setAutoBackToOwner(Boolean.valueOf(false));
            flowTask.setAllowOwnerApprove(Boolean.valueOf(false));
        }
        if (DueTimeStartType.FLOW_START.equals((Object)approvalNodeConfig.getDueTimeStartType())) {
            Date flowStartTime = flowInfoVariables.getFlowInstanceStartTime();
            flowTask.setDueTime(this.calUrgeTime(approvalNodeConfig.getDueCalendar(), flowStartTime, (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getDueDay(), (Object)0), (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getDueHour(), (Object)0), (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getDueMinute(), (Object)0), (DueTimeType)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getDueTimeCalculationType(), (Object)DueTimeType.CALENDAR_DAY)));
        } else {
            flowTask.setDueTime(this.calUrgeTime(approvalNodeConfig.getDueCalendar(), flowTask.getStartTime(), (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getDueDay(), (Object)0), (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getDueHour(), (Object)0), (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getDueMinute(), (Object)0), (DueTimeType)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getDueTimeCalculationType(), (Object)DueTimeType.CALENDAR_DAY)));
        }
        flowTask.setDueAction((DueAction)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getDueAction(), (Object)DueAction.DO_NOTHING));
        flowTask.setUrgeAssigneeCount(Integer.valueOf(0));
        flowTask.setNextUrgeAssigneeTime(this.calUrgeTime(approvalNodeConfig.getUrgeAssigneeCalendar(), flowTask.getStartTime(), (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getUrgeAssigneeDay(), (Object)0), (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getUrgeAssigneeHour(), (Object)0), (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getUrgeAssigneeMinute(), (Object)0), approvalNodeConfig.getUrgeAssigneeTemplate(), (DueTimeType)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getUrgeAssigneeTimeCalculationType(), (Object)DueTimeType.CALENDAR_DAY)));
        flowTask.setUrgeStarterTime(this.calUrgeTime(approvalNodeConfig.getUrgeStarterCalendar(), flowTask.getStartTime(), (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getUrgeStarterDay(), (Object)0), (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getUrgeStarterHour(), (Object)0), (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getUrgeStarterMinute(), (Object)0), approvalNodeConfig.getUrgeStarterTemplate(), (DueTimeType)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getUrgeStarterTimeCalculationType(), (Object)DueTimeType.CALENDAR_DAY)));
        if (globalConfig.getNoticeSpecialUsers() == null || globalConfig.getNoticeSpecialUsers().isEmpty()) {
            flowTask.setUrgeSpecialTime(FlowConstant.EMPTY_MAX_TIME);
        } else {
            flowTask.setUrgeSpecialTime(this.calUrgeTime(approvalNodeConfig.getUrgeSpecialCalendar(), flowTask.getStartTime(), (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getUrgeSpecialDay(), (Object)0), (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getUrgeSpecialHour(), (Object)0), (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getUrgeSpecialMinute(), (Object)0), approvalNodeConfig.getUrgeSpecialTemplate(), (DueTimeType)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getUrgeSpecialTimeCalculationType(), (Object)DueTimeType.CALENDAR_DAY)));
        }
        flowTask.setCountersign((Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getSignType(), (Object)FlowConstant.SIGN_TYPE_NORMAL));
        this.updateFlowTaskUserValue(flowTask, entity);
        flowTask.setApprovalCode(RandomUtil.randomString((int)6));
        FlowDataListener.initFlowTaskUrl(flowInfoVariables.getFormUrlMap(), projectConfig, flowTask, approvalNodeConfig);
        this.flowTaskService.createFlowTask(flowTask);
        return flowTask;
    }

    private static void initFlowTaskUrl(Map<?, ?> flowUrlMap, FlowProjectConfig projectConfig, FlowTask flowTask, ApprovalNodeConfigDto approvalNodeConfigDto) {
        String baseFormUrl = "";
        if (flowUrlMap != null && flowUrlMap.containsKey(flowTask.getNodeKey())) {
            baseFormUrl = flowUrlMap.get(flowTask.getNodeKey()).toString();
        } else if (flowUrlMap != null && flowUrlMap.containsKey("__default")) {
            baseFormUrl = flowUrlMap.get("__default").toString();
        } else if (StringUtils.isNotBlank((CharSequence)approvalNodeConfigDto.getFormUrl())) {
            baseFormUrl = approvalNodeConfigDto.getFormUrl();
            flowTask.setFormType(approvalNodeConfigDto.getFormType());
        } else if (StringUtils.isNotBlank((CharSequence)projectConfig.getFormUrl())) {
            baseFormUrl = projectConfig.getFormUrl();
            flowTask.setFormType(projectConfig.getFormType());
        }
        flowTask.setFormUrl(baseFormUrl);
        if (StringUtils.isNotBlank((CharSequence)approvalNodeConfigDto.getEditFormUrl())) {
            flowTask.setEditFormUrl(approvalNodeConfigDto.getEditFormUrl());
            flowTask.setEditFormType(approvalNodeConfigDto.getFormType());
        } else if (StringUtils.isNotBlank((CharSequence)projectConfig.getEditFormUrl())) {
            flowTask.setEditFormUrl(projectConfig.getEditFormUrl());
            flowTask.setEditFormType(projectConfig.getEditFormType());
        }
    }

    private Date calUrgeTime(CalendarDto calendarDto, Date startTime, Integer dueDay, Integer dueHour, Integer dueMinute, DueTimeType dueTimeType) {
        if (dueDay > 0 || dueHour > 0 || dueMinute > 0) {
            if (dueTimeType == DueTimeType.CALENDAR_DAY) {
                return this.timeHelperService.calCalendarDayDueTime(startTime, dueDay.intValue(), dueHour.intValue(), dueMinute.intValue());
            }
            if (dueTimeType == DueTimeType.WORK_DAY) {
                return this.timeHelperService.calWorkdayTime(calendarDto == null ? null : calendarDto.getCode(), startTime, dueDay.intValue(), dueHour.intValue(), dueMinute.intValue());
            }
        }
        return FlowConstant.EMPTY_MAX_TIME;
    }

    private Date calDueTime(String calendarCode, Date startTime, DueTimeType dueTimeType, Integer dueDay, Integer dueHour, Integer dueMinute) {
        if (dueDay > 0 || dueHour > 0 || dueMinute > 0) {
            return this.timeHelperService.calDueTime(calendarCode, startTime, DueTimeType.WORK_DAY.equals((Object)dueTimeType), dueDay.intValue(), dueHour.intValue(), dueMinute.intValue());
        }
        return FlowConstant.EMPTY_MAX_TIME;
    }

    private Date calUrgeTime(CalendarDto calendarDto, Date startTime, Integer dueDay, Integer dueHour, Integer dueMinute, List<EventTemplateDto> templateDtoList, DueTimeType dueTimeType) {
        boolean hasDueTimeConfig;
        boolean bl = hasDueTimeConfig = dueDay > 0 || dueHour > 0 || dueMinute > 0;
        if (hasDueTimeConfig && templateDtoList != null && !templateDtoList.isEmpty()) {
            if (dueTimeType == DueTimeType.CALENDAR_DAY) {
                return this.timeHelperService.calCalendarDayDueTime(startTime, dueDay.intValue(), dueHour.intValue(), dueMinute.intValue());
            }
            if (dueTimeType == DueTimeType.WORK_DAY) {
                return this.timeHelperService.calWorkdayTime(calendarDto == null ? null : calendarDto.getCode(), startTime, dueDay.intValue(), dueHour.intValue(), dueMinute.intValue());
            }
        }
        return FlowConstant.EMPTY_MAX_TIME;
    }

    private void handleTaskComplete(FlowableEntityEvent event) {
        Date now = new Date();
        TaskEntity entity = (TaskEntity)event.getEntity();
        FlowTask flowTask = this.updateFlowTaskFinAndGetTask(entity, FlowTaskStatus.COMPLETED, FlowTaskDeleteReason.APPROVE, now);
        this.logTaskComplete(flowTask, now);
    }

    private void logTaskComplete(FlowTask flowTask, Date now) {
        if (Boolean.TRUE.equals(flowTask.getReSubmit())) {
            this.flowInstanceService.changeFlowInstanceBizDataFlowStatus(flowTask.getFlowInstanceId().longValue(), BizFlowConstant.FLOW_STATUS_RUNNING);
        }
        FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask);
        flowLog.setActionType(FlowActionType.APPROVE_TASK);
        flowLog.setActionTime(now);
        this.flowLogService.createFlowLog(flowLog);
    }

    private void handleAddComment(FlowableEntityEvent event) {
        CommentEntity commentEntity = (CommentEntity)event.getEntity();
        FlowLog flowLog = FlowLogUtils.initFlowLog(null);
        if (StringUtils.isNotBlank((CharSequence)commentEntity.getTaskId())) {
            FlowTask flowTaskByTaskId = this.flowTaskService.getFlowTaskByTaskId(commentEntity.getTaskId());
            flowLog.setFlowInstanceId(flowTaskByTaskId.getFlowInstanceId());
            flowLog.setFlowTaskId((Long)flowTaskByTaskId.getId());
        } else {
            FlowInstance flowInstance = this.flowInstanceService.getFlowInstanceByProcessInstanceId(commentEntity.getProcessInstanceId());
            flowLog.setFlowInstanceId((Long)flowInstance.getId());
        }
        flowLog.setActionTime(commentEntity.getTime());
        flowLog.setActionType(FlowActionType.ADD_COMMENT);
        this.flowLogService.createFlowLog(flowLog);
    }

    private void handleAddSign(FlowableAddSignEvent event) {
        FlowTask flowTask = this.flowTaskService.getFlowTask(event.getMainTaskId().longValue());
        FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask);
        HashMap map = MapUtil.newHashMap((int)2);
        map.put("taskNodeKey", event.getTaskDefinitionId());
        map.put("addAssigneeIds", event.getAssigneeIds());
        flowLog.setExtraInfo(JSON.toJSONString((Object)map));
        flowLog.setActionTime(new Date());
        flowLog.setActionType(FlowActionType.ADD_SIGN);
        this.flowLogService.createFlowLog(flowLog);
    }

    private void handleAddPrevNode(CustomFlowableEntityEvent event) {
        Date now = new Date();
        FlowInstanceAddNode addNode = (FlowInstanceAddNode)event.getEntity();
        FlowTask flowTask = this.updateFlowTaskFinAndGetTask(addNode.getActionTaskId(), addNode.getOpinion(), FlowTaskStatus.ADD_PREV_NODE, FlowTaskDeleteReason.ADD_PREV_NODE, now, FlowConstant.AUTO_COMPLETE_FLAG_NO);
        this.createAddNodeFlowLog(flowTask, addNode, FlowActionType.ADD_PREV_NODE, now);
        this.flowNodeService.updateNodeFinAndRejected(flowTask.getFlowNodeId().longValue(), FlowTaskStatus.ADD_PREV_NODE, now);
    }

    private void handleNodeAddPrevNode(CustomFlowableEntityEvent event) {
        TaskEntity task = (TaskEntity)event.getEntity();
        this.updateFlowTaskFin(task, FlowTaskStatus.DELETED, FlowTaskDeleteReason.NODE_ADD_PREV_NODE, new Date());
    }

    private void handleAddNextNode(CustomFlowableEntityEvent event) {
        FlowInstanceAddNode addNode = (FlowInstanceAddNode)event.getEntity();
        FlowTask flowTask = this.flowTaskService.getFlowTask(addNode.getActionTaskId().longValue());
        this.createAddNodeFlowLog(flowTask, addNode, FlowActionType.ADD_NEXT_NODE, new Date());
    }

    private void handleStarterFill(CustomFlowableEntityEvent event) {
        FlowTask flowTask = (FlowTask)event.getEntity();
        FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask);
        flowLog.setActionType(FlowActionType.STARTER_FILL);
        flowLog.setActionTime(new Date());
        this.flowLogService.createFlowLog(flowLog);
    }

    private void handleCcTask(CustomFlowableEntityEvent event) {
        FlowTask flowTask = (FlowTask)event.getEntity();
        FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask);
        flowLog.setActionType(FlowActionType.CC_TASK);
        flowLog.setActionTime(new Date());
        this.flowLogService.createFlowLog(flowLog);
    }

    private void handleCcInstance(CustomFlowableEntityEvent event) {
        FlowInstance flowInstance = (FlowInstance)event.getEntity();
        FlowLog flowLog = this.initInstanceFLowLog(flowInstance);
        flowLog.setActionType(FlowActionType.CC_INSTANCE);
        flowLog.setActionTime(new Date());
        this.flowLogService.createFlowLog(flowLog);
    }

    private void handleStarterFillStart(CustomFlowableEntityEvent event) {
        FlowTask flowTask = (FlowTask)event.getEntity();
        FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask, false);
        flowLog.setActionTime(flowTask.getStartTime());
        flowLog.setActionType(FlowActionType.START_TASK);
        this.flowLogService.createFlowLog(flowLog);
    }

    private void handleStarterFillComplete(CustomFlowableEntityEvent event) {
        FlowTask flowTask = (FlowTask)event.getEntity();
        FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask);
        flowLog.setActionTime(flowTask.getStartTime());
        flowLog.setActionType(FlowActionType.APPROVE_TASK);
        this.flowLogService.createFlowLog(flowLog);
    }

    private void createAddNodeFlowLog(FlowTask flowTask, FlowInstanceAddNode addNode, FlowActionType flowActionType, Date now) {
        FlowLog flowLog = FlowLogUtils.initFlowLog(flowTask);
        flowLog.setActionType(flowActionType);
        flowLog.setActionTime(now);
        HashMap map = MapUtil.newHashMap((int)4);
        map.put("addNodeKey", addNode.getNodeKey());
        map.put("addNodeName", addNode.getNodeName());
        map.put("addNodeId", addNode.getId());
        map.put("assignees", addNode.getAssignees());
        flowLog.setExtraInfo(JSON.toJSONString((Object)map));
        this.flowLogService.createFlowLog(flowLog);
    }

    private FlowLog initInstanceFLowLog(FlowInstance flowInstance) {
        FlowLog flowLog = new FlowLog();
        FlowLogUtils.initBaseFlowLog(flowLog);
        if (flowInstance != null) {
            flowLog.setFlowInstanceId((Long)flowInstance.getId());
        }
        return flowLog;
    }

    private void saveHisData(FlowInfoVariables flowInfoVariables, String processInstanceId) {
        Long flowInstanceId = flowInfoVariables.getFlowInstanceId();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        Map<String, Long> taskIdMap = this.flowTaskService.listByFlowInstance(flowInstanceId.longValue()).stream().filter(t -> FlowTaskType.ENGINE.equals((Object)t.getTaskType())).collect(Collectors.toMap(FlowTask::getTaskId, Entity::getId, (a, b) -> a));
        AtomicInteger sortNo = new AtomicInteger();
        List hisActivityList = processEngineConfiguration.getActivityInstanceEntityManager().findActivityInstancesByProcessInstanceId(processInstanceId, true).stream().sorted(Comparator.comparing(ActivityInstanceEntity::getStartTime).thenComparingInt(ActivityInstance::getTransactionOrder)).map(instance -> {
            FlowHisActivity activity = new FlowHisActivity();
            activity.setFlowInstanceId(flowInstanceId);
            activity.setEngineId(instance.getId());
            activity.setNodeKey(instance.getActivityId());
            activity.setNodeName(StringUtils.defaultString((String)instance.getActivityName()));
            activity.setNodeType(StringUtils.defaultString((String)instance.getActivityType()));
            activity.setStartTime(instance.getStartTime());
            activity.setEndTime(instance.getEndTime());
            activity.setDeleteReason(StringUtils.defaultString((String)instance.getDeleteReason()));
            activity.setSortNo(Integer.valueOf(sortNo.getAndIncrement()));
            if (StringUtils.isNotBlank((CharSequence)instance.getTaskId())) {
                activity.setFlowTaskId((Long)taskIdMap.get(instance.getTaskId()));
            } else {
                activity.setFlowTaskId(FlowConstant.EMPTY_ID_VALUE);
            }
            return activity;
        }).collect(Collectors.toList());
        this.flowHisService.batchInsertActivity(hisActivityList);
        List hisVariableList = processEngineConfiguration.getRuntimeService().getVariableInstances(processInstanceId).values().stream().filter(v -> !"bpmnParallelMultiInstanceCompleted".equals(v.getTypeName())).map(instance -> {
            FlowHisVariable variable = new FlowHisVariable();
            variable.setFlowInstanceId(flowInstanceId);
            variable.setEngineId(instance.getId());
            variable.setName(instance.getName());
            variable.setSourceType(StringUtils.defaultString((String)instance.getTypeName()));
            if (instance.getValue() != null) {
                variable.setVariableValue(JSON.toJSONString((Object)instance.getValue(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
            }
            if (StringUtils.isNotBlank((CharSequence)instance.getTaskId())) {
                variable.setFlowTaskId((Long)taskIdMap.get(instance.getTaskId()));
            } else {
                variable.setFlowTaskId(FlowConstant.EMPTY_ID_VALUE);
            }
            return variable;
        }).collect(Collectors.toList());
        this.flowHisService.batchInsertVariable(hisVariableList);
    }

    public boolean isFailOnException() {
        return true;
    }

    public boolean isFireOnTransactionLifecycleEvent() {
        return false;
    }

    public String getOnTransaction() {
        return null;
    }
}

