/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.listener;

import com.cyberway.mp.bc.dal.model.Entity;
import com.cyberway.mp.bc.event.FrameworkEvent;
import com.cyberway.mp.bc.event.FrameworkEventService;
import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.project.enums.FormType;
import com.cyberway.mp.flow.api.task.enums.FlowTaskStatus;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.instance.service.FlowInstanceService;
import com.cyberway.mp.flow.domain.project.entity.FlowProjectConfig;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.service.FlowTaskService;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.flowable.flow.event.FlowableWithdrawApprovalEvent;
import com.cyberway.mp.flow.flowable.flow.event.FlowableWithdrawProcessEvent;
import com.cyberway.mp.flow.flowable.listener.AsyncActionListener;
import com.cyberway.mp.flow.flowable.service.AsyncEventActionService;
import com.cyberway.mp.flow.flowable.service.AsyncEventActionTask;
import com.cyberway.mp.flow.flowable.service.AsyncEventFrameworkEventTask;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import com.cyberway.mp.flow.infra.config.FlowBaseContextProperties;
import com.cyberway.mp.flow.infra.util.FlowUtils;
import com.cyberway.mp.user.api.user.UserTaskApi;
import com.cyberway.mp.user.api.user.dto.UserTaskCompleteDto;
import com.cyberway.mp.user.api.user.dto.UserTaskCompleteEventDto;
import com.cyberway.mp.user.api.user.dto.UserTaskCreateDto;
import com.cyberway.mp.user.api.user.dto.UserTaskCreateEventDto;
import com.cyberway.mp.user.api.user.dto.UserTaskDeleteDto;
import com.cyberway.mp.user.api.user.dto.UserTaskDeleteEventDto;
import com.cyberway.mp.user.api.user.enums.UserTaskSourceEnum;
import com.cyberway.mp.user.api.user.enums.UserTaskStatusEnum;
import com.cyberway.mp.user.api.user.enums.UserTaskTypeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEntityEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventListener;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandContextCloseListener;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.delegate.event.FlowableEntityWithVariablesEvent;
import org.flowable.engine.delegate.event.FlowableProcessStartedEvent;
import org.flowable.engine.delegate.event.impl.FlowableProcessCancelledEventImpl;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class UserTaskListener
implements FlowableEventListener {
    private final FlowInstanceService flowInstanceService;
    private final FlowTaskService flowTaskService;
    private final FlowProjectConfigCacheRepository flowProjectConfigCacheRepository;
    private final FlowBaseContextProperties flowBaseContextProperties;
    private final UserTaskApi userTaskApi;
    private final FrameworkEventService frameworkEventService;
    private final AsyncEventActionService asyncEventActionService;
    private final List<CustomFlowableEngineEventType> deleteEventTypeList = new ArrayList<CustomFlowableEngineEventType>();

    public UserTaskListener(FlowInstanceService flowInstanceService, FlowTaskService flowTaskService, FlowProjectConfigCacheRepository flowProjectConfigCacheRepository, FlowBaseContextProperties flowBaseContextProperties, UserTaskApi userTaskApi, FrameworkEventService frameworkEventService, AsyncEventActionService asyncEventActionService) {
        this.flowInstanceService = flowInstanceService;
        this.flowTaskService = flowTaskService;
        this.flowProjectConfigCacheRepository = flowProjectConfigCacheRepository;
        this.flowBaseContextProperties = flowBaseContextProperties;
        this.userTaskApi = userTaskApi;
        this.frameworkEventService = frameworkEventService;
        this.asyncEventActionService = asyncEventActionService;
        this.deleteEventTypeList.add(CustomFlowableEngineEventType.PROCESS_WITHDRAW);
        this.deleteEventTypeList.add(CustomFlowableEngineEventType.TASK_APPROVAL_WITHDRAW);
        this.deleteEventTypeList.add(CustomFlowableEngineEventType.NODE_SIGN_FIN);
        this.deleteEventTypeList.add(CustomFlowableEngineEventType.FLOW_JUMP);
        this.deleteEventTypeList.add(CustomFlowableEngineEventType.NODE_JUMP);
        this.deleteEventTypeList.add(CustomFlowableEngineEventType.ROLLBACK_TO_SPECIAL);
        this.deleteEventTypeList.add(CustomFlowableEngineEventType.ROLLBACK_TO_PREV);
        this.deleteEventTypeList.add(CustomFlowableEngineEventType.ROLLBACK_TO_START);
        this.deleteEventTypeList.add(CustomFlowableEngineEventType.NODE_ROLLBACK_SPECIAL);
        this.deleteEventTypeList.add(CustomFlowableEngineEventType.NODE_ROLLBACK_PERV);
        this.deleteEventTypeList.add(CustomFlowableEngineEventType.NODE_ROLLBACK_START);
        this.deleteEventTypeList.add(CustomFlowableEngineEventType.DELETE_ADD_SIGN);
        this.deleteEventTypeList.add(CustomFlowableEngineEventType.NODE_REJECT);
    }

    public void onEvent(FlowableEvent event) {
        if (!this.flowBaseContextProperties.isEnableUserTask() || this.userTaskApi == null || !(event.getType() instanceof FlowableEngineEventType)) {
            return;
        }
        FlowableEngineEventType engineEventType = (FlowableEngineEventType)event.getType();
        if (FlowableEngineEventType.PROCESS_STARTED.equals((Object)engineEventType)) {
            FlowableProcessStartedEvent flowableProcessStartedEvent = (FlowableProcessStartedEvent)event;
            FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((FlowableEntityWithVariablesEvent)flowableProcessStartedEvent);
            Long flowInstanceId = flowInfoVariables.getFlowInstanceId();
            String flowProjectCode = flowInfoVariables.getFlowProjectCode();
            FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowInstanceId.longValue());
            Long flowProjectId = flowInstance.getFlowProjectId();
            FlowProjectConfig projectConfig = this.flowProjectConfigCacheRepository.getProjectConfig(flowProjectId.longValue());
            String formUrl = FlowUtils.formatFormUrl((FormType)projectConfig.getFormType(), (String)projectConfig.getFormUrl(), (Long)flowInstance.getStartUserId(), (Long)flowInstance.getBusinessKey());
            UserTaskCreateDto userTaskCreateDto = (UserTaskCreateDto)((UserTaskCreateDto)((UserTaskCreateDto)UserTaskCreateDto.instance().title(flowInstance.getInstanceName()).source(UserTaskSourceEnum.FLOW).status(UserTaskStatusEnum.PROCESSING).type(UserTaskTypeEnum.APPLY).userId(flowInstance.getStartUserId()).objectId(flowInstanceId).flowBusinessId(flowInstance.getBusinessKey())).flowProjectCode(flowProjectCode)).flowBusinessFrontRoute(formUrl);
            UserTaskCreateEventDto userTaskCreateEventDto = new UserTaskCreateEventDto();
            userTaskCreateEventDto.setData((Object)userTaskCreateDto);
            this.addAsyncTask(new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)userTaskCreateEventDto, "USER_TASK_CREATE_ROUTER"));
        } else if (FlowableEngineEventType.PROCESS_CANCELLED.equals((Object)engineEventType)) {
            FlowableProcessCancelledEventImpl flowableProcessCancelledEvent = (FlowableProcessCancelledEventImpl)event;
            RuntimeService runtimeService = CommandContextUtil.getProcessEngineConfiguration().getRuntimeService();
            FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables(runtimeService, flowableProcessCancelledEvent.getExecutionId());
            Long flowInstanceId = flowInfoVariables.getFlowInstanceId();
            Long flowTaskId = (Long)CommandContextUtil.getCommandContext().getAttribute("_MAIN_FLOW_TASK_ID");
            List flowTasks = this.flowTaskService.findByFlowInstanceIdAndStatus(flowInstanceId.longValue(), FlowTaskStatus.DELETED.name());
            List taskIds = flowTasks.stream().map(Entity::getId).collect(Collectors.toList());
            UserTaskCompleteEventDto userTaskCompleteEventDto = new UserTaskCompleteEventDto();
            userTaskCompleteEventDto.setData((Object)new UserTaskCompleteDto(UserTaskSourceEnum.FLOW, Lists.newArrayList((Object[])new Long[]{flowInstanceId, flowTaskId}).stream().filter(Objects::nonNull).collect(Collectors.toList())));
            this.addAsyncTask(new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)userTaskCompleteEventDto, "USER_TASK_COMPLETE_ROUTER"));
            UserTaskDeleteEventDto userTaskDeleteEventDto = new UserTaskDeleteEventDto();
            userTaskDeleteEventDto.setData((Object)new UserTaskDeleteDto(UserTaskSourceEnum.FLOW, taskIds));
            this.addAsyncTask(new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)userTaskDeleteEventDto, "USER_TASK_DELETE_ROUTER"));
        } else if (FlowableEngineEventType.TASK_ASSIGNED.equals((Object)engineEventType)) {
            FlowableEntityEvent flowableEntityEvent = (FlowableEntityEvent)event;
            TaskEntity taskEntity = (TaskEntity)flowableEntityEvent.getEntity();
            FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)taskEntity);
            Long flowInstanceId = flowInfoVariables.getFlowInstanceId();
            Long flowTaskId = (Long)taskEntity.getVariableLocal("_FLOW_TASK_ID", Long.class);
            FlowTask flowTask = this.flowTaskService.getFlowTask(flowTaskId.longValue());
            FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(flowTask.getFlowInstanceId().longValue());
            Long businessKey = flowInfoVariables.getBusinessKey();
            String flowProjectCode = flowInfoVariables.getFlowProjectCode();
            UserTaskCreateDto userTaskCreateDto = (UserTaskCreateDto)((UserTaskCreateDto)((UserTaskCreateDto)((UserTaskCreateDto)UserTaskCreateDto.instance().title(flowInstance.getInstanceName()).source(UserTaskSourceEnum.FLOW).status(UserTaskStatusEnum.PROCESSING).type(UserTaskTypeEnum.PROCESS).userId(flowTask.getAssigneeUserId()).objectId(flowTaskId).flowInstanceId(flowInstanceId)).flowBusinessId(businessKey)).flowProjectCode(flowProjectCode)).flowBusinessFrontRoute(flowTask.getFormUrl());
            UserTaskCreateEventDto userTaskCreateEventDto = new UserTaskCreateEventDto();
            userTaskCreateEventDto.setData((Object)userTaskCreateDto);
            this.addAsyncTask(new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)userTaskCreateEventDto, "USER_TASK_CREATE_ROUTER"));
        } else if (FlowableEngineEventType.TASK_COMPLETED.equals((Object)engineEventType)) {
            FlowableEntityEvent flowableEntityEvent = (FlowableEntityEvent)event;
            TaskEntity taskEntity = (TaskEntity)flowableEntityEvent.getEntity();
            Long flowTaskId = (Long)taskEntity.getVariableLocal("_FLOW_TASK_ID", Long.class);
            UserTaskCompleteEventDto userTaskCompleteEventDto = new UserTaskCompleteEventDto();
            userTaskCompleteEventDto.setData((Object)new UserTaskCompleteDto(UserTaskSourceEnum.FLOW, flowTaskId));
            this.addAsyncTask(new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)userTaskCompleteEventDto, "USER_TASK_COMPLETE_ROUTER"));
        } else if (FlowableEngineEventType.CUSTOM.equals((Object)engineEventType)) {
            if (event instanceof FlowableWithdrawApprovalEvent) {
                FlowableWithdrawApprovalEvent flowableWithdrawApprovalEvent = (FlowableWithdrawApprovalEvent)event;
                String taskId = flowableWithdrawApprovalEvent.getTaskId();
                FlowTask flowTask = this.flowTaskService.getFlowTaskByTaskId(taskId);
                UserTaskDeleteEventDto userTaskDeleteEventDto = new UserTaskDeleteEventDto();
                userTaskDeleteEventDto.setData((Object)new UserTaskDeleteDto(UserTaskSourceEnum.FLOW, (Long)flowTask.getId()));
                this.addAsyncTask(new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)userTaskDeleteEventDto, "USER_TASK_DELETE_ROUTER"));
            } else if (!(event instanceof FlowableWithdrawProcessEvent) && event instanceof CustomFlowableEntityEvent) {
                CustomFlowableEntityEvent customFlowableEntityEvent = (CustomFlowableEntityEvent)event;
                if (!(customFlowableEntityEvent.getEntity() instanceof TaskEntity)) {
                    return;
                }
                TaskEntity taskEntity = (TaskEntity)customFlowableEntityEvent.getEntity();
                Long flowTaskId = (Long)taskEntity.getVariableLocal("_FLOW_TASK_ID", Long.class);
                if (this.deleteEventTypeList.contains((Object)customFlowableEntityEvent.getCustomEventType())) {
                    UserTaskDeleteEventDto userTaskDeleteEventDto = new UserTaskDeleteEventDto();
                    userTaskDeleteEventDto.setData((Object)new UserTaskDeleteDto(UserTaskSourceEnum.FLOW, flowTaskId));
                    this.addAsyncTask(new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)userTaskDeleteEventDto, "USER_TASK_DELETE_ROUTER"));
                } else if (CustomFlowableEngineEventType.REJECT.equals((Object)customFlowableEntityEvent.getCustomEventType()) || CustomFlowableEngineEventType.SIGN_WAIVER.equals((Object)customFlowableEntityEvent.getCustomEventType()) || CustomFlowableEngineEventType.SIGN_APPROVE.equals((Object)customFlowableEntityEvent.getCustomEventType()) || CustomFlowableEngineEventType.SIGN_REJECT.equals((Object)customFlowableEntityEvent.getCustomEventType())) {
                    UserTaskCompleteEventDto userTaskCompleteEventDto = new UserTaskCompleteEventDto();
                    userTaskCompleteEventDto.setData((Object)new UserTaskCompleteDto(UserTaskSourceEnum.FLOW, flowTaskId));
                    this.addAsyncTask(new AsyncEventFrameworkEventTask(this.frameworkEventService, (FrameworkEvent)userTaskCompleteEventDto, "USER_TASK_COMPLETE_ROUTER"));
                }
            }
        }
    }

    private void addAsyncTask(AsyncEventActionTask task) {
        CommandContext commandContext = Context.getCommandContext();
        ArrayList<AsyncEventActionTask> tasks = (ArrayList<AsyncEventActionTask>)commandContext.getAttribute("asyncActionTasks");
        if (tasks == null) {
            tasks = new ArrayList<AsyncEventActionTask>();
            commandContext.addAttribute("asyncActionTasks", tasks);
        }
        tasks.add(task);
        commandContext.addCloseListener((CommandContextCloseListener)new AsyncActionListener(this.asyncEventActionService));
    }

    public boolean isFailOnException() {
        return true;
    }

    public boolean isFireOnTransactionLifecycleEvent() {
        return false;
    }

    public String getOnTransaction() {
        return null;
    }
}

