/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.service;

import com.alibaba.ttl.threadpool.TtlExecutors;
import com.cyberway.mp.flow.flowable.service.AsyncEventActionRunnable;
import com.cyberway.mp.flow.flowable.service.AsyncEventActionTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncEventActionService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExecutorService executorService;
    private final ThreadLocal<List<AsyncEventActionTask>> tasksThreadLocal = new ThreadLocal();

    public AsyncEventActionService() {
        this.executorService = TtlExecutors.getTtlExecutorService((ExecutorService)new ThreadPoolExecutor(5, 100, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy()));
    }

    public void addTasks(List<AsyncEventActionTask> tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        List<AsyncEventActionTask> list = this.tasksThreadLocal.get();
        if (list == null) {
            list = new ArrayList<AsyncEventActionTask>(tasks);
            this.tasksThreadLocal.set(list);
        } else {
            list.addAll(tasks);
        }
    }

    public void executeTasks() {
        List<AsyncEventActionTask> list = this.tasksThreadLocal.get();
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList syncList = new ArrayList();
        ArrayList<AsyncEventActionTask> asyncList = new ArrayList<AsyncEventActionTask>();
        list.forEach(task -> {
            if (task.isExecuteSync()) {
                syncList.add(task);
            } else {
                asyncList.add((AsyncEventActionTask)task);
            }
        });
        if (!asyncList.isEmpty()) {
            this.executorService.execute(new AsyncEventActionRunnable(asyncList));
        }
        for (AsyncEventActionTask task2 : syncList) {
            try {
                task2.execute();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void clean() {
        this.tasksThreadLocal.remove();
    }

    public void executeTasks(List<AsyncEventActionTask> tasks) {
        this.executorService.execute(new AsyncEventActionRunnable(tasks));
    }
}

