/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.service;

import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.model.vo.FlowModelLineVo;
import com.cyberway.mp.flow.api.model.vo.FlowModelNodeVo;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.ScriptNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.ServiceNodeConfigDto;
import com.cyberway.mp.flow.api.project.enums.AssigneeType;
import com.cyberway.mp.flow.api.project.enums.ScriptType;
import com.cyberway.mp.flow.api.project.enums.TaskExecuteType;
import com.cyberway.mp.flow.infra.service.BpmnXmlFlowDefinitionGenerateServiceImpl;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FlowableFlowDefinitionGenerateServiceImpl
extends BpmnXmlFlowDefinitionGenerateServiceImpl {
    public FlowableFlowDefinitionGenerateServiceImpl() {
        this.bpmnElementPrefix = "";
        this.dcElementPrefix = "omgdc:";
        this.diElementPrefix = "omgdi:";
    }

    protected void initDefinitions(Element definitions) {
        super.initDefinitions(definitions);
        definitions.setAttribute("xmlns:flowable", "http://flowable.org/bpmn");
        definitions.setAttribute("typeLanguage", "http://www.w3.org/2001/XMLSchema");
        definitions.setAttribute("expressionLanguage", "http://www.w3.org/1999/XPath");
        definitions.setAttribute("targetNamespace", "http://www.flowable.org/processdef");
    }

    protected void initUserTask(Element userTask, FlowModelNodeVo node, ApprovalNodeConfigDto approvalNodeConfig, BpmnXmlFlowDefinitionGenerateServiceImpl.BpmnInfo bpmnInfo) {
        super.initUserTask(userTask, node, approvalNodeConfig, bpmnInfo);
        if (approvalNodeConfig == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.NODE_CONFIG_NULL, new Object[]{node.getNodeName()});
        }
        userTask.setAttribute("flowable:assignee", "${assignee}");
        Document document = userTask.getOwnerDocument();
        Element multiInstanceLoopCharacteristics = document.createElement("multiInstanceLoopCharacteristics");
        multiInstanceLoopCharacteristics.setAttribute("isSequential", TaskExecuteType.SEQUENTIAL.equals((Object)approvalNodeConfig.getTaskExecuteType()) ? "true" : "false");
        multiInstanceLoopCharacteristics.setAttribute("flowable:collection", this.buildAssigneeCollectionExpression(approvalNodeConfig, node.getNodeKey()));
        multiInstanceLoopCharacteristics.setAttribute("flowable:elementVariable", "assignee");
        userTask.appendChild(multiInstanceLoopCharacteristics);
    }

    public String buildAssigneeCollectionExpression(ApprovalNodeConfigDto approvalNodeConfig, String nodeKey) {
        if (Boolean.TRUE.equals(approvalNodeConfig.getUseConditionMatrix())) {
            return FlowableFlowDefinitionGenerateServiceImpl.buildMatrixCollectionExpression(approvalNodeConfig, nodeKey);
        }
        if (AssigneeType.FORMULA.equals((Object)approvalNodeConfig.getAssigneeType())) {
            if (StringUtils.isBlank((CharSequence)approvalNodeConfig.getAssigneeFormula())) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.NODE_ASSIGNEE_EMPTY);
            }
            return approvalNodeConfig.getAssigneeFormula();
        }
        if (AssigneeType.CONDITION_MATRIX.equals((Object)approvalNodeConfig.getAssigneeType())) {
            if (approvalNodeConfig.getAssigneeConditionMatrixId() == null) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.NODE_ASSIGNEE_EMPTY);
            }
            return FlowableFlowDefinitionGenerateServiceImpl.buildMatrixOnlyExpression(approvalNodeConfig.getAssigneeConditionMatrixId(), nodeKey, true);
        }
        if (AssigneeType.BUSINESS_LINE.equals((Object)approvalNodeConfig.getAssigneeType())) {
            if (StringUtils.isBlank((CharSequence)approvalNodeConfig.getBusinessLineCode()) || StringUtils.isBlank((CharSequence)approvalNodeConfig.getReporterIdExpression()) || approvalNodeConfig.getReporterIdType() == null) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.NODE_ASSIGNEE_EMPTY);
            }
            return FlowableFlowDefinitionGenerateServiceImpl.buildBusinessLineExpression(approvalNodeConfig);
        }
        if (approvalNodeConfig.getAssignees() == null || approvalNodeConfig.getAssignees().isEmpty()) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.NODE_ASSIGNEE_EMPTY);
        }
        return "${userHelper.findByTypeAndIds(\"" + approvalNodeConfig.getAssigneeType().name() + "\", \"" + approvalNodeConfig.getAssignees().stream().map(a -> a.getId().toString()).collect(Collectors.joining(",")) + "\")}";
    }

    private static String buildBusinessLineExpression(ApprovalNodeConfigDto approvalNodeConfig) {
        String orgUnitExpression = StringUtils.isBlank((CharSequence)approvalNodeConfig.getReporterOrgUnitExpression()) ? "null" : approvalNodeConfig.getReporterOrgUnitExpression();
        return "${userHelper.findUserIdsByBusinessLine(\"" + approvalNodeConfig.getBusinessLineCode() + "\", " + approvalNodeConfig.getReporterIdExpression() + ", " + approvalNodeConfig.getReporterIdType() + ", " + orgUnitExpression + ")}";
    }

    private static String buildMatrixOnlyExpression(Long matrixId, String nodeKey, boolean assigneeRule) {
        return "${flowHelper.conditionMatrixFilter(" + matrixId + ", variableContainer, \"" + nodeKey + "\", " + assigneeRule + ")}";
    }

    private static String buildMatrixCollectionExpression(ApprovalNodeConfigDto approvalNodeConfig, String nodeKey) {
        Map ruleMap = approvalNodeConfig.getConditionMatrixRuleMap();
        if (ruleMap == null || ruleMap.isEmpty()) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.NODE_CONDITION_MATRIX_RULE_MAP_EMPTY);
        }
        Long matrixId = approvalNodeConfig.getConditionMatrixId();
        if (matrixId == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.NODE_CONDITION_MATRIX_EMPTY);
        }
        String baseExpression = FlowableFlowDefinitionGenerateServiceImpl.buildMatrixBaseExpression(approvalNodeConfig);
        if (StringUtils.isBlank((CharSequence)baseExpression)) {
            return FlowableFlowDefinitionGenerateServiceImpl.buildMatrixOnlyExpression(matrixId, nodeKey, false);
        }
        return "${flowHelper.conditionMatrixFilter(" + baseExpression + ", " + matrixId + ", variableContainer, \"" + nodeKey + "\")}";
    }

    private static String buildMatrixBaseExpression(ApprovalNodeConfigDto approvalNodeConfig) {
        if (AssigneeType.FORMULA.equals((Object)approvalNodeConfig.getAssigneeType())) {
            if (StringUtils.isBlank((CharSequence)approvalNodeConfig.getAssigneeFormula())) {
                return "";
            }
            String formula = approvalNodeConfig.getAssigneeFormula().trim();
            if (formula.startsWith("${")) {
                formula = formula.substring(2, formula.length() - 1);
            }
            return formula;
        }
        if (AssigneeType.CONDITION_MATRIX.equals((Object)approvalNodeConfig.getAssigneeType())) {
            if (approvalNodeConfig.getAssigneeConditionMatrixId() == null) {
                return "";
            }
            return "flowHelper.conditionMatrixFilter(" + approvalNodeConfig.getAssigneeConditionMatrixId() + ", variableContainer, \"" + approvalNodeConfig.getNodeKey() + "\", true)";
        }
        if (approvalNodeConfig.getAssignees() == null || approvalNodeConfig.getAssignees().isEmpty()) {
            return "";
        }
        return "userHelper.findByTypeAndIds(\"" + approvalNodeConfig.getAssigneeType().name() + "\", \"" + approvalNodeConfig.getAssignees().stream().map(a -> a.getId().toString()).collect(Collectors.joining(",")) + "\")";
    }

    protected void initEdge(Element edge, FlowModelLineVo line, FlowModelNodeVo sourceNode, FlowModelNodeVo targetNode) {
        super.initEdge(edge, line, sourceNode, targetNode);
        edge.setAttribute("flowable:sourceDockerX", sourceNode.getPositionX().toString());
        edge.setAttribute("flowable:sourceDockerY", sourceNode.getPositionY().toString());
        edge.setAttribute("flowable:targetDockerX", targetNode.getPositionX().toString());
        edge.setAttribute("flowable:targetDockerY", targetNode.getPositionY().toString());
    }

    protected void initScriptTask(Element scriptTask, FlowModelNodeVo node, ScriptNodeConfigDto scriptNodeConfig, BpmnXmlFlowDefinitionGenerateServiceImpl.BpmnInfo bpmnInfo) {
        super.initScriptTask(scriptTask, node, scriptNodeConfig, bpmnInfo);
        if (ScriptType.GROOVY.equals((Object)scriptNodeConfig.getScriptType())) {
            scriptTask.setAttribute("scriptFormat", "groovy");
        } else {
            scriptTask.setAttribute("scriptFormat", "javascript");
        }
        scriptTask.setAttribute("flowable:autoStoreVariables", "false");
        Document document = scriptTask.getOwnerDocument();
        Element script = document.createElement("script");
        script.appendChild(document.createCDATASection(scriptNodeConfig.getScript()));
        scriptTask.appendChild(script);
    }

    protected void initServiceTask(Element serviceTask, FlowModelNodeVo node, ServiceNodeConfigDto serviceNodeConfig, BpmnXmlFlowDefinitionGenerateServiceImpl.BpmnInfo bpmnInfo) {
        super.initServiceTask(serviceTask, node, serviceNodeConfig, bpmnInfo);
        serviceTask.setAttribute("flowable:delegateExpression", "${serviceTaskHelper}");
    }
}

