/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.service;

import cn.hutool.core.map.MapUtil;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.common.vo.BatchActionResultVo;
import com.cyberway.mp.flow.api.common.vo.ErrorInfoVo;
import com.cyberway.mp.flow.api.common.vo.KeyNameVo;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.instance.dto.AttachmentInfo;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceActionDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceBatchStartItemDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceCcDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceStartDto;
import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceBatchStartResultVo;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.EventConfigDto;
import com.cyberway.mp.flow.api.project.dto.GlobalConfigDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskActionDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskAddNodeDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskAddSignDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskCcDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskTargetNodeDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskTransferDto;
import com.cyberway.mp.flow.api.task.enums.FlowTaskStatus;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.node.entity.FlowNode;
import com.cyberway.mp.flow.domain.project.entity.FlowProject;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithProject;
import com.cyberway.mp.flow.flowable.constants.FlowableConstant;
import com.cyberway.mp.flow.flowable.flow.command.ActivateProcessCmd;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.command.GetBeansCmd;
import com.cyberway.mp.flow.flowable.flow.command.ListWaitSequenceAssigneesCmd;
import com.cyberway.mp.flow.flowable.flow.command.SuspendProcessCmd;
import com.cyberway.mp.flow.flowable.flow.model.ReadonlyVariableContainer;
import com.cyberway.mp.flow.flowable.service.AsyncEventActionService;
import com.cyberway.mp.flow.flowable.service.FlowableFlowExpressionExecutor;
import com.cyberway.mp.flow.flowable.service.TransactionalFlowEngineService;
import com.cyberway.mp.flow.flowable.util.BeanCacheUtils;
import com.cyberway.mp.flow.flowable.util.ProcessUtils;
import com.cyberway.mp.flow.infra.dto.DeployResult;
import com.cyberway.mp.flow.infra.dto.FlowEdgeInfo;
import com.cyberway.mp.flow.infra.dto.FlowInstanceBatchActionParam;
import com.cyberway.mp.flow.infra.dto.FlowInstanceBatchVarActionParam;
import com.cyberway.mp.flow.infra.dto.TaskBatchCompleteParam;
import com.cyberway.mp.flow.infra.service.FlowEngineService;
import com.cyberway.mp.flow.infra.service.FlowExpressionExecutor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.de.odysseus.el.tree.TreeBuilderException;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.javax.el.PropertyNotFoundException;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessMigrationService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.Execution;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.variable.api.history.HistoricVariableInstanceQuery;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.jdbc.core.JdbcTemplate;

public class FlowableFlowEngineServiceImpl
implements FlowEngineService,
ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TransactionalFlowEngineService transactionalFlowEngineService;
    private final AsyncEventActionService asyncEventActionService;
    private final JdbcTemplate jdbcTemplate;
    @Value(value="${seata.enabled:false}")
    private boolean seataEnabled = false;

    public FlowableFlowEngineServiceImpl(TransactionalFlowEngineService transactionalFlowEngineService, AsyncEventActionService asyncEventActionService, JdbcTemplate jdbcTemplate) {
        this.transactionalFlowEngineService = transactionalFlowEngineService;
        this.asyncEventActionService = asyncEventActionService;
        this.jdbcTemplate = jdbcTemplate;
    }

    public DeployResult deploy(FlowProject flowProject, String definition, byte[] image) {
        try {
            RepositoryService repositoryService = BeanCacheUtils.getProcessEngine().getRepositoryService();
            Deployment deployment = repositoryService.createDeployment().addString(flowProject.getCodeName() + ".bpmn20.xml", definition).addBytes(flowProject.getCodeName() + ".png", image).tenantId(flowProject.getTenantId().toString()).deploy();
            ProcessDefinition processDefinition = (ProcessDefinition)repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
            return new DeployResult(processDefinition.getId(), Integer.valueOf(processDefinition.getVersion()));
        }
        catch (FlowableException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseI18nException((ErrorCode)FlowErrorCode.PROJECT_DEFINITION_GENERATE_ERROR);
        }
    }

    private <T> T executeNeedTransaction(Callable<T> callable) {
        try {
            T result = callable.call();
            this.asyncEventActionService.executeTasks();
            T t = result;
            return t;
        }
        catch (BaseException e) {
            throw e;
        }
        catch (TreeBuilderException e) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_VAR_EXPRESSION_ERROR, new Object[]{e.getExpression(), e});
        }
        catch (FlowableException e) {
            if (e.getCause() instanceof BaseException) {
                this.logger.error(e.getMessage(), (Object)e.getCause(), (Object)e);
                throw (BaseException)e.getCause();
            }
            if (e.getCause() instanceof PropertyNotFoundException) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_VAR_NOT_FOUND, new Object[]{e.getCause().getMessage(), e});
            }
            if (e.getMessage().startsWith("No outgoing sequence flow of the exclusive gateway")) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_EXCLUSIVE_GATEWAY_NOT_OUTGOING, new Object[]{e.getMessage(), e});
            }
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseI18nException((ErrorCode)FlowErrorCode.UNKNOWN_ERROR);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseI18nException((ErrorCode)FlowErrorCode.UNKNOWN_ERROR);
        }
        finally {
            this.asyncEventActionService.clean();
        }
    }

    private void executeNeedTransactionNoReturn(Runnable runnable) {
        try {
            runnable.run();
            this.asyncEventActionService.executeTasks();
        }
        catch (BaseException e) {
            throw e;
        }
        catch (TreeBuilderException e) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_VAR_EXPRESSION_ERROR, new Object[]{e.getExpression(), e});
        }
        catch (FlowableException e) {
            if (e.getCause() instanceof BaseException) {
                throw (BaseException)e.getCause();
            }
            if (e.getCause() instanceof PropertyNotFoundException) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_VAR_NOT_FOUND, new Object[]{e.getCause().getMessage(), e});
            }
            if (e.getMessage().startsWith("No outgoing sequence flow of the exclusive gateway")) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_EXCLUSIVE_GATEWAY_NOT_OUTGOING, new Object[]{e.getMessage(), e});
            }
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseI18nException((ErrorCode)FlowErrorCode.UNKNOWN_ERROR);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseI18nException((ErrorCode)FlowErrorCode.UNKNOWN_ERROR);
        }
        finally {
            this.asyncEventActionService.clean();
        }
    }

    public Long startProcessInstance(FlowProject flowProject, FlowInstanceStartDto dto) {
        return this.executeNeedTransaction(() -> this.transactionalFlowEngineService.startProcessInstance(flowProject, dto));
    }

    public FlowInstanceBatchStartResultVo batchStartProcessInstance(FlowProject flowProject, List<FlowInstanceBatchStartItemDto> items, Map<String, String> nodeFormUrl, List<EventConfigDto> appendEventConfigs) {
        Long requestUserId = ServiceContext.getContext().getRequestUserId();
        BeanCacheUtils.getProcessEngine().getIdentityService().setAuthenticatedUserId(requestUserId.toString());
        FlowInstanceBatchStartResultVo result = new FlowInstanceBatchStartResultVo();
        HashMap<Long, ErrorInfoVo> errorInfoMap = new HashMap<Long, ErrorInfoVo>(16);
        result.setErrorInfoMap(errorInfoMap);
        HashMap flowInstanceIdMap = MapUtil.newHashMap((int)items.size());
        result.setFlowInstanceIdMap((Map)flowInstanceIdMap);
        ArrayList<Long> flowInstanceIds = new ArrayList<Long>();
        result.setFlowInstanceIds(flowInstanceIds);
        if (this.seataEnabled) {
            result.setFailCount(Integer.valueOf(0));
            this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.batchStartProcessInstance(flowProject, result, items, requestUserId, nodeFormUrl, appendEventConfigs));
            return result;
        }
        int failCount = 0;
        for (FlowInstanceBatchStartItemDto item : items) {
            try {
                Long flowInstanceId = this.executeNeedTransaction(() -> this.transactionalFlowEngineService.startProcessInstance(flowProject, item, requestUserId, nodeFormUrl, appendEventConfigs));
                flowInstanceIds.add(flowInstanceId);
                if (item.getBusinessKey() == null) continue;
                flowInstanceIdMap.put(item.getBusinessKey(), flowInstanceId);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                ++failCount;
                errorInfoMap.put(item.getBusinessKey(), this.buildErrorInfoVo(e));
            }
        }
        result.setFailCount(Integer.valueOf(failCount));
        return result;
    }

    public void completeTask(FlowTaskWithProject flowTask, FlowTaskActionDto dto, boolean noAsyncJob) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.completeTask(flowTask, dto, noAsyncJob));
    }

    public void rejectTask(FlowTaskWithProject flowTask, FlowTaskActionDto dto, boolean noAsyncJob) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.rejectTask(flowTask, dto, noAsyncJob));
    }

    public void suspendProcessInstance(String processInstanceId) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.suspendProcessInstance(processInstanceId));
    }

    public void activeProcessInstance(String processInstanceId) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.activeProcessInstance(processInstanceId));
    }

    public void suspendProcessInstance(FlowInstance flowInstance, FlowInstanceActionDto dto) {
        SuspendProcessCmd cmd = new SuspendProcessCmd(flowInstance.getProcessInstanceId(), CustomCmdParams.fromFlowInstanceActionDto(dto), dto.getVariables());
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)cmd);
    }

    public void suspendProcessInstance(FlowInstance flowInstance, FlowTaskActionDto dto) {
        SuspendProcessCmd cmd = new SuspendProcessCmd(flowInstance.getProcessInstanceId(), CustomCmdParams.fromFlowTaskActionDto(dto), dto.getVariables(), dto.getFlowTaskId());
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)cmd);
    }

    public void activeProcessInstance(FlowInstance flowInstance, FlowInstanceActionDto dto) {
        ActivateProcessCmd cmd = new ActivateProcessCmd(flowInstance.getProcessInstanceId(), CustomCmdParams.fromFlowInstanceActionDto(dto), dto.getVariables());
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)cmd);
    }

    public void activeProcessInstance(FlowInstance flowInstance, FlowTaskActionDto dto) {
        ActivateProcessCmd cmd = new ActivateProcessCmd(flowInstance.getProcessInstanceId(), CustomCmdParams.fromFlowTaskActionDto(dto), dto.getVariables(), dto.getFlowTaskId());
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)cmd);
    }

    private ErrorInfoVo buildErrorInfoVo(Exception e) {
        ErrorInfoVo errorInfoVo = e instanceof BaseException ? new ErrorInfoVo(((BaseException)((Object)e)).getCode(), e.getMessage()) : new ErrorInfoVo(FlowErrorCode.UNKNOWN_ERROR);
        return errorInfoVo;
    }

    public BatchActionResultVo batchCompleteTask(List<TaskBatchCompleteParam> params) {
        BatchActionResultVo result = new BatchActionResultVo();
        HashMap<Long, ErrorInfoVo> errorInfoMap = new HashMap<Long, ErrorInfoVo>(16);
        result.setErrorInfoMap(errorInfoMap);
        if (this.seataEnabled) {
            this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.batchCompleteTask(params));
            result.setFailCount(Integer.valueOf(0));
            return result;
        }
        int failCount = 0;
        HashSet<Long> existedIds = new HashSet<Long>();
        HashSet<Long> duplicateIds = new HashSet<Long>();
        for (TaskBatchCompleteParam param : params) {
            if (existedIds.contains(param.getFlowTask().getFlowInstanceId())) {
                duplicateIds.add(param.getFlowTask().getFlowInstanceId());
                continue;
            }
            existedIds.add(param.getFlowTask().getFlowInstanceId());
        }
        for (TaskBatchCompleteParam param : params) {
            try {
                FlowTaskActionDto dto = new FlowTaskActionDto();
                dto.setOpinion(param.getOpinion());
                dto.setVariables(param.getVariables());
                dto.setFormDataId(param.getFormDataId());
                dto.setFlowTaskId((Long)param.getFlowTask().getId());
                this.completeTask(param.getFlowTask(), dto, duplicateIds.contains(param.getFlowTask().getFlowInstanceId()));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                ++failCount;
                errorInfoMap.put((Long)param.getFlowTask().getId(), this.buildErrorInfoVo(e));
            }
        }
        result.setFailCount(Integer.valueOf(failCount));
        return result;
    }

    public BatchActionResultVo batchRejectTask(List<TaskBatchCompleteParam> params) {
        BatchActionResultVo result = new BatchActionResultVo();
        HashMap<Long, ErrorInfoVo> errorInfoMap = new HashMap<Long, ErrorInfoVo>(16);
        result.setErrorInfoMap(errorInfoMap);
        if (this.seataEnabled) {
            this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.batchRejectTask(params));
            result.setFailCount(Integer.valueOf(0));
            return result;
        }
        int failCount = 0;
        HashSet<Long> existedIds = new HashSet<Long>();
        HashSet<Long> duplicateIds = new HashSet<Long>();
        for (TaskBatchCompleteParam param : params) {
            if (existedIds.contains(param.getFlowTask().getFlowInstanceId())) {
                duplicateIds.add(param.getFlowTask().getFlowInstanceId());
                continue;
            }
            existedIds.add(param.getFlowTask().getFlowInstanceId());
        }
        for (TaskBatchCompleteParam param : params) {
            try {
                FlowTaskActionDto dto = new FlowTaskActionDto(param.getOpinion(), param.getVariables());
                this.rejectTask(param.getFlowTask(), dto, duplicateIds.contains(param.getFlowTask().getFlowInstanceId()));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                ++failCount;
                errorInfoMap.put((Long)param.getFlowTask().getId(), this.buildErrorInfoVo(e));
            }
        }
        result.setFailCount(Integer.valueOf(failCount));
        return result;
    }

    public BatchActionResultVo suspendProcessInstances(List<FlowInstanceBatchActionParam> params) {
        BatchActionResultVo result = new BatchActionResultVo();
        HashMap<Long, ErrorInfoVo> errorInfoMap = new HashMap<Long, ErrorInfoVo>(16);
        result.setErrorInfoMap(errorInfoMap);
        int failCount = 0;
        for (FlowInstanceBatchActionParam param : params) {
            try {
                this.suspendProcessInstance(param.getFlowInstance(), param.getFlowInstanceActionDto());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                ++failCount;
                errorInfoMap.put((Long)param.getFlowInstance().getId(), this.buildErrorInfoVo(e));
            }
        }
        result.setFailCount(Integer.valueOf(failCount));
        return result;
    }

    public BatchActionResultVo activeProcessInstances(List<FlowInstanceBatchActionParam> params) {
        BatchActionResultVo result = new BatchActionResultVo();
        HashMap<Long, ErrorInfoVo> errorInfoMap = new HashMap<Long, ErrorInfoVo>(16);
        result.setErrorInfoMap(errorInfoMap);
        int failCount = 0;
        for (FlowInstanceBatchActionParam param : params) {
            try {
                this.activeProcessInstance(param.getFlowInstance(), param.getFlowInstanceActionDto());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                ++failCount;
                errorInfoMap.put((Long)param.getFlowInstance().getId(), this.buildErrorInfoVo(e));
            }
        }
        result.setFailCount(Integer.valueOf(failCount));
        return result;
    }

    public void withdrawProcessInstance(String processInstanceId, FlowInstanceActionDto dto) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.withdrawProcessInstance(processInstanceId, dto));
    }

    public void cancelProcessInstance(String processInstanceId, FlowInstanceActionDto dto) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.cancelProcessInstance(processInstanceId, dto));
    }

    public BatchActionResultVo batchCancelProcessInstance(Collection<FlowInstanceBatchVarActionParam> params) {
        BatchActionResultVo result = new BatchActionResultVo();
        HashMap<Long, ErrorInfoVo> errorInfoMap = new HashMap<Long, ErrorInfoVo>(16);
        result.setErrorInfoMap(errorInfoMap);
        int failCount = 0;
        FlowEngineService flowEngineService = BeanCacheUtils.getFlowEngineService();
        for (FlowInstanceBatchVarActionParam param : params) {
            try {
                flowEngineService.cancelProcessInstance(param.getFlowInstance().getProcessInstanceId(), param.toFlowInstanceActionDto());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                ++failCount;
                errorInfoMap.put((Long)param.getFlowInstance().getId(), this.buildErrorInfoVo(e));
            }
        }
        result.setFailCount(Integer.valueOf(failCount));
        return result;
    }

    public void cancelProcessInstanceByTask(FlowTaskWithProject flowTask, String opinion, Map<String, Object> variables, List<AttachmentInfo> attachmentInfo) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.cancelProcessInstanceByTask(flowTask, opinion, variables, attachmentInfo));
    }

    public void withdrawalApproval(String historicTaskId, FlowTaskActionDto dto, Boolean isSequentialMultiInstance) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.withdrawalApproval(historicTaskId, dto, isSequentialMultiInstance));
    }

    public void addSign(String processInstanceId, String taskDefinitionId, Boolean isSequentialMultiInstance, FlowTaskAddSignDto dto) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.addSign(processInstanceId, taskDefinitionId, isSequentialMultiInstance, dto));
    }

    public void rollbackTaskToSpecial(String taskId, FlowTaskTargetNodeDto dto) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.rollbackTaskToSpecial(taskId, dto));
    }

    public void rollbackTaskToPrev(String taskId, FlowTaskActionDto dto) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.rollbackTaskToPrev(taskId, dto));
    }

    public void rollbackTaskToStart(String taskId, FlowTaskActionDto dto) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.rollbackTaskToStart(taskId, dto));
    }

    public void jump(String taskId, FlowTaskTargetNodeDto dto) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.jump(taskId, dto));
    }

    public void transferTaskInstance(FlowTask flowTask, FlowTaskTransferDto dto) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.transferTaskInstance(flowTask, dto));
    }

    public void signWaiver(String taskId, FlowTaskActionDto dto) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.signWaiver(taskId, dto));
    }

    public Map<String, Object> getVariablesByProcessInstanceId(String processInstanceId) {
        return ((HistoricProcessInstance)BeanCacheUtils.getProcessEngine().getHistoryService().createHistoricProcessInstanceQuery().includeProcessVariables().processInstanceId(processInstanceId).singleResult()).getProcessVariables().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("_") || FlowableConstant.ALLOW_SEND_INNER_VARIABLES.contains(entry.getKey())).collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), v.getValue()), HashMap::putAll);
    }

    public void setVariablesByProcessInstanceId(String processInstanceId, Map<String, Object> variables) {
        BeanCacheUtils.getProcessEngine().getRuntimeService().setVariables(processInstanceId, variables);
    }

    public void removeVariablesByProcessInstanceId(String processInstanceId, Collection<String> variableKeys) {
        BeanCacheUtils.getProcessEngine().getRuntimeService().removeVariables(processInstanceId, variableKeys);
    }

    public Map<String, Object> getVariablesByTaskId(String taskId) {
        return ((HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)BeanCacheUtils.getProcessEngine().getHistoryService().createHistoricTaskInstanceQuery().taskId(taskId)).includeProcessVariables()).singleResult()).getProcessVariables().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("_") || FlowableConstant.ALLOW_SEND_INNER_VARIABLES.contains(entry.getKey())).collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), v.getValue()), HashMap::putAll);
    }

    public boolean stillAtTaskNode(String taskId) {
        ProcessEngine processEngine = BeanCacheUtils.getProcessEngine();
        HistoricTaskInstance task = (HistoricTaskInstance)((HistoricTaskInstanceQuery)processEngine.getHistoryService().createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (task != null) {
            Execution execution = (Execution)processEngine.getRuntimeService().createExecutionQuery().executionId(task.getExecutionId()).singleResult();
            return execution != null;
        }
        return false;
    }

    public void triggerReceiveTask(String processInstanceId, String nodeKey, Map<String, Object> variables) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.triggerReceiveTask(processInstanceId, nodeKey, variables));
    }

    public void jumpFlow(String processInstanceId, String targetNodeKey, String opinion, Map<String, Object> variables, List<AttachmentInfo> attachmentInfo) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.jumpFlow(processInstanceId, targetNodeKey, opinion, variables, attachmentInfo));
    }

    public void delegateTask(String taskId, long userId, long delegationRuleId) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.delegateTask(taskId, userId, delegationRuleId));
    }

    public void cancelDelegateTask(String taskId) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.cancelDelegateTask(taskId));
    }

    public List<KeyNameVo> getAllowRollbackNodes(long flowInstanceId, long flowProjectId, String nodeKey) {
        FlowProjectConfigCacheRepository cacheRepository = BeanCacheUtils.getFlowProjectConfigCacheRepository();
        String processDefinitionId = cacheRepository.getProcessDefinitionId(flowProjectId);
        GlobalConfigDto globalConfig = cacheRepository.getGlobalConfig(flowProjectId);
        ApprovalNodeConfigDto approvalNodeConfig = cacheRepository.getApprovalNodeConfig(flowProjectId, flowInstanceId, nodeKey);
        Set completedNodeKeys = BeanCacheUtils.getFlowNodeService().listByFlowInstanceId(flowInstanceId).stream().filter(n -> FlowTaskStatus.COMPLETED.equals((Object)n.getStatus()) && Boolean.FALSE.equals(n.getRejected())).map(FlowNode::getNodeKey).collect(Collectors.toSet());
        Map<String, String> nodeNameMap = ProcessUtils.getNodeNameMap(processDefinitionId);
        Map<String, String> nodeTypeMap = ProcessUtils.getNodeTypeMap(processDefinitionId);
        Set<String> notInParallelNodes = ProcessUtils.getNotInParallelNodes(processDefinitionId);
        List parallelLines = ProcessUtils.getParallelLine(processDefinitionId).stream().filter(line -> line.contains(nodeKey)).collect(Collectors.toList());
        String userTaskClassName = UserTask.class.getSimpleName();
        boolean needCheckNodeConfig = approvalNodeConfig.getAllowRollbackNodes() != null && !approvalNodeConfig.getAllowRollbackNodes().isEmpty();
        boolean skipFirstNode = Boolean.TRUE.equals(globalConfig.getSkipFirstTask());
        String firstNodeKey = ProcessUtils.getFirstNodeKey(processDefinitionId);
        return nodeNameMap.entrySet().stream().filter(e -> !(nodeKey.equals(e.getKey()) || !userTaskClassName.equals(nodeTypeMap.get(e.getKey())) || skipFirstNode && ((String)e.getKey()).equals(firstNodeKey) || !completedNodeKeys.contains(e.getKey()) || needCheckNodeConfig && !approvalNodeConfig.getAllowRollbackNodes().contains(e.getKey()) || !notInParallelNodes.contains(e.getKey()) && !this.checkSameParallelLine(parallelLines, nodeKey, (String)e.getKey()))).map(e -> new KeyNameVo((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    public List<KeyNameVo> getAllowJumpNodes(long flowInstanceId, long flowProjectId, String nodeKey) {
        FlowProjectConfigCacheRepository cacheRepository = BeanCacheUtils.getFlowProjectConfigCacheRepository();
        String processDefinitionId = cacheRepository.getProcessDefinitionId(flowProjectId);
        ApprovalNodeConfigDto approvalNodeConfig = cacheRepository.getApprovalNodeConfig(flowProjectId, flowInstanceId, nodeKey);
        GlobalConfigDto globalConfig = cacheRepository.getGlobalConfig(flowProjectId);
        Map<String, String> nodeNameMap = ProcessUtils.getNodeNameMap(processDefinitionId);
        Map<String, String> nodeTypeMap = ProcessUtils.getNodeTypeMap(processDefinitionId);
        List parallelLines = ProcessUtils.getParallelLine(processDefinitionId).stream().filter(line -> line.contains(nodeKey)).collect(Collectors.toList());
        Set<String> notInParallelNodes = ProcessUtils.getNotInParallelNodes(processDefinitionId);
        String userTaskClassName = UserTask.class.getSimpleName();
        boolean needCheckNodeConfig = approvalNodeConfig.getAllowJumpNodes() != null && !approvalNodeConfig.getAllowJumpNodes().isEmpty();
        boolean skipFirstNode = Boolean.TRUE.equals(globalConfig.getSkipFirstTask());
        String firstNodeKey = ProcessUtils.getFirstNodeKey(processDefinitionId);
        return nodeNameMap.entrySet().stream().filter(e -> !(nodeKey.equals(e.getKey()) || !userTaskClassName.equals(nodeTypeMap.get(e.getKey())) || skipFirstNode && ((String)e.getKey()).equals(firstNodeKey) || needCheckNodeConfig && !approvalNodeConfig.getAllowJumpNodes().contains(e.getKey()) || !notInParallelNodes.contains(e.getKey()) && !this.checkSameParallelLine(parallelLines, nodeKey, (String)e.getKey()))).map(e -> new KeyNameVo((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    private boolean checkSameParallelLine(List<Set<String>> parallelLines, String sourceNodeKey, String targetNodeKey) {
        for (Set<String> parallelLine : parallelLines) {
            if (!parallelLine.contains(sourceNodeKey) || !parallelLine.contains(targetNodeKey)) continue;
            return true;
        }
        return false;
    }

    public List<KeyNameVo> getAllowJumpNodes(long flowInstanceId, long flowProjectId, Collection<String> runningNodeKeys) {
        FlowProjectConfigCacheRepository cacheRepository = BeanCacheUtils.getFlowProjectConfigCacheRepository();
        String processDefinitionId = cacheRepository.getProcessDefinitionId(flowProjectId);
        Map<String, String> nodeNameMap = ProcessUtils.getNodeNameMap(processDefinitionId);
        Map<String, String> nodeTypeMap = ProcessUtils.getNodeTypeMap(processDefinitionId);
        boolean needCheckNodeConfig = false;
        HashSet configAllowJumpNodes = new HashSet();
        for (String runningNodeKey : runningNodeKeys) {
            ApprovalNodeConfigDto approvalNodeConfig = cacheRepository.getApprovalNodeConfig(flowProjectId, flowInstanceId, runningNodeKey);
            boolean nodeNeedCheck = approvalNodeConfig.getAllowJumpNodes() != null && !approvalNodeConfig.getAllowJumpNodes().isEmpty();
            if (!nodeNeedCheck) continue;
            if (needCheckNodeConfig) {
                configAllowJumpNodes.retainAll(approvalNodeConfig.getAllowJumpNodes());
                continue;
            }
            configAllowJumpNodes.addAll(approvalNodeConfig.getAllowJumpNodes());
            needCheckNodeConfig = true;
        }
        Set<String> notInParallelNodes = ProcessUtils.getNotInParallelNodes(processDefinitionId);
        String userTaskClassName = UserTask.class.getSimpleName();
        boolean finalNeedCheckNodeConfig = needCheckNodeConfig;
        return nodeNameMap.entrySet().stream().filter(e -> !runningNodeKeys.contains(e.getKey()) && userTaskClassName.equals(nodeTypeMap.get(e.getKey())) && (!finalNeedCheckNodeConfig || configAllowJumpNodes.contains(e.getKey())) && notInParallelNodes.contains(e.getKey())).map(e -> new KeyNameVo((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    public Map<String, Map<String, Object>> batchGetVarByProcessInstances(Set<String> processInstanceIds, Set<String> filterVarNames) {
        HistoricVariableInstanceQuery query = BeanCacheUtils.getProcessEngine().getHistoryService().createHistoricVariableInstanceQuery().executionIds(processInstanceIds);
        if (filterVarNames != null && filterVarNames.size() == 1) {
            query.variableName(filterVarNames.iterator().next());
        }
        List list = query.list();
        boolean notFilter = filterVarNames == null || filterVarNames.isEmpty();
        HashMap result = MapUtil.newHashMap((int)processInstanceIds.size());
        list.stream().filter(i -> !i.getVariableName().startsWith("_") && (notFilter || filterVarNames.contains(i.getVariableName()))).forEach(v -> result.computeIfAbsent(v.getProcessInstanceId(), k -> new HashMap(16)).put(v.getVariableName(), v.getValue()));
        return result;
    }

    public void addPrevNode(String taskId, FlowTaskAddNodeDto dto) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.addPrevNode(taskId, dto));
    }

    public void addNextNode(String taskId, FlowTaskAddNodeDto dto) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.addNextNode(taskId, dto));
    }

    public List<String> listHisNodeKeyOrdered(String processInstanceId) {
        List list = BeanCacheUtils.getProcessEngine().getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
        return list.stream().sorted(Comparator.comparing(HistoricActivityInstance::getStartTime).thenComparingInt(HistoricActivityInstance::getTransactionOrder)).map(HistoricActivityInstance::getActivityId).collect(Collectors.toList());
    }

    public FlowExpressionExecutor getFlowExpressionExecutor(String processInstanceId) {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration();
        Map variables = processEngineConfiguration.getRuntimeService().getVariables(processInstanceId);
        return this.getFlowExpressionExecutor(variables, false);
    }

    public FlowExpressionExecutor getFlowExpressionExecutor(Map<String, Object> variables, boolean initBaseVars) {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration();
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        if (initBaseVars) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("_START_USER_ID", ServiceContext.getContext().getRequestUserId());
            if (variables != null) {
                map.putAll(variables);
                variables = map;
            }
        }
        ReadonlyVariableContainer variableContainer = new ReadonlyVariableContainer((Map)ObjectUtils.defaultIfNull(variables, Collections.emptyMap()));
        return new FlowableFlowExpressionExecutor(expressionManager, variableContainer);
    }

    public List<FlowEdgeInfo> listFlowEdgeInfo(String processInstanceId) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)BeanCacheUtils.getProcessEngine().getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            return Collections.emptyList();
        }
        Process process = ProcessUtils.getProcess(processInstance.getProcessDefinitionId());
        if (process == null) {
            return Collections.emptyList();
        }
        return process.getFlowElements().stream().filter(SequenceFlow.class::isInstance).map(f -> {
            SequenceFlow flow = (SequenceFlow)f;
            FlowEdgeInfo info = new FlowEdgeInfo();
            info.setId(flow.getId());
            info.setSourceId(flow.getSourceRef());
            info.setTargetId(flow.getTargetRef());
            return info;
        }).collect(Collectors.toList());
    }

    public List<Long> listWaitSequenceAssignees(String taskId) {
        ListWaitSequenceAssigneesCmd cmd = new ListWaitSequenceAssigneesCmd(taskId);
        return (List)BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)cmd);
    }

    public void migrationByInstance(String processInstanceId, String targetProcessDefinitionId, Long newFlowProjectId) {
        ProcessEngine processEngine = BeanCacheUtils.getProcessEngine();
        ProcessMigrationService processMigrationService = processEngine.getProcessMigrationService();
        boolean migrationValid = processMigrationService.createProcessInstanceMigrationBuilder().migrateToProcessDefinition(targetProcessDefinitionId).validateMigration(processInstanceId).isMigrationValid();
        if (!migrationValid) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_MIGRATION_VALID_FAILED);
        }
        this.doMigration(Collections.singleton(processInstanceId), targetProcessDefinitionId, newFlowProjectId);
    }

    public void migrationByProject(String sourceProcessDefinitionId, String targetProcessDefinitionId, Long newFlowProjectId) {
        ProcessEngine processEngine = BeanCacheUtils.getProcessEngine();
        ProcessMigrationService processMigrationService = processEngine.getProcessMigrationService();
        boolean migrationValid = processMigrationService.createProcessInstanceMigrationBuilder().migrateToProcessDefinition(targetProcessDefinitionId).validateMigrationOfProcessInstances(sourceProcessDefinitionId).isMigrationValid();
        if (!migrationValid) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_MIGRATION_VALID_FAILED);
        }
        RuntimeService runtimeService = processEngine.getRuntimeService();
        List<String> instanceIds = runtimeService.createProcessInstanceQuery().processDefinitionId(sourceProcessDefinitionId).list().stream().map(Execution::getId).collect(Collectors.toList());
        this.doMigration(instanceIds, targetProcessDefinitionId, newFlowProjectId);
    }

    private void doMigration(Collection<String> processInstanceIds, String targetProcessDefinitionId, Long newFlowProjectId) {
        String idParams = " where PROC_INST_ID_ in ('" + StringUtils.join(processInstanceIds, (String)"','") + "')";
        this.doMigrationChangeSingleTable("ACT_HI_ACTINST", targetProcessDefinitionId, idParams);
        this.doMigrationChangeSingleTable("ACT_HI_PROCINST", targetProcessDefinitionId, idParams);
        this.doMigrationChangeSingleTable("ACT_HI_TASKINST", targetProcessDefinitionId, idParams);
        this.doMigrationChangeSingleTable("ACT_RU_ACTINST", targetProcessDefinitionId, idParams);
        this.doMigrationChangeSingleTable("ACT_RU_EXECUTION", targetProcessDefinitionId, idParams);
        this.doMigrationChangeSingleTable("ACT_RU_TASK", targetProcessDefinitionId, idParams);
        HashSet<String> byteIds = new HashSet<String>();
        byteIds.addAll(this.queryMigrationByteIds("ACT_HI_VARINST", idParams));
        byteIds.addAll(this.queryMigrationByteIds("ACT_RU_VARIABLE", idParams));
        if (!byteIds.isEmpty()) {
            ArrayList byteIdList = new ArrayList(byteIds);
            byteIds.clear();
            int size = byteIdList.size();
            for (int i = 0; i < size; i += 1000) {
                List subList = byteIdList.subList(i, Math.min(i + 1000, size));
                ArrayList batchArgs = new ArrayList();
                String querySql = "select ID_,BYTES_ from ACT_GE_BYTEARRAY where ID_ in ('" + StringUtils.join(subList, (String)"','") + "')";
                this.jdbcTemplate.query(querySql, rs -> {
                    while (rs.next()) {
                        Object[] args = new Object[2];
                        args[1] = rs.getString(1);
                        byte[] bytes = rs.getBytes(2);
                        FlowInfoVariables flowInfoVariables = this.readFlowInfoVariablesFromBytes(bytes);
                        flowInfoVariables.setFlowProjectId(newFlowProjectId);
                        args[0] = this.readFlowInfoVariablesToBytes(flowInfoVariables);
                        batchArgs.add(args);
                    }
                });
                if (batchArgs.isEmpty()) continue;
                this.jdbcTemplate.batchUpdate("update ACT_GE_BYTEARRAY set BYTES_=? where ID_=?", batchArgs);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private FlowInfoVariables readFlowInfoVariablesFromBytes(byte[] bytes) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            FlowInfoVariables flowInfoVariables;
            block13: {
                ObjectInputStream ois = this.createObjectInputStream(is);
                try {
                    flowInfoVariables = (FlowInfoVariables)ois.readObject();
                    if (ois == null) break block13;
                }
                catch (Throwable throwable) {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ois.close();
            }
            return flowInfoVariables;
        }
        catch (IOException | ClassNotFoundException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_MIGRATION_HANDLE_VAR_FAILED);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] readFlowInfoVariablesToBytes(FlowInfoVariables flowInfoVariables) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            byte[] byArray;
            block13: {
                ObjectOutputStream oos = this.createObjectOutputStream(os);
                try {
                    oos.writeObject(flowInfoVariables);
                    byArray = os.toByteArray();
                    if (oos == null) break block13;
                }
                catch (Throwable throwable) {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                oos.close();
            }
            return byArray;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_MIGRATION_HANDLE_VAR_FAILED);
        }
    }

    private ObjectInputStream createObjectInputStream(InputStream is) throws IOException {
        return new ObjectInputStream(is){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                return ReflectUtil.loadClass((String)desc.getName());
            }
        };
    }

    private ObjectOutputStream createObjectOutputStream(OutputStream os) throws IOException {
        return new ObjectOutputStream(os);
    }

    private List<String> queryMigrationByteIds(String varTableName, String idParams) {
        return this.jdbcTemplate.queryForList("select BYTEARRAY_ID_ from " + varTableName + idParams + " and NAME_='_FLOW_INFO_VARIABLES'", String.class);
    }

    private void doMigrationChangeSingleTable(String tableName, String targetProcessDefinitionId, String idParams) {
        this.jdbcTemplate.execute("update " + tableName + " set PROC_DEF_ID_='" + targetProcessDefinitionId + "'" + idParams);
    }

    public void starterFill(FlowTaskWithProject task, FlowTaskActionDto dto) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.starterFill(task, dto));
    }

    public void ccTask(FlowTask flowTask, FlowTaskCcDto dto) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.ccTask(flowTask, dto));
    }

    public void ccInstance(FlowInstance flowInstance, FlowInstanceCcDto dto) {
        this.executeNeedTransactionNoReturn(() -> this.transactionalFlowEngineService.ccInstance(flowInstance, dto));
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        BeanCacheUtils.setApplicationContext(applicationContext);
        ProcessUtils.setApplicationContext(applicationContext);
    }

    public Map<Object, Object> getBeans() {
        GetBeansCmd cmd = new GetBeansCmd();
        return (Map)BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)cmd);
    }
}

