/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.service;

import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.instance.dto.AttachmentInfo;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceActionDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceBatchStartItemDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceCcDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceStartDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceStartItem;
import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceBatchStartResultVo;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.EventConfigDto;
import com.cyberway.mp.flow.api.project.enums.RejectAction;
import com.cyberway.mp.flow.api.task.dto.FlowTaskActionDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskAddNodeDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskAddSignDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskCcDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskTargetNodeDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskTransferDto;
import com.cyberway.mp.flow.api.task.enums.FlowTaskType;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.project.entity.FlowProject;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithProject;
import com.cyberway.mp.flow.flowable.flow.command.AddSignCmd;
import com.cyberway.mp.flow.flowable.flow.command.CancelDelegateTaskCmd;
import com.cyberway.mp.flow.flowable.flow.command.CancelProcessCmd;
import com.cyberway.mp.flow.flowable.flow.command.CcInstanceCmd;
import com.cyberway.mp.flow.flowable.flow.command.CcTaskCmd;
import com.cyberway.mp.flow.flowable.flow.command.CustomCmdParams;
import com.cyberway.mp.flow.flowable.flow.command.CustomCompleteTaskCmd;
import com.cyberway.mp.flow.flowable.flow.command.CustomDelegateTaskCmd;
import com.cyberway.mp.flow.flowable.flow.command.DynamicNextNodeInjectionCmd;
import com.cyberway.mp.flow.flowable.flow.command.DynamicPrevNodeInjectionCmd;
import com.cyberway.mp.flow.flowable.flow.command.JumpFlowCmd;
import com.cyberway.mp.flow.flowable.flow.command.JumpTaskCmd;
import com.cyberway.mp.flow.flowable.flow.command.RejectProcessCmd;
import com.cyberway.mp.flow.flowable.flow.command.RollbackTaskCmd;
import com.cyberway.mp.flow.flowable.flow.command.RollbackTaskPrevCmd;
import com.cyberway.mp.flow.flowable.flow.command.RollbackTaskStartCmd;
import com.cyberway.mp.flow.flowable.flow.command.SignApproveCmd;
import com.cyberway.mp.flow.flowable.flow.command.SignRejectCmd;
import com.cyberway.mp.flow.flowable.flow.command.SignWaiverCmd;
import com.cyberway.mp.flow.flowable.flow.command.StarterFillCmd;
import com.cyberway.mp.flow.flowable.flow.command.StarterFillCompleteCmd;
import com.cyberway.mp.flow.flowable.flow.command.TransferTaskCmd;
import com.cyberway.mp.flow.flowable.flow.command.WithdrawApproveCmd;
import com.cyberway.mp.flow.flowable.flow.command.WithdrawProcessCmd;
import com.cyberway.mp.flow.flowable.util.BeanCacheUtils;
import com.cyberway.mp.flow.infra.dto.TaskBatchCompleteParam;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import com.cyberway.mp.flow.infra.util.CodeUtils;
import io.seata.spring.annotation.GlobalTransactional;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class TransactionalFlowEngineService {
    private final FlowDataHelperService flowDataHelperService;

    public TransactionalFlowEngineService(FlowDataHelperService flowDataHelperService) {
        this.flowDataHelperService = flowDataHelperService;
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public Long startProcessInstance(FlowProject flowProject, FlowInstanceStartDto dto) {
        Long requestUserId = ServiceContext.getContext().getRequestUserId();
        ProcessEngine processEngine = BeanCacheUtils.getProcessEngine();
        processEngine.getIdentityService().setAuthenticatedUserId(requestUserId.toString());
        Long flowInstanceId = BeanCacheUtils.getIdWorker().nextId();
        if (dto.getAppendVariables() == null) {
            dto.setAppendVariables(new HashMap(16));
        }
        Long businessKey = dto.getBusinessKey();
        FlowInfoVariables flowInfoVariables = this.initVariables((FlowInstanceStartItem)dto, flowProject, flowInstanceId, requestUserId, dto.getNodeFormUrl(), dto.getAppendEventConfigs());
        ProcessInstance processInstance = processEngine.getRuntimeService().createProcessInstanceBuilder().processDefinitionId(flowProject.getDefinitionId()).businessKey(businessKey.toString()).name(flowProject.getName()).variables(dto.getAppendVariables()).start();
        BeanCacheUtils.getFlowInstanceService().addOrUpdateExtFields(flowInstanceId.longValue(), processInstance.getId(), flowInfoVariables.getFlowInstanceStartTime(), dto.getExtFields());
        this.flowDataHelperService.removeFlowDraftInstance(flowProject, businessKey);
        return flowInstanceId;
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public Long startProcessInstance(FlowProject flowProject, FlowInstanceBatchStartItemDto item, long startUserId, Map<String, String> nodeFormUrl, List<EventConfigDto> appendEventConfigs) {
        return this.doStartProcessInstance(flowProject, item, startUserId, nodeFormUrl, appendEventConfigs);
    }

    private Long doStartProcessInstance(FlowProject flowProject, FlowInstanceBatchStartItemDto item, long startUserId, Map<String, String> nodeFormUrl, List<EventConfigDto> appendEventConfigs) {
        Long flowInstanceId = BeanCacheUtils.getIdWorker().nextId();
        if (item.getAppendVariables() == null) {
            item.setAppendVariables(new HashMap(16));
        }
        FlowInfoVariables flowInfoVariables = this.initVariables((FlowInstanceStartItem)item, flowProject, flowInstanceId, startUserId, nodeFormUrl, appendEventConfigs);
        ProcessInstance processInstance = BeanCacheUtils.getProcessEngine().getRuntimeService().createProcessInstanceBuilder().processDefinitionId(flowProject.getDefinitionId()).businessKey(item.getBusinessKey().toString()).name(flowProject.getName()).variables(item.getAppendVariables()).start();
        BeanCacheUtils.getFlowInstanceService().addOrUpdateExtFields(flowInstanceId.longValue(), processInstance.getId(), flowInfoVariables.getFlowInstanceStartTime(), item.getExtFields());
        this.flowDataHelperService.removeFlowDraftInstance(flowProject, item.getBusinessKey());
        return flowInstanceId;
    }

    private FlowInfoVariables initVariables(FlowInstanceStartItem item, FlowProject flowProject, Long flowInstanceId, Long startUserId, Map<String, String> nodeFormUrl, List<EventConfigDto> appendEventConfigs) {
        FlowInfoVariables flowInfoVariables = new FlowInfoVariables();
        flowInfoVariables.setFlowInstanceId(flowInstanceId);
        flowInfoVariables.setFlowInstanceStartTime(new Date());
        flowInfoVariables.setBusinessKey(item.getBusinessKey());
        flowInfoVariables.setFlowProjectId((Long)flowProject.getId());
        flowInfoVariables.setFlowProjectFirstVersionId(flowProject.getFirstVersionId());
        flowInfoVariables.setFlowProjectCode(flowProject.getCodeName());
        flowInfoVariables.setStartUserId(startUserId);
        flowInfoVariables.setInstanceCode(item.getInstanceCode());
        if (nodeFormUrl != null) {
            flowInfoVariables.setFormUrlMap(nodeFormUrl);
        }
        if (appendEventConfigs != null) {
            flowInfoVariables.setAppendEventConfigs(appendEventConfigs);
        }
        Map variables = item.getAppendVariables();
        variables.put("_FLOW_INFO_VARIABLES", flowInfoVariables);
        variables.put("_START_USER_ID", startUserId);
        return flowInfoVariables;
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void completeTask(FlowTaskWithProject flowTask, FlowTaskActionDto dto, boolean noAsyncJob) {
        this.doCompleteTask(flowTask, dto, noAsyncJob);
    }

    private void doCompleteTask(FlowTaskWithProject flowTask, FlowTaskActionDto dto, boolean noAsyncJob) {
        ApprovalNodeConfigDto approvalNodeConfig = BeanCacheUtils.getFlowProjectConfigCacheRepository().getApprovalNodeConfig(flowTask);
        if (!CodeUtils.isEmptyId((Long)dto.getFormDataId())) {
            FlowTask updateTask = new FlowTask();
            updateTask.setId((Serializable)((Long)flowTask.getId()));
            updateTask.setFormDataId(dto.getFormDataId());
            this.flowDataHelperService.updateTask(updateTask);
            flowTask.setFormDataId(dto.getFormDataId());
        }
        ProcessEngine processEngine = BeanCacheUtils.getProcessEngine();
        Command<?> cmd = this.buildCompleteCmd(flowTask, dto, noAsyncJob, approvalNodeConfig);
        processEngine.getProcessEngineConfiguration().getCommandExecutor().execute(cmd);
    }

    private Command<?> buildCompleteCmd(FlowTaskWithProject flowTask, FlowTaskActionDto dto, boolean noAsyncJob, ApprovalNodeConfigDto approvalNodeConfig) {
        Object cmd = FlowTaskType.STARTER_FILL.equals((Object)flowTask.getTaskType()) ? new StarterFillCompleteCmd(this.flowDataHelperService, flowTask, dto) : (approvalNodeConfig.getSignType() != null && !FlowConstant.SIGN_TYPE_NORMAL.equals(approvalNodeConfig.getSignType()) ? new SignApproveCmd(flowTask.getTaskId(), CustomCmdParams.fromFlowTaskActionDto(dto), dto.getVariables(), noAsyncJob) : new CustomCompleteTaskCmd(flowTask.getTaskId(), dto.getVariables(), CustomCmdParams.fromFlowTaskActionDto(dto), noAsyncJob));
        return cmd;
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void rejectTask(FlowTaskWithProject flowTask, FlowTaskActionDto dto, boolean noAsyncJob) {
        this.doRejectTask(flowTask, dto, noAsyncJob);
    }

    private void doRejectTask(FlowTaskWithProject flowTask, FlowTaskActionDto dto, boolean noAsyncJob) {
        ApprovalNodeConfigDto approvalNodeConfig = BeanCacheUtils.getFlowProjectConfigCacheRepository().getApprovalNodeConfig(flowTask.getFlowProjectId().longValue(), flowTask.getFlowInstanceId().longValue(), flowTask.getNodeKey());
        ProcessEngine processEngine = BeanCacheUtils.getProcessEngine();
        Command<?> cmd = this.buildRejectCmd(flowTask, dto, noAsyncJob, approvalNodeConfig);
        if (cmd == null) {
            return;
        }
        processEngine.getProcessEngineConfiguration().getCommandExecutor().execute(cmd);
    }

    private Command<?> buildRejectCmd(FlowTaskWithProject flowTask, FlowTaskActionDto dto, boolean noAsyncJob, ApprovalNodeConfigDto approvalNodeConfig) {
        if (approvalNodeConfig.getSignType() != null && !FlowConstant.SIGN_TYPE_NORMAL.equals(approvalNodeConfig.getSignType())) {
            return new SignRejectCmd(flowTask.getTaskId(), CustomCmdParams.fromFlowTaskActionDto(dto), dto.getVariables(), noAsyncJob);
        }
        RejectAction rejectAction = (RejectAction)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getRejectAction(), (Object)RejectAction.ROLLBACK_START);
        switch (rejectAction) {
            case ROLLBACK_TO: {
                return new RollbackTaskCmd(flowTask.getTaskId(), CustomCmdParams.fromFlowTaskActionDto(dto), dto.getVariables(), approvalNodeConfig.getRejectToNodeKey(), true, noAsyncJob, this.flowDataHelperService);
            }
            case ROLLBACK_PREV: {
                return new RollbackTaskPrevCmd(flowTask.getTaskId(), CustomCmdParams.fromFlowTaskActionDto(dto), dto.getVariables(), true, noAsyncJob, this.flowDataHelperService);
            }
            case ROLLBACK_START: {
                return new RollbackTaskStartCmd(flowTask.getTaskId(), CustomCmdParams.fromFlowTaskActionDto(dto), dto.getVariables(), true, noAsyncJob, this.flowDataHelperService);
            }
            case CANCEL_FLOW: {
                return new RejectProcessCmd(flowTask.getTaskId(), CustomCmdParams.fromFlowTaskActionDto(dto), dto.getVariables(), noAsyncJob);
            }
        }
        return null;
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void suspendProcessInstance(String processInstanceId) {
        BeanCacheUtils.getProcessEngine().getRuntimeService().suspendProcessInstanceById(processInstanceId);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void activeProcessInstance(String processInstanceId) {
        BeanCacheUtils.getProcessEngine().getRuntimeService().activateProcessInstanceById(processInstanceId);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void withdrawProcessInstance(String processInstanceId, FlowInstanceActionDto dto) {
        ProcessEngine processEngine = BeanCacheUtils.getProcessEngine();
        WithdrawProcessCmd withdrawProcessCmd = new WithdrawProcessCmd(processInstanceId, CustomCmdParams.fromFlowInstanceActionDto(dto), dto.getVariables(), this.flowDataHelperService);
        processEngine.getProcessEngineConfiguration().getCommandExecutor().execute((Command)withdrawProcessCmd);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void cancelProcessInstance(String processInstanceId, FlowInstanceActionDto dto) {
        ProcessEngine processEngine = BeanCacheUtils.getProcessEngine();
        CancelProcessCmd cancelProcessCmd = new CancelProcessCmd(processInstanceId, CustomCmdParams.fromFlowInstanceActionDto(dto), dto.getVariables());
        processEngine.getProcessEngineConfiguration().getCommandExecutor().execute((Command)cancelProcessCmd);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void cancelProcessInstanceByTask(FlowTaskWithProject flowTask, String opinion, Map<String, Object> variables, List<AttachmentInfo> attachmentInfo) {
        CancelProcessCmd cancelProcessCmd;
        ProcessEngine processEngine = BeanCacheUtils.getProcessEngine();
        if (FlowTaskType.STARTER_FILL.equals((Object)flowTask.getTaskType())) {
            FlowInstance flowInstance = this.flowDataHelperService.getFlowInstance(flowTask.getFlowInstanceId());
            cancelProcessCmd = new CancelProcessCmd(flowInstance.getProcessInstanceId(), (Long)flowTask.getId(), new CustomCmdParams(opinion, attachmentInfo), variables);
        } else {
            cancelProcessCmd = new CancelProcessCmd((Long)flowTask.getId(), flowTask.getTaskId(), new CustomCmdParams(opinion, attachmentInfo), variables);
        }
        processEngine.getProcessEngineConfiguration().getCommandExecutor().execute((Command)cancelProcessCmd);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void withdrawalApproval(String historicTaskId, FlowTaskActionDto dto, Boolean isSequentialMultiInstance) {
        WithdrawApproveCmd withdrawApproveCmd = new WithdrawApproveCmd(historicTaskId, CustomCmdParams.fromFlowTaskActionDto(dto), isSequentialMultiInstance);
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)withdrawApproveCmd);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void addSign(String processInstanceId, String taskDefinitionId, Boolean isSequentialMultiInstance, FlowTaskAddSignDto dto) {
        AddSignCmd addSignCmd = new AddSignCmd(processInstanceId, taskDefinitionId, isSequentialMultiInstance, dto);
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)addSignCmd);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void rollbackTaskToSpecial(String taskId, FlowTaskTargetNodeDto dto) {
        ProcessEngine processEngine = BeanCacheUtils.getProcessEngine();
        RollbackTaskCmd fallbackTaskCmd = new RollbackTaskCmd(taskId, CustomCmdParams.fromFlowTaskTargetNodeDto(dto), dto.getVariables(), dto.getTargetNodeKey(), false, false, this.flowDataHelperService);
        processEngine.getProcessEngineConfiguration().getCommandExecutor().execute((Command)fallbackTaskCmd);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void rollbackTaskToPrev(String taskId, FlowTaskActionDto dto) {
        RollbackTaskPrevCmd fallbackTaskCmd = new RollbackTaskPrevCmd(taskId, CustomCmdParams.fromFlowTaskActionDto(dto), dto.getVariables(), false, false, this.flowDataHelperService);
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)fallbackTaskCmd);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void rollbackTaskToStart(String taskId, FlowTaskActionDto dto) {
        RollbackTaskStartCmd rollbackTaskStartCmd = new RollbackTaskStartCmd(taskId, CustomCmdParams.fromFlowTaskActionDto(dto), dto.getVariables(), false, false, this.flowDataHelperService);
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)rollbackTaskStartCmd);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void jump(String taskId, FlowTaskTargetNodeDto dto) {
        JumpTaskCmd jumpTaskCmd = new JumpTaskCmd(taskId, dto.getTargetNodeKey(), CustomCmdParams.fromFlowTaskTargetNodeDto(dto), dto.getVariables(), this.flowDataHelperService);
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)jumpTaskCmd);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void transferTaskInstance(FlowTask flowTask, FlowTaskTransferDto dto) {
        FlowInstance flowInstance = this.flowDataHelperService.getFlowInstance(flowTask.getFlowInstanceId());
        TransferTaskCmd transferTaskCmd = new TransferTaskCmd(flowTask, flowInstance, dto.getNewAssigneeUserId(), dto.getVariables(), CustomCmdParams.fromFlowTaskActionDto((FlowTaskActionDto)dto));
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)transferTaskCmd);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void signWaiver(String taskId, FlowTaskActionDto dto) {
        SignWaiverCmd signWaiverCmd = new SignWaiverCmd(taskId, CustomCmdParams.fromFlowTaskActionDto(dto), dto.getVariables());
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)signWaiverCmd);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void triggerReceiveTask(String processInstanceId, String nodeKey, Map<String, Object> variables) {
        RuntimeService runtimeService = BeanCacheUtils.getProcessEngine().getRuntimeService();
        Execution execution = (Execution)runtimeService.createExecutionQuery().processInstanceId(processInstanceId).activityId(nodeKey).singleResult();
        if (execution == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.RECEIVE_TASK_NOT_FOUND);
        }
        runtimeService.trigger(execution.getId(), variables);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void jumpFlow(String processInstanceId, String targetNodeKey, String opinion, Map<String, Object> variables, List<AttachmentInfo> attachmentInfo) {
        JumpFlowCmd jumpFlowCmd = new JumpFlowCmd(processInstanceId, targetNodeKey, new CustomCmdParams(opinion, attachmentInfo), variables);
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)jumpFlowCmd);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void delegateTask(String taskId, long userId, long delegationRuleId) {
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)new CustomDelegateTaskCmd(taskId, userId, delegationRuleId));
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void cancelDelegateTask(String taskId) {
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)new CancelDelegateTaskCmd(taskId));
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void addPrevNode(String taskId, FlowTaskAddNodeDto dto) {
        DynamicPrevNodeInjectionCmd cmd = new DynamicPrevNodeInjectionCmd(BeanCacheUtils.getFlowInstanceService(), BeanCacheUtils.getFlowProjectConfigCacheRepository(), taskId, dto.getNodeName(), dto.getAssigneeUsers(), CustomCmdParams.fromFlowTaskAddNodeDto(dto));
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)cmd);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void addNextNode(String taskId, FlowTaskAddNodeDto dto) {
        DynamicNextNodeInjectionCmd cmd = new DynamicNextNodeInjectionCmd(BeanCacheUtils.getFlowInstanceService(), BeanCacheUtils.getFlowProjectConfigCacheRepository(), taskId, dto.getNodeName(), dto.getAssigneeUsers(), CustomCmdParams.fromFlowTaskAddNodeDto(dto));
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)cmd);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void batchCompleteTask(List<TaskBatchCompleteParam> params) {
        params.forEach(param -> this.doCompleteTask(param.getFlowTask(), param.toFlowTaskActionDto(), false));
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void batchRejectTask(List<TaskBatchCompleteParam> params) {
        params.forEach(param -> this.doRejectTask(param.getFlowTask(), param.toFlowTaskActionDto(), false));
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void batchStartProcessInstance(FlowProject flowProject, FlowInstanceBatchStartResultVo result, List<FlowInstanceBatchStartItemDto> items, Long requestUserId, Map<String, String> nodeFormUrl, List<EventConfigDto> appendEventConfigs) {
        items.forEach(item -> {
            Long id = this.doStartProcessInstance(flowProject, (FlowInstanceBatchStartItemDto)item, requestUserId, nodeFormUrl, appendEventConfigs);
            result.getFlowInstanceIds().add(id);
            if (item.getBusinessKey() != null) {
                result.getFlowInstanceIdMap().put(item.getBusinessKey(), id);
            }
        });
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void starterFill(FlowTaskWithProject task, FlowTaskActionDto dto) {
        StarterFillCmd cmd = new StarterFillCmd(this.flowDataHelperService, task, dto);
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)cmd);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void ccTask(FlowTask flowTask, FlowTaskCcDto dto) {
        if (Boolean.TRUE.equals(dto.getAsyncCc())) {
            flowTask = this.flowDataHelperService.getFlowTask((Long)flowTask.getId());
        }
        CcTaskCmd cmd = new CcTaskCmd(this.flowDataHelperService, flowTask, dto);
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)cmd);
    }

    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void ccInstance(FlowInstance flowInstance, FlowInstanceCcDto dto) {
        CcInstanceCmd cmd = new CcInstanceCmd(this.flowDataHelperService, flowInstance, dto);
        BeanCacheUtils.getProcessEngine().getProcessEngineConfiguration().getCommandExecutor().execute((Command)cmd);
    }
}

