/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.util;

import com.cyberway.mp.flow.api.project.enums.CountersignNumType;
import com.cyberway.mp.flow.api.project.enums.CountersignType;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CountersignUtils {
    public static final Integer CONTINUE_TASK_CODE = 0;
    public static final Integer APPROVE_TASK_CODE = 1;
    public static final Integer REJECT_TASK_CODE = 2;

    private CountersignUtils() {
    }

    public static Integer calCountersignResult(CountersignNumType countersignNumType, CountersignType countersignType, Integer countersignNum, Integer totalNum, Integer nrOfActiveInstances, Integer nrOfCompletedInstances, Integer nrOfRollbackInstances) {
        if (CountersignNumType.PERCENT.equals((Object)countersignNumType)) {
            return CountersignUtils.calCountersignResultPercent(countersignType, countersignNum, totalNum, nrOfActiveInstances, nrOfCompletedInstances, nrOfRollbackInstances);
        }
        return CountersignUtils.calCountersignResultAbsolute(countersignType, countersignNum, nrOfActiveInstances, nrOfCompletedInstances, nrOfRollbackInstances);
    }

    private static int calCountersignResultPercent(CountersignType countersignType, Integer countersignNum, Integer totalNum, Integer nrOfActiveInstances, Integer nrOfCompletedInstances, Integer nrOfRollbackInstances) {
        if (CountersignType.REJECT.equals((Object)countersignType)) {
            return CountersignUtils.calCountersignResultPercent(countersignNum, totalNum, nrOfActiveInstances, nrOfRollbackInstances, REJECT_TASK_CODE, APPROVE_TASK_CODE);
        }
        return CountersignUtils.calCountersignResultPercent(countersignNum, totalNum, nrOfActiveInstances, nrOfCompletedInstances, APPROVE_TASK_CODE, REJECT_TASK_CODE);
    }

    private static int calCountersignResultPercent(Integer needPassNum, Integer totalNum, Integer waitVoteNum, Integer votePassNum, Integer votePassCode, Integer voteNotPassCode) {
        BigDecimal passNum = new BigDecimal(votePassNum);
        BigDecimal totalNumDecimal = new BigDecimal(totalNum);
        BigDecimal canPassNum = new BigDecimal(votePassNum + waitVoteNum);
        int passedPercent = passNum.divide(totalNumDecimal, 2, RoundingMode.DOWN).multiply(new BigDecimal(100)).intValue();
        int canPassPercent = canPassNum.divide(totalNumDecimal, 2, RoundingMode.DOWN).multiply(new BigDecimal(100)).intValue();
        if (needPassNum <= passedPercent) {
            return votePassCode;
        }
        if (needPassNum > canPassPercent || waitVoteNum == 0) {
            return voteNotPassCode;
        }
        return CONTINUE_TASK_CODE;
    }

    private static Integer calCountersignResultAbsolute(CountersignType countersignType, Integer countersignNum, Integer nrOfActiveInstances, Integer nrOfCompletedInstances, Integer nrOfRollbackInstances) {
        if (CountersignType.REJECT.equals((Object)countersignType)) {
            if (countersignNum.equals(nrOfRollbackInstances)) {
                return REJECT_TASK_CODE;
            }
            if (countersignNum > nrOfRollbackInstances + nrOfActiveInstances) {
                return APPROVE_TASK_CODE;
            }
            if (nrOfActiveInstances == 0) {
                return nrOfCompletedInstances > nrOfRollbackInstances ? APPROVE_TASK_CODE : REJECT_TASK_CODE;
            }
            return CONTINUE_TASK_CODE;
        }
        if (countersignNum.equals(nrOfCompletedInstances)) {
            return APPROVE_TASK_CODE;
        }
        if (countersignNum > nrOfCompletedInstances + nrOfActiveInstances) {
            return REJECT_TASK_CODE;
        }
        return CONTINUE_TASK_CODE;
    }
}

