/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.util;

import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.common.utils.UrlCoderUtil;
import com.cyberway.mp.bc.context.autoconfigure.ContextProperties;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.project.dto.CustomApiParamValueDto;
import com.cyberway.mp.flow.api.project.dto.CustomHttpActionConfigDto;
import com.cyberway.mp.flow.api.project.dto.InternalHttpActionConfigDto;
import com.cyberway.mp.flow.api.project.dto.ServiceNodeConfigDto;
import com.cyberway.mp.flow.api.project.enums.BodyParamType;
import com.cyberway.mp.flow.api.project.enums.HttpActionHttpMethod;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import feign.Client;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import java.io.IOException;
import java.io.Reader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class CustomApiUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomApiUtils.class);
    private static final Map<String, OkHttpClient> OK_HTTP_CLIENT_MAP = new LinkedHashMap<String, OkHttpClient>();
    public static final MediaType FORM_MEDIA_TYPE = MediaType.get((String)"application/x-www-form-unlencoded; charset=utf-8");
    public static final MediaType JSON_MEDIA_TYPE = MediaType.get((String)"application/json; charset=utf-8");
    public static final MediaType RAW_MEDIA_TYPE = MediaType.get((String)"text/plain; charset=utf-8");
    private static final String API_PATH_SPLIT = "/";

    private CustomApiUtils() {
    }

    public static Request createInternalApiRequest(CustomHttpActionConfigDto actionConfig, Map<String, Object> variables, ContextProperties contextProperties) {
        return CustomApiUtils.createInternalApiRequest(actionConfig.getServiceId(), actionConfig.getApiPath(), actionConfig.getPathParams(), actionConfig.getUrlParams(), actionConfig.getBodyParamType(), actionConfig.getBodyTemplate(), actionConfig.getBodyParams(), actionConfig.getHeaders(), actionConfig.getHttpMethod(), variables, contextProperties);
    }

    public static Request createInternalApiRequest(ServiceNodeConfigDto serviceNodeConfig, Map<String, Object> variables, ContextProperties contextProperties) {
        return CustomApiUtils.createInternalApiRequest(serviceNodeConfig.getServiceId(), serviceNodeConfig.getApiPath(), serviceNodeConfig.getPathParams(), serviceNodeConfig.getUrlParams(), serviceNodeConfig.getBodyParamType(), serviceNodeConfig.getBodyTemplate(), serviceNodeConfig.getBodyParams(), serviceNodeConfig.getHeaders(), serviceNodeConfig.getHttpMethod(), variables, contextProperties);
    }

    public static okhttp3.Request createExternalApiRequest(CustomHttpActionConfigDto actionConfig, Map<String, Object> variables) {
        return CustomApiUtils.createExternalApiRequest(actionConfig.getApiPath(), actionConfig.getPathParams(), actionConfig.getUrlParams(), actionConfig.getBodyParamType(), actionConfig.getBodyTemplate(), actionConfig.getBodyParams(), actionConfig.getHeaders(), actionConfig.getHttpMethod(), variables);
    }

    public static okhttp3.Request createExternalApiRequest(ServiceNodeConfigDto serviceNodeConfi, Map<String, Object> variables) {
        return CustomApiUtils.createExternalApiRequest(serviceNodeConfi.getApiPath(), serviceNodeConfi.getPathParams(), serviceNodeConfi.getUrlParams(), serviceNodeConfi.getBodyParamType(), serviceNodeConfi.getBodyTemplate(), serviceNodeConfi.getBodyParams(), serviceNodeConfi.getHeaders(), serviceNodeConfi.getHttpMethod(), variables);
    }

    public static OkHttpClient getOkHttpClient(long connectionTimeout, long readTimeout) {
        String key = connectionTimeout + "," + readTimeout;
        return OK_HTTP_CLIENT_MAP.computeIfAbsent(key, k -> new OkHttpClient.Builder().connectTimeout(connectionTimeout, TimeUnit.MILLISECONDS).readTimeout(readTimeout, TimeUnit.MILLISECONDS).build());
    }

    public static Request.HttpMethod toMethod(HttpActionHttpMethod httpMethod) {
        switch (httpMethod) {
            case PUT: {
                return Request.HttpMethod.PUT;
            }
            case POST: {
                return Request.HttpMethod.POST;
            }
            case PATCH: {
                return Request.HttpMethod.PATCH;
            }
            case DELETE: {
                return Request.HttpMethod.DELETE;
            }
        }
        throw new BaseI18nException((ErrorCode)FlowErrorCode.UNKNOWN_ERROR);
    }

    public static String formatInternalApiPath(InternalHttpActionConfigDto actionConfig) {
        return CustomApiUtils.formatInternalApiPath(actionConfig.getServiceName(), actionConfig.getApiPath());
    }

    public static Map<String, Collection<String>> buildInternalApiHeaders(Request.Body body, String contentType, ContextProperties contextProperties) {
        HashMap<String, Collection<String>> headers = new HashMap<String, Collection<String>>(16);
        try {
            Map attachments = ServiceContext.getContext().getKeys();
            attachments.forEach((headerName, headerValue) -> {
                String lowerCaseHeaderName = headerName.toLowerCase();
                if (!(lowerCaseHeaderName.startsWith("accept") || lowerCaseHeaderName.startsWith("content") || lowerCaseHeaderName.startsWith("x-forwarded-for") || lowerCaseHeaderName.equals("host") || lowerCaseHeaderName.equals("origin"))) {
                    String encodeHeaderValue = CustomApiUtils.checkNeedEncodeHeader(headerName, contextProperties) ? UrlCoderUtil.encoder((String)headerValue.toString()) : headerValue.toString();
                    headers.put((String)headerName, (Collection<String>)Collections.singleton(encodeHeaderValue));
                }
            });
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        headers.put("Content-Type", Collections.singleton(contentType));
        headers.put("Content-Length", Collections.singleton(body == null ? "0" : String.valueOf(body.length())));
        return headers;
    }

    private static boolean checkNeedEncodeHeader(String headerName, ContextProperties contextProperties) {
        if (contextProperties == null || contextProperties.getHeader() == null || contextProperties.getHeader().getNeedEncode() == null) {
            return false;
        }
        return contextProperties.getHeader().getNeedEncode().stream().anyMatch(h -> h.equalsIgnoreCase(headerName));
    }

    public static void callFeignApi(Client feignClient, Request request, Request.Options options, boolean throwException) {
        CustomApiUtils.callFeignApi(feignClient, request, options, throwException, null);
    }

    public static void callFeignApi(Client feignClient, Request request, Request.Options options, boolean throwException, String errorMsgPath) {
        block4: {
            try {
                Response response = feignClient.execute(request, options);
                if (response.status() < HttpStatus.OK.value() || response.status() >= HttpStatus.MULTIPLE_CHOICES.value()) {
                    LOGGER.error("Call internal api fail, request[{}], response: [{}]", (Object)request, (Object)response);
                    if (throwException) {
                        CustomApiUtils.tryExtraErrorMsg(response, errorMsgPath);
                        throw new BaseI18nException((ErrorCode)FlowErrorCode.CALL_API_FAILED);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Call internal api fail, request[{}]", (Object)request, (Object)e);
                if (!throwException) break block4;
                throw new BaseI18nException((ErrorCode)FlowErrorCode.CALL_API_FAILED);
            }
        }
    }

    public static void tryExtraErrorMsg(Response response, String errorMsgPath) {
        if (StringUtils.isBlank((CharSequence)errorMsgPath)) {
            return;
        }
        String bodyText = null;
        try {
            Response.Body body = response.body();
            if (body == null) {
                return;
            }
            try (Reader reader = body.asReader(StandardCharsets.UTF_8);){
                bodyText = IOUtils.toString((Reader)reader);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        CustomApiUtils.tryExtraErrorMsg(bodyText, errorMsgPath);
    }

    public static void callWebApi(OkHttpClient okHttpClient, okhttp3.Request request, boolean throwException) {
        CustomApiUtils.callWebApi(okHttpClient, request, throwException, null);
    }

    public static void callWebApi(OkHttpClient okHttpClient, okhttp3.Request request, boolean throwException, String errorMsgPath) {
        block4: {
            try {
                okhttp3.Response response = okHttpClient.newCall(request).execute();
                if (!response.isSuccessful()) {
                    LOGGER.error("Call external api fail, request[{}], response: [{}]", (Object)request, (Object)response);
                    if (throwException) {
                        CustomApiUtils.tryExtraErrorMsg(response, errorMsgPath);
                        throw new BaseI18nException((ErrorCode)FlowErrorCode.CALL_API_FAILED);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Call external api fail, request[{}]", (Object)request, (Object)e);
                if (!throwException) break block4;
                throw new BaseI18nException((ErrorCode)FlowErrorCode.CALL_API_FAILED);
            }
        }
    }

    public static void tryExtraErrorMsg(okhttp3.Response response, String errorMsgPath) {
        if (StringUtils.isBlank((CharSequence)errorMsgPath)) {
            return;
        }
        String bodyText = null;
        try {
            ResponseBody body = response.body();
            if (body == null) {
                return;
            }
            bodyText = body.string();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        CustomApiUtils.tryExtraErrorMsg(bodyText, errorMsgPath);
    }

    public static void tryExtraErrorMsg(String bodyText, String errorMsgPath) {
        String errorMsg = null;
        try {
            if (StringUtils.isBlank((CharSequence)bodyText)) {
                return;
            }
            errorMsg = (String)JsonPath.read((String)bodyText, (String)errorMsgPath, (Predicate[])new Predicate[0]);
            if (StringUtils.isBlank((CharSequence)errorMsg)) {
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (StringUtils.isNotBlank(errorMsg)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.CALL_API_FAILED_WITH_MSG, new Object[]{errorMsg});
        }
    }

    private static okhttp3.Request createExternalApiRequest(String apiPath, List<CustomApiParamValueDto> pathParams, List<CustomApiParamValueDto> urlParams, BodyParamType bodyParamType, String bodyTemplate, List<CustomApiParamValueDto> bodyParams, List<CustomApiParamValueDto> headerParams, HttpActionHttpMethod httpMethod, Map<String, Object> variables) {
        HttpUrl url = HttpUrl.parse((String)(apiPath = CustomApiUtils.formatExternalApiPath(apiPath, pathParams, urlParams, variables)));
        if (url == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.API_PATH_FORMAT_ERROR, new Object[]{apiPath});
        }
        RequestBody body = CustomApiUtils.createExternalApiBody(bodyParamType, bodyTemplate, bodyParams, variables);
        Request.Builder builder = new Request.Builder().method(httpMethod.name(), body);
        if (headerParams != null && !headerParams.isEmpty()) {
            for (CustomApiParamValueDto headerParam : headerParams) {
                String paramValue = ObjectUtils.defaultIfNull((Object)variables.get(headerParam.getValueSource()), (Object)StringUtils.defaultString((String)headerParam.getDefaultValue())).toString();
                if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
                builder.addHeader(headerParam.getName(), paramValue);
            }
        }
        return builder.url(url).build();
    }

    private static Request createInternalApiRequest(String serviceId, String apiPath, List<CustomApiParamValueDto> pathParams, List<CustomApiParamValueDto> urlParams, BodyParamType bodyParamType, String bodyTemplate, List<CustomApiParamValueDto> bodyParams, List<CustomApiParamValueDto> headerParams, HttpActionHttpMethod httpMethod, Map<String, Object> variables, ContextProperties contextProperties) {
        String url = CustomApiUtils.formatInternalApiPath(serviceId, apiPath, pathParams, urlParams, variables);
        String bodyString = CustomApiUtils.createCustomBody(bodyParamType, bodyTemplate, bodyParams, variables);
        Request.Body body = bodyString == null ? null : Request.Body.create((String)bodyString, (Charset)StandardCharsets.UTF_8);
        Map<String, Collection<String>> headers = CustomApiUtils.createInternalApiHeaders(bodyParamType, headerParams, body, variables, contextProperties);
        return Request.create((Request.HttpMethod)CustomApiUtils.toMethod(httpMethod), (String)url, headers, (Request.Body)body, (RequestTemplate)new RequestTemplate());
    }

    private static String formatInternalApiPath(String serviceName, String apiPath) {
        return CustomApiUtils.formatInternalApiPath(serviceName, apiPath, null, null, null);
    }

    private static String formatInternalApiPath(String serviceName, String apiPath, List<CustomApiParamValueDto> pathParams, List<CustomApiParamValueDto> urlParams, Map<String, Object> variables) {
        if (StringUtils.isBlank((CharSequence)apiPath)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.API_PATH_FORMAT_ERROR, new Object[]{apiPath});
        }
        StringBuilder path = new StringBuilder();
        path.append("http://").append(serviceName);
        apiPath = apiPath.replaceAll("\\\\+", API_PATH_SPLIT);
        if (!apiPath.startsWith(API_PATH_SPLIT)) {
            path.append(API_PATH_SPLIT);
        }
        path.append(apiPath);
        String url = path.toString();
        if (pathParams != null) {
            url = CustomApiUtils.handlePathParam(url, pathParams, variables);
        }
        if (urlParams != null) {
            url = CustomApiUtils.handleUrlParam(url, urlParams, variables);
        }
        return url;
    }

    private static String formatExternalApiPath(String apiPath, List<CustomApiParamValueDto> pathParams, List<CustomApiParamValueDto> urlParams, Map<String, Object> variables) {
        if (StringUtils.isBlank((CharSequence)apiPath)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.API_PATH_FORMAT_ERROR, new Object[]{apiPath});
        }
        if (pathParams != null) {
            apiPath = CustomApiUtils.handlePathParam(apiPath, pathParams, variables);
        }
        if (urlParams != null) {
            apiPath = CustomApiUtils.handleUrlParam(apiPath, urlParams, variables);
        }
        return apiPath;
    }

    private static RequestBody createExternalApiBody(BodyParamType bodyParamType, String bodyTemplate, List<CustomApiParamValueDto> bodyParams, Map<String, Object> variables) {
        String bodyString = CustomApiUtils.createCustomBody(bodyParamType, bodyTemplate, bodyParams, variables);
        MediaType mediaType = BodyParamType.JSON.equals((Object)bodyParamType) ? JSON_MEDIA_TYPE : (BodyParamType.RAW.equals((Object)bodyParamType) ? RAW_MEDIA_TYPE : FORM_MEDIA_TYPE);
        return bodyString == null ? null : RequestBody.create((String)bodyString, (MediaType)mediaType);
    }

    private static Map<String, Collection<String>> createInternalApiHeaders(BodyParamType bodyParamType, List<CustomApiParamValueDto> headerParams, Request.Body body, Map<String, Object> variables, ContextProperties contextProperties) {
        String contentType = BodyParamType.JSON.equals((Object)bodyParamType) ? JSON_MEDIA_TYPE.toString() : (BodyParamType.RAW.equals((Object)bodyParamType) ? RAW_MEDIA_TYPE.toString() : FORM_MEDIA_TYPE.toString());
        Map<String, Collection<String>> headers = CustomApiUtils.buildInternalApiHeaders(body, contentType, contextProperties);
        if (headerParams != null) {
            CustomApiUtils.handleCustomHeader(headers, headerParams, variables);
        }
        return headers;
    }

    private static String handlePathParam(String url, List<CustomApiParamValueDto> pathParams, Map<String, Object> variables) {
        for (CustomApiParamValueDto pathParam : pathParams) {
            String paramValue = ObjectUtils.defaultIfNull((Object)variables.get(pathParam.getValueSource()), (Object)StringUtils.defaultString((String)pathParam.getDefaultValue())).toString();
            url = url.replace("{" + pathParam.getName() + "}", URLEncoder.encode(paramValue, StandardCharsets.UTF_8));
        }
        return url;
    }

    private static String handleUrlParam(String url, List<CustomApiParamValueDto> urlParams, Map<String, Object> variables) {
        boolean alreadyHasParam = url.contains("?");
        StringBuilder result = new StringBuilder(url);
        for (CustomApiParamValueDto urlParam : urlParams) {
            String paramValue = ObjectUtils.defaultIfNull((Object)variables.get(urlParam.getValueSource()), (Object)StringUtils.defaultString((String)urlParam.getDefaultValue())).toString();
            if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
            result.append(alreadyHasParam ? "&" : "?").append(urlParam.getName()).append("=").append(URLEncoder.encode(paramValue, StandardCharsets.UTF_8));
            alreadyHasParam = true;
        }
        return result.toString();
    }

    private static String createCustomBody(BodyParamType bodyParamType, String bodyTemplate, List<CustomApiParamValueDto> bodyParams, Map<String, Object> variables) {
        if (BodyParamType.FORM.equals((Object)bodyParamType)) {
            return CustomApiUtils.createCustomFormBody(bodyParams, variables);
        }
        if (StringUtils.isBlank((CharSequence)bodyTemplate)) {
            return null;
        }
        String bodyString = bodyTemplate;
        for (CustomApiParamValueDto bodyParam : bodyParams) {
            String paramValue = ObjectUtils.defaultIfNull((Object)variables.get(bodyParam.getValueSource()), (Object)StringUtils.defaultString((String)bodyParam.getDefaultValue())).toString();
            bodyString = bodyString.replace("{" + bodyParam.getName() + "}", paramValue);
        }
        return bodyString;
    }

    private static String createCustomFormBody(List<CustomApiParamValueDto> bodyParams, Map<String, Object> variables) {
        if (bodyParams == null || bodyParams.isEmpty()) {
            return null;
        }
        StringBuilder bodyString = new StringBuilder();
        for (CustomApiParamValueDto bodyParam : bodyParams) {
            String paramValue = ObjectUtils.defaultIfNull((Object)variables.get(bodyParam.getValueSource()), (Object)StringUtils.defaultString((String)bodyParam.getDefaultValue())).toString();
            if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
            if (bodyString.length() > 0) {
                bodyString.append("&");
            }
            bodyString.append(URLEncoder.encode(bodyParam.getName(), StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(paramValue, StandardCharsets.UTF_8));
        }
        if (bodyString.length() > 0) {
            return bodyString.toString();
        }
        return null;
    }

    private static void handleCustomHeader(Map<String, Collection<String>> headers, List<CustomApiParamValueDto> headerParams, Map<String, Object> variables) {
        for (CustomApiParamValueDto headerParam : headerParams) {
            String paramValue = ObjectUtils.defaultIfNull((Object)variables.get(headerParam.getValueSource()), (Object)StringUtils.defaultString((String)headerParam.getDefaultValue())).toString();
            if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
            ArrayList<String> values = new ArrayList<String>();
            values.add(paramValue);
            headers.put(headerParam.getName(), values);
        }
    }
}

