/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.util;

import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.delegate.event.FlowableEntityWithVariablesEvent;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class FlowVariableUtils {
    private FlowVariableUtils() {
    }

    public static FlowInfoVariables getFlowInfoVariables(VariableScope variableScope) {
        FlowInfoVariables flowInfoVariables = (FlowInfoVariables)variableScope.getVariable("_FLOW_INFO_VARIABLES", FlowInfoVariables.class);
        if (flowInfoVariables == null) {
            flowInfoVariables = new FlowInfoVariables();
            flowInfoVariables.setFlowInstanceId((Long)variableScope.getVariable("_FLOW_INSTANCE_ID", Long.class));
            flowInfoVariables.setBusinessKey((Long)variableScope.getVariable("_BUSINESS_KEY", Long.class));
            flowInfoVariables.setFlowProjectId((Long)variableScope.getVariable("_FLOW_PROJECT_ID", Long.class));
            flowInfoVariables.setFlowProjectFirstVersionId((Long)variableScope.getVariable("_FLOW_PROJECT_FIRST_VERSION_ID", Long.class));
            flowInfoVariables.setFlowProjectCode((String)variableScope.getVariable("_FLOW_PROJECT_CODE", String.class));
            flowInfoVariables.setStartUserId((Long)variableScope.getVariable("_START_USER_ID", Long.class));
            flowInfoVariables.setFlowInstanceStartTime((Date)variableScope.getVariable("_FLOW_INSTANCE_START_TIME", Date.class));
            Map flowUrlMap = (Map)variableScope.getVariable("_FORM_URL_MAP", Map.class);
            if (flowUrlMap != null) {
                flowInfoVariables.setFormUrlMap(flowUrlMap.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString())));
            }
        }
        return flowInfoVariables;
    }

    public static FlowInfoVariables getFlowInfoVariables(RuntimeService runtimeService, String processInstanceId) {
        FlowInfoVariables flowInfoVariables = (FlowInfoVariables)runtimeService.getVariable(processInstanceId, "_FLOW_INFO_VARIABLES", FlowInfoVariables.class);
        if (flowInfoVariables == null) {
            return FlowVariableUtils.convertFlowInfoVariables(runtimeService.getVariables(processInstanceId));
        }
        return flowInfoVariables;
    }

    public static FlowInfoVariables getFlowInfoVariables(FlowableEntityWithVariablesEvent event) {
        Map processVariables = event.getVariables();
        return FlowVariableUtils.getFlowInfoVariables(processVariables);
    }

    public static FlowInfoVariables getFlowInfoVariables(HistoricProcessInstance processInstance) {
        Map processVariables = processInstance.getProcessVariables();
        return FlowVariableUtils.getFlowInfoVariables(processVariables);
    }

    public static FlowInfoVariables getFlowInfoVariables(ProcessInstance processInstance) {
        Map processVariables = processInstance.getProcessVariables();
        return FlowVariableUtils.getFlowInfoVariables(processVariables);
    }

    private static FlowInfoVariables getFlowInfoVariables(Map<String, Object> variables) {
        if (variables.containsKey("_FLOW_INFO_VARIABLES")) {
            return (FlowInfoVariables)variables.get("_FLOW_INFO_VARIABLES");
        }
        return FlowVariableUtils.convertFlowInfoVariables(variables);
    }

    private static FlowInfoVariables convertFlowInfoVariables(Map<String, Object> variables) {
        FlowInfoVariables flowInfoVariables = new FlowInfoVariables();
        flowInfoVariables.setFlowInstanceId((Long)variables.get("_FLOW_INSTANCE_ID"));
        flowInfoVariables.setBusinessKey((Long)variables.get("_BUSINESS_KEY"));
        flowInfoVariables.setFlowProjectId((Long)variables.get("_FLOW_PROJECT_ID"));
        flowInfoVariables.setFlowProjectFirstVersionId((Long)variables.get("_FLOW_PROJECT_FIRST_VERSION_ID"));
        flowInfoVariables.setFlowProjectCode((String)variables.get("_FLOW_PROJECT_CODE"));
        flowInfoVariables.setStartUserId((Long)variables.get("_START_USER_ID"));
        flowInfoVariables.setFlowInstanceStartTime((Date)variables.get("_FLOW_INSTANCE_START_TIME"));
        Map flowUrlMap = (Map)variables.get("_FORM_URL_MAP");
        if (flowUrlMap != null) {
            flowInfoVariables.setFormUrlMap(flowUrlMap);
        }
        return flowInfoVariables;
    }

    public static void markAutoComplete(CommandContext commandContext, TaskEntity task, Integer autoCompleteFlag) {
        if (autoCompleteFlag == null || FlowConstant.AUTO_COMPLETE_FLAG_NO.equals(autoCompleteFlag)) {
            return;
        }
        task.setVariableLocal("_TASK_AUTO_COMPLETE_FLAG", (Object)autoCompleteFlag);
        HashSet<String> autoCompleteTaskIds = (HashSet<String>)commandContext.getAttribute("autoCompleteTaskIds");
        if (autoCompleteTaskIds == null) {
            autoCompleteTaskIds = new HashSet<String>();
        }
        autoCompleteTaskIds.add(task.getId());
        commandContext.addAttribute("autoCompleteTaskIds", autoCompleteTaskIds);
    }
}

