/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.flowable.util;

import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.instance.vo.FlowInfoVariables;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.GlobalConfigDto;
import com.cyberway.mp.flow.api.project.enums.EmptyAssigneeAction;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.flowable.flow.constant.CustomFlowableEngineEventType;
import com.cyberway.mp.flow.flowable.flow.event.CustomFlowableEntityEvent;
import com.cyberway.mp.flow.flowable.util.FlowVariableUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.variable.api.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ProcessUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessUtils.class);
    public static final Integer JUMP_MODE_SIMPLE = 0;
    public static final Integer JUMP_MODE_SAME_PARALLEL = 1;
    public static final Integer JUMP_MODE_DIFFERENT_PARALLEL = 2;
    private static final ConcurrentHashMap<String, Map<String, String>> NODE_NAME_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Map<String, String>> NODE_TYPE_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, List<Set<String>>> PARALLEL_LINE_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Set<String>> NOT_IN_PARALLEL_NODES_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> FIRST_NODE_CACHE = new ConcurrentHashMap();
    private static final String ERR_APPLICATION_CONTEXT_NULL = "ApplicationContext\u672a\u521d\u59cb\u5316";
    private static ApplicationContext applicationContext;
    private static DeploymentManager deploymentManager;
    private static RepositoryService repositoryService;
    private static FlowProjectConfigCacheRepository flowProjectConfigCacheRepository;

    private ProcessUtils() {
    }

    public static void cleanCache(String processDefinitionId) {
        NODE_NAME_CACHE.remove(processDefinitionId);
        NODE_TYPE_CACHE.remove(processDefinitionId);
        FIRST_NODE_CACHE.remove(processDefinitionId);
        PARALLEL_LINE_CACHE.remove(processDefinitionId);
        NOT_IN_PARALLEL_NODES_CACHE.remove(processDefinitionId);
    }

    public static boolean checkInParallel(String processDefinitionId, String nodeKey) {
        Set<String> notInParallelNodes = ProcessUtils.getNotInParallelNodes(processDefinitionId);
        return !notInParallelNodes.contains(nodeKey);
    }

    public static Integer checkJumpMode(String processDefinitionId, String sourceNodeKey, String targetNodeKey) {
        Set<String> notInParallelNodes = ProcessUtils.getNotInParallelNodes(processDefinitionId);
        if (notInParallelNodes.contains(targetNodeKey)) {
            return JUMP_MODE_SIMPLE;
        }
        HashSet<String> nodeSet = new HashSet<String>();
        nodeSet.add(sourceNodeKey);
        nodeSet.add(targetNodeKey);
        for (Set<String> nodeKeys : PARALLEL_LINE_CACHE.get(processDefinitionId)) {
            if (!nodeKeys.containsAll(nodeSet)) continue;
            return JUMP_MODE_SAME_PARALLEL;
        }
        return JUMP_MODE_DIFFERENT_PARALLEL;
    }

    public static Set<String> getNotInParallelNodes(String processDefinitionId) {
        Set<String> result = NOT_IN_PARALLEL_NODES_CACHE.get(processDefinitionId);
        if (result == null) {
            ProcessUtils.initProcessCache(processDefinitionId);
            result = NOT_IN_PARALLEL_NODES_CACHE.get(processDefinitionId);
        }
        return result;
    }

    public static List<Set<String>> getParallelLine(String processDefinitionId) {
        List<Set<String>> sets = PARALLEL_LINE_CACHE.get(processDefinitionId);
        if (sets == null) {
            ProcessUtils.initProcessCache(processDefinitionId);
            sets = PARALLEL_LINE_CACHE.get(processDefinitionId);
        }
        return sets;
    }

    public static String getFirstNodeKey(String processDefinitionId) {
        if (!FIRST_NODE_CACHE.containsKey(processDefinitionId)) {
            ProcessUtils.initProcessCache(processDefinitionId);
        }
        return FIRST_NODE_CACHE.get(processDefinitionId);
    }

    public static Map<String, String> getNodeNameMap(String processDefinitionId) {
        if (!NODE_NAME_CACHE.containsKey(processDefinitionId)) {
            ProcessUtils.initProcessCache(processDefinitionId);
        }
        return NODE_NAME_CACHE.get(processDefinitionId);
    }

    public static Map<String, String> getNodeTypeMap(String processDefinitionId) {
        if (!NODE_TYPE_CACHE.containsKey(processDefinitionId)) {
            ProcessUtils.initProcessCache(processDefinitionId);
        }
        return NODE_TYPE_CACHE.get(processDefinitionId);
    }

    private static void initProcessCache(String processDefinitionId) {
        if (!NOT_IN_PARALLEL_NODES_CACHE.containsKey(processDefinitionId)) {
            List outgoingFlows;
            DefinitionCache definitionCache = new DefinitionCache();
            Process process = ProcessUtils.getProcess(processDefinitionId);
            FlowElement initialFlowElement = process.getInitialFlowElement();
            HashSet<String> handledNode = new HashSet<String>();
            ProcessUtils.handleNode(initialFlowElement, null, definitionCache, null, handledNode, 0);
            FIRST_NODE_CACHE.put(processDefinitionId, "");
            if (initialFlowElement instanceof FlowNode && (outgoingFlows = ((FlowNode)initialFlowElement).getOutgoingFlows()) != null && outgoingFlows.size() == 1) {
                FIRST_NODE_CACHE.put(processDefinitionId, ((SequenceFlow)outgoingFlows.get(0)).getTargetFlowElement().getId());
            }
            NODE_NAME_CACHE.put(processDefinitionId, definitionCache.nodeNameCache);
            NODE_TYPE_CACHE.put(processDefinitionId, definitionCache.nodeTypeCache);
            PARALLEL_LINE_CACHE.put(processDefinitionId, definitionCache.lineCache);
            NOT_IN_PARALLEL_NODES_CACHE.put(processDefinitionId, definitionCache.notInParallelCache);
        }
    }

    public static Process getProcess(String processDefinitionId) {
        if (CommandContextUtil.getCommandContext() != null) {
            return ProcessDefinitionUtil.getProcess((String)processDefinitionId);
        }
        ProcessDefinition processDefinition = ProcessUtils.getRepositoryService().getProcessDefinition(processDefinitionId);
        return ProcessUtils.getDeploymentManager().resolveProcessDefinition(processDefinition).getProcess();
    }

    private static void handleNode(FlowElement flowElement, FlowElement fromElement, DefinitionCache definitionCache, Set<String> currentLine, Set<String> handledNode, int parallelCount) {
        boolean notLastIncomingFlow;
        FlowNode flowNode = (FlowNode)flowElement;
        boolean isParallelGateway = flowNode instanceof ParallelGateway;
        if (isParallelGateway && currentLine != null && !currentLine.isEmpty()) {
            definitionCache.lineCache.add(currentLine);
        }
        if (handledNode.contains(flowNode.getId())) {
            return;
        }
        List incomingFlows = flowNode.getIncomingFlows();
        boolean bl = notLastIncomingFlow = incomingFlows != null && incomingFlows.size() > 1 && (fromElement == null || !fromElement.equals(((SequenceFlow)incomingFlows.get(incomingFlows.size() - 1)).getSourceFlowElement()));
        if (notLastIncomingFlow) {
            return;
        }
        handledNode.add(flowNode.getId());
        definitionCache.nodeNameCache.put(flowNode.getId(), flowNode.getName());
        definitionCache.nodeTypeCache.put(flowNode.getId(), flowNode.getClass().getSimpleName());
        if (isParallelGateway) {
            parallelCount = parallelCount + flowNode.getOutgoingFlows().size() - flowNode.getIncomingFlows().size();
        } else if (flowNode instanceof UserTask) {
            if (parallelCount == 0) {
                definitionCache.notInParallelCache.add(flowNode.getId());
            }
            if (currentLine != null) {
                currentLine.add(flowNode.getId());
            }
        }
        ProcessUtils.handleOutgoingFlows(flowElement, definitionCache, currentLine, handledNode, parallelCount, flowNode, isParallelGateway);
    }

    private static void handleOutgoingFlows(FlowElement flowElement, DefinitionCache definitionCache, Set<String> currentLine, Set<String> handledNode, int parallelCount, FlowNode flowNode, boolean isParallelGateway) {
        List outgoingFlows = flowNode.getOutgoingFlows();
        if (outgoingFlows != null) {
            for (SequenceFlow outgoingFlow : outgoingFlows) {
                FlowElement targetFlowElement = outgoingFlow.getTargetFlowElement();
                if (isParallelGateway) {
                    ProcessUtils.handleNode(targetFlowElement, flowElement, definitionCache, parallelCount == 0 ? null : new HashSet<String>(), handledNode, parallelCount);
                    continue;
                }
                if (!(targetFlowElement instanceof FlowNode)) continue;
                ProcessUtils.handleNode(targetFlowElement, flowElement, definitionCache, currentLine, handledNode, parallelCount);
            }
        }
    }

    public static void handleEmptyAssigneeNode(DelegateExecution multiInstanceRootExecution) {
        boolean throwException;
        FlowInfoVariables flowInfoVariables = FlowVariableUtils.getFlowInfoVariables((VariableScope)multiInstanceRootExecution);
        Long projectId = flowInfoVariables.getFlowProjectId();
        String nodeKey = multiInstanceRootExecution.getCurrentActivityId();
        ApprovalNodeConfigDto approvalNodeConfig = ProcessUtils.getFlowProjectConfigCacheRepository().getApprovalNodeConfig(projectId.longValue(), nodeKey);
        if (approvalNodeConfig != null && Boolean.TRUE.equals(approvalNodeConfig.getCustomEmptyAssigneeAction())) {
            throwException = EmptyAssigneeAction.THROW_EXCEPTION.equals((Object)approvalNodeConfig.getEmptyAssigneeAction());
        } else {
            GlobalConfigDto globalConfig = ProcessUtils.getFlowProjectConfigCacheRepository().getGlobalConfig(projectId.longValue());
            boolean bl = throwException = globalConfig != null && EmptyAssigneeAction.THROW_EXCEPTION.equals((Object)globalConfig.getEmptyAssigneeAction());
        }
        if (throwException) {
            String nodeName = ProcessUtils.getFlowProjectConfigCacheRepository().getNodeName(projectId.longValue(), nodeKey);
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_NODE_EMPTY_ASSIGNEE, new Object[]{nodeName});
        }
        CommandContextUtil.getEventDispatcher().dispatchEvent((FlowableEvent)new CustomFlowableEntityEvent(multiInstanceRootExecution, CustomFlowableEngineEventType.EMPTY_MI_NODE_FIN), CommandContextUtil.getProcessEngineConfiguration().getEngineCfgKey());
    }

    public static boolean skipFirstNode(Long flowProjectId) {
        GlobalConfigDto globalConfig = ProcessUtils.getFlowProjectConfigCacheRepository().getGlobalConfig(flowProjectId.longValue());
        return globalConfig != null && Boolean.TRUE.equals(globalConfig.getSkipFirstTask());
    }

    public static void deleteExecutionAndChild(ExecutionEntityManager executionEntityManager, ExecutionEntity execution, String deleteReason) {
        for (ExecutionEntity child : execution.getExecutions()) {
            ProcessUtils.deleteExecutionAndChild(executionEntityManager, child, deleteReason);
        }
        execution.forceUpdate();
        executionEntityManager.deleteExecutionAndRelatedData(execution, deleteReason, false);
    }

    public static void setApplicationContext(ApplicationContext applicationContext) {
        ProcessUtils.applicationContext = applicationContext;
    }

    public static DeploymentManager getDeploymentManager() {
        if (deploymentManager == null) {
            if (applicationContext == null) {
                LOGGER.error(ERR_APPLICATION_CONTEXT_NULL);
                throw new BaseI18nException((ErrorCode)FlowErrorCode.UNKNOWN_ERROR);
            }
            ProcessEngine processEngine = (ProcessEngine)applicationContext.getBean(ProcessEngine.class);
            ProcessEngineConfiguration processEngineConfiguration = processEngine.getProcessEngineConfiguration();
            if (processEngineConfiguration instanceof ProcessEngineConfigurationImpl) {
                deploymentManager = ((ProcessEngineConfigurationImpl)processEngineConfiguration).getDeploymentManager();
            } else {
                LOGGER.error("\u65e0\u6cd5\u83b7\u53d6\u5230ProcessEngineConfigurationImpl");
                throw new BaseI18nException((ErrorCode)FlowErrorCode.UNKNOWN_ERROR);
            }
        }
        return deploymentManager;
    }

    public static RepositoryService getRepositoryService() {
        if (repositoryService == null) {
            if (applicationContext == null) {
                LOGGER.error(ERR_APPLICATION_CONTEXT_NULL);
                throw new BaseI18nException((ErrorCode)FlowErrorCode.UNKNOWN_ERROR);
            }
            ProcessEngine processEngine = (ProcessEngine)applicationContext.getBean(ProcessEngine.class);
            repositoryService = processEngine.getRepositoryService();
        }
        return repositoryService;
    }

    private static FlowProjectConfigCacheRepository getFlowProjectConfigCacheRepository() {
        if (flowProjectConfigCacheRepository == null) {
            if (applicationContext == null) {
                LOGGER.error(ERR_APPLICATION_CONTEXT_NULL);
                throw new BaseI18nException((ErrorCode)FlowErrorCode.UNKNOWN_ERROR);
            }
            flowProjectConfigCacheRepository = (FlowProjectConfigCacheRepository)applicationContext.getBean(FlowProjectConfigCacheRepository.class);
        }
        return flowProjectConfigCacheRepository;
    }

    private static class DefinitionCache {
        private final Map<String, String> nodeNameCache = new LinkedHashMap<String, String>();
        private final Map<String, String> nodeTypeCache = new HashMap<String, String>();
        private final Set<String> notInParallelCache = new HashSet<String>();
        private final List<Set<String>> lineCache = new ArrayList<Set<String>>();

        private DefinitionCache() {
        }
    }
}

