/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.mc.api.event.utils;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class VariableUtils {
    private static final Logger logger = LoggerFactory.getLogger(VariableUtils.class);
    private static final String FREEMARKER_TEMPLATE_NAME = "VARIABLE_LOCAL_NAME";
    public static final Configuration CONFIGURATION = new Configuration(Configuration.VERSION_2_3_0);

    private VariableUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String replaceVariable(String content, Map<String, Object> params) {
        if (CollectionUtils.isEmpty(params) || StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        StringWriter result = new StringWriter();
        try {
            Template template = new Template(FREEMARKER_TEMPLATE_NAME, (Reader)new StringReader(content), CONFIGURATION);
            template.process(params, (Writer)result);
        }
        catch (TemplateException | IOException e) {
            logger.error("\u66ff\u6362\u53d8\u91cf\u7ed3\u679cerror, message={}", (Object)e.getMessage());
            return content;
        }
        return result.toString();
    }

    static {
        CONFIGURATION.setClassicCompatible(true);
        CONFIGURATION.setNumberFormat("#");
    }
}

