/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.mc.api.push.dto;

import com.cyberway.mp.bc.common.api.exception.AssertUtil;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.event.anotation.TopicName;
import com.cyberway.mp.mc.api.McErrorCode;
import com.cyberway.mp.mc.api.push.dto.EventPushExtInfoDto;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@TopicName(value="SIMPLE_EVENT_PUSH_TOPIC")
public class SimpleEventPushDto
extends EventPushExtInfoDto {
    private Long tenantId;
    private Long instanceId;
    private String channelCode;
    private Long userId;
    private String userName;
    private String receiverObject;
    private Boolean useSupplierTemplateCode = false;
    private String supplierTemplateCode;
    private String subject;
    private String content;
    private String actionUrls;

    public static UseSupplierTemplateBuilder useSupplierTemplateCode(String supplierTemplateCode) {
        return new UseSupplierTemplateBuilder(supplierTemplateCode);
    }

    public static SimpleBuilder builder() {
        return new SimpleBuilder();
    }

    public void valid() {
        AssertUtil.notNull((Object)this.tenantId, (ErrorCode)McErrorCode.EMPTY_VALUE, (Object[])new Object[]{"tenantId"});
        AssertUtil.notNull((Object)this.instanceId, (ErrorCode)McErrorCode.EMPTY_VALUE, (Object[])new Object[]{"instanceId"});
        AssertUtil.notBlank((String)this.channelCode, (ErrorCode)McErrorCode.EMPTY_VALUE, (Object[])new Object[]{"channelCode"});
        AssertUtil.isFalse((null == this.userId && StringUtils.isBlank((CharSequence)this.receiverObject) ? 1 : 0) != 0, (ErrorCode)McErrorCode.BASE, (Object[])new Object[]{":\u901a\u8fc7userId\u6216\u8005receiverObject\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a"});
    }

    public String getActionUrls() {
        return this.actionUrls;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getReceiverObject() {
        return this.receiverObject;
    }

    public Boolean getUseSupplierTemplateCode() {
        return this.useSupplierTemplateCode;
    }

    public String getSupplierTemplateCode() {
        return this.supplierTemplateCode;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getContent() {
        return this.content;
    }

    public static final class UseSupplierTemplateBuilder {
        private Map<String, Object> paramsMap = new HashMap<String, Object>(16);
        private Long tenantId;
        private Long instanceId;
        private String channelCode;
        private Long userId;
        private String userName;
        private String receiverObject;
        private String supplierTemplateCode;
        private String actionUrls;

        public UseSupplierTemplateBuilder(String supplierTemplateCode) {
            this.supplierTemplateCode = supplierTemplateCode;
        }

        public UseSupplierTemplateBuilder supplierTemplateCode(String supplierTemplateCode) {
            this.supplierTemplateCode = supplierTemplateCode;
            return this;
        }

        public UseSupplierTemplateBuilder paramsMap(Map<String, Object> paramsMap) {
            this.paramsMap = paramsMap;
            return this;
        }

        public UseSupplierTemplateBuilder actionUrls(String actionUrls) {
            this.actionUrls = actionUrls;
            return this;
        }

        public UseSupplierTemplateBuilder tenantId(Long tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public UseSupplierTemplateBuilder instanceId(Long instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public UseSupplierTemplateBuilder channelCode(String channelCode) {
            this.channelCode = channelCode;
            return this;
        }

        public UseSupplierTemplateBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public UseSupplierTemplateBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public UseSupplierTemplateBuilder receiverObject(String receiverObject) {
            this.receiverObject = receiverObject;
            return this;
        }

        public SimpleEventPushDto build() {
            SimpleEventPushDto simpleEventPushDto = new SimpleEventPushDto();
            simpleEventPushDto.setParamsMap(this.paramsMap);
            simpleEventPushDto.userName = this.userName;
            simpleEventPushDto.instanceId = this.instanceId;
            simpleEventPushDto.channelCode = this.channelCode;
            simpleEventPushDto.receiverObject = this.receiverObject;
            simpleEventPushDto.tenantId = this.tenantId;
            simpleEventPushDto.useSupplierTemplateCode = true;
            simpleEventPushDto.supplierTemplateCode = this.supplierTemplateCode;
            simpleEventPushDto.userId = this.userId;
            simpleEventPushDto.actionUrls = this.actionUrls;
            AssertUtil.notBlank((String)this.supplierTemplateCode, (ErrorCode)McErrorCode.EMPTY_VALUE, (Object[])new Object[]{"supplierTemplateCode"});
            AssertUtil.notNull(this.paramsMap, (ErrorCode)McErrorCode.EMPTY_VALUE, (Object[])new Object[]{"paramsMap"});
            simpleEventPushDto.valid();
            return simpleEventPushDto;
        }
    }

    public static final class SimpleBuilder {
        private Map<String, Object> paramsMap = new HashMap<String, Object>(16);
        private Long tenantId;
        private Long instanceId;
        private String channelCode;
        private Long userId;
        private String userName;
        private String receiverObject;
        private String subject;
        private String content;
        private String actionUrls;

        public SimpleBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public SimpleBuilder actionUrls(String actionUrls) {
            this.actionUrls = actionUrls;
            return this;
        }

        public SimpleBuilder content(String content) {
            this.content = content;
            return this;
        }

        public SimpleBuilder paramsMap(Map<String, Object> paramsMap) {
            this.paramsMap = paramsMap;
            return this;
        }

        public SimpleBuilder tenantId(Long tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public SimpleBuilder instanceId(Long instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public SimpleBuilder channelCode(String channelCode) {
            this.channelCode = channelCode;
            return this;
        }

        public SimpleBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public SimpleBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public SimpleBuilder receiverObject(String receiverObject) {
            this.receiverObject = receiverObject;
            return this;
        }

        public SimpleEventPushDto build() {
            SimpleEventPushDto simpleEventPushDto = new SimpleEventPushDto();
            simpleEventPushDto.setParamsMap(this.paramsMap);
            simpleEventPushDto.userName = this.userName;
            simpleEventPushDto.instanceId = this.instanceId;
            simpleEventPushDto.channelCode = this.channelCode;
            simpleEventPushDto.receiverObject = this.receiverObject;
            simpleEventPushDto.tenantId = this.tenantId;
            simpleEventPushDto.useSupplierTemplateCode = false;
            simpleEventPushDto.subject = this.subject;
            simpleEventPushDto.content = this.content;
            simpleEventPushDto.userId = this.userId;
            simpleEventPushDto.actionUrls = this.actionUrls;
            AssertUtil.notBlank((String)this.content, (ErrorCode)McErrorCode.EMPTY_VALUE, (Object[])new Object[]{"content"});
            simpleEventPushDto.valid();
            return simpleEventPushDto;
        }
    }
}

