/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.user.api.launch.dto;

import com.cyberway.mp.bc.common.api.exception.AssertUtil;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.user.api.constants.UserErrorCode;
import com.cyberway.mp.user.api.launch.TreeNode;
import com.cyberway.mp.user.api.launch.dto.BaseResourceDto;
import com.cyberway.mp.user.api.launch.dto.PageElementImportDto;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class PageResourceImportDto
extends BaseResourceDto
implements TreeNode<PageResourceImportDto> {
    @Schema(title="\u8bbf\u95ee\u8def\u5f84")
    private String path;
    @Schema(title="\u8d44\u6e90\u8def\u5f84")
    private String componentPath;
    @Schema(title="\u7ed1\u5b9a\u7684\u9875\u9762\u5143\u7d20")
    private List<PageElementImportDto> elements;
    private List<PageResourceImportDto> children;

    public void getAllFormerCodes(Set<String> codes) {
        if (!CollectionUtils.isEmpty(this.getFormerCodes())) {
            codes.addAll(this.getFormerCodes());
        }
        if (!CollectionUtils.isEmpty(this.getChildren())) {
            this.getChildren().forEach(c -> c.getAllFormerCodes(codes));
        }
        if (!CollectionUtils.isEmpty(this.getElements())) {
            this.getElements().forEach(e -> {
                if (!CollectionUtils.isEmpty(e.getFormerCodes())) {
                    codes.addAll(e.getFormerCodes());
                }
            });
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getComponentPath() {
        return this.componentPath;
    }

    public void setComponentPath(String componentPath) {
        this.componentPath = componentPath;
    }

    public List<PageElementImportDto> getElements() {
        return this.elements;
    }

    public void setElements(List<PageElementImportDto> elements) {
        this.elements = elements;
    }

    @Override
    public List<PageResourceImportDto> getChildren() {
        return this.children;
    }

    public void setChildren(List<PageResourceImportDto> children) {
        this.children = children;
    }

    public void getAllCodesAndBuildFrontendCode(Set<String> codes, String parentFrontendCode) {
        if (StringUtils.isBlank((CharSequence)this.getFrontendCode())) {
            this.setFrontendCode(parentFrontendCode);
        }
        this.buildAndCheck(codes, this.getCode());
        if (!CollectionUtils.isEmpty(this.getChildren())) {
            this.getChildren().forEach(c -> c.getAllCodesAndBuildFrontendCode(codes, this.getFrontendCode()));
        }
        if (!CollectionUtils.isEmpty(this.getElements())) {
            this.getElements().forEach(e -> {
                if (StringUtils.isBlank((CharSequence)e.getFrontendCode())) {
                    e.setFrontendCode(parentFrontendCode);
                }
                AssertUtil.notBlank((String)e.getCode(), (ErrorCode)UserErrorCode.EMPTY_VALUE, (Object[])new Object[]{"\u5143\u7d20[" + e.getName() + "]\u5bf9\u5e94\u7684\u7f16\u7801"});
                this.buildAndCheck(codes, e.getCode());
            });
        }
    }

    private void buildAndCheck(Set<String> codes, String code) {
        if (codes.contains(code)) {
            throw new IllegalArgumentException("\u91cd\u590d\u7684\u7f16\u7801[" + code + "]");
        }
        codes.add(code);
    }
}

