/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.user.api.role.vo;

import com.cyberway.mp.user.api.role.enums.RoleMenuConfigTreeNodeType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RoleMenuConfigTreeVo {
    @Schema(title="\u6570\u636e\u552f\u4e00\u6807\u8bc6, \u7528\u4f5c\u6811\u8282\u70b9id, \u65e0\u4e1a\u52a1\u610f\u4e49")
    private String uid;
    @Schema(title="\u6570\u636e\u5b9e\u9645\u4e1a\u52a1id")
    private Long id;
    @Schema(title="\u5bf9\u5e94\u83dc\u5355id")
    private Long menuId;
    @Schema(title="\u8282\u70b9\u7c7b\u578b")
    private RoleMenuConfigTreeNodeType type;
    @Schema(title="\u540d\u79f0")
    private String name;
    @Schema(title="\u662f\u5426\u83dc\u5355\u7684\u9ed8\u8ba4\u9875\u9762")
    private boolean defaultPage;
    @Schema(title="\u8282\u70b9\u662f\u5426\u5df2\u9009\u62e9")
    private boolean selected;
    @Schema(title="\u662f\u5426\u53ef\u7f16\u8f91\u9009\u62e9\u72b6\u6001", description="\u5f00\u542f\u5206\u6743\u7ba1\u7406\u540e\u4f7f\u7528, \u4e0d\u5f00\u542f\u65f6\u5168\u90e8\u4e3atrue")
    private boolean editable;
    @Schema(title="\u5b50\u8282\u70b9")
    private List<RoleMenuConfigTreeVo> children = new ArrayList<RoleMenuConfigTreeVo>();

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMenuId() {
        return this.menuId;
    }

    public void setMenuId(Long menuId) {
        this.menuId = menuId;
    }

    public RoleMenuConfigTreeNodeType getType() {
        return this.type;
    }

    public void setType(RoleMenuConfigTreeNodeType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDefaultPage() {
        return this.defaultPage;
    }

    public void setDefaultPage(boolean defaultPage) {
        this.defaultPage = defaultPage;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public List<RoleMenuConfigTreeVo> getChildren() {
        return this.children;
    }

    public void setChildren(List<RoleMenuConfigTreeVo> children) {
        this.children = children;
    }

    public <T1 extends RoleMenuSelectedResource, T2 extends RoleMenuSelectedResource> void handleMenuSelect(Map<Long, List<T1>> selectedMenuResourceMap, Map<Long, List<T2>> editableMenuResourceMap) {
        this.setSelected(selectedMenuResourceMap.containsKey(this.getId()));
        this.setEditable(editableMenuResourceMap == null || editableMenuResourceMap.containsKey(this.getId()));
        for (RoleMenuConfigTreeVo child : this.getChildren()) {
            if (RoleMenuConfigTreeNodeType.MENU.equals((Object)child.getType())) {
                child.handleMenuSelect(selectedMenuResourceMap, editableMenuResourceMap);
                continue;
            }
            if (!RoleMenuConfigTreeNodeType.VIRTUAL.equals((Object)child.getType())) continue;
            this.handleVirtualSelect(child, selectedMenuResourceMap, editableMenuResourceMap);
        }
    }

    private <T1 extends RoleMenuSelectedResource, T2 extends RoleMenuSelectedResource> void handleVirtualSelect(RoleMenuConfigTreeVo node, Map<Long, List<T1>> selectedMenuResourceMap, Map<Long, List<T2>> editableMenuResourceMap) {
        Map<Long, RoleMenuSelectedResource> selectedResourceMap = selectedMenuResourceMap.getOrDefault(node.getMenuId(), Collections.emptyList()).stream().collect(Collectors.toMap(RoleMenuSelectedResource::getResourceId, Function.identity(), (a, b) -> a));
        Map editableResourceMap = null;
        if (editableMenuResourceMap != null) {
            editableResourceMap = editableMenuResourceMap.getOrDefault(node.getMenuId(), Collections.emptyList()).stream().collect(Collectors.toMap(RoleMenuSelectedResource::getResourceId, Function.identity(), (a, b) -> a));
        }
        if (RoleMenuConfigTreeNodeType.ELEMENT_ACTION.equals((Object)node.getType())) {
            RoleMenuConfigTreeVo.handleElementActionNode(node, selectedResourceMap, editableResourceMap);
        } else {
            RoleMenuConfigTreeVo.handleElementViewNode(node, selectedResourceMap, editableResourceMap);
        }
    }

    private static void handleElementActionNode(RoleMenuConfigTreeVo node, Map<Long, RoleMenuSelectedResource> selectedResourceMap, Map<Long, RoleMenuSelectedResource> editableResourceMap) {
        for (RoleMenuConfigTreeVo actionNodeChild : node.getChildren()) {
            actionNodeChild.setSelected(selectedResourceMap.containsKey(actionNodeChild.getId()) && Boolean.TRUE.equals(selectedResourceMap.get(actionNodeChild.getId()).getActionable()));
            if (editableResourceMap == null) {
                actionNodeChild.setEditable(true);
            } else {
                actionNodeChild.setEditable(editableResourceMap.containsKey(actionNodeChild.getId()) && Boolean.TRUE.equals(editableResourceMap.get(actionNodeChild.getId()).getActionable()));
            }
            node.setSelected(node.isSelected() || actionNodeChild.isSelected());
            node.setEditable(node.isEditable() || actionNodeChild.isEditable());
        }
    }

    private static void handleElementViewNode(RoleMenuConfigTreeVo node, Map<Long, RoleMenuSelectedResource> selectedResourceMap, Map<Long, RoleMenuSelectedResource> editableResourceMap) {
        for (RoleMenuConfigTreeVo viewNodeChild : node.getChildren()) {
            viewNodeChild.setSelected(selectedResourceMap.containsKey(viewNodeChild.getId()));
            viewNodeChild.setEditable(editableResourceMap == null || editableResourceMap.containsKey(viewNodeChild.getId()));
            node.setSelected(node.isSelected() || viewNodeChild.isSelected());
            node.setEditable(node.isEditable() || viewNodeChild.isEditable());
        }
    }

    public static interface RoleMenuSelectedResource {
        public Long getResourceId();

        public Boolean getActionable();
    }
}

